﻿<%

'**************************************************
'
'	GLV.SWAssetType Choices
'	
'	
'**************************************************

Const LV_KEY="GLV.SWAssetType" 'set this to the key name
'Possible keys names are: 
'ProjName_ViewName_FC.OrigFieldCaption, ProjName_ViewName_LV.LVTableName, ProjName_ViewName_GLV.LVTableName, 
'ProjName_FC.OrigFieldCaption, ProjName_LV.LVTableName, ProjName_GLV.LVTableName,
'FC.OrigFieldCaption, LV.LVTableName, GLV.LVTableName

%>
<!--#include file="lvconfig.asp" -->
<%
Call LoadLookupValsToApplication(LoadLVInfo(), LV_KEY)

Function LoadLVInfo()

	Dim oLVInfo
	Set oLVInfo = Server.CreateObject("MqWebUI.MQLVUIDetails")
	
	oLVInfo.Display.ColFieldNames = "tName;Software_Publisher" 	'semi-colon delimited list of field names
	oLVInfo.Display.ColHeaders = "Software Asset Type;Vendor" 	'semi-colon delimited list of column header values
	
	oLVInfo.Display.ColExtLV.Add "Software_Publisher", _
									CreateExtLVObj("nID", "tName", "tblUser", 16, "", "nID") 'if any columns to show should be linked to another choice list for the values
	
	oLVInfo.Selection.ValueFieldName = "tName" 	'field name for the value to set when selecting
	oLVInfo.Selection.IDFieldName = "nID" 	'field name for the ID to pass for edit

	oLVInfo.Filter.DefaultFieldCaption = "Software Asset Type" 'field header to show by default in the search by drop down
	oLVInfo.Filter.OptionFields = "Software Asset Type;Vendor" 'semi-colon delimited list of column header values in the search by drop down
	oLVInfo.Filter.DefaultSearchMode = "1" 'use 0 for Starts With... or 1 for Contains...
	
	oLVInfo.CodeBehind.JSFile = "ResourcesFunc.js" 'name of the file to include with the add/edit functions
	oLVInfo.CodeBehind.AddNewParams = "798=10&806=2&954=<ValOfField>408</ValOfField>&1092=321" 'params for the add new function
	
	Set LoadLVInfo = oLVInfo
	
End Function
%>


