function VNViewLoader(objMainDoc, objMainRef, objMainWindow){
	
	var m_dictViews=new Array();
	var m_objMainDoc=objMainDoc;
	var m_objMainRef=objMainRef;
	var m_objMainWindow=objMainWindow;
	var VIEW_FRA_PREFIX="fraWV_";
	
	function AddView(oView)
	{
		m_dictViews.push(oView);
	}
	
	function LoadViews()
	{
		if(m_dictViews)
		{
			var arrWinSize=m_objMainRef.GetWindowSize(m_objMainRef.WIN_MODE_MAXIMIZED, null, null, true);
			var lngWidth=arrWinSize[0];
			var lngHeight=arrWinSize[1];
			var intBodyWidth=arrWinSize[2];
			var intBodyHeight=arrWinSize[3];
			var intBrowserWidth=arrWinSize[4];
			var intBrowserHeight=arrWinSize[5];
			var BORDER_WIDTH=4;
			
			for(var x=0; x<m_dictViews.length; x++){
				var objView=m_dictViews[x];
				
				var objFra = m_objMainDoc.createElement('iframe');
				objFra.style.visibility = "hidden";
				objFra.style.zIndex = 1003;
				objFra.src = objView.URL();
				objFra.style.position="absolute";
				objFra.id = VIEW_FRA_PREFIX + objView.UniqueName();
				objFra.style.marginBottom = "10px";
				objFra.style.marginLeft = "10px";
				objFra.style.marginRight = "10px;"
				objFra.style.backgroundColor = "#ffffff";
				objFra.style.borderRadius = "4px";
				objFra.style.border = "4px solid #cccccc";
				objFra.style.overflow = "auto";

				objFra.style.marginTop=(((((intBrowserHeight-lngHeight)/2)-((intBrowserHeight-intBodyHeight)/2))/2)-BORDER_WIDTH)+"px";
				objFra.style.marginLeft=(((((intBrowserWidth-lngWidth)/2)-((intBrowserWidth-intBodyWidth)/2))/2)+BORDER_WIDTH)+"px";
				objFra.style.top="10px";
				
				objFra.style.height=lngHeight+"px";
				objFra.style.width=lngWidth+"px";
				m_objMainDoc.body.appendChild(objFra);

			}
		}		
	}
	
	function ShowView(strUniqueName)
	{
		var objFra=m_objMainDoc.getElementById(VIEW_FRA_PREFIX+strUniqueName);
		if(objFra){
			objFra.style.visibility = "visible";			
		}
	}
	
	function HideView()
	{
		if(m_dictViews)
		{
			for(var x=0; x<m_dictViews.length; x++){
				var objFra=m_objMainDoc.getElementById(VIEW_FRA_PREFIX+m_dictViews[x].UniqueName());
				if(objFra){
					if(objFra.style.visibility=="visible"){
						objFra.style.visibility="hidden";
						if(m_dictViews[x].OnClose()){
							eval(m_dictViews[x].OnClose());							
						}
					}
				}
			}
		}
	}
	
	function GetView(strUniqueName)
	{
		var objView;
		if(m_dictViews)
		{
			for(var x=0; x<m_dictViews.length; x++){
				if(m_dictViews[x].UniqueName()==strUniqueName){
					objView=m_dictViews[x];
				}
			}
		}
		return objView;
	}
	
	function GetCurrentURL(strUniqueName)
	{
		var strURL="";
		
		var objFra=this.GetMainFrame(strUniqueName);
		if(objFra){
			strURL=objFra.mstrCurrentLocation;
		}
		return strURL;
	}
	
	function GetMainFrame(strUniqueName)
	{
		var strURL="";
		
		var objFra=m_objMainWindow.frames[VIEW_FRA_PREFIX+strUniqueName];
		
		if(objFra){
			if(objFra.contentWindow){
				objFra=objFra.contentWindow;
			}
		}
		return objFra;
	}
	
	function LogOffViews()
	{
		if(m_dictViews)
		{
			for(var x=0; x<m_dictViews.length; x++){
				var objFra=this.GetMainFrame(m_dictViews[x].UniqueName());
				if(objFra){
					if(objFra.objControlsSs){
						objFra.objControlsSs.exit();	
					}
				}					
			}
		}
		
	}
	
	function IsViewLoaded(strUniqueName)
	{
		var blnReturn=false;
		
		if(m_dictViews){
			var objFra=this.GetMainFrame(strUniqueName);
			if(objFra){
				if(objFra.Record){
					if(objFra.Record.loaded){
						blnReturn=true;
					}
				}
			}					
		}	
		return blnReturn;		
	}
	
	this.LoadViews=LoadViews;
	this.ShowView=ShowView;
	this.HideView=HideView;
	this.AddView=AddView;
	this.GetView=GetView;
	this.GetCurrentURL=GetCurrentURL;
	this.GetMainFrame=GetMainFrame;
	this.LogOffViews=LogOffViews;
	this.IsViewLoaded=IsViewLoaded;
}


function VNViewDetails(strUniqueName, strURL, fnOnClose)
{
	var m_strUniqueName=strUniqueName;	
	var m_strURL=strURL;
	var m_fnOnClose=fnOnClose;
	
	function UniqueName()
	{
		return m_strUniqueName;
	}
	
	function URL()
	{
		return m_strURL;
	}
	
	function OnClose()
	{
		return m_fnOnClose;
	}
	
	this.UniqueName=UniqueName;
	this.URL=URL;
	this.OnClose=OnClose;
	
}