// Dependencies:
// MqViewFields.js (CMqField, etc)
// m_objMqButton

//constants for control type
var CTRL_TYPE_LIST =0;
var CTRL_TYPE_COMBO=1;
var CTRL_TYPE_TEXT=2;
var CTRL_TYPE_CHECK=3;
var CTRL_TYPE_SCC=4;
var CTRL_TYPE_DIV =5;
var CTRL_TYPE_MQLIST=6;
var CTRL_TYPE_LARGE_COMBO=7;
var CTRL_TYPE_LARGE_LIST=8;
var CTRL_TYPE_MQRATING=9;

var DIV_TAG_NAME="DIV";
var m_LargeComboCache;

function CMqDisplayElements(){
	var TRUE=1;
	var FALSE=0;
	var mbSCCEnabled;
	var moFormElement;
	
	//initialize the private properties	
	mbSCCEnabled=true;
	moFormElement=new CMqFormElement();

	var m_varExcludedElements=new Array();
	
	function ExcludeElement(strElementName)
	{
		m_varExcludedElements[strElementName]=strElementName;
	}
	
	function DisableElement(objElement,blnDisabled,lngControlType,objDataHTMLDoc){				
		if (Number(lngControlType)!=CTRL_TYPE_DIV){
			//check if the element is the SCC grid
			if (Number(lngControlType)!=CTRL_TYPE_SCC){
				if (!IsExcludedElement(objElement, m_varExcludedElements)){
					moFormElement.Disable(blnDisabled,objElement,objDataHTMLDoc);									
				}		
			}else{
				if (objScc && objControlsUi){
					//we check if the SCC  exists
					if ( objScc.getObject("MqSccFiles").getSCC()){
						if (blnDisabled && mbSCCEnabled){								
							objControlsUi.disableControlSCC();
							mbSCCEnabled=false;
						}else{
							if (!blnDisabled && !mbSCCEnabled){							
								objControlsUi.enableControlSCC();
								mbSCCEnabled=true;
							}			
						}
					}
				}		
			}
		}		
	}
	
	function DisableControls(arrControls, blnDisabled)
	{
		var lngCount;
		var objCtrl;
			
		for(lngCount=0; lngCount<arrControls.length; lngCount++){
			objCtrl=arrControls[lngCount];
				
			if(objCtrl){
				moFormElement.Disable(blnDisabled,objCtrl);
					
			}
		}
	}
	
	this.DisableElement=DisableElement;
	this.ExcludeElement=ExcludeElement;
	this.DisableControls=DisableControls;
	
	//private
	function IsExcludedElement(objElement, varExcludedElements){
		var blnElementIsExcluded=false;
		if (objElement){
			var strElementName=objElement.id;
			if (varExcludedElements){
				if (varExcludedElements[strElementName]){
					blnElementIsExcluded=true;
				}
			}
		}
		return blnElementIsExcluded;
	}
}

function CMqFormElement() {

	//constants for data types
	var CURRENCY_DATATYPE="5";

	//constants for control type
	var DIV_TAG_NAME="DIV";
	var TEXT_TYPE="text";
	var CHECKBOX_TYPE="checkbox";	
	var MEMO_TYPE="textarea";
	var PASSWORD_TYPE="password";
	var DEFAULT_VALUE_DELIM=";";
	var OPTION_NONE=" ";	
	//constants for choice value control
	var CHOICE_VALUE_ON = 1;
	var CHOICE_VALUE_OFF = 2;	

	//private properties
	var m_lngControlType;
	var m_objElement;
	var m_blnInitialized=false;
	var m_strValueDelimiter=DEFAULT_VALUE_DELIM;
	var m_blnIfSetTooltip=false;
	var m_objMqAutoList;
	var m_objDocContainer;
	var m_strElementName;
	
	var _me=this;
	this.HIDDEN_OBJ_CLASS = "HiddenObject";
	this.HIDDEN_ATTRIBUTE = "MqHidden";
	this.ATTR_TRUE="1";
		
	function Initialize(strElementName,lngControlType, strDocContainer, objMqAutoList){
		if (strDocContainer){
			m_objDocContainer=eval(strDocContainer);
			if (m_objDocContainer){
				m_objElement=m_objDocContainer.getElementById(strElementName);
			}
		}else{
			m_objElement=eval(strElementName);
		}
		m_blnInitialized=true;
		m_lngControlType=lngControlType;
		m_objMqAutoList=objMqAutoList;
		m_strElementName=strElementName;
	}

	
	
	function SetValue(strValue,blnUnescape,objElement,lngControlType, blnUnformatXMLData, blnSetText, lngFieldID){
				
		if (!objElement){
			objElement=m_objElement;
		}
	
		if (lngControlType==null){
			if (m_lngControlType==null){
				if (m_blnInitialized){
					m_lngControlType=GetControlType(m_objElement);
                lngControlType=m_lngControlType;
				}else{
                lngControlType=GetControlType(objElement);
            }
			}else{
			    lngControlType=m_lngControlType;
		    }
		}
		var altControlType = _me.GetAlternateControlType(objElement);
		if (altControlType != null)
		{
			lngControlType = altControlType;
		}

		if ((lngControlType!=null) &&(objElement)){
			try{
				if(blnUnformatXMLData){
	            	strValue=g_MqRef.MqStr.MqUnformatXMLData(strValue);
	            }		

	            if (blnUnescape){
	            	strValue =g_MqRef.MqStr.MqDecodeURIComponent(strValue);
	            }

				if(objElement.type == "hidden") 
				{
					objElement.value=strValue;
				}
				else
				{
				switch(Number(lngControlType)){
					case CTRL_TYPE_TEXT :
						SetValueToText(objElement,strValue);				
						break;
					case CTRL_TYPE_CHECK :
						SetValueToCheckBox(objElement,strValue);
						break;
					case CTRL_TYPE_LIST :
						SetValuesToList(objElement,strValue, m_strValueDelimiter,blnUnescape);
						break;
					case CTRL_TYPE_COMBO:
						if(objElement.type == "checkbox") {
							SetValueToCheckBox(objElement,strValue,CTRL_TYPE_CHECK);
						}
						else {
							SetValueToCombo(objElement,strValue,g_MqRef.MqBrowser.nn,blnSetText);
						}
						break;
					case CTRL_TYPE_DIV:
						if (GetControlType(objElement)==CTRL_TYPE_TEXT){
							SetValueToText(objElement,strValue);
						}else{
							SetValueToDiv(objElement,strValue);
						}
						break;
					case CTRL_TYPE_MQLIST:
						SetValueToMqList(objElement,strValue);
						break;
					case CTRL_TYPE_LARGE_COMBO:
						if(lngFieldID==null){
							if(m_objViewFields){
								lngFieldID=m_objViewFields.GetFieldIDByBoundCtrl(objElement.id);
							}
						}
						SetValueToLargeCombo(objElement,strValue,null,lngFieldID);
						break;
					case CTRL_TYPE_LARGE_LIST:
						SetValueToLargeList(objElement,strValue);
						break;
					case CTRL_TYPE_MQRATING:
						SetValueToMqRating(objElement, strValue);
						break;
				}
				}
				
				if(objElement.getAttribute("setValue") != 'undefined')
				{
					ProcessAttribute(objElement, strValue)
				}
				
			}
			catch (errObject){
			}
		}	
	}
	
	function ProcessAttribute(objElement, strValue)
	{
		var attributeValue = objElement.getAttribute("setValue");
		
		if (attributeValue)
		{
			if (!m_objDocContainer)
			{
				m_objDocContainer= objElement.ownerDocument;
			}
			

			var objROElement = m_objDocContainer.getElementById(attributeValue);
			if(objROElement)
			{
				objROElement.innerHTML = objElement.value ; //strValue;			
			}
		}
		
	}

	
	function GetValue(blnEscape,objElement,lngControlType,blnGetText,blnJSEscape){

		var strValue="";		
	
		if (!objElement){
			objElement=m_objElement;
		}
		
		if (lngControlType==null){
			if (m_lngControlType==null){
				if (m_blnInitialized){
					m_lngControlType=GetControlType(m_objElement);
                lngControlType=m_lngControlType;
				}else{
                lngControlType=GetControlType(objElement);
            }
			}else{
			    lngControlType=m_lngControlType;
		    }
		}
		
		var altControlType = _me.GetAlternateControlType(objElement);
		if (altControlType != null)
		{
			if(blnGetText==true && altControlType==CTRL_TYPE_LARGE_COMBO && lngControlType==CTRL_TYPE_TEXT){
				//if they want the text and are asking for the text control, return the text
				lngControlType = CTRL_TYPE_TEXT;
			}else{
				lngControlType = altControlType;
			}
		}

		if ((lngControlType!=null) &&(objElement)){
			try{
				// If it's a hidden field, just get the value
				if(objElement.type == "hidden") 
				{
					strValue=objElement.value;
				}
				else
				{
				switch(Number(lngControlType)){
					case CTRL_TYPE_TEXT :
						strValue=GetValueFromText(objElement);				
						break;
					case CTRL_TYPE_CHECK :
						strValue=GetValueFromCheckBox(objElement);
						break;
					case CTRL_TYPE_LIST :
						strValue=GetSelectedValuesFromList(objElement,m_strValueDelimiter,blnEscape,blnGetText);
						break;
					case CTRL_TYPE_COMBO:
						if(objElement.type == "checkbox") 
						{
							strValue=GetValueFromCheckBox(objElement,CTRL_TYPE_CHECK);
						}
						else {
							strValue=GetSelectedValueFromCombo(objElement,blnGetText);
						}
						break;
					case CTRL_TYPE_SCC :
						strValue=GetValueFromSCCControl(objElement);
						break;
					case CTRL_TYPE_DIV:
						strValue=GetValueFromDIV(objElement);
						break;
					case CTRL_TYPE_MQLIST:
						strValue=GetValueFromMqList(objElement);
						break;				
					case CTRL_TYPE_LARGE_COMBO:
						strValue=GetValueFromLargeCombo(objElement, blnGetText);
						break;		
					case CTRL_TYPE_LARGE_LIST:
						strValue=GetValueFromLargeList(objElement);
						break;
					case CTRL_TYPE_MQRATING:
						strValue=GetValueFromMqRating(objElement);
						break;
				}
				}
			}
			catch (errObject){
			}
		}
		if (strValue){   
			if (blnEscape){
				strValue= g_MqRef.MqStr.MqEncodeURIComponent(strValue);
			}
			if(blnJSEscape){
				strValue=escape(strValue);
			}
		}
		return strValue;	
	}
	
	function GetSelectedValues(objElement,lngControlType)
	{
		var arrValues=new Array();
		
		if (!objElement){
			objElement=m_objElement;
		}
		
		if (lngControlType==null){
			if (m_lngControlType==null){
				if (m_blnInitialized){
					m_lngControlType=GetControlType(m_objElement);
					lngControlType=m_lngControlType;
				}else{
					lngControlType=GetControlType(objElement);
				}
			}else{
			    lngControlType=m_lngControlType;
		    }
		}
		
		var altControlType = _me.GetAlternateControlType(objElement);
		if (altControlType != null)
		{
			lngControlType = altControlType;
		}

		if ((lngControlType!=null) &&(objElement)){
			if(lngControlType==CTRL_TYPE_LIST || lngControlType==CTRL_TYPE_COMBO){
			
				var strElemValue;
				var strElemID;
				var objOptions=objElement.options;
				var lngCount;
				var lngArrIndex=0;
				
				for (lngCount=0;lngCount<objOptions.length; lngCount++){
					if (objOptions[lngCount].selected){
						strElemID=objOptions[lngCount].value;
						strElemValue=objOptions[lngCount].text;
						arrValues.length++;
						arrValues[lngArrIndex]=new Array(strElemID, strElemValue);
						lngArrIndex++;
					}					
				}
			}
		}
		return arrValues;
	}
	    
	function GetPossibleValues(){
		var strPossVal="";
		var lngControlType = m_lngControlType;
		
		if (m_objElement){
			if (lngControlType==null){
				lngControlType=GetControlType(m_objElement);
				m_lngControlType = lngControlType;
			}
			var altControlType = _me.GetAlternateControlType(m_objElement);
			if (altControlType != null)
			{
				lngControlType = altControlType;
			}
			try{
				switch (Number(lngControlType)){
					case CTRL_TYPE_COMBO: 
					case CTRL_TYPE_LIST:
						strPossVal=GetValuesFromCombo();
						break;		
				}
			}
			catch (errObject){
			}
		}
		return strPossVal;
	}
	
	function SetPossibleValues(varValues, blnSelectFirstValue,objElement,lngControlType,strTriggerFieldID){

		var blnSetPrivate=false;
		var varReturn;
		
		if (!objElement){
			objElement=m_objElement;
			if (lngControlType==null){
				blnSetPrivate=true;				
				if (m_lngControlType==null){
					m_lngControlType=GetControlType(objElement);
				}
				lngControlType=m_lngControlType;				
			}
		}else{
			if (lngControlType==null){
				lngControlType=GetControlType(objElement);
			}
		}

		var altControlType = _me.GetAlternateControlType(objElement);
		if (altControlType != null)
		{
			lngControlType = altControlType;
		}

		if (objElement){				
			try{
				switch (Number(lngControlType)){
					case CTRL_TYPE_COMBO:
					case CTRL_TYPE_LIST:
						varReturn=SetValuesToCombo(objElement,varValues, blnSelectFirstValue);
						break;	
					case CTRL_TYPE_LARGE_COMBO:
						varReturn=SetValuesToLargeCombo(objElement,varValues, strTriggerFieldID, blnSelectFirstValue);
						break;
					case CTRL_TYPE_TEXT:
						varReturn=SetValuesToLargeCombo_Text(objElement,varValues, strTriggerFieldID);
						break;
					case CTRL_TYPE_LARGE_LIST:
						varReturn=SetValuesToLargeList(objElement,varValues);
						break;
				}
			}
			catch (errObject){
			}
			return varReturn;
		}
	}
	
	function Enable()
	{
		_me.Disable(false);
	}
	
	function Disable(blnDisable,objElement, objDataHTMLDoc){
	
		var DISABLED = 'disabled';
		
		if(typeof(blnDisable)==="undefined")
		{
			// Calling Disable with no arguments is just "disable"
			blnDisable=true;
		}
					
		if (!objElement){
			objElement =m_objElement;
		}

		
		if (objElement)
		{
			
			var mqReadOnlyAttr = objElement.getAttribute("mqreadonly");
			
			var blnIsReadonly=false;
			if (mqReadOnlyAttr != null){
				if(mqReadOnlyAttr!=""){
					blnIsReadonly=true;
				}
			}
			if(blnIsReadonly)
			{
				objElement.readOnly = true;
				if (blnDisable)
				{
  					//objElement.style.backgroundColor="#ffffff";
  				}
  				else
				{
  					objElement.style.backgroundColor="";
  				}
			}
			else
			{
				if ((typeof(objElement.readOnly)!="undefined") && (GetControlType(objElement)!=CTRL_TYPE_CHECK) && (GetControlType(objElement)!=CTRL_TYPE_COMBO))
				{
					if(objElement.readOnly!=blnDisable)
					{
						objElement.readOnly=blnDisable;
					}
					if (blnDisable)
					{					
						if(objDataHTMLDoc){
							if(_me.GetAlternateControlType(objElement)==CTRL_TYPE_LARGE_COMBO){
								var	strHasUserExt = objElement.getAttribute("hasuserextension");
					
								if(strHasUserExt == "true"){
									
									objElement.style.borderLeft = "0px";
									
									var objUserExt = objDataHTMLDoc.getElementById(objElement.id + "_UDExt");
									if(objUserExt){
										objUserExt.style.borderColor="#000000";
										objUserExt.style.borderStyle="solid";
										objUserExt.style.borderWidth="1px";
										objUserExt.style.borderRight="0px";
									}
								}
							}
						}
						objElement.className=objElement.className + " HTMLControl-Disabled";
						objElement.disabled = true;
    				}
    				else
    				{
						if(objDataHTMLDoc){
							if(_me.GetAlternateControlType(objElement)==CTRL_TYPE_LARGE_COMBO){
								var	strHasUserExt = objElement.getAttribute("hasuserextension");
								
								if(strHasUserExt == "true"){
									
									objElement.style.borderLeft = "0px";
									
									var objUserExt = objDataHTMLDoc.getElementById(objElement.id + "_UDExt");
									if(objUserExt){
										objUserExt.style.borderColor="";
										objUserExt.style.borderStyle="";
										objUserExt.style.borderWidth="";
										objUserExt.style.borderRight="";
										objUserExt.style.backgroundColor="";
									}
								}
							}
						}
						
						objElement.className=objElement.className.replace(" HTMLControl-Disabled", "");
						objElement.disabled = false;
    				}
				}
				else
				{
					if((objElement.disabled!=blnDisable) || (GetControlType(objElement)==CTRL_TYPE_COMBO))
					{		
						if(objElement.className.toLowerCase().indexOf(DISABLED) >= 0){
							objElement.disabled = true;
						}else{						
							objElement.disabled=blnDisable;
						}
						
					}
				}
			}
		}
	}

	function Hide()
	{
		_me.HideElement(true);
	}

	function Show()
	{
		_me.HideElement(false);
	}
	
	// TODO: Split into pure FormElement and VNFormField
	function HideElement(blnHidden, objElement, blnElementAndCaption, lngFieldID, objDataHTMLDoc)		
	{
		if (!objElement){
			objElement =m_objElement;
		}
		

		var VISIBILITY_HIDDEN="hidden";
		var VISIBILITY_VISIBLE="visible";
			
		if(!blnElementAndCaption){						
			if(objElement){
				if(blnHidden){
					objElement.style.visibility=VISIBILITY_HIDDEN;
				}else{
					objElement.style.visibility=VISIBILITY_VISIBLE;
				}		
			}
		}else{
			if(lngFieldID){
				var strDisplay="";
				var strVisibility=VISIBILITY_VISIBLE;
				var strHiddenAttrib="";
				
				var objTD;
			
				if(blnHidden){
					strDisplay="none";
					strVisibility=VISIBILITY_HIDDEN;
					strHiddenAttrib="1";
				}

				// to be moved to inside VN Form field
				var oFrmFld=new VNFormField(null,null);
				objTD=objDataHTMLDoc.getElementById(oFrmFld.MQF_CAPTION_PREFIX + lngFieldID);
				if(objTD){
					objTD.style.display=strDisplay;
					objTD.style.visibility=strVisibility;
					objTD.className=objTD.className.replace(_me.HIDDEN_OBJ_CLASS, "");
					objTD.setAttribute(_me.HIDDEN_ATTRIBUTE, strHiddenAttrib);
				}

				objTD=objDataHTMLDoc.getElementById(oFrmFld.MQF_PREFIX + lngFieldID);
				if(objTD){
					objTD.style.display=strDisplay;
					objTD.style.visibility=strVisibility;
					objTD.className=objTD.className.replace(_me.HIDDEN_OBJ_CLASS, "");
					objTD.setAttribute(_me.HIDDEN_ATTRIBUTE, strHiddenAttrib);
				}

				objTD=objDataHTMLDoc.getElementById(oFrmFld.MQF_EXTRA_PREFIX + lngFieldID);
				if(objTD){
					objTD.style.display=strDisplay;
					objTD.style.visibility=strVisibility;
					objTD.className=objTD.className.replace(_me.HIDDEN_OBJ_CLASS, "");
					objTD.setAttribute(_me.HIDDEN_ATTRIBUTE, strHiddenAttrib);
				}

				
				if(objElement){
					objElement.className=objElement.className.replace(_me.HIDDEN_OBJ_CLASS, "");
				}
			}
		}
	}


	function SetValueDelimiter(strData){
		m_strValueDelimiter=strData;
	}

	function Display(objElement,blnDisplay){
		if (objElement){
			if (!blnDisplay){
				if (objElement.style.display!='none'){
					objElement.style.display='none';
					objElement.style.visibility='hidden';
				}
			}else{
				if (objElement.style.display!==''){
					objElement.style.display='';
					objElement.style.visibility='visible';
				}
			}
		}
	}
	
	function ToggleVisibility(sElemID, oHTMLDoc)
	{
		if (!oHTMLDoc){
			oHTMLDoc=document;
		}
		var oElem=oHTMLDoc.getElementById(sElemID);
		
		if (oElem){
			if (oElem.style.display=="none"){
				oElem.style.display="";
			}else{
				oElem.style.display="none";
			} 

		}
		
	}
	
	function GetPosition(objElement, blnXPos)
	{
		var lngPos=0;
		
		if (!objElement){
			objElement=m_objElement;
		}
		
		if(blnXPos){
			lngPos = objElement.offsetLeft;
		}else{
			lngPos = objElement.offsetTop;
		}	
			
		var oElementParent=objElement.offsetParent;
			
		while (oElementParent){
			if(blnXPos){
				lngPos+=oElementParent.offsetLeft;
			}else{
				lngPos+=oElementParent.offsetTop;


			}
			
			oElementParent=oElementParent.offsetParent;
		}
		
		return lngPos;
	}
	
	function GetElement()
	{
		return m_objElement;
	}
	
	function Name()
	{
		return m_strElementName;
	}

	function SwitchID(strID1, strID2, oDocument)
	{
		if (!oDocument){
			oDocument=document;
		}
		var ret=false;
		var oElem1=oDocument.getElementById(strID1);
		var oElem2=oDocument.getElementById(strID2);
		
		if (oElem1 && oElem2)
		{
			oElem1.id=oElem1.id + "kj3874fhu49834q3ixa";
			oElem2.id=strID1;
			oElem1.id=strID2;
			ret=true;
		}
		return ret;
	}

	function ToggleCurrencyField(strFieldId, blnEditable)
	{


		var strRegExDelimiter = new RegExp("\\"+g_MqRef.RESX['CURRENCY.THOUSANDS'], "g");
		var strRegExDecimal = new RegExp("\\"+g_MqRef.RESX['CURRENCY.DECIMAL'], "g");
		
		fldCurrencyField = Record.document.getElementById(strFieldId + "_readonly");
		fldCurrencyEdit = Record.document.getElementById(strFieldId);

		if(fldCurrencyField.getAttribute("mqreadonly")=="")
		{
			if(blnEditable)
			{
				fldCurrencyField.style.display = "none";
				fldCurrencyEdit.style.display = "block";
				
				fldCurrencyEdit.value = parseFloat(fldCurrencyEdit.value)
											.toFixed(2)
											.toString()
											.replace(/\./g, g_MqRef.RESX['CURRENCY.DECIMAL']) 
											.replace(/\B(?=(\d{3})+(?!\d))/g, g_MqRef.RESX['CURRENCY.THOUSANDS']);
				
				fldCurrencyEdit.focus();
			}
			else
			{
				fldCurrencyField.style.display = "block";
				fldCurrencyEdit.style.display = "none";
			
				//number-format the user input
				//Check that value is a number and not empty
				if(!isNaN(fldCurrencyEdit.value.replace(strRegExDelimiter, "").replace(strRegExDecimal, ".")) && fldCurrencyEdit.value != "")
				{
					//Convert Edit value to use NA format without comas (####.##)
					fldCurrencyEdit.value = parseFloat(fldCurrencyEdit.value.replace(strRegExDelimiter, "").replace(strRegExDecimal, ".")).toFixed(2);

					
					//Update read-only field and convert using specified format (##,###.##) or (##.###,##)
					fldCurrencyField.innerHTML = g_MqRef.RESX['CURRENCY.SYMBOL'] + " " + parseFloat(fldCurrencyEdit.value)
											.toFixed(2)
											.toString()
											.replace(/\./g, g_MqRef.RESX['CURRENCY.DECIMAL']) 
											.replace(/\B(?=(\d{3})+(?!\d))/g, g_MqRef.RESX['CURRENCY.THOUSANDS']);
					
					//Update Edit field to use the converted formatting
					
				}
				else
				{
					//Default value for currency field is invalid data is entered in field
					fldCurrencyEdit.value = "0.00";
					fldCurrencyField.innerHTML = g_MqRef.RESX['CURRENCY.SYMBOL'] + " " + parseFloat(fldCurrencyEdit.value.replace(strRegExDelimiter, "").replace(strRegExDecimal, ".")).toFixed(2);
				}
			}
		}
	}
	
	function MakeHiddenType()
	{

		var oDOMElem=_me.GetElement();
		if (oDOMElem)
		{
			oDOMElem.className=_me.HIDDEN_OBJ_CLASS;
			oDOMElem.setAttribute(_me.HIDDEN_ATTRIBUTE,_me.ATTR_TRUE);
		}
	}

	function CallOnChange(oHTMLCtl)
	{
		if (oHTMLCtl)
		{
			if ("createEvent" in document) 
			{
				var evt = document.createEvent("HTMLEvents");
				evt.initEvent("change", false, true);
				oHTMLCtl.dispatchEvent(evt);
			}
			else
			{
				oHTMLCtl.fireEvent("onchange");
			}
		}
	}
	
	function SetOnChange(oHTMLCtl, strFunction) 
	{
        if (oHTMLCtl) {
            var strBody = "";
            if (oHTMLCtl.onchange) 
			{
                strBody = "var objFunction=" + oHTMLCtl.onchange.valueOf() + ";" + "objFunction();" + strFunction;
            } else {
                strBody = strFunction;
            }
            var objFunc = new Function(strBody);
            oHTMLCtl.onchange = objFunc;
        }
    }

	this.Hide=Hide;
	this.Show=Show;
	this.GetPossibleValues=GetPossibleValues;
	this.SetPossibleValues=SetPossibleValues;
	this.Disable=Disable;
	this.Enable=Enable;
	this.HideElement=HideElement;
	this.Initialize=Initialize;
	this.GetValue=GetValue;	
	this.SetValue=SetValue;
	this.GetValueFromCustomAttribute = GetValueFromCustomAttribute;
	this.SetValueToLargeCombo=SetValueToLargeCombo;
	this.SetValueDelimiter=SetValueDelimiter;
	this.Display=Display;
	this.GetPosition=GetPosition;
	this.GetSelectedValues=GetSelectedValues;
	this.GetElement=GetElement;
	this.GetControlType=GetControlType;
	this.GetAlternateControlType=GetAlternateControlType;
	this.ShowSetRating=ShowSetRating;
	this.HoverRating=HoverRating;
	this.Name=Name;
	this.SwitchID=SwitchID;
	this.ToggleVisibility=ToggleVisibility;
	this.ToggleCurrencyField=ToggleCurrencyField;
	this.MakeHiddenType=MakeHiddenType;
	this.SetOnChange=SetOnChange;
	this.CallOnChange=CallOnChange;
	
	//private functions
	function GetAlternateControlType(objElement){
		// This func is used when a new control type was set by the view editor and
		// it is different from the standard control type defined in dts field. Eventually,
		// I think we should always use the objElement to know the control type.
		var lngControlType;

		if (!objElement){
			objElement=m_objElement;
		}
		if (objElement)
		{
			if (objElement.getAttribute)
			{
				var strControlType = objElement.getAttribute("mqcontroltype");
				if (strControlType)
				{
					if (strControlType == "LargeCombo")
					{
						lngControlType = CTRL_TYPE_LARGE_COMBO;
					}
					else if (strControlType == "LargeList")
					{
						lngControlType = CTRL_TYPE_LARGE_LIST;
					}
					else if (strControlType == "MqRating")
					{
						lngControlType = CTRL_TYPE_MQRATING;
					}
				}
				if(objElement.getAttribute("mqdatatype") == CURRENCY_DATATYPE){
					lngControlType=CTRL_TYPE_TEXT;
				}
			}
		}
		return lngControlType;
	}
	
	function GetControlType(objElement){
		var lngControlType;

		if (!objElement){
			objElement=m_objElement;
		}

		if (objElement){						
			lngControlType = _me.GetAlternateControlType();
			if (lngControlType==null)
			{
				if (objElement.selectedIndex>=-1){
					if (!objElement.multiple){
						lngControlType=CTRL_TYPE_COMBO;
					}else{
						lngControlType=CTRL_TYPE_LIST;
					}

				}else{
					var strType=objElement.type;
					if (strType){
						var strUCaseType;
						strUCaseType=strType.toUpperCase();
						if (strUCaseType==TEXT_TYPE.toUpperCase() || 
								strUCaseType==MEMO_TYPE.toUpperCase() || strUCaseType=="HIDDEN" || 
								strUCaseType==PASSWORD_TYPE.toUpperCase()){								
							lngControlType=CTRL_TYPE_TEXT ;
						}
						if (strUCaseType==CHECKBOX_TYPE.toUpperCase()){								
							lngControlType=CTRL_TYPE_CHECK ;
						}
					}else{
									
						if (objElement.tagName.toUpperCase()== DIV_TAG_NAME){
							lngControlType=CTRL_TYPE_DIV;
						}
					}
				}
			}
		}

		return lngControlType;
	}
	
	function GetValuesFromCombo(){
		var arrValues=new Array();
		var lngCount;
		if (m_objElement){		
			var arrOptions=m_objElement.options;	
			if(arrOptions){				
				for (lngCount=0;lngCount<arrOptions.length;lngCount++){
						arrValues[lngCount]=new Array(arrOptions[lngCount].value,arrOptions[lngCount].text);					
				}
			}
		}
		return arrValues;
	}
	
	function SetValuesToCombo(objElement,arrValues,blnSelectFirstValue){
		
		var lngCount;
		var INDEX_VALUE=0;
		var INDEX_TEXT=1;
		var arrItem;
		var lngOldIndex;
		var lngOldValue;
		var blnValsSet=false;
		
		if (objElement){
			
			var arrOptions;
			if(objElement.options){
				arrOptions=objElement.options;
			}
						
			//remove all the items
			lngOldIndex=-1;

			if (objElement.selectedIndex!=-1){
					if (objElement[objElement.selectedIndex]){
						lngOldValue=objElement[objElement.selectedIndex].value;
					}
			}else{
					lngOldValue=null;
			}

			if (arrOptions){
				while (arrOptions.length){
					arrOptions[0]=null;
				}
		
				var lngValue;
				var lngOpt=0;
				arrOptions.length=arrValues.length;
				for (lngCount=0;lngCount<arrValues.length;lngCount++){
						
					arrItem=arrValues[lngCount];

					if (arrItem){
						lngValue=arrItem[INDEX_VALUE];

						arrOptions[lngOpt]=new Option(arrItem[INDEX_TEXT],lngValue);
						
						if (lngValue==lngOldValue){
							lngOldIndex=lngOpt;
						}
						lngOpt++;
					}
				}
				if (arrOptions.length>lngOpt){
					arrOptions.length=lngOpt;
				}
				
				AddEmptyOptionToChoiceList(objElement, false);
				blnValsSet=true;
				
				if (lngOldIndex!=-1) {
					objElement.selectedIndex=lngOldIndex;	
					objElement.options[lngOldIndex].selected=true;
					
				}else{
					if (blnSelectFirstValue){
						//If we specified to set the first value as the selected one, select it
						objElement.selectedIndex=0;
					}else {
						// If no value was selected or there is no match with the new options, clear it.
						objElement.selectedIndex=-1;	
					}
				}
			}
		}
		return blnValsSet;
	}
	

	
	function GetSelectedValueFromCombo(objElement,blnGetText){
		var strValue="";
	
		if (objElement){
			lngSelectedIndex= objElement.selectedIndex;

			if (lngSelectedIndex!=-1){
				if (objElement[lngSelectedIndex]){
					if (blnGetText){
						strValue= objElement[lngSelectedIndex].text;
					}else{
						strValue= objElement[lngSelectedIndex].value;
					}
				}	
			}
		}
		
		return strValue;

	}
	
	function SetValueToCombo(objElement,strValue,blnIsNetscape,blnSetText){
		if (objElement){
			if(blnSetText){
				if(m_objMqAutoList){
					m_objMqAutoList.SelectValueInList(objElement, strValue);
				}
			}else{
				if (!blnIsNetscape){
					AddEmptyOptionToChoiceList(objElement, false);
					objElement.value=strValue;
				}else{
					NavSetValueToCombo(objElement,strValue);
				}
			}
		}
	}
	
	function NavSetValueToCombo (objElement,strValue){
		if (objElement){						
			if (strValue){
				objElement.selectedIndex=FindOptionValueIndex(objElement.options,strValue);		
				AddEmptyOptionToChoiceList(objElement, false);					
			}else{	
				AddEmptyOptionToChoiceList(objElement, true)
			}
		}	
	}
	
	function AddEmptyOptionToChoiceList(objElement, blnSelectOption)
	{
		var intNoValueOptionIndex=-1;
		var fUseNoValueOption=true;
		
		if(fUseNoValueOption){
			intNoValueOptionIndex=FindOptionValueIndex(objElement.options,"");
		
			if (intNoValueOptionIndex==-1){
				intNoValueOptionIndex=objElement.length;
				objElement.options[intNoValueOptionIndex]=new Option(OPTION_NONE,"");
			}
		}
		if(blnSelectOption){
			objElement.selectedIndex=intNoValueOptionIndex;
		}
	}
	
	function SetValueToText(objElement,strValue){
		if (objElement){
			objElement.value=strValue;
			if(objElement.getAttribute("mqdatatype") == CURRENCY_DATATYPE)
			{
				SetCurrency(objElement);
			}
		}
	}

	function SetCurrency(objElement)
	{


		var strRegExDelimiter = new RegExp("\\"+g_MqRef.RESX['CURRENCY.THOUSANDS'], "g");
		var strRegExDecimal = new RegExp("\\"+g_MqRef.RESX['CURRENCY.DECIMAL'], "g");
		
		if(objElement.previousElementSibling.id == objElement.id + "_readonly")
		{
			if(!isNaN(objElement.value.replace(strRegExDelimiter, "").replace(strRegExDecimal, ".")) && objElement.value != "")
			{
				//Convert Edit value to use NA format (#####.##)
				objElement.value = parseFloat(objElement.value.replace(strRegExDelimiter, "").replace(strRegExDecimal, ".")).toFixed(2);
				
				//Update readonly value to the specified currency format (##,###.##) or (##.###,##)
				objElement.previousElementSibling.innerHTML = g_MqRef.RESX['CURRENCY.SYMBOL'] + " " + parseFloat(objElement.value)
														.toFixed(2)
														.toString()
														.replace(/\./g, g_MqRef.RESX['CURRENCY.DECIMAL']) 
														.replace(/\B(?=(\d{3})+(?!\d))/g, g_MqRef.RESX['CURRENCY.THOUSANDS']);
			}
			else
			{
				//Default value for currency field
				objElement.value = "0.00";
				objElement.previousElementSibling.innerHTML = g_MqRef.RESX['CURRENCY.SYMBOL'] + " " + objElement.value;
			}
		}
	}
	
	function GetValueFromText(objElement){
		var strValue="";			
		if (objElement){
			strValue=objElement.value;	
		}
		if(objElement.getAttribute("mqdatatype") == CURRENCY_DATATYPE)
		{
			strValue=g_MqRef.MqStr.FormatCurrency(strValue, true);
		}
		return strValue;

	}
	
	function GetValueFromCheckBox(objElement,type){
		var strValue="";
		if (objElement){
			strValue= objElement.checked;
			if(type == CTRL_TYPE_CHECK) {
				if(strValue){
					strValue = CHOICE_VALUE_ON;
				}
				else if(!strValue){
					strValue = CHOICE_VALUE_OFF;
				}
			}
		}
		return strValue;
	}
	
	function SetValueToCheckBox(objElement,strValue,type){
		if (objElement ){
			var blnValue=true;
			if (!Number(strValue)){
				if(strValue!="true"){
					blnValue=false;
				}
			}
			if(type == CTRL_TYPE_CHECK) {
				if(strValue == CHOICE_VALUE_OFF) {
					blnValue=false;
				}
			}

			objElement.checked=blnValue;
		}
	}
	
	function GetValueFromSCCControl(){
		var strValue="";
		if (objScc){
			strValue=objScc.getObject('MqSccFiles').getAllItems();
		}
		return strValue;
	}
	
	function GetValueFromDIV(objElement){
		var strValue="";
		if (objElement){
			if (objElement.nodeName=="INPUT")
			{
				strValue=objElement.value;
			}else{
				strValue=objElement.innerHTML;
			}
		}
		return strValue;
	}
	
	function SetValueToDiv(objElement,strValue){
		if (objElement){

			if (objElement.nodeName=="INPUT")
			{
				objElement.value=strValue;
			}else{
				objElement.innerHTML=strValue;
			}
		
			
		}
	}
	
	function GetValueFromLargeCombo(objElement, blnGetText){
		var strValue="";
		if (objElement){
			if(blnGetText){
				strValue = objElement.value;
			}else{
				strValue = objElement.getAttribute("mqvalue");
			}
		}

		return strValue;
	}
	
	function GetValueFromCustomAttribute(objElement,strAttributeName){
		var strValue="";
		if (objElement){
			strValue = objElement.getAttribute(strAttributeName);
		}

		return strValue;
	}
	
	function SetValueToLargeCombo(objElement,strValue, strDisplayName, lngFieldID, blnFromName){
		if (objElement){
			objElement.setAttribute("mqvalue", strValue);
			
			if (strValue=="")
			{
				objElement.value="";
			}
			else
			{
				// Check cache for this IDs
				if (!strDisplayName){
					strDisplayName=GetInCache(objElement, strValue);

					if (!strDisplayName && objRequest){
						// if not found, make call to server for Lookup name
						var strHttpRequest=g_MqRef.MqFS.GetCurrentLocation(window);
						strHttpRequest+="wcTopToolbar.asp?WCI=wciGetLookupName&FieldID="+lngFieldID+"&ItemID="+strValue;
						
						var co=objRequest.Get(strHttpRequest);

						if (co!=objRequest.CANCEL_PROCESS){
							var objResponse=objRequest.Response(co);
							if (objResponse.HasErrors()){
								objResponse.ProcessErrors("",true);
							}else{
								var objMsg=objResponse.GetContent();
								if (objMsg){
									strDisplayName=g_MqRef.MqStr.MqDecodeURIComponent(objMsg.GetText());
									SetInCache(objElement, strValue, strDisplayName);
								}				
							}
						}
						
						if(!strDisplayName){
							if(typeof(blnFromName)=="undefined"){
								blnFromName=false;
							}
							if(!blnFromName){
								strDisplayName=SetValueToLargeComboFromName(objElement,strValue, strDisplayName, lngFieldID);
							}
						}
					}
				}
					
				if (!strDisplayName){
					// at least an indication that we have a value set in this field even though
					// we couldn't get the string for some reason
					if(objElement.getAttribute("mqEmptyIfNotFound")=="1"){
						strDisplayName = "";
					}else{
						strDisplayName = "(" + strValue + ")";
					}
				}
					
				// set control's 'visible' value
				objElement.value=strDisplayName;
				
				return strDisplayName;
			}
		}
	}
		
	function SetValueToLargeComboFromName(objElement,strValue, strDisplayName, lngFieldID)
	{
		var strHttpRequest=g_MqRef.MqFS.GetCurrentLocation(window);
						strHttpRequest+="wcTopToolbar.asp?WCI=wciGetLookupID&FieldID="+lngFieldID+"&ItemVal="+strValue;
						
		var co=objRequest.Get(strHttpRequest);

		if (co!=objRequest.CANCEL_PROCESS){
			var objResponse=objRequest.Response(co);
			if (objResponse.HasErrors()){
				objResponse.ProcessErrors("",true);
			}else{
				var objMsg=objResponse.GetContent();
				if (objMsg){
					var lngID=g_MqRef.MqStr.MqDecodeURIComponent(objMsg.GetText());
					if(lngID>0){
						return SetValueToLargeCombo(objElement,lngID, strDisplayName, lngFieldID, true)
					}
				}
			}
		}
	}
	
	function GetInCache(objElement, strValue){
	
		if (m_LargeComboCache)
		{
			if (m_LargeComboCache[objElement.id]){
				var table = m_LargeComboCache[objElement.id];
				
				if (table[strValue]){
					return table[strValue];
				}
			}
		}
	}
	
	function SetInCache(objElement, strValue, strDisplayName){
	
		if (!m_LargeComboCache){
			m_LargeComboCache=new Array();
		}
		
		if (!m_LargeComboCache[objElement.id]){
			m_LargeComboCache[objElement.id]=new Array();
		}
		
		var table=m_LargeComboCache[objElement.id];
		
		table[strValue]=strDisplayName;
	}

	function GetValueFromLargeList(objElement){
		var strValue="";
		if (objElement){

			strValue = objElement.value;

			var strExpression;
			if (g_MqRef.MqBrowser.ie && g_MqRef.MqBrowser.major < 9)
			{
				strExpression = "\r\n";
			}
			else
			{
				strExpression = "\n";
			}

			var regExp=new RegExp(strExpression, "g");

			strValue = strValue.replace(regExp, m_strValueDelimiter);
		}
		return strValue;
	}

	function SetValueToLargeList(objElement,strValue){
		if (objElement)
		{	
			objElement.style.color="#000000";
			if (strValue && strValue.length > 0)
			{
				objElement.value= "";
				var varValues=strValue.split(m_strValueDelimiter);
				for(var lngIndex=0;lngIndex<varValues.length;lngIndex++)
				{
					if (lngIndex > 0){
						var strDelim;
						if (g_MqRef.MqBrowser.ie && g_MqRef.MqBrowser.major < 9)
						{
							strDelim = "\r\n";
						}
						else
						{
							strDelim = "\n";
						}
						objElement.value += strDelim;
					}
					
					var aValue = varValues[lngIndex];
					
					objElement.value += aValue;
				}
			}
			else
			{
				objElement.value= "";
			}
		}
	}

	function GetSelectedValuesFromList(objElement,strValueDelim,blnEscape,blnGetText){
		var strValue="";
		
		if (strValueDelim){
			strValueDelim=DEFAULT_VALUE_DELIM;
		}
		if (objElement){
			var strElemValue;
			for (var i=0; i <= objElement.length - 1; i++){
				if (objElement.options[i].selected){
					strElemValue=objElement.options[i].value;
					if (blnEscape){
						strElemValue=escape(strElemValue);
					}
					if (blnGetText){
						strValue = strValue  + objElement[i].text + strValueDelim;
					}else{
						strValue = strValue  + objElement[i].value + strValueDelim;
					}
				}					
			}
			if (strValue.length>0) {
				strValue = strValue.substr(0,strValue.length - strValueDelim.length);
			}
			
		}
		
		return strValue;
	
	}
	
	function SetValuesToList(objElement,strValues,strValueDelim,blnUnEscape){
		if (objElement){
			if (strValues!=null){
				var varValues=strValues.split(strValueDelim);
				var strListValue;
				var blnFound;
				var strValue;
				for(var lngCounter=0;lngCounter<objElement.length;lngCounter++){
					blnFound=false;
					strListValue=objElement.options[lngCounter].text;
					for(var lngIndex=0;lngIndex<varValues.length;lngIndex++){
						strValue=varValues[lngIndex];
						if (blnUnEscape){
							strValue=unescape(strValue);
						}
						if (strListValue==strValue){
							blnFound=true;						
							break;
						}
					}
					if (blnFound){
						objElement.options[lngCounter].selected=true;
					}else{
						objElement.options[lngCounter].selected=false;
					}
					
				}
			}			
		}
	}

	function SetValueToMqList(objElement,strValue)
	{
		if (objElement){
			var strListCtl = objElement.getAttribute("mqlist");
			var ctlList = document.getElementById(strListCtl);
			if (ctlList){
				var intMatch=FindOptionValueIndex(ctlList.options,strValue);
				if (intMatch>=0){
					objElement.innerHTML=g_MqRef.MqStr.MqHtmlEncode(ctlList.options[intMatch].text);
					objElement.setAttribute("mqvalue",strValue);
				}
			}
		}
	}
	
	function GetValueFromMqList(objElement, blnGetText)
	{
		var strValue="";
		
		if (objElement){
			strValue=objElement.getAttribute("mqvalue");
		}
		return strValue;
	}

	function FindOptionValueIndex(objHTMLOptions,strValue){
		var intValueIndex=-1;
		if (objHTMLOptions){
			for(var i = 0; i < objHTMLOptions.length; i++){ 
				if (objHTMLOptions[i]){
					if (objHTMLOptions[i].value ==strValue){
						intValueIndex=i;
						break;
					}
				}
			}
		}
		return intValueIndex;
	}

	function SetValuesToLargeCombo(objElement,strValues,strTriggerFieldID,blnSelectFirstValue)
	{	
		if (objElement){
			var WKFLW_NO_VALUES="-1";
			var WKFLW_DONT_SET="-2";
			var WKFLW_ATTRIB="MqWrkFlwVals";
			
			if(strValues==WKFLW_DONT_SET){
				var strAttrib=objElement.getAttribute(WKFLW_ATTRIB);
				if(strAttrib==""){
					objElement.setAttribute(WKFLW_ATTRIB, strValues);
				}else{
					if(AllDependentFieldsAreEmpty(objElement)){
						strValues="";
						objElement.setAttribute(WKFLW_ATTRIB, strValues);
					}else{
						ReloadDepValsForFields(strTriggerFieldID);
					}
				}
			}else{
				objElement.setAttribute(WKFLW_ATTRIB, strValues);
			}
			
			var blnCurrentValInPossVals=true;
			var strValToSet="";
			var blnValSet=false;
			
			if(strValues){
				if(strValues.length>0){
					if(strValues!=WKFLW_DONT_SET){
						blnCurrentValInPossVals=false;
						var strCurrentValue=GetValueFromLargeCombo(objElement);
						
						var arrValues=strValues.split(m_strValueDelimiter);
						
						if(strCurrentValue!=""){
							for(var i=0; i<arrValues.length; i++){ 
								if (arrValues[i]){
									if (arrValues[i]==strCurrentValue){
										blnCurrentValInPossVals=true;
										break;
									}
								}
							}
						}else{
							blnCurrentValInPossVals=true;
						}
					}else{
						blnCurrentValInPossVals=true;
					}
					if(arrValues.length==1){
						if(blnSelectFirstValue){
							strValToSet=arrValues[0];
						}
					}
				}
			}
			if(strValToSet!="" && strValToSet !=WKFLW_NO_VALUES){
				if(strValToSet!=strCurrentValue){
					SetValue(strValToSet,false,objElement);
					blnValSet=true;
				}
			}else{
				if(blnCurrentValInPossVals==false){
					SetValue("",false,objElement);
					blnValSet=true;
				}		
			}	
			return blnValSet;			
		}
	}

	function SetValuesToLargeCombo_Text(objElement,strValues)
	{	
		if (objElement){
			var WKFLW_ATTRIB="MqWrkFlwVals";			
			objElement.setAttribute(WKFLW_ATTRIB, strValues);
			return true;			
		}
	}

	function AllDependentFieldsAreEmpty(objElement)
	{
		var blnAllAreEmpty=true;
		if(m_objWorkFlow){
			var varDependentFields=m_objWorkFlow.GetDependentFields();
			var strTargetFields;
			var arrDepFld;
			var arrTargetFields;
			var strSourceFields;
			var arrSourceFields;
			var objField;
			if(varDependentFields){
				if(m_objViewFields){
					var lngFieldID=m_objViewFields.GetFieldIDByBoundCtrl(objElement.id);
					for(x=0;x<varDependentFields.length;x++){
						arrDepFld=varDependentFields[x];
						if(arrDepFld){
							strTargetFields=arrDepFld.getTargetFieldIDs();
							arrTargetFields=strTargetFields.split(";");
							if(arrTargetFields){			
								for(y=0;y<arrTargetFields.length;y++){
									if(arrTargetFields[y]==lngFieldID){
										strSourceFields=arrDepFld.getSourceFieldIDs();
										arrSourceFields=strSourceFields.split(";");
										if(arrSourceFields){
											for(z=0; z<arrSourceFields.length;z++){									
												var lngSrcField=arrSourceFields[z];
												objField=m_objViewFields.Field(lngSrcField);
												if(objField){
													var objHTMLElement=m_objDocContainer.getElementById(objField.GetBoundControl());
													if(objHTMLElement){
														var strSrcVal=GetValue(false, objHTMLElement);
														if(strSrcVal!=""){
															blnAllAreEmpty=false;
															break;
														}
													}
												}
											}
										}
									}
								}
							}
						}
						if(!blnAllAreEmpty){
							break;
						}
					}
				}
			}
		}
		return blnAllAreEmpty;
	}
	
	function ReloadDepValsForFields(lngExcludeFieldID)
	{
		if(lngExcludeFieldID){
			var varDependentFields=m_objWorkFlow.GetDependentFields();
			var strTargetFields;
			var arrDepFld;
			var arrTargetFields;
			var blnCallSetDep;
			if(varDependentFields){
				if(m_objViewFields){
					for(var intCount=0;intCount<varDependentFields.length;intCount++){
						arrDepFld=varDependentFields[intCount];
						if(arrDepFld){
							blnCallSetDep=true;
							strTargetFields=arrDepFld.getTargetFieldIDs();
							arrTargetFields=strTargetFields.split(";");
							if(arrTargetFields){			
								for(y=0;y<arrTargetFields.length;y++){
									if(arrTargetFields[y]==lngExcludeFieldID){
										blnCallSetDep=false;
									}
								}
								if(blnCallSetDep){			
									arrDepFld.SetDependentField(m_objWorkFlow.GetOrigFldValues(), false, m_objWorkFlow.GetVerifyCondFldsExist());
								}
							}
						}
					}
				}
			}
		}
	}

	function SetValuesToLargeList(objElement,strValues)
	{	
		if (objElement){
			objElement.setAttribute("MqWrkFlwVals", strValues);
		}
	}

	function SetValueToMqRating(objElement,strValue)
	{
		if(SetRatingVal(objElement, strValue)){
			ShowSetRating(objElement);
		}
	}

	function GetValueFromMqRating(objElement)
	{
		var strValue="";
		
		if (objElement){
			strValue=objElement.getAttribute("mqvalue");
		}
		return strValue;
	}
	
	function SetRatingVal(objElement, lngVal)
	{
		if(objElement){
			objElement.setAttribute("mqvalue", lngVal);
			return true;
		}
	}
	
	function ShowSetRating(objElement)
	{
		if(objElement){
			var objDoc=objElement.ownerDocument;
			var strFieldID=objElement.getAttribute("mqfldid");
			var objImg;
			var objCaption=objDoc.getElementById("rating_" + strFieldID + "_caption");
			var strCaption="";
			var blnFound=false;
			var strSetVal;
			var lngNumOptions=0;
		
			if(objCaption){
				strSetVal=objElement.getAttribute("mqvalue");
				lngNumOptions=parseInt(objElement.getAttribute("mqnumoptions"));
				if(strSetVal==""){
					for(x=0; x<lngNumOptions; x++){
						objImg=objDoc.getElementById("rating_" + strFieldID + "_" + (parseInt(x)+1));
						if(objImg){	
							objImg.src=GetImgSrc(objImg, false); //"../../Theme/images/buttons/star_off.gif";
						}
					}
					if(objElement.getAttribute("mqreadonly")==""){
						objCaption.innerHTML=g_MqRef.RESX['DISPLAY_CLICK_TO_RATE'];
					}else{
						objCaption.innerHTML=g_MqRef.RESX['DISPLAY_CLICK_RATE_NONE'];
					}
				}else{
					for(x=0; x<lngNumOptions; x++){
							
						objImg=objDoc.getElementById("rating_" + strFieldID + "_" + (parseInt(x)+1));
						if(objImg){						
							if(blnFound==true){
								objImg.src=GetImgSrc(objImg, false); //"../../Theme/images/buttons/star_off.gif";
							}else{
								objImg.src=GetImgSrc(objImg, true); //"../../Theme/images/buttons/star_on.gif";
							}
							strCaption=objImg.getAttribute("MqCLVal");
							if(objImg.getAttribute("MqCLID")==strSetVal || (strCaption==strSetVal && isNaN(strCaption))){
									
								if(strCaption==""){
									strCaption = g_MqRef.RESX['DISPLAY_CLICK_TO_RATE'];
								}else{
									strCaption="(" + strCaption + ")";
								}
								objCaption.innerHTML=strCaption;
								blnFound=true;
							}else{
								if(lngNumOptions<=2){
									objImg.src=GetImgSrc(objImg, false);
								}
							}
						}
					}
				}
			}
		}
	}
	
	function HoverRating(objElement, lngIndex)
	{
		if(objElement){
			if(objElement.getAttribute("mqreadonly")==""){
				var objDoc=objElement.ownerDocument;
				var strFieldID=objElement.getAttribute("mqfldid");
				var objImg;
				var objCaption=objDoc.getElementById("rating_" + strFieldID + "_caption");
				var strCaption="";
				var blnFound=false;
				var strSetVal;
				var lngNumOptions=0;
				
				if(objCaption){
					lngNumOptions=parseInt(objElement.getAttribute("mqnumoptions"));
					for(x=0; x<lngNumOptions; x++){
						objImg=objDoc.getElementById("rating_" + strFieldID + "_" + (parseInt(x)+1));
						if(objImg){	
							objImg.src=GetImgSrc(objImg, false); //"../../Theme/images/buttons/star_off.gif";
						}
					}

					if(lngNumOptions>2){
						for(x=0; x<lngIndex; x++){
							objImg=objDoc.getElementById("rating_" + strFieldID + "_" + (parseInt(x)+1));
							if(objImg){
								objImg.src=GetImgSrc(objImg, true); //"../../Theme/images/buttons/star_on.gif";
								strCaption=objImg.getAttribute("MqCLVal");
									
								if(strCaption!=""){
									strCaption="(" + strCaption + ")";
								}
								objCaption.innerHTML=strCaption;
							}
						}
					}else{
						objImg=objDoc.getElementById("rating_" + strFieldID + "_" + lngIndex);
						if(objImg){
							objImg.src=GetImgSrc(objImg, true); //"../../Theme/images/buttons/star_on.gif";
							strCaption=objImg.getAttribute("MqCLVal");
									
							if(strCaption!=""){
								strCaption="(" + strCaption + ")";
							}
							objCaption.innerHTML=strCaption;
						}
					}
				}
			}
		}
	}
	
	function GetImgSrc(objImg, blnOn)
	{
		var strSrc=objImg.src;
		
		if(blnOn){
			return strSrc.replace("off.gif", "on.gif");
		}else{
			return strSrc.replace("on.gif", "off.gif");
		}
	}	
}	

function CMqFileElement(strID){
    var m_objFileElement;
    var m_strID;
    var m_objContainerDoc;
    var FILE_ON_CHANGE_FUNCT_NAME ="OnChange";
    //constructor
    m_strID=strID;
    //end constructor
    
    function GetHTML(strBaseClassName, strImagePath){
        var strClassHover;
        var DEFAULT_TXT_CLASS="FileTextBox";
        var CLASS_HOVER_EXT ="Hover";
        var DEFAULT_IMG_PATH="../../../Theme/images/buttons/";
        var strFileElemID;
        strFileElemID=GetFileElemID(m_strID );
 
        if (strBaseClassName){
            if (strBaseClassName.length===0){
                strBaseClassName=DEFAULT_TXT_CLASS;
            }
        }else{
            strBaseClassName=DEFAULT_TXT_CLASS;
        }
        strClassHover=strBaseClassName+CLASS_HOVER_EXT;
 
		if(strImagePath){
			if(strImagePath.length==0){
				strImagePath=DEFAULT_IMG_PATH;
			}
		}else{
			strImagePath=DEFAULT_IMG_PATH;
		}

        var strHTML='<table width="100%" height="100%" cellpadding="0" cellspacing="0" border="0px">';
        strHTML+='<tr><td align"right" class="BrowseTxtFileTD">';
        strHTML+='<input type="text" class=\''+strBaseClassName +'\' onmouseover="this.className=\''+ strClassHover + '\';" onmouseout="this.className=\''+strBaseClassName +'\';"  name="' +m_strID+ '" id="'+m_strID+'" >';
        strHTML+='</td><td class="BrowseButtonTD">';
        strHTML+='<script type="text/javascript">document.write(writeImageAlt("Browse","' + 
        		strImagePath + '","js:document.getElementById(\''+ strFileElemID +
        		'\').click();",78,27, false,g_MqRef.RESX["BROWSE_FILE_BUTTON_TOOLTIP"]));<\/script>';
        strHTML+=GetFileJsCode(m_strID);
        strHTML+='<div id="divFile" name="divFile" style="display:none">';
        strHTML+=GetFileHTMLCode(m_strID);
        strHTML+='</div></td></tr></table>';
        return strHTML;
        
    }
    function WriteHTML(strBaseClassName,objContainerDoc, strImagePath){
        var objDoc = GetValidContainerDoc(objContainerDoc);
        
        if (objDoc){
            objDoc.write(GetHTML(strBaseClassName,strImagePath));
        }
    }
    
    function GetValue(){
        var strValue;
        if (!m_objFileElement){
            m_objContainerDoc=GetValidContainerDoc(m_objContainerDoc);
            m_objFileElement=GetFileElement(m_objContainerDoc,m_strID);
            
        }
        if (m_objFileElement){
            strValue= m_objFileElement.value;
        }
        return strValue;
    }
    
   function SetValue(strValue){
        if (!m_objFileElement){
            m_objContainerDoc=GetValidContainerDoc(m_objContainerDoc);
            m_objFileElement=GetFileElement(m_objContainerDoc,m_strID);
            
        }
        if (m_objFileElement){
            m_objFileElement.value=strValue;
        }
    }
    
    function GetHTMLObject(){
        if (!m_objFileElement){
            m_objContainerDoc=GetValidContainerDoc(m_objContainerDoc);
            m_objFileElement=GetFileElement(m_objContainerDoc,m_strID);
            
        }
        return m_objFileElement;
    }
    function SetContainerDoc(objContainerDoc){
        m_objContainerDoc=objContainerDoc;
    }
    
    function Clear()
    {
		SetValue("");
		if (!m_objContainerDoc){
			m_objContainerDoc=GetValidContainerDoc(m_objContainerDoc);
		}
		if (m_objContainerDoc){
			var divFileElem=m_objContainerDoc.getElementById("divFile");
			if (divFileElem){
				divFileElem.innerHTML=GetFileHTMLCode(m_strID);
			}
		}

    }
    this.SetValue=SetValue;
    this.GetValue=GetValue;
    this.WriteHTML=WriteHTML;
    this.GetHTML=GetHTML;
    this.GetHTMLObject=GetHTMLObject;
    this.SetContainerDoc=SetContainerDoc;
    this.Clear=Clear;
    
    //private functions
    function GetFileJsCode(strElemID)
    {
		var strJsCode='<script type="text/javascript">';
		
		var strOnChangeFunctionCode='function '+ GetFileFunctName(FILE_ON_CHANGE_FUNCT_NAME,strElemID)+'(objFile){';
		strOnChangeFunctionCode+='var txtFile= document.getElementById("'+strElemID+'");';
		strOnChangeFunctionCode+='if (txtFile){txtFile.value=objFile.value;txtFile.onchange();}';
		strOnChangeFunctionCode+='}';		
		strJsCode+=strOnChangeFunctionCode;
		
		strJsCode+='</script>';
		return strJsCode;
    }
    
    function GetFileFunctName(strFunctName,strElemID)
    {
		var strOnChangeFuncName=strFunctName+strElemID;
		return strOnChangeFuncName;
    }
    
    function GetFileHTMLCode(strElemID)
    {
		var strFileElemID=GetFileElemID(strElemID);	
		var strOnChangeFunctName=GetFileFunctName(FILE_ON_CHANGE_FUNCT_NAME,strElemID);	
		var strHTMLCode='<input  type="file"  class="HiddenInputFile" name="' +strFileElemID +'" id="'+strFileElemID +'" onpropertychange="'+strOnChangeFunctName+'(this);" onchange="'+strOnChangeFunctName+'(this);" />';
		return strHTMLCode;
    }
    
    function GetFileElemID(strElemID)
    {
		return "Hidden"+ strElemID +"File";
    }
    
    function GetFileElement(objContainerDoc, strElemID){
        var objFileElement;
        if (objContainerDoc){
            objFileElement=objContainerDoc.getElementById(strElemID);
        }
        
        return objFileElement;
    }
    
    function GetValidContainerDoc(objContainerDoc){
        var objTmpContainerDoc;
        if (objContainerDoc){
            objTmpContainerDoc = objContainerDoc;
        }else{
            if (document){
                objTmpContainerDoc=document;
            }
        }
        return objTmpContainerDoc;
    }
    
}

function CMqRichTextEditor(oCKeditor, chkFormatID, htmlElementID)
{
	var m_oEditor = oCKeditor;
	var m_HtmlElement;
	var m_EditorElement;
	var m_chkFormat;
	var CKEDITOR_ELEMENT_PREFIX = "cke_"
	
	function Init()
	{
		//m_oEditor = oCKeditor;
		m_HtmlElement = document.getElementById(htmlElementID);
		m_EditorElement = document.getElementById(CKEDITOR_ELEMENT_PREFIX + htmlElementID);
		m_chkFormat = document.getElementById(chkFormatID);
		FormatChange();
	}
	
	//Retrieve Data from the Editor
	function GetData()
	{
		var value;
		if(m_oEditor != "")
		{
			value = m_oEditor.getData();
		}
		return value;
	}
	
	//Set Data to the Editor.  NOTE: This will replace all text in the editor.
	function SetData(strValue)
	{
		m_oEditor.setData(strValue);
	}
	
	//Returns Body element of the Editor.
	function GetBody()
	{
		var value;
		if(m_oEditor != "")
		{
			value = m_oEditor.document.getBody();
		}
		return value;
	}
	
	//Return current editor mode.  (WYSIWYG <-> Source)
	function GetMode()
	{
		var value;
		if(m_oEditor != "")
		{
			value = m_oEditor.mode;
		}
		return value;
	}
	
	//Insert HTML at the current cursor point
	function InsertHTML(strValue)
	{
		m_oEditor.insertHtml(strValue);
	}
	
	//Change the editor format (plain <-> rich)
	function FormatChange()
	{
		if(m_chkFormat.checked)
		{
			//Hide textarea and show the ckeditor
			m_HtmlElement.style.visibility='hidden';
			m_HtmlElement.style.display='none';
			m_EditorElement.style.visibility='visible';
			m_EditorElement.style.display='block';
		}
		else
		{
			//Hide ckeditor and show parent textarea
			m_EditorElement.style.visibility='hidden';
			m_EditorElement.style.display='none';
			m_HtmlElement.style.visibility='visible';
			m_HtmlElement.style.display='block';
		}
	}
	
	this.Init = Init;
	this.GetData = GetData;
	this.SetData = SetData;
	this.InsertHTML = InsertHTML;
	this.GetBody = GetBody;
	this.GetMode = GetMode;
	this.FormatChange = FormatChange;
}

// VNFields wraps a DtsField in the record UI
function VNFormField(oFldDef, oDataHTMLDoc)
{
	var _me=this;
	
	this.MQF_PREFIX = "MqF_";
	this.MQF_CAPTION_PREFIX = "MqFC_";
	this.MQF_EXTRA_PREFIX = "MqFExt_";
	
	// Actually a postfix right now. To be changed.
	var MQBTN_PREFIX = "_SelVal";
	
	// a CMqField
	var m_oFldDef=oFldDef;
	var m_oDataHTMLDoc=oDataHTMLDoc;
	
	// Controls (form elements)
	var m_oCapFrmElem;
	var m_oFldFrmElem;
	var m_oValFrmElem;
	var m_oBtnFrmElem;
	
	function GetCaptionControl()
	{
		if (!m_oCapFrmElem)
		{
			if (m_oFldDef)
			{
				m_oCapFrmElem= new CMqFormElement();

				m_oCapFrmElem.Initialize( _me.GetCaptionCtlName() ,
									null,
									m_oDataHTMLDoc);
			}	
		}
		return m_oCapFrmElem;

	}

	function GetFieldControl()
	{
		if (!m_oFldFrmElem)
		{
			if (m_oFldDef)
			{
				m_oFldFrmElem= new CMqFormElement();

				m_oFldFrmElem.Initialize( _me.GetFieldCtlName() ,
									null,
									m_oDataHTMLDoc);
			}	
		}
		return m_oFldFrmElem;

	}

	function GetValueControl()
	{
		if (!m_oValFrmElem)
		{
			if (m_oFldDef)
			{
				m_oValFrmElem= new CMqFormElement();

				m_oValFrmElem.Initialize(m_oFldDef.GetBoundControl(),
									m_oFldDef.GetControlType(),
									m_oDataHTMLDoc);
			}	
		}
		return m_oValFrmElem;
	}
	
	function GetButtonControl()
	{
		if (!m_oBtnFrmElem)
		{
			if (m_oFldDef)
			{
				m_oBtnFrmElem= new CMqFormElement();

				// There are 2 cases: ID_SelVal and CtlName_SelVal
				// TODO: change to ID to standardize. Simplify button naming convention. 
				var sCtlName=_me.GetBtnCtlName();
					
				if (!m_oDataHTMLDoc.getElementById(sCtlName))
				{
					sCtlName=m_oFldDef.GetBoundControl() + MQBTN_PREFIX;
				}
				
				if (!m_oDataHTMLDoc.getElementById(sCtlName))
				{
					sCtlName="a_" + m_oFldDef.GetBoundControl() + MQBTN_PREFIX;
				}
				
				m_oBtnFrmElem.Initialize(sCtlName,
								null,
								m_oDataHTMLDoc);
			}
		}
		return m_oBtnFrmElem;

	}
	
	
	function GetCaptionCtlName()
	{
		return (_me.MQF_CAPTION_PREFIX + m_oFldDef.GetID());
	}
	
	function GetFieldCtlName()
	{
		return (_me.MQF_PREFIX + m_oFldDef.GetID());
	}

	function GetBtnCtlName()
	{
		// There are 2 cases: ID_SelVal and CtlName_SelVal
		// TODO: change to ID to standardize. Simplify button naming convention. 
		return m_oFldDef.GetID() + MQBTN_PREFIX;
	}
	
	function GetFieldDef()
	{
		return m_oFldDef;
	}
	
	// Check the field control to determine if it's defined to be hidden
	function IsHiddenType()
	{

		var bRet=false;

		if (!m_oFldFrmElem)
		{
			_me.GetFieldControl();
		}
		
		if (m_oFldFrmElem)
		{
			var oDOMElem=m_oFldFrmElem.GetElement();
			if (oDOMElem)
			{
				if (oDOMElem.className==m_oFldFrmElem.HIDDEN_OBJ_CLASS && 
					oDOMElem.getAttribute(m_oFldFrmElem.HIDDEN_ATTRIBUTE)==m_oFldFrmElem.ATTR_TRUE)
				{
					bRet=true;
				}
			}
		}
		return bRet;
	}
	
	// Make field and caption controls hidden type 
	function MakeHiddenType()
	{

		var bRet=false;

		_me.GetCaptionControl();
		
		if (m_oCapFrmElem)
		{
			m_oCapFrmElem.MakeHiddenType();
		}
		
		_me.GetFieldControl();
		
		if (m_oFldFrmElem)
		{
			m_oFldFrmElem.MakeHiddenType();
		}
		
		return bRet;
	}


	function AddURLButton(strURL,strCSSClassName)
    {
		var strTooltipButton="";
		var URL_BUTTON_NAME="RC";
		var RC_CSS_CLASS_NAME="RemoteControl";
		var strURLButtonName;
		var objString=new MqString();
		var USER_DETAILS_CLASS_NAME ="UserDetails";
		var BROWSE_ALT_CHOICE_LIST_CLASS_NAME ="BrowseAlternateChoiceList";
		var strButtonAction="MqOpenURL('"+strURL+"')";
		
		if (RC_CSS_CLASS_NAME==objString.Left(strCSSClassName,RC_CSS_CLASS_NAME.length)){
			strTooltipButton=parent.TITLE_START_REMOTE_CONTROL;
		}else{			
			if(USER_DETAILS_CLASS_NAME.toLowerCase()==objString.Left(strCSSClassName,USER_DETAILS_CLASS_NAME.length).toLowerCase()){
				strTooltipButton=parent.TITLE_USER_DETAILS;
				strButtonAction=strURL;
			}else{	
				if(BROWSE_ALT_CHOICE_LIST_CLASS_NAME.toLowerCase()==objString.Left(strCSSClassName,BROWSE_ALT_CHOICE_LIST_CLASS_NAME.length).toLowerCase()){
					strTooltipButton=parent.TITLE_SELECT_VALUE;
					strButtonAction=strURL;
				}else{
					strTooltipButton=parent.TITLE_CONNECT_TO_WEB_ADDRESS;
				}
			}
		}
				
		if(m_objMqButton){	
			strURLButtonName=_me.GetBtnCtlName();
			
			m_objMqButton.WriteButtonHTML(strURLButtonName,strButtonAction,strCSSClassName,false,m_objMqButton.STATE_1,strTooltipButton, null, m_oDataHTMLDoc);
		}
    }		

	function SetCaption(sCaption)
	{
		var oCapFrmElem= _me.GetCaptionControl().GetElement();
		
		if (oCapFrmElem)
		{

			oCapFrmElem.innerText =sCaption;
		}
	}
	
	function Enable()
	{
		_me.GetValueControl().Enable();

		// Make the selection button visible
		var oBtn=_me.GetButtonControl();
		
		if (oBtn)
		{
			oBtn.Show();
		}

	}

	function Disable()
	{

		_me.GetValueControl().Disable();
		
		var oBtn=_me.GetButtonControl();

		// Make the selection button visible
		
		if (oBtn)
		{
			oBtn.Hide();
		}
	}
	
	function GetValue()
	{

		return _me.GetValueControl().GetValue();
		
	}

	function SetValue()
	{

		_me.GetValueControl().SetValue();
		
	}
	
	function GetHTMLDoc()
	{
		return oDataHTMLDoc;
	}
	
	this.GetFieldDef=GetFieldDef;
	this.GetHTMLDoc=GetHTMLDoc;
	
	this.GetCaptionCtlName=GetCaptionCtlName;
	this.GetFieldCtlName=GetFieldCtlName;
	this.GetBtnCtlName=GetBtnCtlName;
	
	// Controls (form elements)
	this.GetCaptionControl=GetCaptionControl;
	this.GetFieldControl=GetFieldControl;
	this.GetValueControl=GetValueControl;
	this.GetButtonControl=GetButtonControl;
	
	this.IsHiddenType=IsHiddenType;
	this.MakeHiddenType=MakeHiddenType;
	this.AddURLButton=AddURLButton;
	this.SetCaption=SetCaption;
	this.Enable=Enable;
	this.Disable=Disable;
	this.GetValue=GetValue;
	this.SetValue=SetValue;
	
	
}

function VNImageField(oVNFrmFld, iGetFromProjID)
{
	// prefix used in the image field template files
	var IMG_CTL_NAME_PREFIX = "img_";
	var m_oVNFrmFld=oVNFrmFld;	// the image field
	var m_sImgCtlName="img_" + m_oVNFrmFld.GetFieldDef().GetID();
	var m_iGetFromProjID=iGetFromProjID;
	var m_sDefaultImage="";
	// Field to get the ID of the record to get the image from 
	// By default it is the same field, but it can be from another DTS field.
	var m_oSrcFrmFld=m_oVNFrmFld; 
	
	var _me=this;
	
	function Set(iRecID)
	{
		var objImg=m_oVNFrmFld.GetHTMLDoc().getElementById(m_sImgCtlName);
			
		if(objImg)
		{
			
			if (iRecID)
			{
				objImg.src="viewicon.asp?Rec=" + iRecID + "&Proj=" + m_iGetFromProjID;
	
			}else{
			
				objImg.src=m_sDefaultImage;
			}
				
		}
	}
	
	// Use the value of the internal VN form field
	function SetFromField()
	{
		// Use the specified source field
		var iRecID=m_oSrcFrmFld.GetValue();
		
		_me.Set(iRecID);
	}
	
	function SetSourceField(oSrcFrmFld)
	{
		if (oSrcFrmFld)
		{
			m_oSrcFrmFld=oSrcFrmFld;
		}
	}
	
	
	function OnError()
	{

		try
		{
			var objImg=m_oVNFrmFld.GetHTMLDoc().getElementById(m_sImgCtlName);
				
			if(objImg)
			{
				objImg.src=m_sDefaultImage;
				objImg.onerror=objImg.onerror;
			}
		
			return true;
		}catch(e)
		{}
	}

	function SetDefaultImage(sDefaultImage)
	{
		m_sDefaultImage=sDefaultImage;
	}
	
	this.Set=Set;
	this.SetFromField=SetFromField;
	this.OnError=OnError;
	this.DEFAULT_IMG_USER="../../theme/images/images/unknownemp.png";
	this.SetDefaultImage=SetDefaultImage;
	this.SetSourceField=SetSourceField;
	
}
