
Array.prototype.remove = function() {
	var what, a = arguments, L = a.length, ax;
	while(L && this.length) {
		what = a[--L];
		while((ax = this.indexOf(what)) !== -1) {
			this.splice(ax,1);
		}
	}
	return this;
};
function IEincludes(container, value) {
	var returnVal = false;
	var pos = container.indexOf(value);
	if (pos >= 0) {
		returnVal = true;
	}
	return returnVal;
}
this.IEincludes = IEincludes;
var m_Grid = {};

function VNGridUIRulesController (oGrid, arrColCenDataTypes) 
{
	var UIRuleProps = {};
	m_Grid = oGrid;
	var curRule = 0;
	var infoStr = "";
	if(typeof SL_UI_Settings !== 'undefined') {infoStr = SL_UI_Settings;}
	var curStyling;
	var colsToStyle = [];
	var styleRules = [];
	var divider = 2;
	var rule = [];
	var priSplit;
	var m_arrCenDataTypes = arrColCenDataTypes;
	
	function LoadGridUIPropRules() {
		var curRule;
		
		if (infoStr != undefined) {
			 priSplit = infoStr.split(";");
		}
		
		for (z=0; z < priSplit.length; z++) {
			switch (z % divider) {
				case 0:
					rule[0] = priSplit[z];
					break;
				case 1:
					rule[1] = priSplit[z];
					ApplySingleRule();
					break;
			}
		}
		FormatColData();
	}
	function LoadSingleRuleBypass() {
		ApplySingleRule();
		FormatColData();
	}
	
	
	function Apply() {
		LoadGridUIPropRules();
	}
	
	this.Apply=Apply;
	this.LoadGridUIPropRules = LoadGridUIPropRules;
	this.LoadSingleRuleBypass = LoadSingleRuleBypass;
	
	function FormatColData()
	{
		var colDateIndexes = [];
		var colCostIndexes = [];
		var curColl;
		var cellVal;
		var dataVal;
		var formattedVal;
		var NumRows = 0;
		var Cell = {};
		
		try {
			NumRows = m_Grid.getRowsNum();
		} catch(err) {
			NumRows = 0;
		}
		
		if(m_arrCenDataTypes){
			for(var l=0; l<m_arrCenDataTypes.length;l++){
				if(m_arrCenDataTypes[l]==8){
					colDateIndexes.push(l);
				}else{
					if(m_arrCenDataTypes[l]==5){
						colCostIndexes.push(l);
					}
				}
			}
		}
		
		if(colDateIndexes.length > 0 || colCostIndexes.length > 0)	{
			
			//Apply Date and cost formatting
			for (i=0; i < NumRows; i++) {
				for (n=0; n<colDateIndexes.length;n++) {
					curColl = colDateIndexes[n];
					Cell[i] = m_Grid.cellByIndex(i,curColl).getValue();
					cellVal = Cell[i];
					dataVal=g_MqRef.MqStr.ExtractTextFromHTML(cellVal);
					if(dataVal.indexOf(" ")>0){
						formattedVal=dataVal.split(" ");
						formattedVal=formattedVal[0];
						formattedVal=cellVal.replace(dataVal, formattedVal);
						m_Grid.cellByIndex(i,curColl).setValue(formattedVal);
					}
				}
				for (n=0; n<colCostIndexes.length;n++) {
					curColl = colCostIndexes[n];
					Cell[i] = m_Grid.cellByIndex(i,curColl).getValue();
					cellVal = Cell[i];
					dataVal=g_MqRef.MqStr.ExtractTextFromHTML(cellVal);
					formattedVal=g_MqRef.MqStr.FormatCurrency(dataVal);
					formattedVal=cellVal.replace(dataVal, formattedVal);
					m_Grid.cellByIndex(i,curColl).setValue(formattedVal);
				}
			}
		}
	}
	
	function ApplySingleRule() {
		var hdrLabelsArr = [];
		var curChoice;
		var NumRows = 0;
		var Cell = {};
		var color = 0;
		var value = 0;
		var ruleProps;
		var selectedRuleProps = {};
		var values = {};
		var colors = {};
		var splitCellVal = {};
		var curColStyle;
		var temp1 = [];
		var temp2 = [];
		var splitColor = "|1";
		var splitFlag = "|2";
		var curCell = {match:"",value:""};
		
		try {
			hdrLabelsArr = m_Grid.hdrLabels;
		} catch(err) {
			hdrLabelsArr = [];
		}
		
		if (typeof m_arrColFieldIDs !== 'undefined') {
			if(rule[0]) {
				curColStyle = m_arrColFieldIDs.indexOf(rule[0]);
			} else {
				curColStyle = 0;
			}
		}
			
		for (n=1; n<rule.length; n++) {
			if (IEincludes(rule[n],splitColor)) {
				temp1 = rule[n].split(splitColor);
				curStyling = 1;
			} else if (IEincludes(rule[n],splitFlag)) {
				temp1 = rule[n].split(splitFlag);
				curStyling = 2;
			}
		}
	
		for (n=0; n < temp1.length; n++) {
			temp2[n] = temp1[n].split("|");
		}
		for (n=0; n < temp2.length; n++) {
			temp2[n].remove("");
		}
		
		try {
			NumRows = m_Grid.getRowsNum();
		} catch(err) {
			NumRows = 0;
		}

		if(temp2 != undefined) {
			for (i=0; i < temp2.length; i++) {
				selectedRuleProps = temp2[i];
				for (s=0; s< selectedRuleProps.length; s++) {
					switch (s % divider) {
						case 0:
							values[value] = selectedRuleProps[s];
							value++;
							break;
						case 1:
							colors[color] = selectedRuleProps[s];
							color++;
							break;
					}
				}
			}
		}
		
		//Apply color or Flag
		if (curColStyle > 0) {
			for (i=0; i < Object.keys(values).length; i++) {
				curChoice = (values[i]);
				for (n=0; n < NumRows; n++) {
					Cell[n] = m_Grid.cellByIndex(n,curColStyle).getValue();
					curCell.value = Cell[n];
					splitCellVal = Cell[n].split("<",2);
					curCell.match = splitCellVal[1].split(">",2);
					if (curCell.match[1] === curChoice) {
						switch(curStyling) {
							case 0:
								break;
							case 1:
								$( "a" ).css("color","inherit");
								m_Grid.cellByIndex(n, curColStyle).setTextColor(colors[i]);
								break;
							case 2:
								$( "a" ).css("color","inherit");
								m_Grid.cellByIndex(n, curColStyle).setValue( "<" + curCell.match[0] + "> <i class='fa fa-flag'></i> " + curCell.match[1]);
								m_Grid.cellByIndex(n, curColStyle).setTextColor(colors[i]);
								break;
						}
					}
				}
			}
		}
	}
}