// Dependencies:
//	images.js
//  MqFormElements.js

if (!m_objMqButton){
	var m_objMqButton=new MqButton();
}
var m_objFormElement;

function CMqTabsMgr()
{
	var IMG_MOVE_TABS_LEFT = "TabsLeft";
	var IMG_MOVE_TABS_RIGHT = "TabsRight";
	var TD_LEFT_PREFIX="TD_LEFT_";
	var TD_MIDDLE_PREFIX="TD_MID_";
	var TD_RIGHT_PREFIX="TD_RIGHT_";
	var DIRECTION_LEFT="left";
	var DIRECTION_RIGHT="right";
	var NOT_INITIALIZED=-1;	
	var TAB_DIV_PREFIX="tab_";
	var TAB_HEIGHT = "25";
	var TAB_BORDER_WIDTH = 14;
	var TAB_FIXED_WIDTH=TAB_BORDER_WIDTH * 2;
	var SL_NAV_WIDTH=280;
	if (!g_MqRef.MqBrowser.ie){
		SL_NAV_WIDTH=230;
	}
	// Private Data		
	var m_lngFirstTabToShow=0;
	var m_lngLastTabToShow=0;
	var m_arrTabs=new Array();
	
	// Public Data
	var m_blnIsSharedTabSource=true;
	var m_varDisplayExceptionTabs=new Array();
	var m_strTabStripTarget;
	var m_lngSelectedTabID=NOT_INITIALIZED;
	var m_objTabPageContainer;
	var m_objTabStripContainer;
	var m_lngVisibleTabs;	
	var m_blnReloadSelectedOnClick=false;
	var m_strImagesPath="../../theme/images/";
	var m_strInstance="m_objTabsMgr";
	var m_objTabsDoc;
	var m_lngReserverdAreaWidth=0;
		
	var self=this;
	
	var TABS_TABLE_ID="tblTabStrip";
	var CELLS_PER_TAB=3;
	var TABS_ROW=0;
	var TAB_CENTER_CELL_RELATIVE_INDEX=2;
	var TAB_CELL_OFFSET=CELLS_PER_TAB-TAB_CENTER_CELL_RELATIVE_INDEX;
	var m_blnRemoveTabsIfPartiallyVisible=true;
	var m_blnEnableSmartResize=true;
	
	function HideTabs(arrHiddenTabs, blnKeepHiddenNotInArray)
	{
		var lngTabID;
		var blnMoveTab;
		arrHiddenTabs;
		// If the current tab will be hidden now, move to the 1st one available
		for(i=0; i<m_arrTabs.length; i++){
			objTab=m_arrTabs[i];
			if(objTab){
				lngTabID=objTab.GetID();
				if (g_MqRef.MqArr.IsValueInArray(lngTabID,arrHiddenTabs)){
					objTab.Hidden=true;
					if (!blnMoveTab){
						blnMoveTab=(m_lngSelectedTabID==lngTabID);
					}
				}else{
					if(!blnKeepHiddenNotInArray){
						objTab.Hidden=false;
					}
				}
			}
		}
		if (blnMoveTab){
			Load(GetFirstTabID());
		}else{
			Load();
			WriteTabs();
		}
	}
	
	function UnHideTabs(arrVisibleTabs)
	{
		var lngTabID;
		
		// If the current tab will be hidden now, move to the 1st one available
		for(i=0; i<m_arrTabs.length; i++){
			objTab=m_arrTabs[i];
			if(objTab){
				lngTabID=objTab.GetID();
				if (g_MqRef.MqArr.IsValueInArray(lngTabID,arrVisibleTabs)){
					objTab.Hidden=false;
				}
			}
		}
		Load();
		WriteTabs();
	}
	
	function HideTab(lngTabID)
	{
		var blnMoveTab;

		// If the current tab will be hidden now, move to the 1st one available
		var objTab=GetTabFromID(lngTabID);
		if(objTab){
			objTab.Hidden=true;
			blnMoveTab=(m_lngSelectedTabID==lngTabID);
		}

		if (blnMoveTab){
			Load(GetFirstTabID());
		}else{
			Load();
			WriteTabs();
		}
	}
	
	function UnHideTab(lngTabID)
	{
		// If the current tab will be hidden now, move to the 1st one available
		var objTab=GetTabFromID(lngTabID);
		if(objTab){
			objTab.Hidden=false;
		}
		Load();
		WriteTabs();
	}
	
	function Add(lngTabID, strTabName, strContentSource, strHTMLName)
	{
		if (!(TabInArray(lngTabID))){
			var lngIndex =m_arrTabs.length;
			var objTab=new CMqTab();
		
			objTab.SetID(lngTabID);
			objTab.SetName(strTabName);
			objTab.SetContentSource(strContentSource);
			objTab.SetHTMLName(strHTMLName);
		
			m_arrTabs[lngIndex]=objTab;
		}
	}
	
	function DisplayTabPage(lngTabId, objTabDocument, blnDisplay){
		if (objTabDocument){
			var oDivTab=objTabDocument.getElementById(GetTabName(lngTabId));
			Display(oDivTab,blnDisplay);
		}
	}
	
	function GetTabName(lngTabID){
		return TAB_DIV_PREFIX+String(lngTabID);
	}

	function GetTabPageHeaderHTML(lngTabID){
		var strHtml ="";
		var strStyle="";

		
		if (lngTabID!=m_lngSelectedTabID){
			if (m_blnIsSharedTabSource){
				strStyle="display:none";
			}
		}		
									
		strHtml ="<div id='tab_" + lngTabID + "' style='" + strStyle + "' >";
		
		return strHtml;
	}
	
	function Load(lngSelectTabID, objTabsDoc, lngReserverdAreaWidth)
	{
		var blnReturn=false;		
		var lngVisibleTabs; 
		var lngAvailableWidth;		
		
		if(objTabsDoc){			
			lngAvailableWidth = objTabsDoc.body.clientWidth;
			m_objTabsDoc = objTabsDoc;
		}else{
			if(m_objTabsDoc){
				lngAvailableWidth = m_objTabsDoc.body.clientWidth;
			}else{
				lngAvailableWidth = document.body.clientWidth;	
			}
		}
		
		m_lngReserverdAreaWidth = lngReserverdAreaWidth;
		lngVisibleTabs = CalculateNumVisibleTabs(lngAvailableWidth, lngReserverdAreaWidth);	

		SetVisibleTabs(lngVisibleTabs);
		
		if (lngSelectTabID==null){
			if (m_lngSelectedTabID==NOT_INITIALIZED){
				lngSelectTabID=GetFirstTabID();
			}else{
				lngSelectTabID=m_lngSelectedTabID;
				m_lngSelectedTabID=NOT_INITIALIZED;
			}
		}
		OnTabClick(lngSelectTabID);
		
		return blnReturn;
	}
	
	function WriteTabs()
	{
		var strHTML;
		var objTab;
		var objTabDocument;
		
		if (m_objTabPageContainer){
			objTabDocument=m_objTabPageContainer.document;
		}
		strHTML="<table id='" + TABS_TABLE_ID + "' height='" + TAB_HEIGHT + "' border='0' cellpadding='0' cellspacing='0'>";
		strHTML+="<tr>";										
		
		for(lngCount=0; lngCount<m_arrTabs.length ; lngCount++){
			objTab=m_arrTabs[lngCount];
			if(objTab){
				if(!objTab.Hidden){
					if (objTab.GetID()==m_lngSelectedTabID){
						strHTML+=GetTabHTML_Selected(objTab);				
					}else{
						strHTML+=GetTabHTML_Unselected(objTab);
					}
				}
				if(objTabDocument && !m_blnIsSharedTabSource){
					DisplayTabPage(objTab.GetID(),objTabDocument,!objTab.Hidden);
				}
			}
		}
		
		if(TabCount()>m_lngVisibleTabs){
			strHTML+=GetMoveLeftRightButtonHTML();
		}
		
		strHTML+="<\/tr>";
		strHTML+="<\/table>";
		
		if (WriteTabStrip(strHTML)){
			FixTabStrip(m_lngFirstTabToShow);
		}				
	}
	
	function WriteTabStrip(strHTML)
	{
		var blnReturn=false;
		if ((strHTML) && (m_objTabStripContainer) && (m_strTabStripTarget) ){
			if (m_objTabStripContainer.document){
				var objDiv=m_objTabStripContainer.document.getElementById(m_strTabStripTarget);

				if (objDiv){
					objDiv.innerHTML=strHTML;
					blnReturn=true;
				}
			}
		}
		return blnReturn;
	}
	
	function MoveTabStrip(strDirection)
	{	
		var lngLastIndex=LastTabIdx();
		var blnReturn=false;
		var lngNumVisibleTabs;
		var lngTabId;
		var lngTabIndex;
		var lngCurrentSelectedTabID = m_lngSelectedTabID;
		var lngNewSelectedTabIndex;

		if ( (m_lngFirstTabToShow>=0 && strDirection==DIRECTION_LEFT) || 
			 (m_lngLastTabToShow<=lngLastIndex && strDirection==DIRECTION_RIGHT) ){
		
				var lngFirstTabToShow;
				if (strDirection==DIRECTION_LEFT){
					lngFirstTabToShow = FindPrevTab(m_lngFirstTabToShow,lngLastIndex);
				}else{
					lngFirstTabToShow = FindNextTab(m_lngFirstTabToShow,lngLastIndex);
				}
		
				blnReturn=FixTabStrip(lngFirstTabToShow);
				
				lngNumVisibleTabs = CalculateNumVisibleTabs(m_objTabStripContainer.document.body.clientWidth, m_lngReserverdAreaWidth);

				SetVisibleTabs(lngNumVisibleTabs);
				WriteTabs();		
				
				lngTabIndex = GetTabIndexByID(lngCurrentSelectedTabID);
				
				if(lngTabIndex >= 0 && lngTabIndex <= lngLastIndex){	
					var objTab=GetTabFromID(lngCurrentSelectedTabID);
					if(objTab.VisibleInTabStrip==false){
						if(strDirection==DIRECTION_LEFT){
							lngNewSelectedTabIndex = lngTabIndex-1;							
						}else{
							lngNewSelectedTabIndex = lngTabIndex+1;							
						}
						while(m_arrTabs[lngNewSelectedTabIndex].Hidden){
							if(strDirection == DIRECTION_LEFT){
								lngNewSelectedTabIndex--;
							}else{
								lngNewSelectedTabIndex++;
							}
						}
						
						if(lngNewSelectedTabIndex >= m_arrTabs.length){
							lngNewSelectedTabIndex = (m_arrTabs.length - 1)
						}else{
							if(lngNewSelectedTabIndex < 0){
								lngNewSelectedTabIndex = 0;
							}
						}
						lngTabId = m_arrTabs[lngNewSelectedTabIndex].GetID();
						OnTabClick(lngTabId);
					}
				}		
		}
		return blnReturn;
	}
	
	function FindNextTab(lngTabIdx,lngLastIndex)
	{	
		var i;
		for(i=lngTabIdx+1;i<lngLastIndex;i++){
			if (IsValidTabIdx(i)){
				break;
			}
		}
		return i;
	}

	function FindPrevTab(lngTabIdx,lngLastIndex)
	{	
		var i;
		for(i=lngTabIdx-1;i>0;i--){
			if (IsValidTabIdx(i)){
				break;
			}
		}
		return i;
	}
		
	function OnTabClick(lngTabID)
	{
		if(lngTabID==m_lngSelectedTabID){
			OnTabClick_Selected(lngTabID);
		}else{
			OnTabClick_Unselected(lngTabID);
		}
	}
	
	function IsValidTabIdx(lngTabIdx)
	{
		var blnValidTab=false;
		var oTab=m_arrTabs[lngTabIdx];
		if (oTab){
			blnValidTab=!oTab.Hidden;
		}
		return blnValidTab;
	}
	
	function TabCount()
	{
		var intCount=0;
		for (i=0;i<m_arrTabs.length;i++){
			if (IsValidTabIdx(i)){
				intCount++;
			}
		}
		return intCount;
	}

	function LastTabIdx()
	{
		var intIdx=0;
		for (i=0;i<m_arrTabs.length;i++){
			if (IsValidTabIdx(i)){
				intIdx=i;
			}
		}
		return intIdx;
	}
	
	function LastVisibleTabIdx()
	{
		var intIdx=0;
		for (i=0;i<m_arrTabs.length;i++){
			if (m_arrTabs[i].VisibleInTabStrip==true){
				intIdx=i;
			}			
		}
		return intIdx;
	}
	
	function FirstTabIdx()
	{
		var intIdx=0;
		for (i=0;i<m_arrTabs.length;i++){
			if (IsValidTabIdx(i)){
				intIdx=i;
				break;
			}
		}
		return intIdx;
	}
	
	function GetSelectedTabID()
	{
		return m_lngSelectedTabID;
	}

	function GetSelectedTab()
	{
		return GetTabFromID(m_lngSelectedTabID);
	}

	function GetIsSharedTabSource()
	{
		return m_blnIsSharedTabSource;
	}
	
	function SetIsSharedTabSource(fEnableSeparateTabs)
	{
		m_blnIsSharedTabSource=fEnableSeparateTabs;
	}
	
	function GetDisplayExceptionTabs()
	{
		return m_varDisplayExceptionTabs;
	}
	
	function SetDisplayExceptionTabs(varDisplayExceptionTabs)
	{
		m_varDisplayExceptionTabs=varDisplayExceptionTabs;
	}
	
	function GetVisibleTabs()
	{
		return m_lngVisibleTabs;
	}
	
	function SetVisibleTabs(lngVisibleTabs)
	{
		m_lngVisibleTabs=parseInt(lngVisibleTabs);
	}
	
	function GetTabStripTarget()
	{
		return m_strTabStripTarget;
	}
	
	function SetTabStripTarget(strTabStripTarget)
	{
		m_strTabStripTarget=strTabStripTarget;
	}
	
	
	function GetTabPageContainer()
	{
		return m_objTabPageContainer;
	}
	
	function SetTabPageContainer(objTabPageContainer)
	{
		m_objTabPageContainer=objTabPageContainer;
	}
	

	function GetTabStripContainer()
	{
		return m_objTabStripContainer;
	}
	
	function SetTabStripContainer(objTabStripContainer)
	{
		m_objTabStripContainer=objTabStripContainer;
	}

	function GetReloadSelectedOnClick()
	{
		return m_blnReloadSelectedOnClick;
	}
	
	function SetReloadSelectedOnClick(blnReloadSelectedOnClick)
	{
		m_blnReloadSelectedOnClick=blnReloadSelectedOnClick;
	}

	function GetImagesPath()
	{
		return m_strImagesPath;
	}
	
	function SetImagesPath(strImagesPath)
	{
		m_strImagesPath=strImagesPath;
	}
	
	function GetInstance()
	{
		return m_strInstance;
	}
	
	function SetInstance(strInstance)
	{
		m_strInstance=strInstance;
	}
	
	
	function GetTabFromID(lngTabID)	{
		var objTab;
		var objReturnTab;
		for (i=0;i<m_arrTabs.length;i++){
			objTab=m_arrTabs[i];
			if (objTab){
				if(objTab.GetID()==lngTabID){
					objReturnTab=objTab;
					break;
				}
			}
		}
		return objReturnTab;
	}
	
	function OnRequestUnloadCurrentTab()
	{
		var oCurrentTab;
		var bReturn=true;		
		//get current tab object
		oCurrentTab=GetSelectedTab();
		try{
			if (oCurrentTab){
				bReturn=oCurrentTab.OnRequestUnload();
			}	
		}catch(objError){
		}
		return bReturn;
	}
	
	function TabStrip_OnResize(lngAvailWidth)
	{
		var blnReturn = false;
		var lngNumVisibleTabs;
		if (m_blnEnableSmartResize){
			m_lngFirstTabToShow = 0;
			lngNumVisibleTabs = CalculateNumVisibleTabs(lngAvailWidth, m_lngReserverdAreaWidth); 
			SetVisibleTabs(lngNumVisibleTabs);
			blnReturn=FixTabStrip(m_lngFirstTabToShow);
			MoveTabStripOnResize(lngAvailWidth, m_lngFirstTabToShow, m_lngReserverdAreaWidth);		
		}
	}
	
	function MoveTabStripOnResize(lngAvailWidth, lngFirstTabToShow, lngReserverdAreaWidth)
	{
		var lngLastIndex=LastTabIdx();
		var lngLastVisibleIndex=LastVisibleTabIdx();
		var blnReturn=false;
		var lngNumVisibleTabs;
		var lngTabId;
		var lngTabIndex;
		var lngCurrentSelectedTabID = m_lngSelectedTabID;
		var lngNewSelectedTabIndex;

		if (m_lngFirstTabToShow>=0 || m_lngLastTabToShow<=lngLastIndex){

				blnReturn=FixTabStrip(m_lngFirstTabToShow);
				
				lngNumVisibleTabs = CalculateNumVisibleTabs(lngAvailWidth, m_lngReserverdAreaWidth);

				SetVisibleTabs(lngNumVisibleTabs);
				WriteTabs();		
				
				lngTabIndex = GetTabIndexByID(lngCurrentSelectedTabID);
				
				if(lngTabIndex >= 0 && lngTabIndex <= lngLastIndex){	
					if (lngTabIndex > lngLastVisibleIndex)
					{
						lngNewSelectedTabIndex = lngLastVisibleIndex;
						lngTabId = m_arrTabs[lngNewSelectedTabIndex].GetID();
						OnTabClick(lngTabId);
					}
				}		
		}
		return blnReturn;
	}
	
  function DisplayExceptionTabPages(blnDisplay)
  {
    if (m_objTabPageContainer){
        var objTabDocument=m_objTabPageContainer.document;
    
        if (m_varDisplayExceptionTabs && objTabDocument){
			    if (m_varDisplayExceptionTabs.length){
				    for(var lngIndex=0;lngIndex<m_varDisplayExceptionTabs.length;lngIndex++){
						DisplayTabPage(m_varDisplayExceptionTabs[lngIndex],objTabDocument,blnDisplay);
				    }
			    }
		    }
    }
  }
  
	function ClickNextTab(lngCurrentTabID)
	{
		var lngLastIndex=LastTabIdx();
		var lngCurrentTabIdx=GetTabIndexByID(lngCurrentTabID);
		var lngNextTabIdx=FindNextTab(lngCurrentTabIdx, lngLastIndex);
		
		var objTab=m_arrTabs[lngNextTabIdx];
		var lngCurrentTabVisibleIdx=GetVisibleTabIndexByID(lngCurrentTabID);
		if(lngCurrentTabVisibleIdx>m_lngVisibleTabs){
			m_lngFirstTabToShow=FindNextTab(m_lngFirstTabToShow);
		}
		
		if(objTab){
			var lngNextTab=objTab.GetID();
			OnTabClick(lngNextTab);
		}		
		return true;
	}
	
	function ClickPrevTab(lngCurrentTabID)
	{
		var lngLastIndex=LastTabIdx();
		var lngCurrentTabIdx=GetTabIndexByID(lngCurrentTabID);
		var lngPrevTabIdx=FindPrevTab(lngCurrentTabIdx, lngLastIndex);
	
		var objTab=m_arrTabs[lngPrevTabIdx];
		
		var lngCurrentTabVisibleIdx=GetVisibleTabIndexByID(lngCurrentTabID);
		if(lngCurrentTabVisibleIdx>m_lngVisibleTabs){
			if(m_lngFirstTabToShow>0){
				m_lngFirstTabToShow=FindPrevTab(m_lngFirstTabToShow);
			}
		}
		
		if(objTab){
			var lngPrevTab=objTab.GetID();
			OnTabClick(lngPrevTab);
		}	
		return true;
	}
	
	function GetTabIndexByID(lngTabID)
	{
		var objTab;
		for (i=0;i<m_arrTabs.length;i++){
			objTab=m_arrTabs[i];
			if (objTab){
				if(lngTabID==objTab.GetID()){
					break;
				}
			}
		}
		return i;
	}
	
	function GetVisibleTabIndexByID(lngTabID)
	{
		var objTab;
		var lngCount=0;
		for (i=0;i<m_arrTabs.length;i++){
			objTab=m_arrTabs[i];
			if (objTab){
				if(!objTab.Hidden){
					lngCount++;
					if(lngTabID==objTab.GetID()){
						break;
					}
				}
			}
		}
		return lngCount;
	}
	
	function GetAllTabs()
	{
		return m_arrTabs;
	}
	
	function GetAllTabIDs()
	{
		var arrAllTabs=new Array();
		
		var objTab;
		for (i=0;i<m_arrTabs.length;i++){
			objTab=m_arrTabs[i];
			if (objTab){
				var lngTabID=objTab.GetID();
				arrAllTabs[lngTabID]=objTab;
			}
		}
		return arrAllTabs;
	}
	
	// data member accessors
	this.GetIsSharedTabSource=GetIsSharedTabSource;
	this.SetIsSharedTabSource=SetIsSharedTabSource;
	this.GetSelectedTabID=GetSelectedTabID;
	this.GetDisplayExceptionTabs=GetDisplayExceptionTabs;
	this.SetDisplayExceptionTabs=SetDisplayExceptionTabs;
	this.GetVisibleTabs=GetVisibleTabs;
	this.SetVisibleTabs=SetVisibleTabs;
	this.GetTabStripTarget=GetTabStripTarget;
	this.SetTabStripTarget=SetTabStripTarget;
	this.GetTabPageContainer=GetTabPageContainer;
	this.SetTabPageContainer=SetTabPageContainer;
	this.GetSelectedTab=GetSelectedTab;
	this.TabCount=TabCount;
	this.GetTabStripContainer=GetTabStripContainer;
	this.SetTabStripContainer=SetTabStripContainer;
	this.GetReloadSelectedOnClick=GetReloadSelectedOnClick;
	this.SetReloadSelectedOnClick=SetReloadSelectedOnClick;
	this.GetTabName=GetTabName;
	this.GetImagesPath=GetImagesPath;
	this.SetImagesPath=SetImagesPath;
	this.GetInstance=GetInstance;
	this.SetInstance=SetInstance;
	this.GetTabFromID=GetTabFromID;
	this.HideTabs=HideTabs;
	this.UnHideTabs=UnHideTabs;
	this.HideTab=HideTab;
	this.UnHideTab=UnHideTab;
	this.Add=Add;
	this.Load=Load;
	this.GetTabPageHeaderHTML=GetTabPageHeaderHTML;
	this.MoveTabStrip=MoveTabStrip;
	this.TabStrip_OnResize=TabStrip_OnResize;
	this.DisplayExceptionTabPages=DisplayExceptionTabPages;
	this.OnTabClick=OnTabClick;
	this.OnRequestUnloadCurrentTab=OnRequestUnloadCurrentTab;
	this.ClickNextTab=ClickNextTab;
	this.ClickPrevTab=ClickPrevTab;
	this.GetTabIndexByID=GetTabIndexByID;
	this.LastTabIdx=LastTabIdx;
	this.GetAllTabs=GetAllTabs;
	this.GetAllTabIDs=GetAllTabIDs;
	this.CalculateNumVisibleTabs=CalculateNumVisibleTabs;
	this.WriteTabs=WriteTabs;
	this.TabsReservedWidth = m_lngReserverdAreaWidth;
	this.RefreshTabDisplay = RefreshTabDisplay;
	this.FirstTabIdx=FirstTabIdx;
	this.GetFirstTabID=GetFirstTabID;
	
	function HideTabElements(lngTabID, blnHide)
	{
		if(m_objTabStripContainer){
			var objTabTDLeft=m_objTabStripContainer.document.getElementById(TD_LEFT_PREFIX + lngTabID);
			var objTabTDMiddle=m_objTabStripContainer.document.getElementById(TD_MIDDLE_PREFIX + lngTabID);
			var objTabTDRight=m_objTabStripContainer.document.getElementById(TD_RIGHT_PREFIX + lngTabID);
			
			var objTab=GetTabFromID(lngTabID)
			
			Display(objTabTDLeft,!blnHide,objTab);
			Display(objTabTDMiddle,!blnHide,objTab);
			Display(objTabTDRight,!blnHide,objTab);
		}
	}
	
	function ShowTabElements(lngTabID){
		HideTabElements(lngTabID, false);
	}
	
	function Display(objDivTab,blnDisplay,objTab){
		if (objDivTab){
			if (!blnDisplay){
				if (objDivTab.style.display!='none'){
					objDivTab.style.display='none';
				}
				if(objTab){
					objTab.VisibleInTabStrip=false;
				}
			}else{
				if (objDivTab.style.display!=''){
					objDivTab.style.display='';
				}
				if(objTab){
					objTab.VisibleInTabStrip=true;
				}
			}
		}
	}
	
	function GetTabHTML_Selected(objTab)
	{
		var strReturn="";
		
		if (objTab){
			var lngTabID=objTab.GetID();
			var strName=objTab.GetName();
			var strHTMLName=objTab.GetHTMLName();
			objTab.VisibleInTabStrip=true;
			
			strReturn+="<td id='" + TD_LEFT_PREFIX + lngTabID +"' class='TabsLeftCornerUp' width='14' height='";
			strReturn+=TAB_HEIGHT + "'><img src='" + m_strImagesPath + "spacer.gif' width='14' height='" + TAB_HEIGHT + "' border='0'><\/td>";
			strReturn+="<td id='" + TD_MIDDLE_PREFIX + lngTabID +"' class='TabsBackgroundUp' height='" + TAB_HEIGHT + "' nowrap=true align='center' ><a id='atab";
			strReturn+=lngTabID + "' name='" + strHTMLName;
			strReturn+="' href='#' onclick='" + m_strInstance + ".OnTabClick(\"";
			strReturn+=lngTabID + "\");' class='tabssel'>";
			strReturn+=strName;
			strReturn+="<\/td>";
			strReturn+="<td id='" + TD_RIGHT_PREFIX + lngTabID +"' class='TabsRightCornerUp' width='14' height='";
			strReturn+=TAB_HEIGHT + "'><img src='" + m_strImagesPath + "spacer.gif' width='14' height='" + TAB_HEIGHT + "' border='0'><\/td>";
		}
		
		return strReturn;
	}
	
	function GetTabHTML_Unselected(objTab)
	{
		var strReturn="";
		
		if (objTab){
			var lngTabID=objTab.GetID();
			var strName=objTab.GetName();
			var strHTMLName=objTab.GetHTMLName();
			var strDisplay = "style='display:none'";
			objTab.VisibleInTabStrip=false;
			
			strReturn+="<td id='" + TD_LEFT_PREFIX + lngTabID +"' class='TabsLeftCornerDown' " + strDisplay + " width='14' height='" + TAB_HEIGHT + "'><A ID='atab";
			strReturn+=lngTabID + "' name='" + strHTMLName; 
			strReturn+="' HREF='#";
			strReturn+="' onClick='" + m_strInstance + ".OnTabClick(" + lngTabID + ")'><img src='";
			strReturn+=m_strImagesPath + "spacer.gif' width='14' height='" + TAB_HEIGHT + "' border='0'><\/a><\/td>";
			strReturn+="<td id='" + TD_MIDDLE_PREFIX + lngTabID +"' class='TabsBackgroundDown' "+ strDisplay +" height='" + TAB_HEIGHT + "' nowrap=true align='center'><a id='atab";
			strReturn+=lngTabID + "' name='" + strHTMLName;
			strReturn+="' class='tabs' href='#"; 
			strReturn+="' onclick='" + m_strInstance + ".OnTabClick(" + lngTabID + ")'>";
			strReturn+=strName;
			strReturn+="<\/a><\/td>";
			strReturn+="<td id='" + TD_RIGHT_PREFIX + lngTabID +"' class='TabsRightCornerDown' " + strDisplay + " width='14' height='" + TAB_HEIGHT + "'><a id='atab";
			strReturn+=lngTabID + "' name='" + strHTMLName;
			strReturn+="' href='#";
			strReturn+="' onclick='" + m_strInstance + ".OnTabClick(" + lngTabID + ")'><img src='";
			strReturn+=m_strImagesPath + "spacer.gif' width='14' height='" + TAB_HEIGHT + "' border='0'><\/a><\/td>";

		}
		return strReturn;
	}
	
	function GetMoveLeftRightButtonHTML()
	{
		var strReturn="";
				
		strReturn+="<td>";
		strReturn+="<table class='TabsBorder' width='100%' height='" + TAB_HEIGHT + "' border='0' cellpadding='0' cellspacing='0'>";
		strReturn+="<tr>";
		strReturn+="<td>&#160;<\/td>";
		strReturn+="<td>";
		
		strReturn+=m_objMqButton.GetButtonHTML( IMG_MOVE_TABS_LEFT + m_strInstance ,'js:' + m_strInstance +
					'.MoveTabStrip(\'' + DIRECTION_LEFT + '\')', IMG_MOVE_TABS_LEFT, false, m_objMqButton.STATE_1,g_MqRef.RESX["TAB.SCROLL_LEFT"]);
		strReturn+="<\/td><td>";
		
		strReturn+=m_objMqButton.GetButtonHTML( IMG_MOVE_TABS_RIGHT + m_strInstance ,'js:' + m_strInstance +
					'.MoveTabStrip(\'' + DIRECTION_RIGHT + '\')', IMG_MOVE_TABS_RIGHT, false, m_objMqButton.STATE_1,g_MqRef.RESX["TAB.SCROLL_RIGHT"]);
		
		strReturn+="<\/td>";
		strReturn+="<\/tr>";
		strReturn+="<\/table>";
		strReturn+="<\/td>";
	
		return strReturn;
	}
	
		function OnTabClick_Selected(lngTabID)
	{
		if (m_blnReloadSelectedOnClick){
			var objCurrentTab=GetTabFromID(lngTabID);
			if (objCurrentTab){		
				if (objCurrentTab.OnRequestUnload()){
					if (objCurrentTab.OnClick(true)){
						LoadTabPage(objCurrentTab);
					}
				}							
			}
		}
	}	
	
	function OnTabClick_Unselected(lngTabID)
	{	
		var objCurrentTab=GetTabFromID(lngTabID);		

		if(objCurrentTab){

			var objPreviousTab=GetSelectedTab();
			var blnUnselect=true;
			if (objPreviousTab){
				blnUnselect=objPreviousTab.OnRequestUnload();
			}
			if (blnUnselect){	
				if (objCurrentTab.OnClick(false)){									
					var blnLoadNewTab=true;
						
					if (objPreviousTab){
						blnLoadNewTab=objPreviousTab.OnPageUnload();
					}
					
					if (blnLoadNewTab){
						
						DisplaySharedTabPage(lngTabID);
						LoadTabPage(objCurrentTab);
						m_lngSelectedTabID=lngTabID;
						WriteTabs();
					}
				}	
			}		
		}
	}
	
	function DisplaySharedTabPage(lngTabIDToDisplay)
	{
		var blnResult=false;		
		if (m_blnIsSharedTabSource){
			var lngTabId;
			if (m_objTabPageContainer){
				var objTabDocument=m_objTabPageContainer.document;
				var objTab;
					
				if (objTabDocument){
					for (i=0;i<m_arrTabs.length;i++){
						objTab=m_arrTabs[i];			
						if (objTab){		
							lngTabId=objTab.GetID();
							if (lngTabId!=lngTabIDToDisplay){
								DisplayTabPage(lngTabId,objTabDocument,false);
							}else{
								DisplayTabPage(lngTabId,objTabDocument,true);
							}
						}
					}
					blnResult=true;
				}
			}
		}else{
			blnResult=true;
		}
		
		return blnResult;
	}
	
	function LoadTabPage(objCurrentTab)
	{
		if (objCurrentTab){
			if (m_objTabPageContainer){
				if (m_objTabPageContainer.document){
					if (m_objTabPageContainer.initialized){
  					if ("#"==objCurrentTab.GetContentSource()){
  						m_objTabPageContainer.document.location.hash=objCurrentTab.GetID();
  					}else{
  						m_objTabPageContainer.document.location.replace(objCurrentTab.GetContentSource());
  					}
					}
				}
			}
		}	
	}
	

	
	function GetFirstTabID()
	{
		var objTab;
		var lngTabID=NOT_INITIALIZED;
		
		for (i=0;i<m_arrTabs.length;i++){
			objTab=m_arrTabs[i];
			if (objTab && !objTab.Hidden){
				lngTabID=objTab.GetID();
				break;
			}
		}
		return lngTabID;
	}
	
	function TabInArray(lngTabID)
	{
		var blnResult=false;
		var objTab=GetTabFromID(lngTabID);
		
		if (!(objTab)){
			blnResult=false;
		}else{
			blnResult=true;
		}
		
		return blnResult;
	}
	
	function FixTabStrip(lngFirstTabToShow)
	{	
		var lngTabCount=TabCount();
		var lngLastIndex=LastTabIdx();
		var blnReturn=false;
		var lngTmpVisTabs=0;
		
	
		var objTab;
		var lngLastTabToShow =lngLastIndex;
				
		
		for(i=0; i<m_arrTabs.length; i++){
			objTab=m_arrTabs[i];
			if(objTab && !objTab.Hidden){
				if(i<lngFirstTabToShow || i > lngLastTabToShow){
					HideTabElements(objTab.GetID(), true);
				}else{						
					ShowTabElements(objTab.GetID());
					lngTmpVisTabs++;
					if (lngTmpVisTabs >= m_lngVisibleTabs){
						lngLastTabToShow=i;
					}
				}
			}
		}
		
		if(m_objTabStripContainer){
			var objMoveTabsLeftButton=m_objTabStripContainer.document.getElementById("a_" + IMG_MOVE_TABS_LEFT + m_strInstance);
			var objMoveTabsRighttButton=m_objTabStripContainer.document.getElementById("a_" + IMG_MOVE_TABS_RIGHT + m_strInstance);

			if(objMoveTabsLeftButton){
				if(lngFirstTabToShow<=0){
					m_objMqButton.Disable(objMoveTabsLeftButton, IMG_MOVE_TABS_LEFT);
				}else{
					m_objMqButton.Enable(objMoveTabsLeftButton, IMG_MOVE_TABS_LEFT);
				}
			}
			if(objMoveTabsRighttButton){				
				if(lngLastTabToShow<lngLastIndex){
					m_objMqButton.Enable(objMoveTabsRighttButton, IMG_MOVE_TABS_RIGHT);
				}else{
					m_objMqButton.Disable(objMoveTabsRighttButton, IMG_MOVE_TABS_RIGHT);
				}
			}
		}
		
		m_lngFirstTabToShow=lngFirstTabToShow;
		m_lngLastTabToShow=lngLastTabToShow;
		blnReturn=true;
		return blnReturn;
	}




	
	function GetTabsOffset(lngAvailWidth){
		var lngTabsOffset=0;
		
		try{
			var lngMaxTabIndex=LastTabIdx();
			var lngSampleTabIndex=m_lngFirstTabToShow + m_lngVisibleTabs-1;
			    
			if (lngSampleTabIndex>lngMaxTabIndex){
			    lngSampleTabIndex=lngMaxTabIndex;
			}else{
				if (lngSampleTabIndex<0){
					lngSampleTabIndex=0;
				}
			}
		
			var objObjRect =GetTabRect(lngSampleTabIndex, TABS_TABLE_ID);
							    
			if (objObjRect){
			    var objAreaRect = new CMqRect(0,0,lngAvailWidth,0);
			    var lngOffsetRight;
			    var dblOffsetInObjects;
			        
			    lngOffsetRight=(objAreaRect.GetRight - objObjRect.GetRight);
			        
			    if (lngSampleTabIndex==lngMaxTabIndex){
			        var TABS_NAVIGATOR_WIDTH=SL_NAV_WIDTH;
				}else{
					var TABS_NAVIGATOR_WIDTH=SL_NAV_WIDTH + 38;	//19*2
			    }
			        
			    dblOffsetInObjects=((lngOffsetRight-TABS_NAVIGATOR_WIDTH)/objObjRect.GetWidth);
			    
				
			    if (m_blnRemoveTabsIfPartiallyVisible){
			        lngTabsOffset=Math.floor(dblOffsetInObjects);
			    }else{
			        lngTabsOffset=Math.ceil(dblOffsetInObjects);
			    }
			}		    
		}catch(errObject){
		}				
	    return lngTabsOffset;		    
	}


    function GetTabRect(lngTabIndex, strTableDivID)
    {
        var objTabsTableDiv = GetTableDiv(strTableDivID);
        if (objTabsTableDiv){
            var objTabDiv = GetTabDiv(objTabsTableDiv, lngTabIndex);
            
            if (objTabDiv){
				if (!m_objFormElement){
					m_objFormElement=new CMqFormElement();
				}
                var lngAbsLeft = m_objFormElement.GetPosition(objTabDiv,true);
        
                var lngWidth = GetWidth(objTabDiv) + TAB_FIXED_WIDTH;
        
                var objObjRect = new CMqRect(lngAbsLeft,0,lngWidth,0);
                
                return objObjRect;
            }
        }
    }                    
	
	function GetTableDiv(strTableDivID )
	{
	    var objTableDiv;
	    
	    if (strTableDivID && m_objTabStripContainer){
			if (m_objTabStripContainer.document){
				objTableDiv=m_objTabStripContainer.document.getElementById(strTableDivID);
			}
		}	    
	    return objTableDiv;
	    
	}
	

	function CalculateNumVisibleTabs(lngAvailableWidth, lngReservedAreaWidth){
		var arrAllTabs = GetAllTabs();
		var lngNumMaxTabs = 0;
		var lngNavButtonsWidth = 48;		
		var lngTempWidth=0;
		var objTabDivLeft;
		var objTabDivCenter;
		var objTabDivRight;
		var lngTempWidthVisibleTabs=0;
		var lngTabID;
		
		if(!lngReservedAreaWidth){
			lngReservedAreaWidth=0;
		}

		lngAvailableWidth = lngAvailableWidth - lngReservedAreaWidth;
		
		for(var c=0;c<arrAllTabs.length;c++){
			lngTabID = arrAllTabs[c].GetID();
				
				if(!arrAllTabs[c].Hidden)
				{
					if(m_objTabStripContainer){
						objTabDivLeft = m_objTabStripContainer.document.getElementById(TD_LEFT_PREFIX + lngTabID);
						objTabDivCenter = m_objTabStripContainer.document.getElementById(TD_MIDDLE_PREFIX + lngTabID);
						objTabDivRight = m_objTabStripContainer.document.getElementById(TD_RIGHT_PREFIX + lngTabID);

						if(objTabDivLeft && objTabDivCenter && objTabDivRight){				
							if(objTabDivLeft.style.display == 'none'){objTabDivLeft.style.display = '';}
							if(objTabDivCenter.style.display == 'none'){objTabDivCenter.style.display = '';}
							if(objTabDivRight.style.display == 'none'){objTabDivRight.style.display = '';}
							
							lngTempWidth += parseFloat(objTabDivLeft.offsetWidth) +
											parseFloat(objTabDivCenter.offsetWidth) +
											parseFloat(objTabDivRight.offsetWidth);
							
							if(lngTempWidth <= lngAvailableWidth){					
								lngNumMaxTabs++;						
								lngTempWidthVisibleTabs = lngTempWidth;
								
							}										
						}				
					}
				}
			}
		
		
		if(lngNumMaxTabs < arrAllTabs.length){ // The button is supposed to be visible
			if(lngTempWidthVisibleTabs + lngNavButtonsWidth >= lngAvailableWidth){
				lngNumMaxTabs--;
			}
		}
		
		if(lngTempWidth == 0){lngNumMaxTabs = arrAllTabs.length; }
		
		return lngNumMaxTabs;
	}
	
	function GetTabDiv(objTabsTableDiv, lngTabIndex){
	    var objTabDiv;
	    
	    if (objTabsTableDiv && !isNaN(lngTabIndex)){
	        
	        lngTabIndex=Number(lngTabIndex) + 1;
	        
	        var lngCellIndex= (lngTabIndex * CELLS_PER_TAB) - TAB_CELL_OFFSET - 1;
	        
	        var objTR=objTabsTableDiv.getElementsByTagName("tr").item(TABS_ROW);
	        
	        if (objTR){
	            var objCells=objTR.getElementsByTagName("td");
	        
	            if (objCells){
	                if (lngCellIndex<objCells.length){
	                    objTabDiv=objCells.item(lngCellIndex);                
	                }
	            }

	        }
	    }
	    
	    return objTabDiv;
	}
	
	function GetWidth(objElement)
	{
	    var lngWidth;
	    
	    if (objElement){
	        lngWidth=objElement.offsetWidth;
	    }
	    
	    return lngWidth;
	}
	
	function RefreshTabDisplay(){
		var oTabs;
		
		if(typeof(objFrames) == 'undefined'){
			if(opener.objFrames){
				objFrames = opener.objFrames;
				TABS_FRAME_ID = opener.TABS_FRAME_ID;
			}
		}
		
		oTabs = objFrames.GetFrameWindow(TABS_FRAME_ID);

		if(oTabs){
			if(oTabs.m_objTabsMgr){
				lngTabReservedArea = oTabs.m_objTabsMgr.TabsReservedWidth;
				
				oTabs.m_objTabsMgr.Load(null,'',lngTabReservedArea);
				setTimeout(function(){oTabs.m_objTabsMgr.OnTabClick(oTabs.m_objTabsMgr.GetSelectedTabID())},10);
			}
		}	
	}
}

function CMqTab(){
	var m_lngID;
	var m_strName="";
	var m_strContentSource="";
	var m_strHTMLName="";
	var self=this;
	
	function OnPageLoad()
	{		
		return true;	
	}
	
	function OnPageUnload()	
	{		
		return true;
	}
	
	function OnClick(blnSelected){	
		return true;
	}
	
	function Reset()	
	{	
		self.OnPageUnload=OnPageUnload;
		self.OnPageBeforeUnload=OnPageBeforeUnload;
		self.OnRequestUnload=OnRequestUnload;

	}

	function GetID()
	{
		return m_lngID;
	}
	
	function SetID(lngID)
	{
		m_lngID=lngID;
	}
	
	function GetName()
	{
		return m_strName;
	}
	
	function SetName(strName)
	{
		m_strName=strName;
	}
	
	function GetContentSource()
	{
		return m_strContentSource;
	}
	
	function SetContentSource(strContentSource)
	{
		m_strContentSource=strContentSource;
	}
	
	function GetHTMLName()
	{
		return m_strHTMLName;
	}
	
	function SetHTMLName(strHTMLName)
	{
		m_strHTMLName=strHTMLName;
	}

	function SetOnClick(strFunction){
		var strBody="var objFunction=" +
					self.OnClick.valueOf() + ";" + 
					strFunction + "return objFunction();";
			
		var objFunc=new Function ( strBody );
		self.OnClick=objFunc;		
		
	}
	function OnRequestUnload()
	{
		return true;
	}
	
	function OnPageBeforeUnload()
	{
		return "";
	}
	
	this.OnPageUnload=OnPageUnload;
	this.OnPageLoad=OnPageLoad;
	this.OnPageBeforeUnload=OnPageBeforeUnload;
	this.OnRequestUnload=OnRequestUnload;
	this.OnClick=OnClick;

	this.SetOnClick=SetOnClick;
	this.Reset=Reset;
	this.GetID=GetID;
	this.SetID=SetID;
	this.GetName=GetName;
	this.SetName=SetName;
	this.GetContentSource=GetContentSource;
	this.SetContentSource=SetContentSource;
	this.Hidden=false;
	this.VisibleInTabStrip=false;
	this.GetHTMLName=GetHTMLName;
	this.SetHTMLName=SetHTMLName;
	

	
}
  
  
function CMqRect(lngLeft, lngTop, lngWidth, lngHeight)
{
    this.GetLeft=lngLeft;
    this.GetTop=lngTop;
    this.GetWidth=lngWidth;
    this.GetHeight=lngHeight;
    this.GetRight = lngLeft + lngWidth;
    this.GetBottom = lngTop + lngHeight;
}