REM Script for remote uninstallation of the Vector Asset 
REM Management Client using the Vector Software Distribution agent.
REM
REM ** This script requires the following files to exist in the same folder **
REM 	closeapp.exe 
REM 	vnltvc8324d.dll 
REM	SETUP.EXE
REM
REM v5.60
REM
REM Copyright (c) Vector Networks Technologies Limited. All Rights Reserved.
REM


REM ------------------------------------------------------------------------
REM ---------------------------------CHECK----------------------------------
REM Check if the parameter DO is passed or not. 
REM It should not be passed on the first time the batch file is called 
REM and usually it is only this batch file who calls it with the DO parameter.

if not "%1"=="DO" goto VNCALLDO
if "%1"=="DO" goto VNEXECUTE


:VNCALLDO

REM ------------------------------------------------------------------------
REM ---------------------------------CALL DO--------------------------------
REM If DO was not passed, then call this same script but in a separate 
REM process so that the Software Distribution agent that is monitoring the
REM first process (batch fike) can terminate.

start /B "Remote Uninstall" "%~dp0\VAMOverwrite.bat" DO



REM ------------------------------------------------------------------------
REM Nothing else to do in this mode.
goto VNDONE



:VNEXECUTE

REM ------------------------------------------------------------------------
REM ------------------------ CLOSE ALL CLIENT PROGRAMS ---------------------

REM Stop the Software Distribution Agent

net stop "LANutil32 Distribution Agent"

REM Stop the Software Metering Agent

net stop "LANutil32 Software Metering Agent"
net stop "Vector Asset Management Agent"

REM Stop the Software Metering User application
"%~dp0\closeapp.exe" class=CLMETER


REM ------------------------------------------------------------------------
REM -------------------------- UNINSTALL PREVIOUS VERSIONS -----------------


REM Uninstall the VAM Client 5.0 silently

msiexec /x {8E76EB16-E277-44A1-A5E9-7D83CAC099FF} /qn REBOOT=R

REM Uninstall the VAM Client 5.5 silently

msiexec /x {41DFC812-B596-408D-8AA1-1E106F137CE3} /qn REBOOT=R

REM Uninstall the VAM Client 5.6 silently

msiexec /x {E0B1485D-6ACB-4DC2-BFA4-2F1ED5E6F993} /qn REBOOT=R

REM Uninstall the VAM Client 5.7 silently

msiexec /x {A40A237D-C090-4C05-8580-9DBECFE3602B} /qn REBOOT=R

REM Uninstall the VAM Client 5.8 silently

msiexec /x {B80B4DC6-0A49-442B-9393-3A0387B6D77C} /qn REBOOT=R

REM uninstall the VAM Client 5.8 silently (1)

msiexec /x {4229B10A-6565-4084-A658-68A4ED0F1D98} /qn REBOOT=R

REM uninstall the VAM Client 5.8 silently (2)

msiexec /x {9892177B-2489-4858-BEBE-E09F1FCD7C04} /qn REBOOT=R

REM Uninstall the VAM Client 6.0 silently

msiexec /x {D455E588-61BE-4C71-9DBA-538A7B8EBA70} /qn REBOOT=R

REM Uninstall the VAM Client 6.0.0.1260 silently

msiexec /x {BC443641-8F4B-40C0-B2F3-A17778B0C496} /qn REBOOT=R

REM Uninstall the VAM Client 6.0.0.1261 silently

msiexec /x {BD5FD3AC-9BEA-498F-A6D9-7D6146D0BCD1} /qn REBOOT=R

REM Uninstall the VAM Client 6.0.2.1262 silently

msiexec /x {784F26F5-6B07-4849-A725-98F9DA85ADD7} /qn REBOOT=R

REM Uninstall the VAM Client 6.0.3.1264 silently

msiexec /x {9C17C707-4A40-4387-B38C-90CDBB565EA8} /qn REBOOT=R

REM Uninstall the VAM Client 6.0.4.1300 silently

msiexec /x {E5B4DFF6-5934-46F0-8218-FFDE94FE3C85} /qn REBOOT=R

REM Uninstall the VAM Client 6.0.5.1306 and 6.0.5.1307 silently

msiexec /x {D91AEA30-3CD3-4BC5-AA33-CF3CFDF90DB7} /qn REBOOT=R

REM Uninstall the VAM Client 6.0.6.1319 silently

msiexec /x {2C8BEA7D-AF8F-4ABB-A62B-DDAC22AC263D} /qn REBOOT=R

REM Uninstall the VAM Client6.0.7.1325 and 6.0.11.1325 silently

msiexec /x {04821777-1FD1-4C1A-AC4D-BF5D4D53C34C} /qn REBOOT=R




REM ------------------------------------------------------------------------

REM --------------------------- CLEAN UP SELF-UPDATES FOLDER ----------------

DEL /Q /F /S "%ProgramData%\Vector\Updates\Asset Management Client\*.*"
RD /S /Q "%ProgramData%\Vector\Updates\Asset Management Client"


REM -------------------------- INSTALL CURRENT VERSION -----------------


"%~dp0\SETUP.EXE" /S /w /v"/qn REBOOT=R"

exit

REM ---------------------------------EXIT----------------------------------
REM Exit
:VNDONE


