USE [Resources02_def]
GO

/*** Last Installations Validation for internal use, Computers ***/
IF NOT EXISTS ( SELECT nID FROM [dbo].[tblDtsFields]  WHERE nID=77)
	INSERT [dbo].[tblDtsFields] 
		([nID], [tTableName], [nTableDSType], [tName], [nDataViewID], [nDataType], [nDataSize], [tCaption], [fChoiceOrder], [fRequired], [tFieldValuesTable], 
		[nValueTableDSType], [fEnabled], [fKeepHistory], [fCanQueryBy], [tDestinationTab], [fEditable], [fVisible], [nRelatedField], [tLabelCaption],
		[tAliasSourceTable], [tBoundControlName], [nDestinationTabID], [tWhere], [fIncludeInDefaultReports], [nRelationshipType], 
		[nContainerType], [nControlType], [tValueTableIDFld], [tValueTableNameFld], [nRevisionNumber], [tOrigCaption]) 
	VALUES (77, N'tblDts', 32, N'dLastInstallationsValidation', 1, 109, 0, N'Last Installations Validation', 0, 0, '', 
		NULL, 0, 0, 1, NULL, 0, 1, NULL, N'Last Installations Validation', 
		NULL, N'77', 26, NULL, 0, -1, 
		NULL, NULL, NULL, NULL, 2, N'Last Installations Validation');

	
	
-- Point OA Location to Discovery Location and rename
UPDATE tblDtsFields
	SET tName='Discovery_Location',
	tCaption='Discovery Location',
	tLabelCaption='Discovery Location',
	tBoundControlName='1089',
	tOrigCaption='Discovery Location'
	WHERE nId=1089;

-- Rename Assets_Remaining to Total_Available        / Total Available
UPDATE tblDtsFields
	SET tName='Total_Available',
	tCaption='Total Available',
	tLabelCaption='Total Available',
	[fCanQueryBy]=1,
	tBoundControlName='885',
	tOrigCaption='Total Available'
	WHERE nId=885;

-- Rename Caption Total Allocated for Bulk
UPDATE tblDtsFields
	SET tCaption='Total Allocated (Bulk)',
	tBoundControlName='1006',
	[fCanQueryBy]=1,
	tOrigCaption='Total Allocated (Bulk)'
	WHERE nId=1006;
	
-- Copy of Total Allocated in Allocation Tab  
IF NOT EXISTS ( SELECT nID FROM [dbo].[tblDtsFields]  WHERE nID=100)
BEGIN
	INSERT [dbo].[tblDtsFields] ([nID], [tTableName], [nTableDSType], [tName], [nDataViewID], [nDataType], [nDataSize], 
	[tCaption], [fChoiceOrder], [fRequired], [tFieldValuesTable], [nValueTableDSType], [fEnabled], [fKeepHistory], 
	[fCanQueryBy], [tDestinationTab], [fEditable], [fVisible], [nRelatedField], [tLabelCaption], [tAliasSourceTable], 
	[tBoundControlName], [nDestinationTabID], [tWhere], [fIncludeInDefaultReports], [nRelationshipType], [nContainerType], [nControlType], 
	[tValueTableIDFld], [tValueTableNameFld], [nRevisionNumber], [tOrigCaption]) 
	VALUES (100, N'tblDts', 32, N'Total_Allocated', 1, 102, 4, 
	N'Total Allocated', 0, 0, NULL, NULL, 0, 1, 
	1, NULL, 1, 1, NULL, N'Total Allocated', NULL, 
	N'100', 30, NULL, 0, -1, 1, NULL, 
	NULL, NULL, 3, 'Total Allocated');	
END	
ELSE
	UPDATE tblDtsFields
	SET tBoundControlName='100',
	[fCanQueryBy]=1,
	tOrigCaption='Total Allocated'
	WHERE nId=100;


UPDATE tblDtsFields
	SET tBoundControlName='883',
	[fCanQueryBy]=1,
	tOrigCaption='Total Assets'
	WHERE nId=883;

-- Change tab Minimum Quantity to Detail tab
UPDATE tblDtsFields
	SET nDestinationTabID=30
	WHERE nId=999;
	
GO


