
USE [Licenses_mdb]
GO

IF NOT EXISTS(SELECT nID FROM [tblSettings] WHERE nID=14)
BEGIN
	INSERT [dbo].[tblSettings] ([nID], [tValue], [tName], [nType], [tDescription], [tValidationRule], [nCustomAction], [tCACaption], [tCADisplay], [tValueSourceTable]) 
	VALUES (14, N'1', N'Execute Actions Interval', 10, 
	N'How often to execute Actions such as Provisioning and Deprovisioning Actions. The value is in minutes. A negative value will turn off the task.', 
	NULL, NULL, NULL, NULL, NULL)
END

IF NOT EXISTS(SELECT nID FROM [tblSettings] WHERE nID=15)
BEGIN
	INSERT [dbo].[tblSettings] ([nID], [tValue], [tName], [nType], [tDescription], [tValidationRule], [nCustomAction], [tCACaption], [tCADisplay], [tValueSourceTable]) 
	VALUES (15, N'1', N'Calculate Licences Interval', 10, 
	N'How often to calculate software licenses and compliance, based on software assets, installations and entitlements. The value is in minutes. A negative value will turn off the task.', 
	NULL, NULL, NULL, NULL, NULL)
END

IF NOT EXISTS(SELECT nID FROM [tblSettings] WHERE nID=16)
BEGIN
	INSERT [dbo].[tblSettings] ([nID], [tValue], [tName], [nType], [tDescription], [tValidationRule], [nCustomAction], [tCACaption], [tCADisplay], [tValueSourceTable]) 
	VALUES (16, N'No', N'Disable remembering last Summary List', 103,
	'If No, the last Summary List of the user will be used in the next session. If Yes, the default Summary List will be used.'
	, NULL, NULL, NULL, NULL, 'tblSystemBooleanValue')
END

IF  EXISTS(SELECT nID FROM [tblSettings] WHERE nID=202)
BEGIN
	UPDATE [dbo].[tblSettings] 
	SET [tName]=N'Evaluate Notifications Interval',
	[tDescription]= N'How often to evaluate notifications in the different projects. The value is in minutes. A negative value will turn off the task.', 
	[tValidationRule]=''
	WHERE nID=202
END

IF NOT EXISTS(SELECT nID FROM [tblSettings] WHERE nID=214)
BEGIN
	INSERT [dbo].[tblSettings] ([nID], [tValue], [tName], [nType], [tDescription], [tValidationRule], [nCustomAction], [tCACaption], [tCADisplay], [tValueSourceTable]) 
	VALUES (214, N'15', N'Send Emails Interval', 10, 
	N'How often to send emails from the internal outgoing emails queue. The value is in seconds. A negative value will turn off the task.', 
	NULL, NULL, NULL, NULL, NULL)
END

-- Previously: Software Monitor Interval
UPDATE [tblSettings] 
	Set [tName]=N'Assets Verification Interval', 
	[tValue]='10', 
	[nType]=4, 
	[tDescription]=N'Verify and create assets from purchases. Evaluate software licenses and compliance. The value is in minutes. A negative value will turn off the task.',
	[tValidationRule]=''
	WHERE nID=455

UPDATE [tblSettings] 
	Set  
	[tDescription]=N'Use 1 for the new mode, which supports email addresses as logons. Use 2 for  backwards compatible version.'
	WHERE nID=465

IF NOT EXISTS(SELECT nID FROM [tblSettings] WHERE nID=469)
BEGIN
	INSERT [dbo].[tblSettings] ([nID], [tValue], [tName], [nType], [tDescription], [tValidationRule], [nCustomAction], [tCACaption], [tCADisplay], [tValueSourceTable]) 
	VALUES (469, N'', 
	N'Google GSuite - Admin User ', 10, N'User with permissions to retrieve devices within a domain in GSuite', 
	NULL, NULL, NULL, NULL, NULL)
END
GO

IF NOT EXISTS(SELECT nID FROM [tblSettings] WHERE nID=470)
BEGIN
	INSERT [dbo].[tblSettings] ([nID], [tValue], [tName], [nType], [tDescription], [tValidationRule], [nCustomAction], [tCACaption], [tCADisplay], [tValueSourceTable]) 
	VALUES (470, N'', 
	N'Google GSuite - API KEY', 10, N'Key given by Google in their administrator console for external systems to call their API', 
	NULL, NULL, NULL, NULL, NULL)
END
GO

IF NOT EXISTS(SELECT nID FROM [tblSettings] WHERE nID=471)
BEGIN
	INSERT [dbo].[tblSettings] ([nID], [tValue], [tName], [nType], [tDescription], [tValidationRule], [nCustomAction], [tCACaption], [tCADisplay], [tValueSourceTable]) 
	VALUES (471, N'No', N'Enable log ons using Microsoft / Azure / Office 365 accounts', 103,
	'Enable this option to allow users to log on with their Microsoft / Azure / Office 365 accounts from the logon page. This change will only be applied after you regenerate a Web view (per virtual directory).'
	, NULL, NULL, NULL, NULL, 'tblSystemBooleanValue')
END
GO

