﻿<%
    Option Explicit
    Response.Buffer = True
%>
<!--#include file="sessmgr.asp" -->
<%
	Private Const DEBUG_MODE =0 ' Using DEBUG conflicts with the native VBScript object

	' Load Resources
	Dim sLocal
	sLocal = Session("Localization.Culture")

	LogMsg "Start Loading Resources GenListHTML:" & sLocal

	' Load Resources
	Dim RESX
	Dim sAppRes

	sAppRes= "Resources." & sLocal

	If IsObject(Application(sAppRes)) Then
		Set RESX=Application(sAppRes)
	
	Else 
		LogMsg "Cannot find application Resources:" & sAppRes
	End If

	LogMsg "End Loading Resources GenListHTML"	
	' End of Load Resources

    On Error Resume Next
    Const USER_NAME_FIELD = "tUserName"
    Const INDEX_FIELD_NAME = 0
    Const INDEX_FIELD_VALUE = 1
    Const cenWeb = 256
    Const cenUsers = 16
    Const cenDef = 64
    Const DELIMITER = ";"
    Const FLD_VAL_DELIM = "="
    Const RET_FALSE="False"
	
	Dim objWorkflow
	Set objWorkflow = CreateObject("MqCenCore.VNWorkflow")
			

	Const FLD_SECURITY_TYPE = "Security_Type"
    Const SEC_TYPE_COMPANY = 3
    Const FLD_ID  = "nID"
    Const TABLE_USER = "tblUser"
    Const FLD_NAME = "tName"
    Const FLD_ACCESSIBLE_COMPANIES = "Accessible_Companies"
    Const FLD_USER_NAME = "tUsername"
    
    Dim CR_NL
    Dim conConnection
    Dim rstFunc
    Dim strSqlWhere
    Dim strGroups
    Dim strConditions
    Dim strResponse
    Dim strSql
    Dim strSelect
    Dim strFrom
    Dim varRSArray()
    Dim intCount

  	Dim moStrMan
    Dim PREFIX_COND_FIELD 
    Dim dbTarget
    Dim bQueryWithWildCards
    Dim strDefaultIfEmpty
    Dim m_objCenApp
	Dim strOutputMode
	Dim strOutput
	Dim lngCount
	
    PREFIX_COND_FIELD="Cond_"
    strDefaultIfEmpty = ""
    strOutputMode = Request(objWorkflow.QRY_STR_OUTPUT)
	strOutput = ""
	
	        
    CR_NL =Chr(13) & Chr(10)
	
	Set m_objCenApp = GetStoredSession()

	If DEBUG_MODE Then    
    	LogMsg("[Workflow Rule] QueryString: " + Request.QueryString)
	End If
	    
    strConditions = Request(objWorkflow.QRY_STR_COND)
	If right(strConditions,Len(DELIMITER))=DELIMITER Then 
        strConditions=left(strConditions,len(strConditions)-Len(DELIMITER))
	End If
	    
    ' Get the target fields
    strSelect = Request(objWorkflow.QRY_STR_TGT)
    
    If Len(strConditions)=0  OR Len(strSelect)=0 Then
        Response.Write (RET_FALSE)
       	LogMsg("[Workflow Rule] Incomplete rule parameters specified in the http request. QueryString: " + Request.QueryString)
        Response.End
    End If
    
    Dim strGlobalID
    
    ' Mode =1 : uses a predefined SQL and GlobalID
    If Request.QueryString(objWorkflow.QRY_STR_MODE)=objWorkflow.SRC_MODE_SQL Then
    
    	strGlobalID = Request(objWorkflow.QRY_STR_FROM)

    	strSql = ResolvePredefinedSQL(strGlobalID , strConditions)
    
    	dbTarget=Session(strGlobalID & "_EXECUTE_DS")
    	
    	If Session(strGlobalID & "_EMPTY_VAL") <> "" Then
	    	strDefaultIfEmpty = Session(strGlobalID & "_EMPTY_VAL")
		End If	
    Else
        
	    ' Build the SQL FROM clause
	    strFrom = Request(objWorkflow.QRY_STR_FROM)
	
	    If Len(strFrom)=0 Then
	        Response.Write (RET_FALSE)
	        If DEBUG_MODE Then
	        	LogMsg("[Workflow Rule] No FROM information specified in the http request.")
	        End If
	        
	        Response.End
	    Else
	    	If Mid(strFrom,1,7)<>"tblWrk_" Then
		    	If DEBUG_MODE Then
		        	LogMsg("[Workflow Rule] Processing non-default workflow rule.")
		        End If
	
	    		PREFIX_COND_FIELD=""
	    		
	    		If strFrom="tblUser" Then
	    			dbTarget=cenUsers
	    			bQueryWithWildCards=False
	    			
	    			
	    		Else
	    			dbTarget=cenDef
	    			bQueryWithWildCards=True
	    		End If
	    	Else
	    		dbTarget=cenDef
	    		bQueryWithWildCards=True
	    	End If
	    End If
    
	    ' Build the SQL WHERE statement
	    strSqlWhere = BuildSqlWhere(strConditions, bQueryWithWildCards)
	
		' Build the SQL SELECT clause
		
	    strSelect=BuildSqlSelect(strSelect,m_objCenApp.CurrentProject.GetAllDataStores(Clng(dbTarget)).GeneralProviderType)
    
	    strSql = "SELECT DISTINCT " & strSelect & " FROM [" & strFrom & "] WHERE " & _
            strSqlWhere
            
	End If

    Set rstFunc = CreateObject("ADODB.Recordset")

	Set rstFunc.ActiveConnection = m_objCenApp.CurrentProject.GetAllDataStores(Clng(dbTarget)).GetConnection(1)

   	If Err.Number<>0 Then

   		LogMsg("[Workflow Rule] Current error:" + Err.Description & "," & Err.Source )

    End If
    
    
    If DEBUG_MODE Then
    	LogMsg("[Workflow Rule] Workflow rule to be resolved with SQL:" + strSql )
    End If
    
    Err.Clear
	
	If strSql = "Mq.GetUserAccessibleCompanies" Then
		Set rstFunc = GetUserAccessibleCompaniesRS(m_objCenApp)
	ElseIf InStr(1, strSql, "Mq.GetDefaultStorageLocation") > 0 Then
		Set rstFunc = GetDefaultStorageLocationRS(m_objCenApp, strSql)
    Else
    	rstFunc.Open strSql
    End If
    
    ' **************** Begin - Writing the output data
    strResponse = ""
	
	lngCount = 1
    If Len(Err.Description)=0 Then
    	Set moStrMan= CreateObject("MqSysutils40.CMqStringManipulation")
        Redim varRSArray(rstFunc.Fields.Count-1)
		
        Do Until rstFunc.EOF
            
            For intCount=0 to rstFunc.Fields.Count-1
				If strOutputMode = objWorkflow.OUTPUT_MODE_XML Then
					strOutput = strOutput & vbCrLf & vbTab & vbTab & "<cell>" & rstFunc.Fields(intCount).Value & "</cell>"
				Else	
					varRSArray(intCount)=varRSArray(intCount) & rstFunc.Fields(intCount).Value & DELIMITER
				End If
            Next
    
			If strOutputMode = objWorkflow.OUTPUT_MODE_XML Then
				If strOutput <> "" Then
					strResponse = strResponse & vbTab & "<row id='" & lngCount & "'>" & strOutput & vbCrLf & vbTab & "</row>" & vbCrLf
					strOutput = ""
				End If
			End If
			lngCount = lngCount + 1
            rstFunc.MoveNext
        Loop
    
		If strOutputMode <> objWorkflow.OUTPUT_MODE_XML Then
			For intCount=0 to rstFunc.Fields.Count-1
				'Remove the last delimiter
				If Right(varRSArray(intCount),Len(DELIMITER))=DELIMITER Then
					varRSArray(intCount)=Left(varRSArray(intCount),Len(varRSArray(intCount))-Len(DELIMITER))
				End If
		
				If varRSArray(intCount) = "" Then
					varRSArray(intCount) = strDefaultIfEmpty
				End If
				
				' nSubstateID=1;3;7;34      <- encoded values
				varRSArray(intCount)=moStrMan.URLEncode(rstFunc.Fields(intCount).Name & FLD_VAL_DELIM & _
									moStrMan.URLEncode(varRSArray(intCount)))
			Next
		End If
    Else
    	If DEBUG_MODE Then
        	LogMsg("[Workflow Rule] Error resolving workflow rule from query:" + strSql + ". The error is:" + Err.Description)
        End If

    End If

    rstFunc.Close
    
    Set rstFunc.ActiveConnection=Nothing
    
    Set rstFunc=Nothing

	If strOutputMode = objWorkflow.OUTPUT_MODE_XML Then
		strResponse = "<rows>" & vbCrLf & strResponse  & "</rows>"
	Else
		If IsArray(varRSArray) <> 0 Then
			strResponse = Join(varRSArray,DELIMITER)
		Else
			strResponse = RET_FALSE
		End If
	End If
	
    If Len(Trim(strResponse))=0 Then
        strResponse=CR_NL
    End If
  
   	If DEBUG_MODE Then
    	LogMsg("[Workflow Rule] Results of workflow rule:" + strResponse)
    End If
	
    Response.Write (strResponse)
    Response.End
    
    ' **************** End - Writing the output data

    Function GetGroups()
        Dim strGroups
    
        ' Chec if the groups have been set in the session
        If session("CurrentUserGroups") = "" Then
            strGroups=m_objCenApp.Authenticator.GetGroupList(CStr(m_objCenApp.User))
            
            session("CurrentUserGroups")=strGroups
        Else
            'get the groups from the session
            strGroups = session("CurrentUserGroups")
        End If
    
        GetGroups=strGroups
    End Function

    Function BuildSqlWhere(strConditions, bQueryWithWildCards)
        On Error Resume Next
        
        Const AND_OPERATOR=" AND "
        Dim arrParams
        Dim arrFields
        Dim strSqlWhere
        Dim strOperator
        Dim intCounter
        Dim strUserClause
        Dim strAddSQL
        
        strOperator = AND_OPERATOR
        arrParams = Split(strConditions, DELIMITER)
        If IsArray(arrParams) Then
            For intCounter = LBound(arrParams) To UBound(arrParams)
                If intCounter = UBound(arrParams) Then 
                    strOperator = ""
                End If
                arrFields = Split(arrParams(intCounter), FLD_VAL_DELIM)
                If IsArray(arrFields) Then
                    If UBound(arrFields) > 0 Then

                        If arrFields(INDEX_FIELD_NAME) = USER_NAME_FIELD Then
                            If Not LCase(GetUserNameForId(arrFields(INDEX_FIELD_VALUE))) = LCase(m_objCenApp.User) Then
                                strUserClause = " bOriginator=0"
                            Else
                                strUserClause = ""
                            End If

                        ElseIf arrFields(INDEX_FIELD_NAME) =RESX("MACRO_USER_IN_GROUP") Then
                            strSqlWhere = strSqlWhere & "[" & PREFIX_COND_FIELD & _
                                arrFields(INDEX_FIELD_NAME) & "] IN (" & GetGroups() & ") " & strOperator
    
                        Else
                            If Len(arrFields(INDEX_FIELD_VALUE)) = 0 Then
                                strSqlWhere = strSqlWhere & "([" & PREFIX_COND_FIELD & _
                                    arrFields(INDEX_FIELD_NAME) & "] ='" & RESX("MACRO_NULL") & "' "
                            Else
                                strSqlWhere =  strSqlWhere & "([" & PREFIX_COND_FIELD & _
                                arrFields(INDEX_FIELD_NAME) & "]='" & _
                                arrFields(INDEX_FIELD_VALUE) & "' "
                                
                                If bQueryWithWildCards Then
                                	strSqlWhere =  strSqlWhere & " OR [" & PREFIX_COND_FIELD & _
												arrFields(INDEX_FIELD_NAME) & "] ='" & RESX("MACRO_NOT_NULL") & "' " 
								End If
								
                            End If
                            strAddSQL=OnValueMacroUser(arrFields)
                            
                            If Len(Trim(strAddSQL))>0 Then
                                strSqlWhere = strSqlWhere & strAddSQL
                            End If
                            
                            If bQueryWithWildCards Then
                            	strSqlWhere = strSqlWhere & " OR [" & PREFIX_COND_FIELD & _
                            				arrFields(INDEX_FIELD_NAME) & "] ='" & RESX("MACRO_ANY") & "'"
                            End If
                            
                            strSqlWhere = strSqlWhere & ") " & strOperator
                            
                        End If
                     
                    End If
                End If
            Next
        End if
        BuildSqlWhere = strSqlWhere & strUserClause
        If Len( BuildSqlWhere )<>0 Then
            If right(BuildSqlWhere,Len(AND_OPERATOR))=AND_OPERATOR Then
                BuildSqlWhere =LEFT(BuildSqlWhere,Len(BuildSqlWhere)-Len(AND_OPERATOR))
            End If
        End If
        
    End Function

    Function BuildSqlSelect(strTargetFields,lngProviderType)
        ' Create an array with the field names
        Dim arrTargetFields
        Dim intCounter
        Dim strFieldName
        Const cenSQLServerDataStore = 2
        
        arrTargetFields=Split(strTargetFields,DELIMITER)
        
        For intCounter = LBound(arrTargetFields) To UBound(arrTargetFields)
			strFieldName = arrTargetFields(intCounter)
			If lngProviderType = cenSQLServerDataStore Then
	            arrTargetFields(intCounter)="CONVERT(VARCHAR(4000),[" & strFieldName & "]) AS [" & strFieldName & "]"
			Else
				arrTargetFields(intCounter)="[" & strFieldName & "]"
			End If
        Next
        
        BuildSqlSelect=Join(arrTargetFields,",")
    End Function
    
    Private Function GetUserNameForId(lngId)
        Dim rstFunc
        Dim strSql
        Dim strReturn
        
        Set rstFunc = CreateObject("ADODB.Recordset")
        Set rstFunc.ActiveConnection = m_objCenApp.CurrentProject.GetAllDataStores(cenUsers).GetConnection(1)
        
        if IsNumeric(lngId) then
            strSql = "SELECT tUserName FROM tblUser WHERE nID=" & lngId
        else
            ' Handle tName (e.g. for a Submitter)
            strSql = "SELECT tUserName FROM tblUser WHERE tName='" & lngId & "'"
        end if
        
        rstFunc.Open strSql
        If Not rstFunc.EOF Then
         strReturn = rstFunc("tUserName")
        End If
        
        rstFunc.Close
        
        Set rstFunc.ActiveConnection=nothing
        
        Set rstFunc=nothing
        
        GetUserNameForId = strReturn
    End Function
  
    Private Function OnValueMacroUser(ByVal arrFields)
        Const MACRO_CURRENT_USER_VALUE="-3"
        Dim strFieldName
        Dim lngCurrentUserID
        OnValueMacroUser=""
        
        If IsArray(arrFields) Then
            If IsNumeric(arrFields(INDEX_FIELD_VALUE)) Then
                strFieldName=CStr(arrFields(INDEX_FIELD_NAME))
                
                Select Case strFieldName
                
                    Case "nUserID","nSubmitterID","nOriginatorID","Employee","Manager"

						lngCurrentUserID = GetCurrentUserID()
                        If Clng(arrFields(INDEX_FIELD_VALUE)) = lngCurrentUserID  Then
                            'LogMsg  strFieldName & " matches current user: " & lngCurrentUserID
                            OnValueMacroUser =  " OR [" & PREFIX_COND_FIELD & strFieldName & "]='" & _
                                            MACRO_CURRENT_USER_VALUE & "' "
                        End If
                End Select
                
            End If
        End If
    End Function

	Private Function GetCurrentUserID()
		Dim lngCurrentUserID
		Dim objUserMgr
		If Session("CurrentUserID") = "" Then
			Set objUserMgr = CreateObject("MqCenX20.CMqUserMgr")
			If objUserMgr.InitializeEx(m_objCenApp.DataStores) Then
				objUserMgr.UniqueFieldName = "tUserName"
				lngCurrentUserID = objUserMgr.GetId(CStr(m_objCenApp.User))
				Session("CurrentUserID") = lngCurrentUserID
			End If
		Else
			lngCurrentUserID = Session("CurrentUserID")
		End If
		
		GetCurrentUserID = lngCurrentUserID
		
	End Function
	
	Private Function ResolvePredefinedSQL(strGlobalID , strConditions)
	
		On Error Resume Next
		
	    Dim intCounter 
	    Dim arrParams 
	    Dim arrFields
	    Dim regEx
		Dim strSql 
		Dim strParamName
		Dim strParamVal
		
	    strSql = Session(strGlobalID & "_EXECUTE_SQL")
	    
	    arrParams = Split(strConditions, DELIMITER)
	    If IsArray(arrParams) Then
	        
	        ' Initialize the regular expression object
	       	Set regEx = New RegExp

		    regEx.IgnoreCase = True
		    regEx.Global = True
		    regEx.MultiLine = True
			
	        	                	
	        For intCounter = LBound(arrParams) To UBound(arrParams)
			    arrFields = Split(arrParams(intCounter), FLD_VAL_DELIM)

	            If IsArray(arrFields) Then
	                If UBound(arrFields) > 0 Then
						
	                	strParamName=arrFields(INDEX_FIELD_NAME)
	                	strParamVal=PrepareParamValue(strParamName, arrFields(INDEX_FIELD_VALUE), strGlobalID )

						regEx.Pattern = strParamName
	                
						strSQL= regEx.Replace(strSQL, strParamVal)
	                End If
	                
	             End If
	             
	         Next
	                
		End If
    	
		ResolvePredefinedSQL = strSQL
		
		set regEx = nothing
		
	End Function
    
	Private Function PrepareParamValue(strParamName, strParamValue, strGlobalID )
		On Error Resume Next
		
		Dim strDefaultValue
		
		If Len(strParamValue) = 0 Then
			strDefaultValue=Session(strGlobalID & "_DEF_" & strParamName )
			
			If Len(strParamValue) = 0 Then
				strParamValue=strDefaultValue
			End If

		End If
		
		PrepareParamValue=strParamValue
		
	End Function
	
Private Function GetUserAccessibleCompaniesRS(objCenApp)
		
    Dim rstCompany
    Dim strSQL
    Dim strAccessibleCompanyNames
    Dim strAccessibleCompanyIDs

    Const MC_DELIM = ";"
    Const SQL_LIKE_DELIM = ","


    strAccessibleCompanyIDs = ""

    strAccessibleCompanyNames = GetUserAccessibleCompanyNames(objCenApp, objCenApp.User)

    If strAccessibleCompanyNames <> "" Then
	'convert to the IDs, with a comma between each

	strAccessibleCompanyNames = Replace(strAccessibleCompanyNames, "'", "''")
	strAccessibleCompanyNames = Replace(strAccessibleCompanyNames, MC_DELIM, "'" & SQL_LIKE_DELIM & "'")
	strAccessibleCompanyNames = "'" & strAccessibleCompanyNames & "'"

	strSQL = "SELECT [" & FLD_ID & "] FROM [" & TABLE_USER & _
                        "] WHERE ([" & FLD_NAME & "] IN(" & strAccessibleCompanyNames  & ")" & _
			" AND [" & FLD_SECURITY_TYPE & "]=" & SEC_TYPE_COMPANY & ")" & _
			" OR [" & FLD_ID & "] IN (SELECT [nCompanyName] FROM [" & TABLE_USER & "] WHERE [" & FLD_USER_NAME & "] ='" & Replace(objCenApp.User, "'", "''") & "')"

    	Set GetUserAccessibleCompaniesRS = objCenApp.DataStores.Item(CLng(16)).GetConnection( _
                        	CLng(1)).Execute(strSQL)

    End If

End Function

Private Function GetDefaultStorageLocationRS(objCenApp, strParams)
	Dim arrParams
	Dim lngAssetType
	Dim lngCurrentLocation
	Dim strSQL
	Dim rsCurrentLoc
	Dim lngLevelCount
	Dim lngLocVal
	Dim rsStorageLoc
	
	arrParams = Split(strParams, ";")
	
	If IsNumeric(arrParams(1)) Then
		lngAssetType = CLng(arrParams(1))
	Else
		lngAssetType = 0
	End If
	
	If IsNumeric(arrParams(2)) Then
		lngCurrentLocation = CLng(arrParams(2))
	Else
		lngCurrentLocation = 0
	End If
		
	If lngAssetType > 0 And lngCurrentLocation > 0 Then
		
		strSQL = "SELECT Level_1, Level_2, Level_3, Level_4, Level_5 FROM tblDts WHERE nID=" & lngCurrentLocation

		Set rsCurrentLoc = objCenApp.CurrentProject.GetAllDataStores.Item(CLng(4096)).GetConnection( _
                        	CLng(1)).Execute(strSQL)
					
		If Not rsCurrentLoc.EOF Then
			For lngLevelCount = 5 To 1 Step -1
				lngLocVal = rsCurrentLoc("Level_" & lngLevelCount)
				If IsNumeric(lngLocVal) Then
					If lngLocVal > 0 Then
						
						strSQL = "SELECT [Storage_Location] FROM [tblStorageLocation] AS A LEFT JOIN [Roles01_Dat].dbo.tblDts AS B ON A.Storage_Location=B.nID" & _
									" WHERE (A.[nID]=" & lngAssetType & " AND B.Level_" & lngLevelCount & "=" & lngLocVal & ")"
				
						Set rsStorageLoc = objCenApp.CurrentProject.GetAllDataStores.Item(CLng(32)).GetConnection( _
												CLng(1)).Execute(strSQL)
						
						If Not rsStorageLoc.EOF Then
							Set GetDefaultStorageLocationRS = rsStorageLoc
							Exit For
						End If
					End If
				End If
			Next
		End If
	End If

End Function

Private Function GetUserAccessibleCompanyNames(objCenApp, strLogonName)

    Dim rstCompany
    Dim strSQL
    Dim strAccessibleCompanyNames

    strAccessibleCompanyNames = ""
                        
    strSQL = "SELECT [" & FLD_ACCESSIBLE_COMPANIES & "] FROM [" & TABLE_USER & _
                        "] WHERE [" & FLD_USER_NAME & "] ='" & Replace(strLogonName, "'", "''") & "'"

    Set rstCompany = objCenApp.DataStores.Item(CLng(16)).GetConnection( _
                        CLng(1)).Execute(strSQL)

    If Not rstCompany.EOF Then
        If Not IsNull(rstCompany.Fields(FLD_ACCESSIBLE_COMPANIES).Value) Then
            strAccessibleCompanyNames = CStr(rstCompany.Fields(FLD_ACCESSIBLE_COMPANIES).Value)
        End If
    End If
    
    If Not rstCompany Is Nothing Then
        rstCompany.Close
        Set rstCompany = Nothing
    End If

    GetUserAccessibleCompanyNames =  strAccessibleCompanyNames 

End Function

Private Sub LogMsg(strMsg)
	Dim moEventLogger
	
	'This "IF" is in case we make the variable private to the module and we do not create it and destroy it every call
	If DEBUG_MODE =1 then
	    Set moEventLogger = CreateObject("MqSysutils40.CMqEventLogger")
	
	    moEventLogger.InitializeEventLogger
	
	    If Not IsNull(strMsg) Then
	            moEventLogger.LogEvent CStr(strMsg)
	    End If
	    
	End If
		
End Sub


If Err.Number <> 0 Then
      %>Error<%
End If

%>
