// Dependencies
//	MqSysUtils.js
//	CMqHTTPRequest.js
//	MqViewFields.js
//	MqWebSessionURL.js
//	CMqSummaryList.js
//	MqLoadData.js
//	MqRecordset.js
//	CMqWorkflowRules.js
//	window.js
//  CMqCommandBar.js

function VecWebSession()
{
	var m_oLoadDataMgr; // Created in the InitFields
	var m_oViewFields= new CMqFieldCol();
	var m_oWorkFlowMgr; // Created in the InitFields
	var m_oWebSessURL=new CMqWebSessionURL();
	var m_oRecMgr;	// Created in the InitFields
	var m_objSL=new CMqSummaryList();	
	var m_oMacros=new CMqMacros(); 
	var m_oURIOpener=new MqURIOpener();
	var m_objReportMgr=new VNReportManager();
	var m_oHTTPRequest=new CMqHTTPRequest_js();
	var m_oVNMainWin;
	var m_objCmdBar;
	var m_VNFeatures = new Array();
	var _me=this;
	
	function Init(strCurrentVD, strBaseVD, objMainDoc, oMainWindow)
	{
		m_oVNMainWin=new VNMainWindow(oMainWindow, _me);
		
		m_oWebSessURL.Init(strCurrentVD, strBaseVD);
		
		m_objSL.Init(objMainDoc, oMainWindow);
		
		m_objCmdBar=new CMqCommandBar(oMainWindow);
		
		if(this.m_VNFeatures == undefined)
		{
			this.m_VNFeatures = new Array();
		}
		
	}
	
	function InitFields(strXMLFields,strRevisionHistoryFieldID,oMqAutoList, oDisplayElements, fnInitDeclaredBizRules)
	{
		
		// Init View Fields
		var objRecordset=new CMqRecordset(strXMLFields, m_oViewFields.GetFieldIDName()); 
		m_oViewFields.Load(objRecordset);		
		m_oViewFields.SetRevisionHistoryFieldID(strRevisionHistoryFieldID);
		
		// Init LoadDataMgr and other objects
		m_oLoadDataMgr= new CMqLoadDataMgr(m_oViewFields);
	
		m_oURIOpener.InitForMacros(m_oMacros,m_oLoadDataMgr);
		
		m_oWorkFlowMgr=new CMqWorkFlowRules(m_oViewFields,m_oLoadDataMgr, oMqAutoList, oDisplayElements);

		if (!m_oWorkFlowMgr.InitDeclaredBizRules)
		{
			m_oWorkFlowMgr.InitDeclaredBizRules=fnInitDeclaredBizRules;
		}

		m_oLoadDataMgr.SetOnBeforeLoad(
			"m_objWorkFlow.Initialize(m_objViewFields,m_objLoadDataMgr.GetDataHTMLDocument(),m_MqAutoList, m_objDisplayElements);" + 
			"objCustomCode.AddWorkflowRules(m_objWorkFlow,m_objViewFields,m_objLoadDataMgr.GetDataHTMLDocument(), m_MqAutoList, m_objDisplayElements);" +
			"objCustomCode.OnBeforeLoadRec();" + 
			" return true;",false);

		m_oLoadDataMgr.SetOnAfterLoad(
			"ShowDefaultControls();" +
			"m_objWorkFlow.OnLoad();" +
			"objCustomCode.OnAfterLoadRec();" +
			"m_objLoadDataMgr.Reset();" +
			"m_objLoadDataViewActions.Reset(); " +
			"var objFieldsDescription = new FieldsDescription();" +
			"objFieldsDescription.AttachToAllFields(); " +
			"objFieldsDescription.ShowFieldHeader();" +
			" return true;",false); 

		m_oRecMgr=new CMqRecordMgr(m_oLoadDataMgr, m_oHTTPRequest);
		
		m_oRecMgr.SetVecWebSession(this);
		
		// ToDo: move to UI Init.
		ShowBannerPopup(false);
	}

		
	function LoadDataMgr()
	{
		return m_oLoadDataMgr;
	}
			
	function ViewFields()
	{
		return m_oViewFields;
	}
	
	function WorkflowMgr()
	{
		return m_oWorkFlowMgr;
	}
	
	function URL()
	{
		return m_oWebSessURL;
	}

	function RecordMgr()
	{
		return m_oRecMgr;
	}
	
	function SummaryList()
	{
		return m_objSL;
	}	

	function ReportMgr()
	{
		return m_objReportMgr;
	}

	function HTTPRequest()
	{
		return m_oHTTPRequest;
	}
	
	function MainWindow()
	{
		return m_oVNMainWin;
	}

	function CommandBar()
	{
		return m_objCmdBar;
	}
	
	function AddFeature(feature)
	{
		if(feature != undefined)
		{
			this.m_VNFeatures.push(feature);
		}
	}
	
	function FeatureExists(iID)
	{
		if( this.m_VNFeatures.filter(function(x){if(x.ID == iID){return x}}).length > 0)
		{
			return true;
		}
		else
		{
			return false;
		}
	}	
	
	this.Init=Init;
	this.InitFields=InitFields;
	this.LoadDataMgr=LoadDataMgr;
	this.ViewFields=ViewFields;
	this.WorkflowMgr=WorkflowMgr;
	this.URL=URL;
	this.RecordMgr=RecordMgr;
	this.SummaryList=SummaryList;	
	this.Macros=m_oMacros; 
	this.URIOpener=m_oURIOpener; 
	this.ReportMgr=ReportMgr;
	this.HTTPRequest=HTTPRequest;
	this.MainWindow=MainWindow;
	this.CommandBar=CommandBar;
	this.DefaultSearchField=new Object();
	this.DefaultSearchField.FieldID=0;
	this.AddFeature =AddFeature;
	this.FeatureExists = FeatureExists;	
}

function VNUser(sName, iID)
{
	// Change to Get/Set when needed 
	this.Name=sName;
	this.ID=iID;

}

function VNFeature(sName, iID)
{
	// Change to Get/Set when needed 
	this.Name=sName;
	this.ID=iID;

}


function VNMainWindow(oHTMLMainWin, oVecWS)
{
	var m_oHTMLMainWin=oHTMLMainWin;
	var m_bModal;
	var m_sBaseURL;
	var m_sViewFolderURL;
	var m_oVecWS=oVecWS;
	
	/** The BaseURL is the HTML folder of the view, which is the folder of CensusMain
	For example: http://server/connect02/example_view/html/
	**/
	
	function BaseURL()
	{
		if (!m_sBaseURL)
		{
			m_sBaseURL=g_MqRef.MqFS.GetCurrentLocation(m_oHTMLMainWin);
		}	
		return m_sBaseURL;		
	}

	/** The ViewFolderURL is the folder of the view, which is usually named <project>_<view name>
	For example: http://server/connect02/example_view/
	**/
	
	function ViewFolderURL()
	{
		if (!m_sViewFolderURL)
		{
			m_sViewFolderURL=g_MqRef.MqFS.ViewFolderURL(m_oHTMLMainWin);
		}	
		return m_sViewFolderURL;		

	}
	
	function Close()
	{
		if (this.IsModal())
		{
			m_oHTMLMainWin.CloseModalWindow();
		}else{
			m_oHTMLMainWin.close();
		}
	}

	// Check if the current Web view is Modal or a separate window that can/should be closed.
	function IsModal()
	{

		// Get it once
		if (typeof(m_bModal)=="undefined"){

			var retModal=true;
			if (m_oHTMLMainWin)
			{
				if (m_oHTMLMainWin.location)
				{
					// if the top URL is not the Main window for the current view, then it's modal
					retModal=(m_oHTMLMainWin.location.href!==top.location.href);
				}
			}
			m_bModal=retModal;
		}
		
		return m_bModal;
	}
	
	function SetFocus(sFrameName, sElementID)
	{
		try
		{
			if (m_oHTMLMainWin)
			{
				var frm=m_oHTMLMainWin.document.getElementById(sFrameName);
				
				if (frm)
				{
					frm.contentWindow.focus();
					var oElem=frm.contentDocument.getElementById(sElementID);
					if (oElem)
					{	
						oElem.value="";
						oElem.focus();

					}

				}
			}
		
		}catch(e){}
	}
	
	function OnLoad()
	{
		try
		{
			if (m_oVecWS.SummaryList())
			{
				var oSLSearch=m_oVecWS.SummaryList().SLSearch();
				if (oSLSearch.FocusOnLoad)
				{
					oSLSearch.SetFocus();
				}
			}
			
			// Pre load the Main Record Form so it loads faster
			window.setTimeout(function () {objRecord.Preload();},2000);	
		}catch(e){}
	}
	
	
	this.HTMLMainWin=m_oHTMLMainWin;
	this.IsModal=IsModal;
	this.Close=Close;
	this.SetFocus=SetFocus;
	this.BaseURL=BaseURL;
	this.ViewFolderURL=ViewFolderURL;	
	this.OnLoad=OnLoad;
	
}
