// Dependencies
// 		frameconstants.js
//		mqsysutils.js
//		window.js

function CMqSummaryList()
{
	var m_objMainDoc;
	var m_objMainRef;
	var m_intCurrentPage=0;
	var m_intPageCount;
	var m_objPageBox=new CMqSLPageBox(this);
	var m_oSLSearch;
	var m_objSLFrame;
	
	function Init(objMainDoc, objMainRef)
	{
		m_objMainDoc=objMainDoc;
		m_objMainRef=objMainRef;
		
		// Initialize the search box, with a reference to the main html doc 
		m_oSLSearch=new CMqSLSearch(objMainDoc,this);
	}
	
	function PageTo(e, objPageToTxt)
	{
		if (e.keyCode==13){
			if(objPageToTxt){
				MoveToPage(objPageToTxt.value);
			}
		}
	}
	
	function PageBox()
	{
		return m_objPageBox;
	}
	
	function SLSearch()
	{
		return m_oSLSearch;
	}
	
	function GetPageControlSrc(intCurrentPage)
	{
		m_intCurrentPage=intCurrentPage;
		//temporary - should be private when moving more SL code here
		return "<input type='text' id='txtPageStart' name='txtPageStart' class='PageBox' value='" + 
						intCurrentPage + "' style='width:" + PageBox().GetWidth(false, String(intCurrentPage)) + "' onfocus='m_objRef.g_VWS.SummaryList().PageBox().Enter(this, true)' " +
						"onblur='m_objRef.g_VWS.SummaryList().PageBox().Exit(this, true)' onclick='m_objRef.g_VWS.SummaryList().PageBox().Click(this)' onkeyup='m_objRef.g_VWS.SummaryList().PageBox().KeyPress(event, this)' " + 
						"onmouseover='m_objRef.g_VWS.SummaryList().PageBox().Enter(this, false)'  onmouseout='m_objRef.g_VWS.SummaryList().PageBox().Exit(this, false)'/>";
	
	}
	
	function Load(strParam){	
		if(objFrames){
			if(objFrames.GetFrameWindow(SUMMARY_LIST_FRAME_ID)){
				m_objSLFrame=objFrames.GetFrameWindow(SUMMARY_LIST_FRAME_ID);
				
				var strURL=m_objSLFrame.location.href;
				strURL=g_MqRef.MqStr.StripTrailing(strURL, "#");
				strURL=g_MqRef.MqURI.AddToQueryString(strURL, "data", "1");
				strURL=g_MqRef.MqURI.AddToQueryString(strURL, m_objSLFrame.QS_VIEW_TYPE, m_objSLFrame.m_lngViewType);
				if(m_objSLFrame.m_lngViewType==m_objSLFrame.VIEW_TYPE_CARD){
					strURL=g_MqRef.MqURI.AddToQueryString(strURL, m_objSLFrame.QS_NUM_TO_SHOW, m_objSLFrame.mlngCardSize);
				}
				
				
				if(strParam){
					strURL=g_MqRef.MqURI.RemoveFromQueryString(strURL, "Position");
					strURL=g_MqRef.MqURI.RemoveFromQueryString(strURL, "PageNumber");
					strURL+="&" + strParam;
				}
				m_objSLFrame.document.getElementById("fraSLSrc").src=strURL;
			}
		}
	}
	
	function PageCount()
	{
		return m_intPageCount;
	}
	function SetPageCount(intPageCount)
	{
		//temporary - will be read-only and intelligence should be inside
		m_intPageCount=intPageCount;
	}
	
	function MoveToPage(lngPageID)
	{
		if(!isNaN(lngPageID)){
			if(lngPageID<=PageCount()){
				if(lngPageID!=m_intCurrentPage){
					if(m_objMainRef){
						if(m_objMainRef.objControls){
							if (m_objMainRef.objControls.OnBeforeAction(SUMMARY_LIST_FRAME_ID)){
								if(m_objMainRef.objStatus){
									m_objMainRef.objStatus.cacheStatus();
								}
								Load("PageNumber="+(Number(lngPageID)));
								PageBox().SetHasFocus(false);
							}
						}
					}
				}
			}
		}
	}

	function GetCurrentPage()
	{
		return m_intCurrentPage;	
	}
	
	function GetCellValue(lngRowID, strColName)
	{
		var strValue="";
		if(m_objSLFrame)
		{
			if(m_objSLFrame.mDataGrid){
				lngColID=GetColID(m_objSLFrame.mDataGrid, strColName);
				strValue=m_objSLFrame.mDataGrid.cellById(lngRowID,lngColID).getValue();
			}
			if(strValue!=""){
				var strValueText=$(strValue).text();
				
				if(strValueText!=""){
					strValue=strValueText;
				}
			}
		}
		return strValue;
	}
	
	function GetColID(oDataGrid, strColName)
	{
		var lngColID=0;
		
		for(var x=0; x<oDataGrid.getColumnsNum(); x++){
			if(oDataGrid.getColumnLabel(x)==strColName){
				lngColID=x;	
				break;				
			}
		}
		return lngColID;
	}
	this.Init=Init;
	this.PageTo=PageTo;
	this.PageBox=PageBox;
	this.GetPageControlSrc=GetPageControlSrc;
	this.Load=Load;
	this.PageCount=PageCount;
	this.SetPageCount=SetPageCount;
	this.MoveToPage=MoveToPage;
	this.SLSearch=SLSearch;
	this.AutoLoadIfOneMatch=false;
	this.GetCurrentPage=GetCurrentPage;
	this.GetCellValue=GetCellValue;
}

function CMqSLPageBox(objSL)
{
	var mblnHasFocus=false;
	var m_objSL=objSL;
	
	function KeyPress(event, objPageToTxt)
	{
		SetWidth(objPageToTxt, true); 
		if(m_objSL){
			m_objSL.PageTo(event, objPageToTxt);
		}
	}
	function Enter(objPageToTxt, blnOnClick)
	{
		if(objPageToTxt){
			objPageToTxt.style.border="1px solid #c0c0c0";
			
			SetWidth(objPageToTxt, true);
			if(!mblnHasFocus){
				mblnHasFocus=blnOnClick;
			}
		}
	}
	
	function Exit(objPageToTxt, blnOnBlur)
	{
		if(objPageToTxt){
			if((blnOnBlur && mblnHasFocus)||(!blnOnBlur&&!mblnHasFocus)){
				objPageToTxt.style.border="1px solid transparent";
				SetWidth(objPageToTxt, false);
				if(blnOnBlur){
					if(objPageToTxt){
						if(m_objSL){
							m_objSL.MoveToPage(objPageToTxt.value);
						}
					}
					SetHasFocus(false);
				}
			}
		}
	}
	function GetWidth(blnMax, strValue)
	{
		var lngWidthMultiplier=7;
		var lngPadding=0;
		if(blnMax){
			lngPadding=24;
		}
		return ((strValue.length*lngWidthMultiplier)+lngPadding)+"px";
	}
	
	function Click(objPageToTxt)
	{
		objPageToTxt.select();
	}
	
	function SetHasFocus(blnHasFocus)
	{
		mblnHasFocus=blnHasFocus;
	}
	
	this.Enter=Enter;
	this.Exit=Exit;
	this.KeyPress=KeyPress;
	this.GetWidth=GetWidth;
	this.Click=Click;
	this.SetHasFocus=SetHasFocus;
	
	function SetWidth(objPageToTxt, blnMax)
	{
		if(objPageToTxt){
			
			objPageToTxt.style.width=GetWidth(blnMax, objPageToTxt.value);
		}
	}
}


function CMqSLSearch(objMainDoc, objSL)
{
	var m_objMainDoc=objMainDoc;
	
	// Default name of the search box
	var SEARCH_BOX_NAME="txtfieldvalue";
	var m_objSL=objSL;
	var m_oSearchBox;

	function _GetElement()
	{
		// Just get it once	
		if (!m_oSearchBox)
		{

			if (m_objMainDoc)
			{
				// TOOLBAR_FRAME_NAME in frameconstants.js
				var oSearchHTM=m_objMainDoc.getElementById(TOOLBAR_FRAME_NAME);
	
				if (oSearchHTM)
				{
					var oSearchHTMLWin=oSearchHTM.contentWindow;
				
					if (oSearchHTMLWin)
					{
						m_oSearchBox=oSearchHTMLWin.document.getElementById(SEARCH_BOX_NAME);
					}
				}
	
			}
		}
		return m_oSearchBox;
	}
	
	function SetFocus(bClearVal)
	{
		if (_GetElement())
		{
			m_oSearchBox.focus();
			
			if(bClearVal)
			{
				m_oSearchBox.value="";
			}
		}
	}
	
	this.SetFocus=SetFocus;
	this.FocusOnLoad=false;
	
}


function CMqSummaryListMgr(objSummaryListInput, objFrames, blnDDInSL, strCurrentViewFolder, objSLDD, objMainRef)
{	
	var m_objSummaryListInput=objSummaryListInput;
	var m_objFrames=objFrames;
	var mstrCurrentViewFolder=strCurrentViewFolder;
	var m_objSLDD=objSLDD;
	var m_objMainRef=objMainRef;
	
	if(typeof(blnDDInSL) != "undefined"){
		if(blnDDInSL){
			InitSumListDD();
		}
	}
	
	//stop remove the 3rd arg
	function ApplySearchToSL(blnAutoRefreshMode, blnRefreshBaseQuery, objSummaryListInput, blnFromDD)
	{
		if(m_objSummaryListInput){
			var RET_MAIN_QRY=2; //Main Query ANDed with SQE
			var lngQryID="";
			var lngSrtID="";
			var lngLytID="";
			var lngSrtFldID="";
			var lngSrtOrd="";
			var lngAutoRefresh=0;
		
			var strTextSearchQS="";
			var strAdhocSearchQS="";
			var strDDSearchQS="";
			var strSearchVal="";
			var lngQryType="";
			var lngViewType="";
			var blnDoSearch;
			var strPageParam="";
			
			SetState(TOOLBAR_FRAME_ID, BUSY_STATE);
			SetState(SUMMARY_LIST_FRAME_ID, BUSY_STATE);		
		
			if(m_objSummaryListInput){
				lngQryID=m_objSummaryListInput.QueryVal();
				lngSrtID=m_objSummaryListInput.SortVal();
				lngLytID=m_objSummaryListInput.LayoutVal();
				lngQryType=m_objSummaryListInput.QueryTypeVal();
				lngViewType=m_objSummaryListInput.ViewTypeVal();
			}

			if(m_objSummaryListInput.SortField){
				lngSrtFldID=m_objSummaryListInput.SortField;
			}
			if(m_objSummaryListInput.SortOrder){
				lngSrtOrd=m_objSummaryListInput.SortOrder;
			}
		
			var strExtraExpression=m_objSummaryListInput.GetExtraExpression();

			if(blnAutoRefreshMode){
				lngAutoRefresh = 1;
				if(m_blnSLRefresh_StayOnCurrentPage=="1"){
					var lngCurrentPage = g_VWS.SummaryList().GetCurrentPage();
					if(lngCurrentPage){
						strPageParam="&PageNumber=" + lngCurrentPage;
					}
				}
			}

			var blnDoSearch=true;
			
			if(m_objSLDD){
				if(m_objSLDD.DDIsEnabled()){
					if(!blnFromDD){
						this.InitSumListDD();
						blnDoSearch=false;
					}
				}
			}

			if(blnDoSearch){
				if(blnRefreshBaseQuery){
					m_objSummaryListInput.SetTextSearchValue(SEARCH_MSG);
					//stop - reset the advanced search too
				}
				strSearchVal=m_objSummaryListInput.GetTextSearchValue();				
				if(strSearchVal!=""){
					strTextSearchQS=m_objSummaryListInput.TextSearchDetails() +
										"&val=" + g_MqRef.MqStr.MqEncodeURIComponent(strSearchVal);
				}
				
				strAdhocSearchQS = m_objSummaryListInput.AdhocSearchDetails();
				
				if(strAdhocSearchQS=="" && strTextSearchQS==""){
					strDDSearchQS = m_objSummaryListInput.DDSearchDetails();
				}
				
				if(strSearchVal.length>0 && g_MqRef.MqStr.TrimString(strSearchVal).length==0){
					blnDoSearch=false;
				}
							
				if(blnDoSearch){
					var strURL="";
					if(m_objMainRef){
						strURL=m_objMainRef.mstrCurrentLocation;
					}
					strURL+="SummaryList.ASP?WCI=SummaryListTmpl&processqry=1&qry=" + lngQryID + 
						"&srt=" + lngSrtID + "&lyt=" + lngLytID + "&QryType=" + lngQryType + strTextSearchQS + strAdhocSearchQS + strDDSearchQS + 
						"&ret=" + RET_MAIN_QRY + "&ATO=" + lngAutoRefresh + "&VT=" + lngViewType + 
						"&srtfld=" + lngSrtFldID + "&srtord=" + lngSrtOrd  + 
						"&ex=" + g_MqRef.MqStr.MqEncodeURIComponent(strExtraExpression) +
						"&tobaseonly=1" + strPageParam + "&rd=" + Math.floor(Math.random()*1000001);

						
					SetSLURL(strURL, m_objSummaryListInput, objRecord);
					
				}else{
					SetState(TOOLBAR_FRAME_ID, IDLE_STATE);
					SetState(SUMMARY_LIST_FRAME_ID, IDLE_STATE);
				}
			}
		}
	}
	
	
	
	this.ApplySearchToSL=ApplySearchToSL;
	this.InitSumListDD=InitSumListDD;
	this.SetSLURL=SetSLURL;
	
	function SetSLURL(strURL, objSummaryListInput, objRecord)
	{	
		if(objSummaryListInput){
			
			if(objSummaryListInput.SummaryListDoc()){
				if(objRecord){
					objRecord.ShowLoadingUI(true);
				}
				objSummaryListInput.SummaryListDoc().location.replace(strURL);
			}else{
				window.setTimeout(m_objSLMgr.SetSLURL.bind(null, strURL, objSummaryListInput, objRecord), 200);
			}			
		}
	}
	
	function InitSumListDD()
	{
		if(m_objFrames){
			var objSL=m_objFrames.GetFrameWindow(SUMMARY_LIST_FRAME_ID);
			if(objSL){
				var objTBar=m_objFrames.GetFrameWindow(TOOLBAR_FRAME_ID);
				if(objTBar){
					var objQueryList=objTBar.document.getElementById("cboQueries");
					var lngSelectedQuery=objQueryList.value;	
					if(mstrCurrentViewFolder=="Resources%5FLibrary" || mstrCurrentViewFolder=="Resources%5FSWAssets"){
						if(lngSelectedQuery==10){
							m_objSLDD.EnableDD();
						}else{
							m_objSLDD.DisableDD();
						}
					}else{
						if(mstrCurrentViewFolder=="Resources%5FManage" || mstrCurrentViewFolder=="Resources%5FSWAssetTypes"){
							if(lngSelectedQuery==1){
								m_objSLDD.EnableDD();
							}else{
								m_objSLDD.DisableDD();
							}
						}else{
							m_objSLDD.InitDDStart();
						}
					}
				}else{
					window.setTimeout("m_objSLMgr.InitSumListDD()", 200);
				}
			}else{
				window.setTimeout("m_objSLMgr.InitSumListDD()", 200);
			}
		}else{
			window.setTimeout("m_objSLMgr.InitSumListDD()", 200);
		}
	}
}

function CMqSummaryListInput(objFrames)
{
	var m_objFrames=objFrames;
	var m_strAdhocFilters="";
	var m_strExtraExpression="";
	var m_strDDFields="";
	var m_strDDTests="";
	var m_strDDVals="";
	var m_strDDRetains="";
	var m_lngViewType="";
	
	function GetQueryVal()
	{
		var objTBar=this.ToolbarDoc();
		if (objTBar){	
			if(objTBar.getElementById("txtquery")){
				return objTBar.getElementById("txtquery").value;
			}
		}
	}
	
	function GetQueryName()
	{
		var objTBar=this.ToolbarDoc();
		if (objTBar){	
			var objQryLst=objTBar.getElementById("cboQueries");
			if(objQryLst){
				var lngSelIndex=objQryLst.selectedIndex;
				return objQryLst[lngSelIndex].text;
			}
		}
	}
	
	function GetSortVal()
	{
		var objTBar=this.ToolbarDoc();
		if (objTBar){	
			if(objTBar.getElementById("cbosort")){
				return objTBar.getElementById("cbosort").value;
			}
		}
	}
	
	function GetLayoutVal()
	{
		var objTBar=this.ToolbarDoc();
		if (objTBar){	
			if(objTBar.getElementById("cbolayout")){
				return objTBar.getElementById("cbolayout").value;
			}
		}
	}
	
	function GetQueryTypeVal()
	{
		var objTBar=this.ToolbarDoc();
		if (objTBar){	
			if(objTBar.getElementById("txtquerytype")){
				return objTBar.getElementById("txtquerytype").value;
			}
		}
	}
	
	function GetSummaryListDoc()
	{
		if(m_objFrames){
			var objSL=m_objFrames.GetFrameWindow(SUMMARY_LIST_FRAME_ID);
			
			if (objSL){
				return objSL.document;
			}		
		}
	}
	
	function GetToolbarDoc()
	{
		if(m_objFrames){
			var objTBar=m_objFrames.GetFrameWindow(TOOLBAR_FRAME_ID);
			
			if (objTBar){
				return objTBar.document;
			}		
		}
	}
	
	function GetViewTypeVal()
	{
		if(m_lngViewType==""){
			if(DEFAULT_VIEW_TYPE){
				m_lngViewType=DEFAULT_VIEW_TYPE;
			}else{
				m_lngViewType=VIEW_TYPE_LIST;
			}
		}
		return m_lngViewType;
	}
	
	function SetViewTypeVal(lngViewType)
	{
		m_lngViewType=lngViewType;
	}
	
	function GetTextSearchQS()
	{
		//should move these out of the sqe...
		var strQS="";
		var objSQE=m_objFrames.GetFrameWindow(SQE_FRAME_ID);
		if (objSQE){		
			strQS="&fx1=" + objSQE.FLD_IDS + 
					"&ox1=" + objSQE.TEST_IDS + 
					"&rx1=" + objSQE.RETAIN_IDS + 
					"&vx1=" + g_MqRef.MqStr.MqEncodeURIComponent(objSQE.VAL_VALS)
		}
		
		return strQS;
	}
	
	function GetTextSearchValue()
	{
		var strSearchValue="";
		var objTBar=this.ToolbarDoc();
		if (objTBar){	
			if(objTBar.getElementById("txtfieldvalue")){
				strSearchValue=objTBar.getElementById("txtfieldvalue").value;
				if(strSearchValue==SEARCH_MSG){
					strSearchValue="";
				}
			}
		}
		return strSearchValue;
	}
	
	function SetTextSearchValue(strValue)
	{
		var objTBar=this.ToolbarDoc();
		if (objTBar){	
			if(objTBar.getElementById("txtfieldvalue")){
				objTBar.getElementById("txtfieldvalue").value=strValue;
			}
		}
	}
	
	function GetAdhocSearchQS()
	{
		var strQS="";
		var strFilters=this.GetAdhocFilters();
		if(strFilters){
			var arrFilters = JSON.parse(strFilters);
			var strFldIDs = "";
			var strTestIDs = "";
			var strRetainIDs = "";
			var strSearchVals = "";
			
			if(arrFilters.length > 0){
				arrFilters.forEach(function(objFilter){
					if(strFldIDs === "") {
						strFldIDs += objFilter.field;
					} else {
						strFldIDs += ";" + objFilter.field;
					}
					if(strTestIDs === "") {
						strTestIDs += objFilter.operator;
					} else {
						strTestIDs += ";" + objFilter.operator;
					}
					if(strRetainIDs === "") {
						strRetainIDs += "And";
					} else {
						strRetainIDs += ";And";
					}
					if(strSearchVals === "") {
						strSearchVals += objFilter.value;
					} else {
						strSearchVals += ";" + objFilter.value;
					}
				});
				
				strQS="&fx2=" + strFldIDs + 
						"&ox2=" + strTestIDs + 
						"&rx2=" + strRetainIDs + 
						"&vx2=" + g_MqRef.MqStr.MqEncodeURIComponent(strSearchVals);
			}
		}
		return strQS;
	}
	
	function SetAdhocFilters(strAdhocFilters)
	{
		m_strAdhocFilters=strAdhocFilters;
	}
	
	function GetAdhocFilters()
	{
		return m_strAdhocFilters;
	}
	
	function GetDDSearchQS()
	{
		
		return "&fx3=" + m_strDDFields + 
						"&ox3=" + m_strDDTests + 
						"&rx3=" + m_strDDRetains + 
						"&vx3=" + g_MqRef.MqStr.MqEncodeURIComponent(m_strDDVals);
	}
	
	function SetDDFilters(strDDFields, strDDTests, strDDVals, strDDRetains)
	{
		m_strDDFields=strDDFields;
		m_strDDTests=strDDTests;
		m_strDDVals=strDDVals;
		m_strDDRetains=strDDRetains;
	}
		
	function SetExtraExpression(strExtraExpression)
	{
		m_strExtraExpression=strExtraExpression;
	}
	
	function GetExtraExpression()
	{
		return m_strExtraExpression;
	}
	
	this.QueryVal=GetQueryVal;
	this.QueryName=GetQueryName;
	this.SortVal=GetSortVal;
	this.LayoutVal=GetLayoutVal;
	this.QueryTypeVal=GetQueryTypeVal;
	this.SummaryListDoc=GetSummaryListDoc;
	this.ToolbarDoc=GetToolbarDoc;
	this.ViewTypeVal=GetViewTypeVal;
	this.SetViewTypeVal=SetViewTypeVal;
	this.SortField; //set from click grid header
	this.SortOrder; //set from click grid header
	this.SetExtraExpression=SetExtraExpression;
	this.GetExtraExpression=GetExtraExpression;
	this.GetTextSearchValue=GetTextSearchValue;
	this.SetTextSearchValue=SetTextSearchValue;
	this.TextSearchDetails=GetTextSearchQS;
	this.AdhocSearchDetails=GetAdhocSearchQS;
	this.DDSearchDetails=GetDDSearchQS;
	this.SetAdhocFilters=SetAdhocFilters;
	this.GetAdhocFilters=GetAdhocFilters;
	this.SetDDFilters=SetDDFilters;
}

function InitSLInputInfo(blnIsSimpleSearch, blnGetSimpleSearchInfo, blnIsAutoComplete, blnIsFilterBy, blnIsDrillDown)
{
	//stop remove
}


function VNMassUpdateWindow(oWinProp)
{
	var QS_RECSRC = "recsrc";
	var QS_SHOWTABS = "ShowTabs";
	var QS_TITLE = "TRES";
	var QS_DESCRIPTION = "DRES";
	var QS_HEADER2 = "H2";
				
	var _me=this;
	var m_oWinProp=oWinProp;
	
	_me.DefVals="";
	

	// TODO: change to BatchUpdate frame window to use text not RES string
	// and change the names of these properties to not have the "Res"
	this.TitleRes="";
	this.DescriptionRes="";
	this.Header2Res="";
	this.RecSrc="";
	this.ShowTabs="";
	
    function Open(arrRecIDs, strHeader2Args)
    {
	    
		var sURL="wcCmdBar.asp?wci=wciBatchUpdateMain"
		var arrPost;
		var FLD_SUB_VALS_DELIM=";";
			
		if(arrRecIDs){
			
			var oStr=new MqString();

			// Consider if these should be moved/supported elsewhere			
			sURL=oStr.AddToQueryString(sURL,"IDs",arrRecIDs.join(FLD_SUB_VALS_DELIM));

			sURL=oStr.AddToQueryString(sURL,"DV", _me.DefVals);

			sURL=oStr.AddToQueryString(sURL,QS_RECSRC, _me.RecSrc);

			sURL=oStr.AddToQueryString(sURL,QS_SHOWTABS, _me.ShowTabs);
			
			sURL=oStr.AddToQueryString(sURL,QS_TITLE, _me.TitleRes);
			
			sURL=oStr.AddToQueryString(sURL,QS_DESCRIPTION , _me.DescriptionRes);
			
			sURL=oStr.AddToQueryString(sURL,QS_HEADER2 , _me.Header2Res);


			if(strHeader2Args){
				arrPost = [new HTTPPostField("H2ARG", strHeader2Args)];
			}

			var objWin = new VNWindow(m_oWinProp.Modal);
			objWin.Open(sURL, "", m_oWinProp.Width, m_oWinProp.Height, arrPost,null, m_oWinProp.SizeMode);
			
		}else{
			alert(g_MqRef.RESX['WARNING_MESSAGE_SELECT_ISSUES_UPDATE']);
		}
		
	}
	this.Open=Open;

}


// Generic VNGridList used in summary list and other UIs
// Requires dhtmlx grid 
function VNGridList(oDataGrid, oHTMLDoc)
{
	var m_oDataGrid=oDataGrid;
	var m_oHTMLDoc=oHTMLDoc;
	var m_arrSelectedIDs = [];
	var m_arrSelectedColsInfo = [];

	function SelectedIDs()
	{
		return m_arrSelectedIDs;
	}

	function SelectedColsInfo()
	{
		return m_arrSelectedColsInfo;
	}
	
	// Return the IDs of the selected rows in an array
	// Populate the extended column info for the selected rows
	function GetSelectedRows(bLoadRowInfo)
	{
		m_arrSelectedIDs.length=0;
		m_arrSelectedColsInfo.length=0;
		
		if(m_oDataGrid){
			var lngLastCol=m_oDataGrid.getColumnsNum()-1;
			if(m_oDataGrid.getColType(lngLastCol)=="ch"){
				
				if (bLoadRowInfo)
				{
					// TODO: consider making this more flexible
					m_arrSelectedColsInfo.push("<table style=\"color:#727272;width:100%;\">");
				}
				
				m_oDataGrid.forEachRow(function(id){
					if (m_oDataGrid.cells(id,lngLastCol).getValue()=="0"){
					}else{
						m_arrSelectedIDs.push(id);
						//m_arrSelectedColsInfo.push(GetGridValue("Serial_Number_", id));
						
						if (bLoadRowInfo)
						{

							var col1 = m_oDataGrid.cells(id,1).getValue().replace(/<(?:.|\n)*?>/gm,"");
							var col2 = m_oDataGrid.cells(id,2).getValue().replace(/<(?:.|\n)*?>/gm,"");
							var col3 = m_oDataGrid.cells(id,3).getValue().replace(/<(?:.|\n)*?>/gm,"");
							m_arrSelectedColsInfo.push("<tr><td style=\"font-weight:bold;padding-right:5px;\">" + col1 + 
								"</td><td style=\"padding-left:5px;padding-right:5px;\">" + col2 + 
								"</td><td style=\"padding-left:5px\">" + col3 + "</td></tr>");
						}
					}
				});
				m_arrSelectedColsInfo.push("</table>");
			}
		}	
		return m_arrSelectedIDs;
	}
	
	
	function GetGridValue(strTag, lngID)
	{
		var strValue="";
		var objCell=m_oHTMLDoc.getElementById(strTag+lngID);
		if(objCell){
			strValue=objCell.innerHTML;
		}
		return strValue;
	}
	
	this.GetSelectedRows=GetSelectedRows;
	this.SelectedIDs=SelectedIDs;
	this.SelectedColsInfo=SelectedColsInfo;
	
}