function MqSLDrillDown(objCenMain, lngItemLevelField)
{
	var m_arrBreadcrumbs=new Array();
	var m_strBreadCrumbs="";
	var m_objCenMain=objCenMain;
	var m_objSumListWin;
	var m_strBaseQueryVal="";
	
	var m_strDisplayVal;
	var m_strFields;
	var m_strTests;
	var m_strVals;
	var m_strRetains;
	var m_strTooltip;
	var m_strFullValue;
	
	var ITEM_LEVEL_FLD_LOC=846;
	var ITEM_LEVEL_FLD_ASSETS=886;
	
	var LOC_LEVEL_1_VAL=g_MqRef.RESX["LOCATION.LEVEL_1"];
	var LOC_LEVEL_2_VAL=g_MqRef.RESX["LOCATION.LEVEL_2"];
	var LOC_LEVEL_3_VAL=g_MqRef.RESX["LOCATION.LEVEL_3"];
	var LOC_LEVEL_4_VAL=g_MqRef.RESX["LOCATION.LEVEL_4"];
	var LOC_LEVEL_5_VAL=g_MqRef.RESX["LOCATION.LEVEL_5"];
	var LOC_LEVEL_6_VAL=g_MqRef.RESX["LOCATION.LEVEL_6"];
	
	var ASSET_LEVEL_1_VAL=g_MqRef.RESX["ASSET.LEVEL_1"];
	var ASSET_LEVEL_2_VAL=g_MqRef.RESX["ASSET.LEVEL_2"];
	
	var WV_ASSET_LIBRARY="Resources%5FLibrary";
	var WV_SW_ASSET_LIBRARY="Resources%5FSWAssets";

	if (lngItemLevelField==""){
		lngItemLevelField=ITEM_LEVEL_FLD_ASSETS;
	}

	var m_lngItemLevelField=lngItemLevelField;
	
	if(m_lngItemLevelField==ITEM_LEVEL_FLD_LOC){
		m_strBaseQueryVal=LOC_LEVEL_1_VAL;
	}else{
		if(m_lngItemLevelField==ITEM_LEVEL_FLD_ASSETS){
			m_strBaseQueryVal=ASSET_LEVEL_1_VAL;
		}else{
			if(m_lngItemLevelField==806){
				m_strBaseQueryVal="Template";
			}
		}
	}
	
	function GetSLWin()
	{
		if(!m_objSumListWin){
			if(m_objCenMain){
				m_objSumListWin=m_objCenMain.objFrames.GetFrameWindow(SUMMARY_LIST_FRAME_ID);
			}		
		}
		return m_objSumListWin;
	}
	
	function TriggerDrillDownQuery(lngItemID)
	{
		ApplyQuery(lngItemID);
	}
	
	function GetCurrentLevel(lngItemID)
	{
		var objLevel=GetSLWin().document.getElementById("Level_" + lngItemID);
		var strLevel="";
		
		if(objLevel){
			strLevel=objLevel.innerHTML;
		}
		return strLevel;
	}
	
	function GetTopLevel(lngItemID)
	{
		var objTopLevel=GetSLWin().document.getElementById("TopLevel_" + lngItemID);
		var strTopLevel="";
		
		if(objTopLevel){
			strTopLevel=objTopLevel.innerHTML;
		}
		return strTopLevel;
	}
	
	function GetField(lngItemID)
	{
		var lngField;
		var strQryVal=GetCurrentLevel(lngItemID);
		if(strQryVal!=""){		
			if(m_lngItemLevelField==ITEM_LEVEL_FLD_LOC){
				if(strQryVal==LOC_LEVEL_1_VAL){
					lngField=840;
				}else{
					if(strQryVal==LOC_LEVEL_2_VAL){
						lngField=841;
					}else{
						if(strQryVal==LOC_LEVEL_3_VAL){
							lngField=842;
						}else{
							if(strQryVal==LOC_LEVEL_4_VAL){
								lngField=843;
							}else{
								if(strQryVal==LOC_LEVEL_5_VAL){
									lngField=844;
								}else{
									if(strQryVal==LOC_LEVEL_6_VAL){
										lngField=855;
									}
								}
							}
						}
					}
				}
			}else{
				if(m_lngItemLevelField==ITEM_LEVEL_FLD_ASSETS){
					if(strQryVal==ASSET_LEVEL_1_VAL){
						lngField=1092;
					}else{
						if(strQryVal==ASSET_LEVEL_2_VAL){
							lngField=1093;
						}
					}
				}else{
					if(m_lngItemLevelField==806){
						if(strQryVal=="Template"){
							lngField=30;
						}
					}
				}
			}
		}
		
		return lngField;
	}
	
	function GetNextLevel(lngItemID)
	{
		var strNextLevel;
		var strQryVal=GetCurrentLevel(lngItemID);
		var strTopLevelVal=GetTopLevel(lngItemID);
		if(strQryVal!=""){		
			if(m_lngItemLevelField==ITEM_LEVEL_FLD_LOC){
				if(strQryVal==LOC_LEVEL_1_VAL){
					strNextLevel=LOC_LEVEL_2_VAL;
				}else{
					if(strQryVal==LOC_LEVEL_2_VAL){
						strNextLevel=LOC_LEVEL_3_VAL;
					}else{
						if(strQryVal==LOC_LEVEL_3_VAL){
							strNextLevel=LOC_LEVEL_4_VAL;
						}else{
							if(strQryVal==LOC_LEVEL_4_VAL){
								strNextLevel=LOC_LEVEL_5_VAL;
							}else{
								if(strQryVal==LOC_LEVEL_5_VAL){
									strNextLevel=LOC_LEVEL_6_VAL;
								}else{
									if(strQryVal==LOC_LEVEL_6_VAL){
										strNextLevel=null;
									}
								}
							}
						}
					}
				}
			}else{
				if(m_lngItemLevelField==ITEM_LEVEL_FLD_ASSETS){
					if(strQryVal==ASSET_LEVEL_1_VAL){
						strNextLevel=ASSET_LEVEL_2_VAL;
					}else{
						if(strQryVal==ASSET_LEVEL_2_VAL){
							strNextLevel=ASSET_LEVEL_2_VAL;
						}else{
							if(strQryVal=="Item"){
								strNextLevel=null;
							}
						}
					}
				}else{
					if(m_lngItemLevelField==806){
						if(strQryVal=="Template"){
							strNextLevel="Employee";
						}else{
							if(strQryVal=="Employee"){
								strNextLevel=null;
							}
						}
					}
				}
			}
		}
		return strNextLevel;
	}
	
	function GetValue(lngItemID, blnDisplay)
	{
		var objName=GetSLWin().document.getElementById("DD_Fld_Value_Full_" + lngItemID);
		
		if(!objName || blnDisplay==true){
			objName=GetSLWin().document.getElementById("DD_Fld_Value_" + lngItemID);
		}
		
		var strValue;
		
		if(objName){
			strValue=objName.innerHTML;
		}
		
		if(!blnDisplay){
			strValue=g_MqRef.MqStr.MqHtmlDecode(strValue, false);
		}
		return strValue;
	}
	function HandleSetDDVals(lngItemID, strDisplayVal, strFields, strTests, strVals, strRetains, strTooltip, strFullValue)
	{
		var blnReturn=false;
		var strValue="";
		var strTooltipValue="";
		var strDDFields="";
		var strDDTests="";
		var strDDVals="";
		var strDDRetains="";
		var strValueDisplay="";

		if(typeof(strFields) != 'undefined' && typeof(strTests) != 'undefined' && typeof(strVals) != 'undefined' && typeof(strRetains) != 'undefined' && typeof(strTooltip) != 'undefined' && typeof(strFullValue) != 'undefined'){
			strDDFields=strFields;
			strDDTests=strTests;
			strDDVals=strVals;
			strDDRetains=strRetains;
			strValue=strFullValue;
			strValueDisplay=strDisplayVal;
			strTooltipValue=strTooltip;
			blnReturn=true;
		}else{
			if(lngItemID==0){
				strDDFields=m_lngItemLevelField;
				strDDTests="0";
				strDDVals=m_strBaseQueryVal;
				strDDRetains="And";
				strValue="(Start)";
				strValueDisplay=strValue;
				strTooltipValue="";
				blnReturn=true;
			}else{
				var lngField=GetField(lngItemID);
				var strValue=GetValue(lngItemID, false);
				strValueDisplay=GetValue(lngItemID, true);
				var strNextLevel=GetNextLevel(lngItemID);
				var strAddFlds="";
				var strAddTests="";
				var strAddVals="";
				var strAddRets="";
				if(m_lngItemLevelField==ITEM_LEVEL_FLD_ASSETS && lngField==1092 && (mstrCurrentViewFolder==WV_ASSET_LIBRARY || mstrCurrentViewFolder==WV_SW_ASSET_LIBRARY)){
						strAddFlds=";806";
						strAddTests=";0";
						strAddVals=";Asset Type";
						strAddRets=";And";
				}	
					
				if(lngField && strNextLevel){
					
					if(strValue){
						strDDFields=lngField+";" + m_lngItemLevelField + strAddFlds;
						strDDTests="0;0" + strAddTests;
						strDDVals=strValue+";"+strNextLevel + strAddVals;
						strDDRetains="And;And" + strAddRets;
						strTooltipValue=GetCurrentLevel(lngItemID);				
						blnReturn=true;
					}
				}
			}
		}
		m_objCenMain.m_objSLInput.SetDDFilters(strDDFields, strDDTests, strDDVals, strDDRetains);
		
		if(blnReturn){
			StoreCurrentDD(strValueDisplay, strDDFields, strDDTests, strDDVals, strDDRetains, strTooltipValue, strValue);
			ApplyToBreadCrumbs(strValueDisplay, strDDFields, strDDTests, strDDVals, strDDRetains, strTooltipValue, strValue);
		}
		
		return blnReturn;
	}
	
	function StoreCurrentDD(strDisplayVal, strFields, strTests, strVals, strRetains, strTooltip, strFullValue)
	{
		m_strDisplayVal=strDisplayVal;
		m_strFields=strFields;
		m_strTests=strTests;
		m_strVals=strVals;
		m_strRetains=strRetains;
		m_strTooltip=strTooltip;
		m_strFullValue=strFullValue;
	}
	
	function ApplyQueryFromBC(strDisplayVal, strFields, strTests, strVals, strRetains, lngSelectedIndex, strTooltip, strFullValue)
	{
		m_arrBreadcrumbs.length=lngSelectedIndex;
		strFullValue=unescape(strFullValue);
		strVals=unescape(strVals);
		
		ApplyQuery(null, strDisplayVal, strFields, strTests, strVals, strRetains, strTooltip, strFullValue);
	}
	
	function ApplyQuery(lngItemID, strDisplayVal, strFields, strTests, strVals, strRetains, strTooltip, strFullValue)
	{
		if(HandleSetDDVals(lngItemID, strDisplayVal, strFields, strTests, strVals, strRetains, strTooltip, strFullValue)){	
			//clear the search when drilling down
			var blnResetQry=true;
			if(lngItemID!=null){
				if(lngItemID==0){
					blnResetQry=false;
				}
			}
			if(blnResetQry){
				m_objCenMain.m_objSLInput.SetTextSearchValue(SEARCH_MSG);
			}
			m_objCenMain.m_objSLMgr.ApplySearchToSL(false, false, m_objCenMain.m_objSLInput, true);
		}
	}
	
	function InitDDStart()
	{
		ApplyQuery(0);
	}
	
	function SetDDBreadCrumbs()
	{
		var objBreadcrumbs=GetSLWin().document.getElementById("DDBreadcrumbs");
		
		if(objBreadcrumbs){
			objBreadcrumbs.innerHTML=m_strBreadCrumbs;
		}
	}
	
	function ApplyToBreadCrumbs(strCaption, strFields, strTests, strVals, strRetains, strTooltip, strFullValue)
	{
		var lngIndex=m_arrBreadcrumbs.length;
		m_arrBreadcrumbs.length=lngIndex+1;
		m_arrBreadcrumbs[lngIndex]=new Array(strCaption, strFields, strTests, strVals, strRetains, strTooltip, strFullValue);
		
		m_strBreadCrumbs=GenerateBreadCrumbs(m_arrBreadcrumbs);
	}
	
	function GenerateBreadCrumbs(arrBreadcrumbs)
	{
		var strBreadCrumbs="";
		
		for(x=0;x<arrBreadcrumbs.length;x++){
			var arrSearchLevel=arrBreadcrumbs[x];
			var QUOTE="\"";
			
			strBreadCrumbs+="<a href='#' onclick='parent.m_objSLDD.ApplyQueryFromBC(" + QUOTE + arrSearchLevel[0] + QUOTE + "," + QUOTE +
											arrSearchLevel[1] + QUOTE + "," + QUOTE + arrSearchLevel[2] + QUOTE + "," + 
											QUOTE + escape(arrSearchLevel[3]) + QUOTE + "," + QUOTE + arrSearchLevel[4] + QUOTE + ", " + x + 
											", " + QUOTE + arrSearchLevel[5] + QUOTE + ", " + QUOTE +  escape(arrSearchLevel[6]) + QUOTE + 
											")' class='SLBreadCrumbs' title='" + arrSearchLevel[5] + "'>" + arrSearchLevel[0] + "</a>>";
		}
		return strBreadCrumbs;
	}
	
	function DisableDD()
	{
		if(m_lngItemLevelField==ITEM_LEVEL_FLD_ASSETS){
			if(mstrCurrentViewFolder==WV_ASSET_LIBRARY || mstrCurrentViewFolder==WV_SW_ASSET_LIBRARY){
				m_objCenMain.m_objSLInput.SetExtraExpression("([tblUsageType].[tName]<>'Asset Type' OR [tblUsageType].[tName] IS NULL)");
			}
			ApplyQuery(0, "", "", "", "", "", "", "");
		}
		m_strBreadCrumbs="";
		
		SetDDBreadCrumbs();
	}
	
	function EnableDD()
	{
		if(m_lngItemLevelField==ITEM_LEVEL_FLD_ASSETS){
			ResetDD();
			InitDDStart();
		}
	}
	
	function ResetDD()
	{
			m_arrBreadcrumbs.length=0;
			m_objCenMain.m_objSLInput.SetExtraExpression("");
	}
	
	function DDIsEnabled()
	{
		return(m_strBreadCrumbs!="");
	}
	
	function RefreshToCurrentDD()
	{
		if(m_strDisplayVal){
			if(m_arrBreadcrumbs){
				if(m_arrBreadcrumbs.length>0){
					m_arrBreadcrumbs.length=m_arrBreadcrumbs.length-1;
				}
			}
		}
		ApplyQuery(null, m_strDisplayVal, m_strFields, m_strTests, m_strVals, m_strRetains, m_strTooltip, m_strFullValue);
	}
	
	this.SetDDBreadCrumbs=SetDDBreadCrumbs;
	this.TriggerDrillDownQuery=TriggerDrillDownQuery;
	this.InitDDStart=InitDDStart;
	this.ApplyQueryFromBC=ApplyQueryFromBC;
	this.DisableDD=DisableDD;
	this.EnableDD=EnableDD;
	this.DDIsEnabled=DDIsEnabled;
	this.RefreshToCurrentDD=RefreshToCurrentDD;
	this.ResetDD=ResetDD;
}