<!--#include file="SettingsMgr.asp" -->
<!--#include file="MqLog.asp" -->
<%

'///////////////////////////////////////////////////////////////////////////////
'//                                                                           //
'//  File:          oarelay.asp                                               //
'//                                                                           //
'//                                                                           //
'///////////////////////////////////////////////////////////////////////////////



	' Get the parms from the query string
	Dim mstrFileName		
	Dim mstrHTTPID
	Dim mstrClientSecurityKey
	Dim mstrOAPath
	Dim oFSO
	Dim mstrUploadDir
	Dim objMqFS
	Dim mstrSubFolder
	Dim mlngMode
	Dim mlngSegment
	Dim mstrFilePath
	Dim objWebClient
	Dim lngFileCount
	Dim arrFiles
	Dim bKeepFile 
	
	Const MODE_HTTP_PUSH = "1"
	Const MODE_HTTP_GET = "2"
	Const MODE_HTTP_PUSH_NET = "3"
	Const MODE_HTTP_GET_NET = "4"
	
	Const SEGMENT_INI = "1"
	Const SEGMENT_ZIP = "2"
	Const SEGMENT_CONFIRM = "3"
	
	Const CHUNK_SIZE = 1024 
	Const INI_CONTENT_TYPE  = "text/plain"
	
	Const ZIP_FILES = "LUCLIENT.MOD,LUDIST.MOD,LUTINFO.REF"
	Const FILE_DELIM = ","
	
	Const adTypeBinary = 1
			
	mstrFileName = CStr(Request.QueryString("FN"))
	LogMsg "Request FN returned " & mstrFileName
	
	mstrHTTPID = CStr(Request.QueryString("HTTPID"))
	LogMsg "Request HTTPID returned " & mstrHTTPID
	
	mstrClientSecurityKey = CStr(Request.QueryString("ID"))
	LogMsg "Request ID returned " & mstrClientSecurityKey
	
	mstrOAPath = GetOAFromSecKey(mstrClientSecurityKey)
	LogMsg "Offline Area path: " & mstrOAPath
	
	mlngMode = CStr(Request.QueryString("Mode"))
	LogMsg "Request Mode returned " & mlngMode
	
	If mlngMode = "" Then
		mlngMode = MODE_HTTP_PUSH
		LogMsg "Using Mode " & mlngMode
	End If
	
	mlngSegment = CStr(Request.QueryString("Sgmt"))
	LogMsg "Request  Sgmt returned " & mlngSegment
	
	bKeepFile = CBool(Request.QueryString("KF")="1")
	LogMsg "Request Keep File returned " & bKeepFile 

	Set oFSO = CreateObject("Scripting.FileSystemObject")
	Set objMqFS = CreateObject("Mqsysutils40.CMqFileSystem")
				
	' If we get an OA Path, then the key was a valid one
	If mstrOAPath <> "" Then

		If mlngMode = MODE_HTTP_GET Then
		
			' are HTTPID and Filename parms valid?
			If mstrHTTPID = "" OR mstrFileName = "" Then
				' No...
				LogMsg "No HTTP ID or File Name. File will not be downloaded"
				
			Else
				' Yes...
				mstrHTTPIDPath = objMqFS.ConcatenatePath(CStr(mstrOAPath), CStr(mstrHTTPID))

				' Check if this folder exists
				If oFSO.FolderExists(mstrHTTPIDPath ) = True Then
					LogMsg "Folder " & mstrHTTPIDPath & " exists!"
				
					If Len(mstrFileName) > 0 Then
						'return the requested file
						GetFile objMqFS.ConcatenatePath(CStr(mstrHTTPIDPath), CStr(mstrFileName)), _
								mstrFileName, bKeepFile 
					End If
					
				Else
					LogMsg mstrHTTPIDPath & " doesn't exist!"
					
				End If
					
			End If
			
		ElseIf mlngMode = MODE_HTTP_GET_NET Then
			
			' is HTTPID param valid?
			If mstrHTTPID = "" Then
				' No...
				LogMsg "No HTTP ID. File will not be downloaded"
			Else
				' Yes...
				mstrHTTPIDPath = objMqFS.ConcatenatePath(CStr(mstrOAPath), CStr(mstrHTTPID))

				' Check if this folder exists
				If oFSO.FolderExists(mstrHTTPIDPath ) = True Then
					LogMsg "Folder " & mstrHTTPIDPath & " exists!"

				
					If mlngSegment = SEGMENT_INI Then
						' when requesting the ini, we build both the ini and zip files, and return the ini
						If Len(mstrFileName) = 0 Then
							mstrFileName = GetIniFileName(mstrHTTPID)
						End If
										
						'first generate the ini and zip package files
						'stop - if it already exists, should we use it?
						' PENDING for Vizor 
						' Set objWebClient = CreateObject("MqPCDEPortal.CMqWebClient")
						'If objWebClient.GenerateKit(objMqFS.ConcatenatePath(CStr(mstrHTTPIDPath), CStr(GetIniFileName(mstrHTTPID))), _
						'							objMqFS.ConcatenatePath(CStr(mstrHTTPIDPath), CStr(GetZipFileName(mstrHTTPID))), _
						'							CStr(ZIP_FILES), FILE_DELIM, CStr(mstrHTTPIDPath)) Then
						
							'return the ini file
							GetFile objMqFS.ConcatenatePath(CStr(mstrHTTPIDPath), CStr(mstrFileName)), _
									mstrFileName, bKeepFile 
						'End If
						
						'Set objWebClient = Nothing
						
					ElseIf mlngSegment = SEGMENT_ZIP Then
						'return the zip file that was created
						If Len(mstrFileName) = 0 Then
							mstrFileName = GetZipFileName(mstrHTTPID)
						End If
						
						GetFile objMqFS.ConcatenatePath(CStr(mstrHTTPIDPath), CStr(mstrFileName)), _
								mstrFileName, bKeepFile 
						
					ElseIf mlngSegment = SEGMENT_CONFIRM Then
						'delete the zip file
						mstrFilePath = objMqFS.ConcatenatePath(CStr(mstrHTTPIDPath), CStr(GetZipFileName(mstrHTTPID)))
						If oFSO.FileExists(mstrFilePath) = True Then
							oFSO.DeleteFile mstrFilePath
							LogMsg mstrFilePath & " was deleted"
						End If
							
						'delete the ini file
						mstrFilePath = objMqFS.ConcatenatePath(CStr(mstrHTTPIDPath), CStr(GetIniFileName(mstrHTTPID)))
						If oFSO.FileExists(mstrFilePath) = True Then
							oFSO.DeleteFile mstrFilePath
							LogMsg mstrFilePath & " was deleted"
						End If
						
						'delete the files that were in the zip file
						'if we leave them til now, then we can always rebuild the package with the files again
						'the risk is that if a new file is put here in between the time that the zip file is downloaded and this call,
						'then we may be deleting the wrong one. The alternative is to delete the file when it's packaged, but if something is
						'wrong with the package then we can't rebuild it
						
						arrFiles = Split(ZIP_FILES, FILE_DELIM)
						
						For lngFileCount = LBound(arrFiles) To UBound(arrFiles)
							mstrFilePath = objMqFS.ConcatenatePath(CStr(mstrHTTPIDPath), CStr(arrFiles(lngFileCount)))
							If oFSO.FileExists(mstrFilePath) = True Then
								oFSO.DeleteFile mstrFilePath
								LogMsg mstrFilePath & " was deleted"
							End If
						Next
							
					Else
						LogMsg "Unknown Segment for GET: " & mlngSegment
					End If

				Else
					LogMsg mstrHTTPIDPath & " doesn't exist!"
					
				End If
				
				
			End If
			
		ElseIf mlngMode = MODE_HTTP_PUSH Then
			' are HTTPID and Filename parms valid?
			If mstrHTTPID = "" OR mstrFileName = "" Then
				' No...
				'Response.Status = "400 invalid syntax"
				LogMsg "No HTTP ID or File Name. File will not be uploaded"
			Else
				' Yes...
				mstrSubFolder = CStr(Request.QueryString("SF"))
				LogMsg "Request for SF returned " & mstrSubFolder
				
				mstrUploadDir = objMqFS.ConcatenatePath(CStr(mstrOAPath), CStr(mstrHTTPID))

				If Len(Trim(mstrSubFolder)) > 0 Then
					mstrUploadDir = objMqFS.ConcatenatePath(CStr(mstrUploadDir), CStr(mstrSubFolder))
				End If
				
				If Len(mstrFileName) > 0 Then
					PostFile mstrUploadDir, mstrFileName, oFSO, objMqFS
				End If
			End If
		
		ElseIf mlngMode = MODE_HTTP_PUSH_NET Then
			' is HTTPID param valid?
			If mstrHTTPID = "" Then
				' No...
				'Response.Status = "400 invalid syntax"
				LogMsg "No HTTP ID. File will not be uploaded"
			Else
				' Yes...
				mstrSubFolder = CStr(Request.QueryString("SF"))
				LogMsg "Request for SF returned " & mstrSubFolder
				
				mstrUploadDir = objMqFS.ConcatenatePath(CStr(mstrOAPath), CStr(mstrHTTPID))

				If Len(Trim(mstrSubFolder)) > 0 Then
					mstrUploadDir = objMqFS.ConcatenatePath(CStr(mstrUploadDir), CStr(mstrSubFolder))
				End If
				
				If mlngSegment = SEGMENT_INI Then
					' when requesting the ini, we build both the ini and zip files, and return the ini
					If Len(mstrFileName) = 0 Then
						mstrFileName = GetIniFileName(mstrHTTPID)
					End If
					PostFile mstrUploadDir, mstrFileName, oFSO, objMqFS
					
				ElseIf mlngSegment = SEGMENT_ZIP Then
					'return the zip file that was created
					If Len(mstrFileName) = 0 Then
						mstrFileName = GetZipFileName(mstrHTTPID)
					End If
					PostFile mstrUploadDir, mstrFileName, oFSO, objMqFS
					
				ElseIf mlngSegment = SEGMENT_CONFIRM Then
					'verify files were uploaded
					' PENDING for Vizor
					'Set objWebClient = CreateObject("MqPCDEPortal.CMqWebClient")
					
					'If objWebClient.ExtractKit(objMqFS.ConcatenatePath(CStr(mstrUploadDir), CStr(GetIniFileName(mstrHTTPID))), _
					'							objMqFS.ConcatenatePath(CStr(mstrUploadDir), CStr(GetZipFileName(mstrHTTPID))), _
					'							CStr(mstrUploadDir)) Then
						
						'delete the ini file
					'	objMqFS.DeleteFile(objMqFS.ConcatenatePath(CStr(mstrUploadDir), CStr(GetIniFileName(mstrHTTPID))))
						
						'return true
					'	Response.Write "1"
					'Else
					'	'return false
					'	Response.Write "0"
					'End If
					
					'Set objWebClient = Nothing
					
				Else
					LogMsg "Unknown Segment for POST: " & mlngSegment
				End If
				
				
			End If
		End If
		
	Else
	
		Response.Write Request.ServerVariables("REMOTE_ADDR")
		'Response.Status = "400 Security Key"
		LogMsg "Offline Area path to upload to not resolved. File will not be uploaded"
		
	End If
	
	
	Set objMqFS = Nothing
	Set oFSO = Nothing		
	
	Private Sub GetFile(strFilePath, strFileName, bKeepFile)
	On Error Resume Next

		Dim objStream
		Dim lngSize
		
		' does the file exist?
		If oFSO.FileExists(strFilePath) = True Then
						
			'Set the content type to ini?				
			'Response.AddHeader "Content-Type", INI_CONTENT_TYPE
			Response.AddHeader "Content-Disposition","attachment; filename=""" & strFileName & """"
			'Response.ContentType = INI_CONTENT_TYPE
							
			'stream the content in the response
			Set objStream = Server.CreateObject("ADODB.Stream")
			objStream.Open
			objStream.Type = adTypeBinary
								
			LogMsg "Loading " & strFilePath & " for streaming"
			
			objStream.LoadFromFile strFilePath

			lngSize = objStream.Size 
											
			LogMsg "Content-Length=" & lngSize

			Response.AddHeader "Content-Length", lngSize 
			Response.Buffer = False 
						
			Do Until objStream.EOS Or Not Response.IsClientConnected 
				Response.BinaryWrite(objStream.Read(CHUNK_SIZE)) 
			Loop
			
			LogMsg "Done writing " & strFilePath
			
			objStream.Close		
			
			If not bKeepFile Then 
				oFSO.DeleteFile strFilePath
				LogMsg strFilePath & " was deleted"
							
			End If	
			
		Else
			LogMsg strFilePath & " doesn't exist!"
			
		End If
		
		Set objStream = Nothing
	
	End Sub
	
	Private Sub PostFile(strUploadDir, strFileName, oFSO, objMqFS)
	
		' Read the POST data as 4K chunks		
		Const adSaveCreateOverWrite = 2
		Const readSize = 4096
				
		Dim oBinaryStream
		Dim lngToRead
		Dim lngReadSize
		Dim postData
		Dim strLocalPathFile
				
		Set oBinaryStream = Server.CreateObject("ADODB.Stream")

		LogMsg "File will be uploaded to: " & strUploadDir
				
		' does a directory already exist on the server for this client?
		If oFSO.FolderExists(strUploadDir) = False Then

			LogMsg "Folder " & strUploadDir & " does not exist. Creating it now..."

			'No...
			' Create directory for this client
			oFSO.CreateFolder(strUploadDir)
					
			LogMsg "Folder " & strUploadDir & " was created"
			
		End If

		' Increase Script Timeout to 10 hours
		Server.ScriptTimeout = 36000

		
		lngToRead = Request.TotalBytes
				
		LogMsg "File is " & lngToRead & " bytes"
				
		lngReadSize = readSize
				
		oBinaryStream.Type = adTypeBinary
		oBinaryStream.Open

		Do While lngToRead > 0
			postData = Request.BinaryRead(lngReadSize)

			oBinaryStream.Write(postData)

			lngToRead = lngToRead - lngReadSize

			If lngReadSize > lngToRead Then
				lngReadSize = lngToRead
			End If
		Loop
				
		' Write the file to local file system
		strLocalPathFile = objMqFS.ConcatenatePath(CStr(strUploadDir), CStr(strFileName))

		oBinaryStream.Position = 0
		oBinaryStream.SaveToFile strLocalPathFile, adSaveCreateOverWrite

		LogMsg "File was saved to " & strLocalPathFile
				
		oBinaryStream.Close
				
		Set oBinaryStream = Nothing
				
	End Sub
	
	Private Function GetIniFileName(strHTTPID)
		GetIniFileName = strHTTPID & ".ini"
	End Function

	Private Function GetZipFileName(strHTTPID)
		GetZipFileName = strHTTPID & ".zip"
	End Function

%>