// Dependencies:
//	xml.js
function CMqLoadDataMgr(objFields,strDataHTMLDocument){
	var m_strDataHTMLDocument;
	var m_lngPrevMode;
	var m_varFieldsChanged;
	var m_varExcludedFields=new Array();
	var m_arrStateButtonPostfixes=Array("_cal", "_HTMLEdit", "_MemoEdit", "_SelVal", "_UDExtBtn");	
	var m_arrModeButtonPostfixes=Array("_attach");	
	var SECURITY_READ_ONLY_PERMISSIONS="R";
	var m_objRSHelper = new CMqRSHelper();
	var m_arrEnFldsPerMode=new Array();
	var m_arrEnIfHasValModes=new Array();
	var m_blnAlwaysRefreshDisplay=false;
	var m_blnUnescapeData=false;
	var m_strBatchFieldIDs="";
	var m_lngNumBatchRows=0;
	
	//start constructor
	var	m_objFields=objFields;			
	if (strDataHTMLDocument){
			m_strDataHTMLDocument=strDataHTMLDocument;
	}else{
			m_strDataHTMLDocument="Record.document";
	}
	var m_objFieldValues=new CMqFieldValues(m_objFields,m_strDataHTMLDocument);
	//end constructor
		
	var self=this;
	
	//constants
	var INIT_REVISION_NUMBER=-1;

	
	function GetDataHTMLDocument(){
		return m_strDataHTMLDocument;
	}
	
	function GetDataHTMLDocumentObject(){
		return eval(m_strDataHTMLDocument);
	}
	
	function SetOnBeforeLoad(strFunction, blnAppend){
		var strAppendFunct;
		if (blnAppend){
			strAppendFunct=self.OnBeforeLoad.valueOf();	
		}
		self.OnBeforeLoad=BuildFunction(strFunction, strAppendFunct) ;		
	}
	
	function SetOnAfterLoad(strFunction, blnAppend){
		var strAppendFunct;
		if (blnAppend){
			strAppendFunct=self.OnAfterLoad.valueOf();	
		}
		self.OnAfterLoad=BuildFunction(strFunction,strAppendFunct) ;	
	}
	
	function OnBeforeLoad(){
		
		return true;
	}
	
	function OnAfterLoad(){
	
		return true;
	}	
	
	function Load(objTargetFieldValuesRs,lngMode,objDisplayElements,objControlsSs){
		self.OnBeforeLoad();								
		//Start Load action
		if (m_objFields){			
			var lngFieldID;
			var oField;
			var oFormElement=new CMqFormElement();
			var oHTMLElement;
			var blnElementDisabled;
			var varTargetFieldIds;
			var objDataHTMLDocument=eval(m_strDataHTMLDocument);
			var varFields;
			var blnInitializeValues=false;
			var blnChangeDisplay=ChangeDisplay(lngMode);
			var varEnFlds=m_arrEnFldsPerMode[lngMode];
			var varEnIfVal=m_arrEnIfHasValModes[lngMode];
			
			if(IsRs(objTargetFieldValuesRs)){
				varFields=objTargetFieldValuesRs.GetRecordset();  
			}else{
				varFields=m_objFields.GetFieldCol();
			}
			if (!objTargetFieldValuesRs){
				blnInitializeValues=true;             
			}
    
			for(lngFieldID in varFields){
						
			   try{
					oField=m_objFields.Field(lngFieldID);
			        if (oField){
					    oHTMLElement=GetHTMLElement(oField,objDataHTMLDocument);
			            SetFieldValue(oHTMLElement, blnInitializeValues, lngFieldID, objTargetFieldValuesRs, oFormElement, oField);
			            if (blnChangeDisplay){
			            	SetFieldDisplay(oHTMLElement, oField, varEnFlds, varEnIfVal, objDisplayElements, objDataHTMLDocument,objTargetFieldValuesRs);
			            }
			            SetInitValAttrib(oHTMLElement, oFormElement, oField);
			        }
			    }catch (e){
			    //we do not log the error
			    }
			}
		
			m_lngPrevMode=lngMode;
			if (objControlsSs){		
				//set revision number
				SetRevisionNumber(objTargetFieldValuesRs,m_objFields,objControlsSs);					
			}
		}
		//End Load action
		self.OnAfterLoad();				
	}
		
	function Reset(){
		m_varFieldsChanged=null;
	}	
	
	
	function SetFieldChanged(strFieldID){
		if (!m_varFieldsChanged){
			m_varFieldsChanged=new Array();
		}		
		m_varFieldsChanged[strFieldID]=strFieldID;		
		
	}

	function ExcludeField(strFieldID){
		m_varExcludedFields[strFieldID]=strFieldID;
	}
	
	function SetBatchFieldIDs(strFieldIDs)
	{
		m_strBatchFieldIDs=strFieldIDs;
	}
	
	function SetNumBatchRows(lngNumBatchRows)
	{
		m_lngNumBatchRows=lngNumBatchRows;
	}
	
	function GetBatchFieldIDs()
	{
		return m_strBatchFieldIDs;
	}
	
	function GetNumBatchRows()
	{
		return m_lngNumBatchRows;
	}
	
	function FieldsChanged()
	{
		return m_varFieldsChanged;
	}
	
	function GetDataForSave(blnOnlyChangedFields){
		var strData;
		if (m_objFieldValues){
			if (!blnOnlyChangedFields){
				strData=m_objFieldValues.GetFromDocument(null,true,m_strBatchFieldIDs,m_lngNumBatchRows);
			}else{
				strData=m_objFieldValues.GetFromDocument(m_varFieldsChanged,true,m_strBatchFieldIDs,m_lngNumBatchRows);
			}
		}

		return strData;
	}

	function GetObjFieldValues(){
		return m_objFieldValues;
	}

	
	function SetSingleValueToFields(strValue,varTargetFieldIds,blnUnescape,blnUnformatXMLData){
			if (m_objFields){				 
				var oDocumentData=eval(m_strDataHTMLDocument);
				if (varTargetFieldIds){	
					var strFieldID;
					var objField;
					var objFieldElement;
					var objFormElement=new CMqFormElement();
					for (var i=0;i<varTargetFieldIds.length;i++){
						try{
							strFieldID=String(varTargetFieldIds[i]);							
							objField=m_objFields.Field(strFieldID);
							if (objField){
								objFieldElement=GetHTMLElement(objField,oDocumentData);
								if (objFieldElement){
									objFormElement.SetValue(strValue,blnUnescape,objFieldElement,objField.GetControlType(),blnUnformatXMLData);									
								}
							}
						}
						catch(e){								
						}
					}			
				}		
			}
	}

	function GetFieldValue(strFieldID,blnEscape,blnFromServer,blnGetIDText,blnJSEscape,lngBatchRow){
		var varValue="";
		
		if (!blnFromServer){
			varValue=GetFieldValueFromDocument(strFieldID,blnEscape,blnGetIDText,blnJSEscape,lngBatchRow);
		}
		
		return varValue;
	}

	function GetHTMLElement(oField,oDataHTMLDocument, strBatchID){
		var oElement;
		if (oField && oDataHTMLDocument){
			var strElement=oField.GetBoundControl();
			if (strElement){
				if (strElement.length>0){
					if(strBatchID){
						var regExp=new RegExp(oField.GetID(),"g");
						strElement=strElement.replace(regExp, oField.GetID() + "_" + strBatchID);
					}
					oElement= oDataHTMLDocument.getElementById(strElement);
				}
			}
		}
		return oElement;
	}
	
	function SetEnFldsPerMode(arrEnFldsModes)
	{
		m_arrEnFldsPerMode=arrEnFldsModes;
	}	
	
	function SetEnableIfHasValPerMode(arrEnIfValModes)
	{
		m_arrEnIfHasValModes=arrEnIfValModes;
	}
	
	function SetUnescapeData(blnUnescapeData)
	{
		m_blnUnescapeData=blnUnescapeData;
	}

	this.SetUnescapeData=SetUnescapeData;
	this.SetEnFldsPerMode=SetEnFldsPerMode;	
	this.SetEnableIfHasValPerMode=SetEnableIfHasValPerMode;	
	this.ExcludeField=ExcludeField;
	this.GetDataHTMLDocument=GetDataHTMLDocument;
	this.SetFieldChanged=SetFieldChanged;
	this.GetObjFieldValues=GetObjFieldValues;
	this.GetDataHTMLDocumentObject=GetDataHTMLDocumentObject;
	this.GetFieldValue=GetFieldValue;
	this.Load=Load;	
	this.GetDataForSave=GetDataForSave;	
	this.SetSingleValueToFields=SetSingleValueToFields;
	this.SetOnBeforeLoad=SetOnBeforeLoad;
	this.SetOnAfterLoad=SetOnAfterLoad;
	this.OnBeforeLoad=OnBeforeLoad;
	this.OnAfterLoad=OnAfterLoad;
	this.Reset=Reset;
	this.GetHTMLElement=GetHTMLElement;
	this.DisableDtsFieldButton=DisableDtsFieldButton;
	this.DisableElement=DisableElement;
	this.SetBatchFieldIDs=SetBatchFieldIDs;
	this.SetNumBatchRows=SetNumBatchRows;
	this.GetBatchFieldIDs=GetBatchFieldIDs;
	this.GetNumBatchRows=GetNumBatchRows;
	this.FieldsChanged=FieldsChanged;
	
	//private functions
	function BuildFunction(strNewContent,strContentFunction){
		var strBody;
		if (strContentFunction){		
			strBody="var objFunction=" +
						strContentFunction + ";" + 
						strNewContent + "objFunction();";
		}
		else{
			strBody=strNewContent;
		}
		
		var objFunc=new Function ( strBody );
		return objFunc;
	}
	
	function ChangeDisplay(lngNewMode){
		if(m_blnAlwaysRefreshDisplay){
			return true;
		}else{
			return (lngNewMode != m_lngPrevMode);
		}
	}
	
	function SetRevisionNumber(oFieldValuesRs,oFieldCol,objControlsSs){
		if (objControlsSs){	
			var strRevisioNumber;
			if (oFieldValuesRs){	
				strRevisioNumber=m_objRSHelper.GetFieldValue(oFieldCol.GetRevisionHistoryFieldID(),oFieldValuesRs);
			}
			if (strRevisioNumber){
				if (strRevisioNumber.length===0){
					strRevisioNumber=INIT_REVISION_NUMBER;
				}	
			}else{
				strRevisioNumber=INIT_REVISION_NUMBER;
			}	
			objControlsSs.setRevisionNumber(strRevisioNumber);	
		}
	
	}
	
	function DisableElement(objElement,oFld,blnForceDis,oRecElems, objDataHTMLDoc)
	{
		if (oRecElems){
			var blnDisabled=IsElemDisabled(oFld,blnForceDis);
			oRecElems.DisableElement(objElement,blnDisabled,oFld.GetControlType(),objDataHTMLDoc);
			var strFldName=oFld.GetBoundControl();
						
			DisableDtsFieldButton(strFldName, blnDisabled, objDataHTMLDoc, m_arrStateButtonPostfixes, objElement);
			SetDtsFieldMode(strFldName, blnDisabled, objDataHTMLDoc, m_arrModeButtonPostfixes);
		}
	}

	function IsElemDisabled(oFld,blnForceDis)
	{
		var blnDisabled=false;
		if (blnForceDis){
			blnDisabled=true;
		}else{
        		if (!oFld.GetEnabled()){
        			blnDisabled=true;
        		}else{
        			if (oFld.GetSecurity()==SECURITY_READ_ONLY_PERMISSIONS){
        				blnDisabled=true;
        			}
        		}
		}
		return blnDisabled;
	}
		
	function IsFieldExcluded(strField,varFields){
			var blnExists=false;
			if (varFields){
				var strValue=varFields[strField];
				if (strValue){
					blnExists=true;
				}
			}
			return blnExists;
	}
	
	function SetInitialValue(oField, oHTMLElement, oFormElement)
	{
		if (oField){			
			if(oHTMLElement){
				var lngControlType = oField.GetControlType();
				var lngAltControlType = oFormElement.GetAlternateControlType(oHTMLElement);
				if (lngAltControlType){
					lngControlType = lngAltControlType;
				}
				if (lngControlType == CTRL_TYPE_COMBO){
					oFormElement.SetValue("",false,oHTMLElement,CTRL_TYPE_COMBO,true);
			    }
			}
		}
	}
	
	function GetFieldValueFromDocument(strFieldID,blnEscape,blnGetIDText,blnJSEscape,lngBatchRow){
		var varValue="";
		
		try{
			if (m_objFields){
				var objFieldElement;
				var objField;
				var objFormElement=new CMqFormElement();
				var oDocumentData=eval(m_strDataHTMLDocument);
													
				if (strFieldID){
					objField=m_objFields.Field(strFieldID);
					if (objField){
						objFieldElement=GetHTMLElement(objField,oDocumentData,lngBatchRow);
						if (objFieldElement){
							varValue=objFormElement.GetValue(blnEscape,objFieldElement,objField.GetControlType(),blnGetIDText,blnJSEscape);
						}
					}
				}
			}
		}catch(e){
			//WriteConsole(e.description);
		}

		return varValue;
	}
	function IsRs(objFieldValuesRs){	
		var blnValid=false;
		try{
			if(objFieldValuesRs){
				if (objFieldValuesRs.Record){
					blnValid=true;
				}
			}
		}
		catch(e){
		}
		return blnValid;
	}

	function SetFieldValue(oHTMLElement, blnInitializeValues, lngFieldID, objTargetFieldValuesRs, oFormElement, oField)
	{
		var strValue;
		
		if(oHTMLElement){
			var blnIsFieldExcluded=IsFieldExcluded(String(lngFieldID), m_varExcludedFields);
			
			if (!blnInitializeValues){
				if (!blnIsFieldExcluded) {
					
			        strValue=m_objRSHelper.GetFieldValue(lngFieldID,objTargetFieldValuesRs);
			        oFormElement.SetValue(strValue,m_blnUnescapeData,oHTMLElement,oField.GetControlType(), true,null,lngFieldID);
			    }
			}else{
				if(!blnIsFieldExcluded){
					SetInitialValue(oField, oHTMLElement, oFormElement);
				}
			}
		
			SetAssociatedControlValue(oField, oHTMLElement);
		}
	}
	function SetInitValAttrib(oHTMLElement, oFormElement, oField)
	{
		var strInitVal=oFormElement.GetValue(false,oHTMLElement,oField.GetControlType(),true,false);
		oHTMLElement.setAttribute("MqValOnLoad", strInitVal);
	}
	
	function SetFieldDisplay(oHTMLElement, oField, varEnFlds, varEnIfVal, objDisplayElements, objDataHTMLDocument,objTargetFieldValuesRs)
	{		
		if(oHTMLElement){
        		var blnForceDis;
        		var lngIndex=-1;
        		var strFieldVal;
        		
        		if (varEnFlds==0){
        			blnForceDis=true;
        		}else{
        			if (varEnFlds==1){
        				blnForceDis=false;
        			}else{
        				if (varEnFlds){
        					m_blnAlwaysRefreshDisplay=true;
        					lngIndex=g_MqRef.MqArr.GetIndex(oField.GetID(),varEnFlds);
        					
        					if(lngIndex>=0){
        						blnForceDis=false;
        					}else{
        						blnForceDis=true;
        					}
        				}
						if(varEnIfVal){
							lngIndex=g_MqRef.MqArr.GetIndex(oField.GetID(),varEnIfVal)
							if(lngIndex>=0){
								strFieldVal=m_objRSHelper.GetFieldValue(oField.GetID(),objTargetFieldValuesRs)
								if(strFieldVal!=""){
									blnForceDis=true;
								}else{
									blnForceDis=false;
								}
							}
						}
        			}
        		}
			DisableElement(oHTMLElement,oField,blnForceDis,objDisplayElements, objDataHTMLDocument);
		}
	}
	
	function DisableDtsFieldButton(strFieldName, blnDisable, objDataHTMLDocument,arrButtonPostfixes, objElement)
	{
		var lngCount;
		var objElementButton;
		var blnHidden=false;
		if(m_objMqButton){
			if(objDataHTMLDocument){
				if(objElement){
					if(objElement.getAttribute('MqHideAssCtrls')=="1"){
						//it's a field that has the hide associated ctrls attribute, hide the buttons
						blnHidden=true;
					}
				}
				
				for(lngCount=0; lngCount<arrButtonPostfixes.length; lngCount++){				
					
					objElementButton=objDataHTMLDocument.getElementById(m_objMqButton.GetButtonHTMLName(strFieldName + arrButtonPostfixes[lngCount]));
					
					if(objElementButton){
						if(blnHidden){
							objElementButton.className=""; 
						}else{
							if(blnDisable){
								m_objMqButton.Disable(objElementButton);
							}else{
								m_objMqButton.Enable(objElementButton);
							}
						}
					}
				}
			}
		}
	}

	function SetDtsFieldMode(strFieldName, blnDisable, objDataHTMLDocument, arrButtonPostfixes)
	{
		var ATTACH_MODE_READ_ONLY=7;
		var ATTACH_MODE_DEFAULT=0;
		var lngCount;
		
		if(m_objMqButton){
			if(objDataHTMLDocument){
				for(lngCount=0; lngCount<arrButtonPostfixes.length; lngCount++){				
					
					var objFieldElement=objDataHTMLDocument.getElementById(strFieldName);
					if(objFieldElement){									
						if(objFieldElement.AttachMode){
							if(blnDisable){
								objFieldElement.AttachMode=ATTACH_MODE_READ_ONLY;
							}else{
								objFieldElement.AttachMode=ATTACH_MODE_DEFAULT;
							}
						}
					}
				}
			}
		}
	
	}
	
	function SetAssociatedControlValue(oField, oHTMLElement)
	{
		if(oField){
			if(oField.GetControlType()==CTRL_TYPE_LIST){
				SetListTooltip(oHTMLElement);
				SetListTextBox(oHTMLElement);
			}
		}
	}

	function CMqFieldValues(objFields,strDataHTMLDocument){
		//begin constructor
		var m_objFields=objFields;
		var m_strDataHTMLDocument=strDataHTMLDocument;
		var m_strFieldDelim="&";
		var m_strFieldValueDelim="=";
		//end constructor
	
		function SetFieldDelimiter(strDelim){
			m_strFieldDelim=strDelim;
		}
		
		function SetFieldValueDelimiter(strDelim){
			m_strFieldValueDelim=strDelim;
		}
		
		function GetFromDocument(varFields, blnSkipAppendValFlds, strBatchFieldIDs, lngNumBatchRows){
			var strCtrlQueryString="";		
			var strFieldID;
			var oField;
			var oDocumentData=eval(m_strDataHTMLDocument);
			var oFormElement=new CMqFormElement();
			var blnFieldArray=false;
			var arrBatchFieldIDs=new Array();
			
			if (!varFields){
				varFields=	m_objFields.GetFieldCol();
				blnFieldArray=true;
			}		
			
			if(strBatchFieldIDs){
				if(strBatchFieldIDs!=""){
					arrBatchFieldIDs=strBatchFieldIDs.split(",");
				}		
			}
			
			for (var i=0;i<varFields.length;i++){					
				if (blnFieldArray){	
					oField=varFields[i];
					strFieldID=i;	
				}else{		
					strFieldID=varFields[i];							 			
					oField =m_objFields.Field(strFieldID);	
				}		
				if (oField){		
					strQSForFld=GetQueryStringForField(oField,oDocumentData,oFormElement,m_strFieldValueDelim,blnSkipAppendValFlds);
					
					if(strQSForFld!=""){
						strCtrlQueryString+=strQSForFld + m_strFieldDelim;
					}
					if(g_MqRef.MqArr.IsValueInArray(strFieldID, arrBatchFieldIDs)){
						for(x=1; x<=lngNumBatchRows;x++){
							strQSForFld=GetQueryStringForField(oField,oDocumentData,oFormElement,m_strFieldValueDelim,blnSkipAppendValFlds, x);
					
							if(strQSForFld!=""){
								strCtrlQueryString+=strQSForFld + m_strFieldDelim;
							}
						}
					}
				}					
			}		
			return strCtrlQueryString;
		}
	
		function GetFromServer(varDataViewIDs,strCondition,objHTTPRequest,strHTTPLocation){
			var strXMLFields="";
			var strReturn;
			var objValues;
			if (varDataViewIDs){			
				strHTTPLocation+="wcCmdBar.asp?WCI=wciLoadDataViews";				
				var strPostData="DataViewIDs="+varDataViewIDs.join(",")+"&QueryString="+strCondition;			
				strHTTPLocation+="&"+strPostData;
				strReturn=objRequest.Get(strHTTPLocation);							
				if (strReturn!=CANCEL_PROCESS){
					strXMLFields=strReturn;
				}								
				if (strXMLFields){
					objValues= new CMqRecordset(strXMLFields,m_objFields.GetFieldIDName());
				}				
			}
			return objValues;
		}
	
		this.GetFromDocument=GetFromDocument;
		this.GetFromServer=GetFromServer;
		this.SetFieldDelimiter=SetFieldDelimiter;
		this.SetFieldValueDelimiter=SetFieldValueDelimiter;
	
		//private methods
		function GetQueryStringForField(oField,oDataHTMLDocument,oFormElement,strFieldValueDelim,blnSkipAppendValFlds, strBatchRowID){			
			var oHTMLElement=GetHTMLElement(oField,oDataHTMLDocument, strBatchRowID);
			var strQueryStringForField="";
			var blnAddVal=true;
			var strFieldID="";
			var strTempVal="";
			
			if (oHTMLElement){					
				if(blnSkipAppendValFlds){
					var strAttributeValue = oFormElement.GetValueFromCustomAttribute(oHTMLElement,"MqAppendVal");
					if(strAttributeValue=="1"){
						//don't get the content if it's a field we append val to like the Activity Log
						blnAddVal=false;
					}else{
						strAttributeValue = oFormElement.GetValueFromCustomAttribute(oHTMLElement,"MqSkipForSave");
						if(strAttributeValue=="1"){
							//don't get the content if it's a field we skip for saving like a disabled field
							strTempVal="<PlaceHolderDontSaveValue>";
						}
					}
				}				
				if(blnAddVal){
					strFieldID=oField.GetID();
					
					if(strBatchRowID){
						strFieldID+="_"+strBatchRowID;
					}
					if(strTempVal==""){
						strTempVal=oFormElement.GetValue(true,oHTMLElement,oField.GetControlType());
					}	
					strQueryStringForField=strFieldID +strFieldValueDelim+ strTempVal;
				}	
			}
	
			return strQueryStringForField;
		}
	}
		
}

function CMqMacros()
{
	var MAX_MACROS_TO_RESOLVE=50;
	var m_strTagName="ValOfField";
	
	function ResolveFieldMacros(strString, objLoadDataMgr, blnJSEscape, blnGetIDText)
	{
	    var strResolvedValue;
	    var strReplace;
	    var strReturn="";
	    var lngCountResolved=0;
	    var arrField;
	    var lngRow;
	    var strField;
	    var strFieldID;
	    
	    if (strString){
	        strReturn=strString;
	                        
	        if (objLoadDataMgr){
					            
	            var objHTMLUtils=new CMqHTMLUtils();
	            var strField=GetFieldMacroContents(strReturn, objHTMLUtils);
				while ((strField) && (lngCountResolved<MAX_MACROS_TO_RESOLVE)){
					
					arrField=strField.split("_");
				
					if(arrField.length>=0){
						strFieldID=arrField[0];
					}
				
					if(arrField.length>=1){
						lngRow=arrField[1];
					}				
	            	                
	                strResolvedValue=objLoadDataMgr.GetFieldValue(strFieldID,false,false,blnGetIDText,blnJSEscape,lngRow);
	                            
	                strReplace=objHTMLUtils.TagPair(m_strTagName,strField);
	                                
	                strReturn=ReplaceText(strReturn,strReplace,strResolvedValue);

	                strField=GetFieldMacroContents(strReturn, objHTMLUtils);
	                
	                lngCountResolved++;
	            }
	        }
	    }
	    return strReturn;
	}
    
    function GetFieldMacroContents(strString, objHTMLUtils)
    {
		if(!objHTMLUtils){
			objHTMLUtils=new CMqHTMLUtils();
		}
		return objHTMLUtils.GetTagContents(strString,m_strTagName);
    }
    
    function ReplaceText(strValue, strRegExp, strReplaceText)
    {
        var strReplacedText;
    
        if (strValue){
                    
            var objRE = new RegExp(strRegExp,"ig");
            strReplacedText= strValue.replace(objRE,strReplaceText);
                            
        }
                    
        return strReplacedText;   
    }
                
	this.ResolveFieldMacros=ResolveFieldMacros;
	this.GetFieldMacroContents=GetFieldMacroContents;

}

function CMqDefVals()
{
	var m_blnApplyDefVals=false;
	var m_varDefVals= new Array();
	var m_oRSHpr=new CMqRSHelper();
	
	function GetApplyDefVals()
	{
		return m_blnApplyDefVals ;
	}
	function SetApplyDefVals(blnApplyDefVals)
	{
		m_blnApplyDefVals=blnApplyDefVals;
	}

	function SetDefVals(varDefVals)
	{
		m_varDefVals=varDefVals;
	}
	function GetDefVals()
	{
		return m_varDefVals;
	}

	function FillRS(rsLoadData)
	{					
		if (rsLoadData && m_varDefVals){
						
			if (m_varDefVals.length>0 ){
				var varFields=rsLoadData.GetRecordset();
				var lngFldID;
				var strValue;
				for (lngFldID in varFields){
					strValue =m_varDefVals[lngFldID];

					if(strValue){
						m_oRSHpr.SetFieldValue(lngFldID,rsLoadData,g_MqRef.MqStr.MqDecodeURIComponent(strValue));
					}								
				}
			}
		}			
	}
	
	this.GetApplyDefVals=GetApplyDefVals;
	this.SetApplyDefVals=SetApplyDefVals;
	this.SetDefVals=SetDefVals;
	this.GetDefVals=GetDefVals;
	this.FillRS=FillRS;
				
}
