var winArray=new Array();
var INVALID_WIN_ID = -1;
var m_strSessWinID="";

var CLOSE_SCENARIO_USER_LOGS_OFF = 1;
var CLOSE_SCENARIO_USER_SWITCHES_VIEW = 2;
var CLOSE_SCENARIO_USER_LEAVES_ISSUE_CONTEXT = 4;
var DIALOG_MODAL = '#dialog-modal';

var MODAL_DLG_CLASS=" ui-widget-content";

var m_intOrigPopUpWindowWidth=0;
var m_intOrigPopUpWindowHeight=0;

// Window Size Mode
// TODO: move to WindowProperties
var WIN_MODE_AS_DEFINED=0;
var WIN_MODE_MAXIMIZED=1;
var WIN_MODE_WITH_BORDERS=2;
	
function GetWinHeight(){
		if (document.all){
		    if (document.documentElement && document.documentElement.offsetHeight){
				return document.documentElement.offsetHeight;
			}else{
				return document.body.offsetHeight;
			}
		}else{
		    return window.innerHeight;
		}
}

function GetWinWidth(){
		if (document.all){
		    if (document.documentElement && document.documentElement.offsetWidth){
				return document.documentElement.offsetWidth;
			}else{
				return document.body.offsetWidth;
			}
		}else{
		    return window.innerWidth;
		}
}

function GetWindow(strWinName)
{
	var intWinIndex = getWinIndex(strWinName);
	var objWinInfo=winArray[intWinIndex];
	var objWindow;

	if(objWinInfo){
		objWindow=objWinInfo.win;
	}
	return objWindow;
}

function CloseModalWindow()
{
	if(document.getElementById(DIALOG_MODAL.replace('#',''))){
		
		if(parent){
			var objDlgWrapper=parent.document.getElementById("dialog-modal-wrapper");
			if(objDlgWrapper){
				var strParentClass=objDlgWrapper.className;
				if(strParentClass.indexOf(MODAL_DLG_CLASS)<0){
					objDlgWrapper.className=strParentClass+MODAL_DLG_CLASS;
				}
			}
		}
		
		try {
			$(DIALOG_MODAL).dialog("close");
			ResizeOpenerIfNeeded(parent, false);
			$("#" + new VNWindow().MODAL_WIN_IFRAME_ID).attr("src",""); 
		} catch(e) {
			WriteConsole("[CloseModalWindow] Modal window doesn't exist, or is not initialized");
		}
	}
}

function GetWindowSize(intMode, lngDefinedWidth, lngDefinedHeight, blnCurrentWin)
{
	
	var arrWinSize=new Array(5);
	
	if(!intMode){
		intMode=WIN_MODE_AS_DEFINED;
	}else{
		if(intMode!=WIN_MODE_AS_DEFINED && intMode!=WIN_MODE_MAXIMIZED && intMode!=WIN_MODE_WITH_BORDERS){
			intMode=WIN_MODE_AS_DEFINED;
		}
	}
	
	var intBodyWidth;
	var intBodyHeight;
	var objTopWin;
	if(blnCurrentWin){
		objTopWin=window;
	}else{
		objTopWin=GetTopWin();
	}
	
	intBodyHeight=$(objTopWin).height();
	intBodyWidth=$(objTopWin).width();
	
	if(intMode==WIN_MODE_AS_DEFINED){
		if(lngDefinedWidth<intBodyWidth){
			lngCalcWidth=lngDefinedWidth;
		}else{
			lngCalcWidth=intBodyWidth;
		}
		
		if(lngDefinedHeight<intBodyHeight){
			lngCalcHeight=lngDefinedHeight;
		}else{
			lngCalcHeight=intBodyHeight;
		}
	}else{
		if(intMode==WIN_MODE_MAXIMIZED){
			lngCalcWidth=intBodyWidth-40;
			lngCalcHeight=intBodyHeight-40;
		}else{
			if(intMode==WIN_MODE_WITH_BORDERS){
				var intPadding=80;
				if(intBodyHeight<700||intBodyWidth<900){
					intPadding=40;
				}
				
				lngCalcWidth=intBodyWidth-intPadding;
				lngCalcHeight=intBodyHeight-intPadding;
			}
		}
	}
	
	arrWinSize[0]=lngCalcWidth;
	arrWinSize[1]=lngCalcHeight;
	arrWinSize[2]=intBodyWidth;
	arrWinSize[3]=intBodyHeight;
	arrWinSize[4]=window.outerWidth;
	arrWinSize[5]=window.outerHeight;
	
	return arrWinSize;
}

function GetTopWin()
{
	var objTopWin;
	
	if(window){
		objTopWin=window;
		
		while(objTopWin.parent && objTopWin.parent != objTopWin){
			objTopWin=objTopWin.parent;
		}
	}
	
	return objTopWin;
}

function OpenModalWindow(strURL, lngWidth, lngHeight, blnNearFullscreen, intMode)
{
	new VNWindow().OpenModalWin(lngWidth,lngHeight,blnNearFullscreen,intMode);

	$("#" + new VNWindow().MODAL_WIN_IFRAME_ID).attr("src",strURL); 
}

function ResizeOpenerIfNeeded(objOpener, blnOpening, lngWidth, lngHeight)
{		
	if(objOpener){
		if(objOpener.$){
			if(objOpener.$(DIALOG_MODAL)){
				if(objOpener.$(DIALOG_MODAL).is(':data(dialog)')){
					var lngOrigOpenerWidth=objOpener.$("#dialog-modal-orig-width").attr("innerHTML");
					var lngOrigOpenerHeight=objOpener.$("#dialog-modal-orig-height").attr("innerHTML");
									
					if(blnOpening){
					
						if(lngOrigOpenerWidth<=lngWidth && objOpener.$(DIALOG_MODAL).width() < lngWidth){
							objOpener.$(DIALOG_MODAL).dialog("option", "width", lngWidth + 20);
						}
						
						if(lngOrigOpenerHeight<=lngHeight && objOpener.$(DIALOG_MODAL).height() < lngHeight){
							objOpener.$(DIALOG_MODAL).dialog("option", "height", lngHeight + 20);
						}
						 
					}else{
						objOpener.$(DIALOG_MODAL).dialog("option", "width", lngOrigOpenerWidth);
						objOpener.$(DIALOG_MODAL).dialog("option", "height", lngOrigOpenerHeight);
					}
					
					//objOpener.$(DIALOG_MODAL).dialog("option", "position", "center"); 
					objOpener.$(DIALOG_MODAL).dialog("option", "position", { my: "center", at: "center"} );
				}
			}
		}
	}
}

function ResizeAllOpeners(objOpener, blnOpening, lngWidth, lngHeight) {
	ResizeOpenerIfNeeded(objOpener, blnOpening, lngWidth, lngHeight);
	while(objOpener.parent && objOpener.parent != objOpener){
		objOpener= objOpener.parent;
		ResizeOpenerIfNeeded(objOpener, blnOpening, lngWidth, lngHeight);
	}
}

function OpenChildWindow(strURL,strWinName,strFeatures, blnCentered, intWinWidth, intWinHeight, fNotUseSessionWin, blnOpenIFramePopup, lngX, lngY, lngSupportedCloseScenarios, objRef)
{
	var blnDoOpenWindow=false;
	
	if(blnOpenIFramePopup){
		if(!OpenIFramePopup(strURL, intWinWidth, intWinHeight, lngX, lngY)){
			blnDoOpenWindow=true;
		}
	}else{
		blnDoOpenWindow=true;
	}

	if(!lngSupportedCloseScenarios){
		lngSupportedCloseScenarios = CLOSE_SCENARIO_USER_LOGS_OFF + CLOSE_SCENARIO_USER_SWITCHES_VIEW + CLOSE_SCENARIO_USER_LEAVES_ISSUE_CONTEXT;
	}

	if(blnDoOpenWindow){
		if(!fNotUseSessionWin){
		  strWinName=BuildSessWinName(strWinName);
		}

		var intWinIndex = getWinIndex(strWinName);
		var objWinInfo;
		var objWinArray;
		if (objRef) {
			if (objRef.winArray) {
				objWinInfo=objRef.winArray[intWinIndex];
				objWinArray=objRef.winArray;
			}
		}
		
		if (typeof objWinInfo == 'undefined '|| typeof objWinArray == 'undefined') {
			objWinInfo=winArray[intWinIndex];
			objWinArray=winArray;
		}
		var objWindow;
		var blnOpenWin=true;
		if(objWinInfo){
			objWindow=objWinInfo.win;
			if (objWindow){

			 if(!objWindow.closed){
			 	blnOpenWin=false;			   
			 }
			}
		}
	
		if (blnOpenWin){
			if (blnCentered){
			  if (!strFeatures){
			    strFeatures="";
			  }
			  strFeatures+=GetWinFeaturesToCenter(intWinWidth, intWinHeight);
			}
			
			//WriteConsole("Creating a child window that supports the following close scenarios: " + lngSupportedCloseScenarios);
			if (objWinArray) {
				objWinArray[intWinIndex] = new winInfo(null,strWinName,lngSupportedCloseScenarios)
				objWinArray[intWinIndex].win = window.open(strURL,strWinName,strFeatures);
			}
		}else{
			objWindow.focus();
		}
	}
}

function OpenIFramePopup(strURL, lngWidth, lngHeight, lngX, lngY)
{
	var objIFramePopup=parent.document.getElementById("ifraPopupCtnr");
	
	if(!lngX){
		lngX=GetLeftPos(lngWidth, true);
	}		
	if(!lngY){
		lngY=GetTopPos(lngHeight, true);
	}		

	if(objIFramePopup){
		objIFramePopup.src=strURL;
		objIFramePopup.style.width=lngWidth + "px";
		objIFramePopup.style.height=lngHeight + "px";
		objIFramePopup.style.left=lngX + "px";
		objIFramePopup.style.top=lngY + "px";
		objIFramePopup.style.visibility="visible";
		return true;
	}else{
		return false;
	}
}
function GetWinFeaturesToCenter(intWinWidth, intWinHeight){
  var l,t;
  var strFeatures="";
  
  if (intWinWidth && intWinHeight){
    l = GetLeftPos(intWinWidth);
    t = GetTopPos(intWinHeight);
    strFeatures=",width=" + intWinWidth + ",height=" + intWinHeight + ",left=" + l + ",top=" + t;
  }
  return strFeatures;
}

function GetLeftPos(intWinWidth, blnCenterOnBrowser){
  var w;
  var l=0;
  var SCREEN_PADDING_WIDTH=50;
  
  if (intWinWidth){
	if(blnCenterOnBrowser){
		w = document.body.offsetWidth;
	}else{
	    w = screen.width;
    }
    if(intWinWidth > w-SCREEN_PADDING_WIDTH){
		intWinWidth=w-SCREEN_PADDING_WIDTH;
    }
    
    l = parseInt((w-intWinWidth)/2);
  }
  return l;
}

function GetTopPos(intWinHeight, blnCenterOnBrowser){
  var h;
  var t=0;
  var SCREEN_PADDING_HEIGHT=100;
  
  if (intWinHeight){
	if(blnCenterOnBrowser){
		h = document.body.clientHeight;
	}else{
	    h = screen.height;
    }
    if(intWinHeight > h-SCREEN_PADDING_HEIGHT){
		intWinHeight=h-SCREEN_PADDING_HEIGHT;
    }
    
    t = parseInt((h-intWinHeight)/2);
  }
  return t;
}

function OpenModalDialog(url, name, features, replace, intWinWidth, intWinHeight)
{
  if(window.showModalDialog){
      var strdlgFeatures="center:yes;help:no;unadorned:yes;resizable:yes;status:no;dialogHeight:" +
          intWinHeight + "px;dialogWidth:" + intWinWidth + "px;";
      return window.showModalDialog(url,window,strdlgFeatures);
  }else{
      features+=",toolbar=no,resizable=yes,directories=no," + GetWinFeaturesToCenter(intWinWidth, intWinHeight);
      return window.open(url,name, features,replace);
  }
}
        
function CloseChildWindow(strWinName, fNotUseSessionWin)
{
  if(winArray){
    if(!fNotUseSessionWin){
        strWinName=BuildSessWinName(strWinName);
    }

    var intlen = winArray.length;
    var objWinInfo;
		var objWindow;
    for (i=0; i<intlen; i++){
		  objWinInfo=winArray[i];
      if (objWinInfo){
        if (objWinInfo.name == strWinName){
          objWindow=objWinInfo.win;
			  if(objWindow){
				try{
			  		if (!objWindow.closed){
						objWindow.close();
          			}
				}catch(e){}
			  }
          RemoveWindow(strWinName);
          i=intlen;
        } 
      }
    }
  } 
}

function RemoveWindow(ctrlName){
  var intlen = winArray.length;
	var objWinInfo;
  for (var i = 0; i < intlen; i++){
		objWinInfo=winArray[i];
    if (objWinInfo !== null){
      if (objWinInfo.name == ctrlName){
		winArray[i].name = "";
        winArray[i].win = null;
		winArray[i].supportedCloseScenarios = null;
        winArray[i] = null;

      }
    }
  }
}

//this function is a constructor for the winArray
function winInfo(win, name, supportedCloseScenarios){
  this.win = win;
  this.name = name;
  this.supportedCloseScenarios = supportedCloseScenarios;
}

//this function will get the index of the child window from the array winArray
function getWinIndex(winName) {
  var intlen=0;
  if (winArray){
    intlen = winArray.length;
  }
    
  var i = 0;
  var nEmptyIndex = INVALID_WIN_ID;

  for (i = 0; i < intlen; i++){
  
    if (winArray[i] !== null && eval(winArray[i])){
    
      // compare case insensitive
      if (winArray[i].name == winName){
        return i;
      }
    } else if (nEmptyIndex == INVALID_WIN_ID) {
      nEmptyIndex = i;
    }
  }

  if (nEmptyIndex == INVALID_WIN_ID) {
    //all the windows in the array are in use and there is no window with the requested name
    winArray[intlen] = new winInfo(null,winName);
    nEmptyIndex=intlen;
  }
  else if (nEmptyIndex != INVALID_WIN_ID) {
    //there is an empty element in the array, so use it
    winArray[nEmptyIndex] = new winInfo(null,winName);
  }
    
  return nEmptyIndex;       
}


function OnBeforeNavigate(desiredCloseScenarios){
	var intlen=0;
	
	if (winArray){
		intlen = winArray.length;
	}
	
	if(!desiredCloseScenarios){
		desiredCloseScenarios = CLOSE_SCENARIO_USER_LOGS_OFF + CLOSE_SCENARIO_USER_SWITCHES_VIEW + CLOSE_SCENARIO_USER_LEAVES_ISSUE_CONTEXT;
	}
  
  var objWinInfo;
  var objWindow;
  var blnClose;
  var i = 0;
  for (i = 0; i < intlen; i++){
	blnClose = false;

	objWinInfo=winArray[i];
    if (objWinInfo !== null){
		  objWindow=objWinInfo.win;
      if (objWindow!== null){
        if (objWindow.closed===false){
			blnClose = true;
			
			if(objWinInfo.supportedCloseScenarios){
				
				//If the desired close scenarios includes when the user logs off...
				if ((desiredCloseScenarios & CLOSE_SCENARIO_USER_LOGS_OFF)==CLOSE_SCENARIO_USER_LOGS_OFF){
				
					//But the window doesn't support it
					if((objWinInfo.supportedCloseScenarios & CLOSE_SCENARIO_USER_LOGS_OFF)!=CLOSE_SCENARIO_USER_LOGS_OFF){
						//WriteConsole("OnBeforeNavigate wants to close when the user logs off, but the window ('" + objWinInfo.name + "') doesn't support being closed in that situation. Abort close operation.")
						blnClose = false;
					}
				}
				
				if ((desiredCloseScenarios & CLOSE_SCENARIO_USER_SWITCHES_VIEW)==CLOSE_SCENARIO_USER_SWITCHES_VIEW){
					if((objWinInfo.supportedCloseScenarios & CLOSE_SCENARIO_USER_SWITCHES_VIEW)!=CLOSE_SCENARIO_USER_SWITCHES_VIEW){
						//WriteConsole("OnBeforeNavigate wants to close when the user switches view, but the window ('" + objWinInfo.name + "') doesn't support being closed in that situation. Abort close operation.")
						blnClose = false;
					}
				}
				
				if ((desiredCloseScenarios & CLOSE_SCENARIO_USER_LEAVES_ISSUE_CONTEXT)==CLOSE_SCENARIO_USER_LEAVES_ISSUE_CONTEXT){
					if((objWinInfo.supportedCloseScenarios & CLOSE_SCENARIO_USER_LEAVES_ISSUE_CONTEXT)!=CLOSE_SCENARIO_USER_LEAVES_ISSUE_CONTEXT){
						//WriteConsole("OnBeforeNavigate wants to close when the user leaves issue context, but the window ('" + objWinInfo.name + "') doesn't support being closed in that situation. Abort close operation.")
						blnClose = false;
					}
				}

			}else{
				//Should never occur, but if it does, close the window.
				blnClose = true;
			}

			if(blnClose)
			{
				objWindow.close();
			}
			
        }         
      }
	  
	  if(blnClose){
		winArray[i] = null;
	  }
    }
  }
  
  var RECORD_FRAME_NAME ="Record";
  if(window){
	if(!window.opener){
		if(window.frames){
			if(window.frames[RECORD_FRAME_NAME]){
				if(window.frames[RECORD_FRAME_NAME].OnBeforeNavigate){
					window.frames[RECORD_FRAME_NAME].OnBeforeNavigate();
				}
			}
		}
	}
  }
}

function SetWindowFocus(strWinName, fNotUseSessionWin)
{
  var intWinIndex;
  if(!fNotUseSessionWin){
      strWinName=BuildSessWinName(strWinName);
  }
    
  intWinIndex = GetArrayIDOfOpenWindow(strWinName);
  
  if (intWinIndex!=INVALID_WIN_ID){
    winArray[intWinIndex].win.focus();
  }
}

function FindOpenWindow(arrWindows)
{
  var i,strOpenWin,strWinName;
  var intlen=0;
  if (arrWindows){
    intlen = arrWindows.length;
  }

  strOpenWin="";
  
  if (intlen > 0){
    //there are some invalid windows - check if they are open
    for (i=0;i<intlen;i++){
      if (arrWindows[i] !== null){
        strWinName=arrWindows[i];
        var intID=GetArrayIDOfOpenWindow(strWinName);
      
        if (intID!=INVALID_WIN_ID){
          strOpenWin=strWinName;
          i=intlen;
        }
      }
    }
  }

  //return the name of the first window we found that was open
  return strOpenWin;
    
}

function GetArrayIDOfOpenWindow(strWinName)
{

  var i;
  var intID=INVALID_WIN_ID;
  var intlen=0;
  if(winArray){
    intlen=winArray.length;
  }
  
  for (i=0;i<intlen;i++){
    if (winArray[i] !== null){
      if (winArray[i].name==strWinName){
        if (winArray[i].win !== null){
          if (winArray[i].win.closed===false){
            intID=i;
            i=intlen;
          } 
        }
      }
    }
  }
  return intID;
}

function BuildSessWinName(strBaseName)
{
  if (strBaseName){
    if (!m_strSessWinID){
        m_strSessWinID=parseInt( Math.random() * 1000);
    }
    strBaseName=strBaseName + m_strSessWinID;
  }
  return strBaseName;
}



function SetChildWindow(objWin, strWinName)
{
	var intWinIndex = getWinIndex(strWinName);
	var objWinInfo=winArray[intWinIndex];
	if (objWinInfo){
		objWinInfo.win=objWin;	
	}
}

function CreateEscapeIframe(m_objRef){
	var objHtmlBody = m_objRef.document.getElementsByTagName('body');
	var objIFrame = m_objRef.document.createElement('iframe');
	var ifrName = 'ifrControlExit';
	var objCreatedIframe;
		
	if(m_objRef.frames[ifrName]){
		objCreatedIframe = m_objRef.frames[ifrName];
	}

	if(!objCreatedIframe){
		if(objHtmlBody){
			if(objHtmlBody.length > 0){						
				objIFrame.src = '';												
				objIFrame.width = 0;
				objIFrame.height = 0;
				objIFrame.name = ifrName;
				objIFrame.style.visibility='hidden';
				objIFrame.id = 'ifrControlSessExit';
				objHtmlBody[0].appendChild(objIFrame);
				
				objCreatedIframe = m_objRef.frames[ifrName];
			}	
		}
	}
	
	return objCreatedIframe ? objCreatedIframe : undefined;
}

function CloseWindowByEscKey(blnSessionPopUp){
	var objref = parent.parent;
	var elmToolBarIframe;
	var lngEscKeyCode = 27;
	var objBrowser = CMqBrowserDetector();
	var c;
	var objIframe;
	
	function ClosePopUp(){
		if(typeof(blnSessionPopUp) != 'undefined' && !blnSessionPopUp){
			CloseWindow();
		}else{
			try{
				if(objref.$(DIALOG_MODAL).dialog("option", "closeOnEscape")){
					//objref.BeforeCloseWindow(); (Removed in jquery 1.9)
					objref.$(DIALOG_MODAL).dialog("close");
				}
			} catch(e) {
				WriteConsole("[ClosePopUp] Unable to close dialog");
			}
		}
	}		
	
	function ClosePopUpWindow(e, objRef){
		if(e){					
			if(e.keyCode==lngEscKeyCode){
				ClosePopUp();
			}
		}
	}
	
	elmToolBarIframe = parent.frames['TopToolbar2'];
	
	if(window.attachEvent){				
		document.attachEvent("onkeydown", function(){ClosePopUpWindow(event, document);});
		
		if(parent){
			if(parent.document){
				parent.document.attachEvent("onkeydown", function(){ClosePopUpWindow(parent.event, parent.document);});
			}
		}		
		
		if(elmToolBarIframe){
			elmToolBarIframe.document.attachEvent("onkeydown", function(){ClosePopUpWindow(elmToolBarIframe.event, elmToolBarIframe);});
		}
	}else{
		if(window.addEventListener){			
			document.addEventListener("keydown",function(event){ClosePopUpWindow(event, document);},false);
			
			if(parent){
				if(parent.document){
					parent.document.addEventListener("keydown",function(event){ClosePopUpWindow(event, parent.document);},false);
				}
			}			
			
			if(elmToolBarIframe){
				elmToolBarIframe.addEventListener("keydown",function(event){ClosePopUpWindow(event, elmToolBarIframe);},false);
			}
		}
	}
	
	for(c=0;c<window.frames.length;c++){		
		objIframe = window.frames[c];
		if(objIframe){
			if(window.attachEvent){
				objIframe.document.attachEvent("onkeydown", function(){ClosePopUpWindow(objIframe.event, objIframe);});
				objIframe.addEventListener("keydown",function(event){ClosePopUpWindow(event, objIframe);},false);	
			}else{
				objIframe.addEventListener("keydown",function(event){ClosePopUpWindow(event, objIframe);},false);	
			}
		}		
	}
}


function GetDocHeight() {
    var D = document;
    return Math.max(			    
        Math.max(D.body.scrollHeight, D.documentElement.scrollHeight),
        Math.max(D.body.offsetHeight, D.documentElement.offsetHeight),
        Math.max(D.body.clientHeight, D.documentElement.clientHeight)
    );
}

function GetDocWidth() {
    var D = document;
    return Math.max(
        Math.max(D.body.scrollWidth, D.documentElement.scrollWidth),
        Math.max(D.body.offsetWidth, D.documentElement.offsetWidth),
        Math.max(D.body.clientWidth, D.documentElement.clientWidth)
    );
}

function WindowResize(m_strMainScreenWidth, m_strMainScreenHeight){	
	var intBrowserWidth = GetDocumentBodySize('width');
	var intBrowserHeight = GetDocumentBodySize('height');
	var intWinWidth = $(DIALOG_MODAL).dialog("option", "width");
	var intWinHeight = $(DIALOG_MODAL).dialog("option", "height");

	m_intOrigPopUpWindowWidth = m_intOrigPopUpWindowWidth == 0 || isNaN(m_intOrigPopUpWindowWidth) ? parseInt(intWinWidth) : m_intOrigPopUpWindowWidth;
	m_intOrigPopUpWindowHeight = m_intOrigPopUpWindowHeight == 0 || isNaN(m_intOrigPopUpWindowHeight) ? parseInt(intWinHeight) : m_intOrigPopUpWindowHeight;

	var PERC_WINDOW_SIZE_X = ((m_intOrigPopUpWindowWidth * 100 / m_strMainScreenWidth) / 100).toFixed(2);
	var PERC_WINDOW_SIZE_Y = ((m_intOrigPopUpWindowHeight * 100 / m_strMainScreenHeight) / 100).toFixed(2);
	var intDiffWinFrame = 9.0;
	var PERC_OFFSET = .01;
	var objRoundedWindowIE = document.getElementById('RoundedPopUpWndwFrame')
	var intNewWidth = (intBrowserWidth * PERC_WINDOW_SIZE_X).toFixed(0);
	var intNewHeight = (intBrowserHeight * (PERC_WINDOW_SIZE_Y - PERC_OFFSET)).toFixed(0);
			
	if($(DIALOG_MODAL)){		
		if(!isNaN(intNewHeight)){
			$(DIALOG_MODAL).dialog("option", "height", intNewHeight); 
		}
		
		if(!isNaN(intNewWidth)){
			if(intBrowserWidth < m_intOrigPopUpWindowWidth){
				$(DIALOG_MODAL).dialog("option", "width", intBrowserWidth); 
			}else{
				$(DIALOG_MODAL).dialog("option", "width", m_intOrigPopUpWindowWidth);
			}
		}
	}
	
	if(objRoundedWindowIE){
		objRoundedWindowIE.style.height = (parseFloat(intNewHeight) + intDiffWinFrame) + 'px';
		
		if(intBrowserWidth < m_intOrigPopUpWindowWidth){
			objRoundedWindowIE.style.width = (parseFloat(intBrowserWidth) + intDiffWinFrame) + 'px';
		}else{
			objRoundedWindowIE.style.width = (parseFloat(m_intOrigPopUpWindowWidth) + intDiffWinFrame) + 'px';
		}
	}
					
	$(DIALOG_MODAL).dialog("option", "position", "center"); 
}

function GetDocumentBodySize(strType){
	var intBodySize = 0;
		
	switch(strType.toLowerCase()){
	case 'width':
		if (document.all){
			intBodySize=document.body.offsetWidth;
		}else{
			intBodySize=window.innerWidth;
		}	
		break;
	case 'height':	
		if (document.all){
			if (document.documentElement && document.documentElement.offsetHeight){
				intBodySize=document.documentElement.offsetHeight;
			}else{
				intBodySize=document.body.offsetHeight;
			}
		}else{
			intBodySize=window.innerHeight;
		}
		break;
	}
	
	return intBodySize;
}

function CloseWindow(){
	var objRef = undefined;	
	var MAX_ATTEMPTS_FIND_MODAL_WINDOW = 5;
	var blnCurrentDoc = false;
	
	
	for(var c=0;c<=MAX_ATTEMPTS_FIND_MODAL_WINDOW;c++){
			if(objRef == undefined){
				objRef = parent;
			}else{
				objRef = objRef.parent;
			}
			
			if(objRef.document.getElementById(DIALOG_MODAL.replace('#',''))){			
				break;	
			}
	}
	
	if(c==MAX_ATTEMPTS_FIND_MODAL_WINDOW +1){
		objRef = undefined;
		if(document.getElementById(DIALOG_MODAL.replace('#',''))){
			blnCurrentDoc = true;
		}
	}
	if (blnCurrentDoc == true)
	{
		if ($)
		{
			if (CloseModalWindow)
			{
				CloseModalWindow();
			}
		}else{
			window.close();
		}
	}
	else{
		if(objRef){	
			if(objRef.$){
				if(objRef.CloseModalWindow){
					objRef.CloseModalWindow();	
				}
			}else{
				objRef.window.close();
			}
		}else{
			if(parent){
				parent.window.close();	
			}else{
				window.close();	
			}
		}
	}
}

function VNWindow(bModal)
{
	// temp ref to the local non-OO functions library. TODO: OO, consolidate and encapsulate.
	var m_WinLib=window;
	var m_bCentered=true;
	var m_iWidth;
	var m_iHeight;
	var m_bModal=true;
	var m_iSizeMode=WIN_MODE_MAXIMIZED;
	var m_bWinNameUniquePerSession=true;
	var m_iAutoCloseScenarios=CLOSE_SCENARIO_USER_LOGS_OFF;
	var MODAL_WIN_IFRAME_ID = "dialog-modal-url";
	
	
	// Overwrite the default
	if (typeof(bModal)!=="undefined"){
		m_bModal=bModal;
	}
	
	function Open(strURL, sWinName, lngWidth, lngHeight, arrPostData, blnNearFullscreen, intMode)
	{
		if (lngWidth)
		{
			m_iWidth = lngWidth;
		}
		if (lngHeight)
		{
			m_iHeight = lngHeight;
		}

		if (m_bModal)
		{
			if (arrPostData)
			{
				OpenModalWithPost(strURL, m_iWidth, m_iHeight, arrPostData, blnNearFullscreen, intMode);
				
			} else
			{
				m_WinLib.OpenModalWindow(strURL, m_iWidth, m_iHeight, null, m_iSizeMode);
			}
			
		}else{
			var strFeatures="scrollbars=auto,resizable=yes";
			m_WinLib.OpenChildWindow(strURL,sWinName,strFeatures, m_bCentered, m_iWidth, m_iHeight, 
					!m_bWinNameUniquePerSession, false, null, null, m_iAutoCloseScenarios, null)
		}
	}
	
	
	function OpenModalWithPost(strURL, lngWidth, lngHeight, arrPostData, blnNearFullscreen, intMode)
	{
		var oVNForm = new VNForm(strURL, "ifrWindow");
		
		arrPostData.forEach(oVNForm.AddParameter);
		
		OpenModalWin(lngWidth,lngHeight,blnNearFullscreen,intMode);

		oVNForm.Submit();    //Submit the form to the iFrame
		
		oVNForm.Destroy();   //Destroy temporary form
	    
	}
	
	// TODO: make it more generic
	function OpenModalWin(lngWidth,lngHeight,blnNearFullscreen,intMode)
	{
		var MAX_FULL_SCREEN_WIDTH=1440;
		var MAX_FULL_SCREEN_HEIGHT=900;

		if (typeof(intMode)=="undefined")
		{
			if(typeof(blnNearFullscreen)=="undefined"){
				intMode=WIN_MODE_WITH_BORDERS;
			}else{
				if(blnNearFullscreen){
					intMode=WIN_MODE_MAXIMIZED;
				}else{
					intMode=WIN_MODE_AS_DEFINED;
				}
			}
		}
		
		var arrWinInfo=GetWindowSize(intMode, lngWidth, lngHeight);
		var objDlgWrapper=parent.document.getElementById("dialog-modal-wrapper");
		
		if(objDlgWrapper){
			objDlgWrapper.className=objDlgWrapper.className.replace(MODAL_DLG_CLASS, "");
		}
		lngWidth=arrWinInfo[0];
		lngHeight=arrWinInfo[1];

		ResizeAllOpeners(parent,true, lngWidth, lngHeight);
		
		$("#" + new VNWindow().MODAL_WIN_IFRAME_ID).attr("src",""); 
		$("#" + new VNWindow().MODAL_WIN_IFRAME_ID).attr("name","ifrWindow");

		//Destroy old dialog if it exists
		try{
			$(DIALOG_MODAL).dialog("destroy");
		} catch(e) {
			WriteConsole("[OpenModalWindow] No dialog to destroy");
		}
		$(DIALOG_MODAL).dialog({
			height: lngHeight,
			width: lngWidth,
			modal: true,
			autoopen:false,
			resizable: false
		});

		$("#dialog-modal-orig-width").attr("innerHTML", lngWidth);
		$("#dialog-modal-orig-height").attr("innerHTML", lngHeight);
		
		$(".ui-dialog-titlebar").hide();
		$(DIALOG_MODAL).dialog("option", "position", { my: "center", at: "center"} );
		$(DIALOG_MODAL).dialog("open");
	}

	this.OpenModalWin=OpenModalWin;
	this.MODAL_WIN_IFRAME_ID=MODAL_WIN_IFRAME_ID;
	this.Open=Open;
	

}

//* Dynamic form used to POST 
// Currently, it only support POST
function VNForm(strUrl, sTarget)
{
	var dtTime = new Date().getTime();  // timestamp to ensure the form object is unique
	var m_sTarget=sTarget;
	var oform = $('<form action="'+strUrl+'" target="' + sTarget + 
    			'" method="post" style="display:none;" id="form' + 
    			dtTime + '" name="form' + dtTime+ '"></form>');
	
	$( "body" ).append(oform);
	
	function AddParameter(HTTPPostField)
    {
        $("<input type='hidden' />")
         .attr("name", HTTPPostField.Field)
         .attr("value", HTTPPostField.Value)
         .appendTo(oform);
    }

    function Submit()
    {
		try
		{
			$("#" + m_sTarget).attr("src",""); 
        } catch(e) {
			WriteConsole("[VNForm.Submit] Target iFrame is missing or not initialized.");
		}
		oform.submit();
    }

	function Destroy()
	{
		try
		{
			oform.remove();
		} catch(e) {
			WriteConsole("[VNForm.Destroy] Form is missing or not initialized.");
		}
	}
	

	this.AddParameter=AddParameter;
	this.Submit=Submit;
	this.Destroy=Destroy;
}

function HTTPPostField(sField, sValue)
{
	this.Field=sField;
	this.Value=sValue;
}

function VNWindowProperties()
{
	this.Width=1366;
	this.Height=768;
	// Window Size Mode
	this.SizeMode=WIN_MODE_MAXIMIZED;	
	this.Modal=true;

}

