var m_objRef;
var m_objOpenerRef;

var m_blnAutoComplete;

if(parent){
	m_objRef = parent;
	
	if(opener){
		m_objOpenerRef = opener;
	}else{
		if(parent){
			m_objOpenerRef = parent;
		}
	}
}

function Form_OnKeyPress(e)
{
	if (e){
		if (e.keyCode == 27){
			ClosePopup();
		}
	}
}

function OnChangeInvFind(e)
{
	var keynum;

	try{
		if(e){
			if (e.keyCode){
				keynum = e.keyCode;
			}else{
				if (e.which){
					keynum = e.which;
				}
			}

			if (keynum >= 32 || keynum == 8 || keynum==13){
				DoSearch("tblInvLst");
			}
		}
	}catch(e){}
}

function OnChangeInvPartFind(e)
{
	var keynum;

	try{
		if(e){
			if (e.keyCode){
				keynum = e.keyCode;
			}else{
				if (e.which){
					keynum = e.which;
				}
			}

			//if (keynum >= 32 || keynum == 8 || keynum==13){
			if (keynum==13){
				DoSearch("tblInvLst");
			}
		}
	}catch(e){}
}

function OnChangeInvDescFind(e)
{
	var keynum;

	try{
		if(e){
			if (e.keyCode){
				keynum = e.keyCode;
			}else{
				if (e.which){
					keynum = e.which;
				}
			}

			//if (keynum >= 32 || keynum == 8 || keynum==13){
			if (keynum==13){
				DoSearch("tblInvLst");
			}
		}
	}catch(e){}
}

function OnChangeFind(e)
{
	var keynum;

	try{
		if(e){
			if (e.keyCode){
				keynum = e.keyCode;
			}else{
				if (e.which){
					keynum = e.which;
				}
			}

			if (keynum >= 32 || keynum == 8 || keynum==13){
				DoSearch();
			}
		}
	}catch(err){
		DoSearch();
	}

}
	
function ResetFind()
{
	m_objMqButton.EnableButton('Find');
	if(m_strCursor == "wait"){
		document.body.style.cursor = "default";
	}else{
		document.body.style.cursor=m_strCursor;
	}
}

function SortColumn(lngFieldID)
{
	var SORT_ASCENDING="ASC";
	var SORT_DESCENDING="DESC";
	var strSortOrder=SORT_ASCENDING;
	
	if(m_objLookupItemInfo){
		if(m_objLookupItemInfo.SortFields){
			if(m_objLookupItemInfo.SortFields[0]!="undefined"){
				if(m_objLookupItemInfo.SortFields[0]==lngFieldID){
					if(m_objLookupItemInfo.SortOrders[0]!="undefined"){
						if(m_objLookupItemInfo.SortOrders[0]==SORT_ASCENDING){
							strSortOrder=SORT_DESCENDING;
						}
					}
				}
			}
			m_objLookupItemInfo.SortFields[0]=lngFieldID;
		}
		if(m_objLookupItemInfo.SortOrders){
			m_objLookupItemInfo.SortOrders[0]=strSortOrder;
		}
	}
	var strURL=GetLookupURL();
	SetIFrameSrc(strURL, GetTargetFrame(""));
}

function ShowAll()
{
	var objSearchTxt=document.getElementById("txtFind");
	
	if(objSearchTxt){
		objSearchTxt.value="";
		DoSearch();
	}
}
		
function DoSearch(strHTMLTableName, blnRefreshWorkflow)
{
	if(blnRefreshWorkflow){
		RefreshWorkflow();
	}
	
	ResetSelection();
	if(IsInvList(strHTMLTableName)){
		m_strCursor=document.body.style.cursor;
		document.body.style.cursor="wait";
		CallWhileWait("Search('" + strHTMLTableName + "')");
	}else{
		m_objMqButton.DisableButton("Find");
		m_strCursor=document.body.style.cursor;
		document.body.style.cursor="wait";
		CallWhileWait("Search('" + strHTMLTableName + "')");
	}
}

function RefreshWorkflow()
{
	var objWrkflw;
	var objViewFields;
	if(parent){
		if(parent.m_objWorkFlow){
			objWrkflw=parent.m_objWorkFlow;		
			objViewFields=parent.m_objViewFields;
		}else{
			if(parent.parent){
				if(parent.parent.m_objWorkFlow){
					objWrkflw=parent.parent.m_objWorkFlow;	
					objViewFields=parent.parent.m_objViewFields;
				}
			}
		}
		if(objWrkflw)
		{
			var varDependentFields=objWrkflw.GetDependentFields();
			var strTargetFields;
			var arrDepFld;
			var arrTargetFields;
			var objField;
			if(varDependentFields){
				for(x=0;x<varDependentFields.length;x++){
					arrDepFld=varDependentFields[x];
					if(arrDepFld){
						strTargetFields=arrDepFld.getTargetFieldIDs();
						arrTargetFields=strTargetFields.split(";");
						if(arrTargetFields){
							for(y=0;y<arrTargetFields.length;y++){
								if(arrTargetFields[y]==m_lngFieldID){
									objWrkflw.OnChange(x,true);
									if(objViewFields){
										objField=objViewFields.Field(m_lngFieldID);
										if(objField){	
											if(m_MainWin){
												if(m_MainWin.Record){
													objHTMLElement=m_MainWin.Record.document.getElementById(objField.GetBoundControl());
													if(objHTMLElement){
														m_objLookupItemInfo.WorkflowValues=objHTMLElement.getAttribute("MqWrkFlwVals");
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}

function CallWhileWait(strFunctionEval)
{
	window.setTimeout(strFunctionEval, 10);
}
		
function Search(strHTMLTableName)
{
	var strURL=GetLookupURL(strHTMLTableName);
	
	SetIFrameSrc(strURL, GetTargetFrame(strHTMLTableName));

	if(m_arrCurrentSelectedIDs_FullList){
		m_arrCurrentSelectedIDs_FullList=new Array();
	}
	if(m_arrCurrentSelectedNames_FullList){
		m_arrCurrentSelectedNames_FullList=new Array();
	}

}

function SetIFrameSrc(strURL,strTarget)
{
	var objLookupItemContentsFrm=document.getElementById("frmLookupItemContents");
	if(objLookupItemContentsFrm){
		objLookupItemContentsFrm.target=strTarget;
		objLookupItemContentsFrm.action=strURL;
		objLookupItemContentsFrm.submit();
	}
}

function GetTargetFrame(strHTMLTableName)
{
	if(IsInvList(strHTMLTableName)){
		return "fraDisplayInv";
	}else{
		return "fraDisplayItems";
	}
}

function OnSelectRow(strName, strID, strTableName, lngRowID, strAddValueInternal)
{
	if(!m_objLookupItemInfo.MultiSelect){
		if(IsInvList(strTableName)){
			LoadInv(strName);
			ClearSelectedPart();
		}else{
			AddToList(strName, strID, strAddValueInternal);
		}
	}else{
		if(strTableName=="tblFullList"){
			if(!RemoveItemFromArraysByID(strID, m_arrCurrentSelectedIDs_FullList, m_arrCurrentSelectedNames_FullList)){
				AddItemToArrays(strID, strName, m_arrCurrentSelectedIDs_FullList, m_arrCurrentSelectedNames_FullList);
			}
		}else{
			if(!RemoveItemFromArraysByName(strName, m_arrCurrentSelectedIDs_SelList, m_arrCurrentSelectedNames_SelList)){
				AddItemToArrays(strID, strName, m_arrCurrentSelectedIDs_SelList, m_arrCurrentSelectedNames_SelList);
			}
		}
	}
}

function ClearSelectedPart()
{
	SetSelectedItemsSimpleList(Array());
	
	if(m_arrCurrentSelectedIDs_FullList){
		m_arrCurrentSelectedIDs_FullList=new Array();
	}
	if(m_arrCurrentSelectedNames_FullList){
		m_arrCurrentSelectedNames_FullList=new Array();
	}
	if(m_arrSelectedIDs){
		m_arrSelectedIDs=new Array();
	}
	if(m_arrSelectedValues){
		m_arrSelectedValues=new Array();
	}
	if(m_arrSelectedValuesInternal){
		m_arrSelectedValuesInternal=new Array();
	}
}

function RemoveItemFromArraysByID(strID, arrItemIDArray, arrItemNameArray)
{
	var lngCount;
	var blnReturn=false;
				
	for(lngCount=0; lngCount<arrItemIDArray.length; lngCount++){
					
		if(arrItemIDArray[lngCount]==strID){
			arrItemIDArray.splice(lngCount, 1);	
			arrItemNameArray.splice(lngCount, 1);
			blnReturn = true;					
			break;
		}
	}
	return blnReturn;
}

function RemoveItemFromArraysByName(strName, arrItemIDArray, arrItemNameArray)
{
	var lngCount;
	var blnReturn=false;
				
	for(lngCount=0; lngCount<arrItemNameArray.length; lngCount++){
					
		if(arrItemNameArray[lngCount]==strName){
			arrItemIDArray.splice(lngCount, 1);	
			arrItemNameArray.splice(lngCount, 1);
			blnReturn = true;					
			break;
		}
	}
	return blnReturn;
}

function AddItemToArrays(strID, strValue, arrItemIDArray, arrItemNameArray)
{
	var lngIndex=arrItemIDArray.length;
	arrItemIDArray.length++;
	arrItemIDArray[lngIndex]=strID;
	
	arrItemNameArray.length++;
	arrItemNameArray[lngIndex]=strValue;
}

function OnDoubleClickGridRow()
{
	RemoveMultiSelectItemsFromList();
}

function OnDblClickItem(strName, strID, blnKeepAutoCompleteFrameOpen, strAddValueInternal, strHTMLTableName, blnKeepPopupOpen)
{	
	if(IsInvList(strHTMLTableName)){
		
	}else{
		if(!m_objLookupItemInfo.MultiSelect){
			AddToList(strName, strID, strAddValueInternal);
			
			SetListToCaller(blnKeepPopupOpen);
		}else{
				
			AddMultiSelectItemsFromList();
		}
	
		if(m_objOpenerRef){
			if(m_objOpenerRef.OnDblClickItem){
				m_objOpenerRef.OnDblClickItem(strName, strID, blnKeepAutoCompleteFrameOpen);
			}
		}
	}
}


function OnClickItem(strName, strID)
{	
	var strCtrl="";
	
	if(m_objLookupItemInfo.SourceControl){
		if(m_objLookupItemInfo.SourceControl.id){
			strCtrl=m_objLookupItemInfo.SourceControl.id;
		}
	}
	if(strCtrl==""){
		if(m_objLookupItemInfo.TargetControl){
			if(m_objLookupItemInfo.TargetControl.id){
				strCtrl=m_objLookupItemInfo.TargetControl.id;
			}
		}
	}
	if(m_objOpenerRef){
		if(m_objOpenerRef.OnClickItem){
			m_objOpenerRef.OnClickItem(strName, strID, strCtrl);
		}
	}
}

function SortNonCaseSensitive(a, b)
{
	var strA = String(a).toLowerCase();
	var strB = String(b).toLowerCase();
	var lngReturn=0;
				
	if (strA < strB){
		lngReturn=-1;
	}
	if (strA > strB){
		lngReturn=1;
	}
	return lngReturn;
}

function AddToList(strName, strID, strAddValueInternal)
{
	var blnSetValue=true;
	var lngArrLen;
	var strDisplayName;
	
	strName = g_MqRef.MqStr.MqDecodeURIComponent(strName);
	if(document){
		if(m_objLookupItemInfo.MultiSelect){
			if(ItemExistsInList(strName, m_arrSelectedValues)){
				blnSetValue=false;
			}
				
			if(blnSetValue){	
				if(!m_arrSelectedIDs){
					m_arrSelectedIDs=new Array();
				}
				if(!m_arrSelectedValues){
					m_arrSelectedValues=new Array();
				}
				
				lngArrLen=m_arrSelectedIDs.length;
				m_arrSelectedIDs.length++;
				m_arrSelectedIDs[lngArrLen]=strID;
				
				lngArrLen=m_arrSelectedValues.length;
				m_arrSelectedValues.length++;
				m_arrSelectedValues[lngArrLen]=g_MqRef.MqStr.MqEncodeURIComponent(strName);
	
				m_arrSelectedValues.sort(SortNonCaseSensitive);
				
				var objDisplaySelItemsAdv = document.getElementById("fraDisplaySelItemsAdv");
				if(objDisplaySelItemsAdv){
					objDisplaySelItemsAdv.src=objDisplaySelItemsAdv.src;
				}
				
			}
		}else{
			if(!m_arrSelectedIDs){
				m_arrSelectedIDs=new Array();
				m_arrSelectedIDs.length=1;
			}
			m_arrSelectedIDs[0]=strID;
				
			if(!m_arrSelectedValues){
				m_arrSelectedValues=new Array();
				m_arrSelectedValues.length=1;
			}
			m_arrSelectedValues[0]=strName;
			
			if(!m_arrSelectedValuesInternal){
				m_arrSelectedValuesInternal=new Array();
			}
			m_arrSelectedValuesInternal=unescape(unescape(strAddValueInternal)).split("*|*");
			
		}
		SetSelectedItemsSimpleList(m_arrSelectedValues);
	}
}
		
function ItemExistsInList(strItem, arrList)
{
	var lngCount;
	var blnReturn=false;
	
	if(arrList){
		for(lngCount=0; lngCount<arrList.length; lngCount++){
					
			if(g_MqRef.MqStr.TrimString(arrList[lngCount])==strItem){
				blnReturn=true;
				lngCount=arrList.length;
			}
		}
	}
	return blnReturn;
}

function SetListSize(blnMultiSelect)
{
	var objMain = document.getElementById("tblMain");
	var objDisplaySelItemsAdv = document.getElementById("fraDisplaySelItemsAdv");
	var objDisplayItems = document.getElementById("fraDisplayItems");
	
	if(m_objLookupItemInfo){
		var intBodyHeight;
		var intBodyWidth;
		var lngNewHeight;
		
		var LST_HEIGHT_SC=270;
		var LST_HEIGHT_MC=220;
		
		intBodyHeight=GetWinHeight();
		if(blnMultiSelect){
			lngNewHeight=(intBodyHeight-LST_HEIGHT_MC);
			if(lngNewHeight > 0){
				if(objDisplaySelItemsAdv){
					objDisplaySelItemsAdv.style.height=lngNewHeight + "px";
				}
			}
		}else{
			var objSelItemInfo=document.getElementById("selectedItemInfo");
			if(objSelItemInfo){
				if(objSelItemInfo.style.display=="none"){
					LST_HEIGHT_SC=220;
				}
			}
			lngNewHeight=(intBodyHeight-LST_HEIGHT_SC);
		}
		
		if(lngNewHeight > 0){
			var objInvList=document.getElementById("fraDisplayInv");
			if(objInvList){
				objInvList.style.height=(intBodyHeight-120);
				document.getElementById("fraDisplayItems").style.height=(lngNewHeight+50);
				
			}else{
				if(objDisplayItems){
					objDisplayItems.style.height=lngNewHeight + "px";
				}
			}
		}

		if(objMain){
			if(intBodyHeight > 85){
				objMain.style.height=(intBodyHeight -85) + "px" ; //85: buttons and top text + top text margin
			}
		}
	}
	
	ShowLoadingDiv();
}	
				
function SetListToCaller(blnKeepPopupOpen)
{
	if(ShowLoadingUI(true)){
		window.setTimeout("DoSetListToCaller(" + blnKeepPopupOpen + ")", 100);
	}
}

function DoSetListToCaller(blnKeepPopupOpen)
{
	if(typeof(m_arrSelectedIDs)=="undefined" && typeof(m_arrSelectedValues)=="undefined"){
		//don't continue, nothing is selected
		ShowLoadingUI(false);
	}else{
		if(m_objLookupItemInfo.SetValue){
			m_objLookupItemInfo.SetValue(m_objLookupItemInfo.FieldID,m_arrSelectedIDs,m_arrSelectedValues,m_arrSelectedValuesInternal,this);
		}else{
			if(m_objLookupItemInfo.TargetControl){
				if(m_arrSelectedValues){
					m_objLookupItemInfo.TargetControl.value=g_MqRef.MqStr.MqDecodeURIComponent(m_arrSelectedValues.join("; "));
				}
				m_objLookupItemInfo.TargetControl.focus();
			}
		}
		
		if(m_objLookupItemInfo.OnAfterSetValue){
			m_objLookupItemInfo.OnAfterSetValue(m_objLookupItemInfo);
		}
		
		if(m_objOpenerRef.OnSetListToCaller){
			m_objOpenerRef.OnSetListToCaller(m_objLookupItemInfo.FieldID,m_arrSelectedIDs,m_arrSelectedValues);
		}

		if(!blnKeepPopupOpen){
			ClosePopup();
		}else{
			ShowLoadingUI(false);
		}
	}
}

function ShowLoadingUI(blnVisible)
{
	var objLoadingOverlay=document.getElementById("loadingOverlay");
	if(objLoadingOverlay){
		if(blnVisible){
			objLoadingOverlay.style.display="";
		}else{
			objLoadingOverlay.style.display="none";
		}
	}
	return true;
}

function ClosePopup()
{
	if(opener){
		window.close();
	}else{
		CloseWindow();
	}
	if(m_objLookupItemInfo.OnClose){
		m_objLookupItemInfo.OnClose();
	}
}
		
function HideAddNewButton(blnHide){
	var ADD_NEW_CELL_BTN_ID = "tdAddNewBtn";
	var SHOW_ALL_CELL_BTN_ID = "tdShowAllBtn";

	if(blnHide){
		var objCellBtn = document.getElementById(ADD_NEW_CELL_BTN_ID);
		var objShowAllBtn = document.getElementById(SHOW_ALL_CELL_BTN_ID);
		
		if(objCellBtn){
			objCellBtn.style.display = "none";
			
			if(objShowAllBtn){
				objShowAllBtn.style.width = "100%";
			}
		}
	}
}
		
function Form_OnLoad(blnSkipResize)
{
	if(m_objLookupItemInfo.HideAddNewButton){
		HideAddNewButton(true);
	}else{
		if(opener){
			if(opener.parent){
				if(opener.parent.mblnIsUserView == true){
					HideAddNewButton(true);
				}
			}
		}
	}	

	if (m_objLookupItemInfo){

		document.title = m_objLookupItemInfo.WindowTitle;
		
		m_arrSelectedIDs=m_objLookupItemInfo.SelectedIDs;
		
		if(m_objLookupItemInfo.SelectedValues){
			m_arrSelectedValues=new Array();
			for(lngCount=0;lngCount<m_objLookupItemInfo.SelectedValues.length; lngCount++){
				m_arrSelectedValues[lngCount]=g_MqRef.MqStr.MqEncodeURIComponent(m_objLookupItemInfo.SelectedValues[lngCount]);
			}
		}

		if(!m_arrSelectedIDs && !m_arrSelectedValues){
			if(m_objLookupItemInfo.SourceControl){
				var strSrcValue=m_objLookupItemInfo.SourceControl.value;
				if(strSrcValue.length>0){
					m_arrSelectedValues=strSrcValue.split(";");
				}
			}
		}
		
		if(m_arrSelectedValues && !m_arrSelectedIDs){
			SetSelectedItemsSimpleList(m_arrSelectedValues);
		}
		
		var objSearchTxt=document.getElementById("txtFind");
		var objInstructionsLbl = document.getElementById("InstructionText");
		var objItemsTextAdvanced = document.getElementById("SelectedItemsTextAdvanced");
		var objItemsTextSimple = document.getElementById("SelectedItemsTextSimple");
		
		if(objInstructionsLbl){
			objInstructionsLbl.innerHTML=m_objLookupItemInfo.InstructionsText;
		}
		
		if(m_objLookupItemInfo.MultiSelect){
			if(objItemsTextAdvanced && m_objLookupItemInfo.SelectedItemsText){
				objItemsTextAdvanced.innerHTML=m_objLookupItemInfo.SelectedItemsText;
			}
		}else{
			if(objItemsTextSimple && m_objLookupItemInfo.SelectedItemsText){
				objItemsTextSimple.innerHTML=m_objLookupItemInfo.SelectedItemsText;
			}
		}
		
		
		if(objSearchTxt ){
			if(objSearchTxt.style.display != "none"){
				objSearchTxt.focus();
			}
		}
		var objMemSelectedItems = document.getElementById("memSelectedItems");
		if(objMemSelectedItems){
			objMemSelectedItems.readOnly=m_objLookupItemInfo.DisableSelectedItemsText;
		}
		
		if(m_strTableName=="tblDts"){
			var objSelItemInfo=document.getElementById("selectedItemInfo");
			if(objSelItemInfo){
				objSelItemInfo.style.display="none";
			}
		}
		
		if(m_objLookupItemInfo.MultiSelect){
			var objDisplaySelectedAdvanced = document.getElementById("DisplaySelectedAdvanced");
			var objDisplaySelectedSimple = document.getElementById("DisplaySelectedSimple");
			var objBottomContents = document.getElementById("BottomContents");
			var objfraDisplaySelItemsAdv = document.getElementById("fraDisplaySelItemsAdv");
			
			if(objDisplaySelectedAdvanced){
				objDisplaySelectedAdvanced.style.display="";
			}
			if(objDisplaySelectedSimple){
				objDisplaySelectedSimple.style.display="none";
			}
			if(objBottomContents){
				objBottomContents.style.top="92%";
			}
			if(objfraDisplaySelItemsAdv){
				objfraDisplaySelItemsAdv.src=m_objLookupItemInfo.ShowSelectedAdvURL;
			}
			
			if(!blnSkipResize){
				window.resizeTo(800,550);
			}

		}
		
		if(document.getElementById("fraDisplayInv")){
			DoSearch("tblInvLst");
		}else{
			DoSearch();
		}
		
		if(m_objRef){
			if(m_objRef.OnGridPageLoad){
				m_objRef.OnGridPageLoad();
			}
		}
	}
}
	
function GetLookupURL(strHTMLTableName)
{
	var strSearchVal="";
	var strSearchVal2="";
	var strSearchVal3="";
	var strURL="";
	var objFindTxt;
	var lngQueryID=m_objLookupItemInfo.QueryID;
	
	m_objLookupItemInfo.SortFields[0]="0";
	if(IsInvList(strHTMLTableName)){
		objFindTxt=document.getElementById("txtFindInv");
		if(objFindTxt){
			strSearchVal=objFindTxt.value.toUpperCase();
		}
		objFindTxt=document.getElementById("txtFindInvPart");
		if(objFindTxt){
			strSearchVal2=objFindTxt.value;
			if(strSearchVal2){
				strSearchVal2=strSearchVal2.toUpperCase();
			}else{
				strSearchVal2="";
			}
		}
		objFindTxt=document.getElementById("txtFindInvDesc");
		if(objFindTxt){
			strSearchVal3=objFindTxt.value;
			if(strSearchVal3){
				strSearchVal3=strSearchVal3.toUpperCase();
			}else{
				strSearchVal3="";
			}
		}
		strURL=m_objLookupItemInfo.SearchResultsURL2;
	}else{
		if(strHTMLTableName=="tblInvPartLst"){
			strSearchVal=m_strSelInv;
			lngQueryID=2;
			
			if(strSearchVal==""){
				strSearchVal="-1";
			}
			m_objLookupItemInfo.QueryFields[0]="0";
			m_objLookupItemInfo.SortFields[0]="0";
			
			var objChk=document.getElementById("chkShowOnlyFiltered");
			if(objChk){
				if(objChk.checked){
					objFindTxt=document.getElementById("txtFindInvPart");
					if(objFindTxt){
						strSearchVal2=objFindTxt.value;
						if(strSearchVal2){
							strSearchVal2=strSearchVal2.toUpperCase();
						}else{
							strSearchVal2="";
						}
					}
					objFindTxt=document.getElementById("txtFindInvDesc");
					if(objFindTxt){
						strSearchVal3=objFindTxt.value;
						if(strSearchVal3){
							strSearchVal3=strSearchVal3.toUpperCase();
						}else{
							strSearchVal3="";
						}
					}
				}else{
					strSearchVal2="";
					strSearchVal3="";
				}
			}else{
				strSearchVal2="";
				strSearchVal3="";
			}
		}else{
			objFindTxt=document.getElementById("txtFind");
			if(objFindTxt){
				strSearchVal=objFindTxt.value;
			}
		}
		strURL=m_objLookupItemInfo.SearchResultsURL;
	}
			
	if(strSearchVal == ""){
		strSearchVal="*";
	}
	
	m_objLookupItemInfo.QueryValues[0]=strSearchVal;
	
	if(strSearchVal2!=""){
		m_objLookupItemInfo.QueryFields[1]="ITEMNMBR";
		m_objLookupItemInfo.QueryValues[1]=strSearchVal2;
	}else{
		m_objLookupItemInfo.QueryFields[1]="";
		m_objLookupItemInfo.QueryValues[1]="";
	}
	
	if(strSearchVal3!=""){
		m_objLookupItemInfo.QueryFields[2]="ITEMDESC";
		m_objLookupItemInfo.QueryValues[2]=strSearchVal3;
	}else{
		m_objLookupItemInfo.QueryFields[2]="";
		m_objLookupItemInfo.QueryValues[2]="";
	}

	var strJoinChar="?";
		
	if(strURL.indexOf(strJoinChar) >=0){
		strJoinChar="&";
	}

	strURL+=strJoinChar + "QueryID=" + lngQueryID;
	
	strURL+=GetQueryQSVals();					
	
	strURL+=GetSortQSVals();
	
	strURL+=GetLayoutQSVals();

	//strURL+=GetWorkflowQSVals();

	SetWorkflowQSVals(strHTMLTableName);

	strURL+=GetExtraQSVals();
	
return strURL;
}

function GetQueryQSVals()
{
	var strQS="";
	var lngCount;
	var arrQueryFields=m_objLookupItemInfo.QueryFields;
	var arrQueryOperators=m_objLookupItemInfo.QueryOperators;
	var arrQueryValues=m_objLookupItemInfo.QueryValues;
	var arrQueryParams=m_objLookupItemInfo.QueryParams;
	var lngRowID;

	if(arrQueryFields){
		for(lngCount=0; lngCount<arrQueryFields.length; lngCount++){
			lngRowID=(parseInt(lngCount)+1)
			strQS+="&Q_R" + lngRowID + "_F=" + arrQueryFields[lngCount]; 
			
			if(arrQueryOperators){
				if(arrQueryOperators[lngCount]!="undefined"){
					strQS+="&Q_R" + lngRowID + "_O=" + arrQueryOperators[lngCount];
				}
			}
			
			if(arrQueryValues){
				if(arrQueryValues[lngCount]!="undefined"){
					strQS+="&Q_R" + lngRowID + "_V=" + arrQueryValues[lngCount];
				}
			}
			
			if(arrQueryParams){
				if(arrQueryParams[lngCount]!="undefined"){
					strQS+="&Q_R" + lngRowID + "_P=" + arrQueryParams[lngCount];
				}
			}
		}
	}
	return strQS;
	
}

function GetSortQSVals()
{
	var strQS="";
	var lngCount;
	var arrSortFields=m_objLookupItemInfo.SortFields;
	var arrSortOrders=m_objLookupItemInfo.SortOrders;
	var lngRowID;
	if(arrSortFields){
		for(lngCount=0; lngCount<arrSortFields.length; lngCount++){
			lngRowID=(parseInt(lngCount)+1)
			strQS+="&S_R" + lngRowID + "_F=" + arrSortFields[lngCount]; 
			
			if(arrSortOrders){
				if(arrSortOrders[lngCount]!="undefined"){
					strQS+="&S_R" + lngRowID + "_O=" + arrSortOrders[lngCount];
				}
			}
		}
	}
	return strQS;
}

function GetLayoutQSVals()
{
	var strQS="";
	var lngCount;
	var arrLayoutFields=m_objLookupItemInfo.LayoutFields;
	var lngRowID;
	if(arrLayoutFields){
		for(lngCount=0; lngCount<arrLayoutFields.length; lngCount++){
			lngRowID=(parseInt(lngCount)+1)
			strQS+="&L_R" + lngRowID + "_F=" + arrLayoutFields[lngCount]; 
		}
	}
	return strQS;
}

function GetWorkflowQSVals()
{
	var strQS="";
	
	if(m_objLookupItemInfo.WorkflowValues){
		strQS+="&WFVals=" + g_MqRef.MqStr.MqEncodeURIComponent(m_objLookupItemInfo.WorkflowValues);
	}
	
	return strQS;
}

function SetWorkflowQSVals(strHTMLTableName)
{
	var strQS="";
	var objWFVals=document.getElementById("WFVals");

	if(objWFVals){
		if(m_objLookupItemInfo.WorkflowValues){
			if(strHTMLTableName=="tblInvPartLst"){
				//don't apply the workflow to the 2nd grid
				objWFVals.value="";
			}else{	
				objWFVals.value=m_objLookupItemInfo.WorkflowValues;
			}
		}else{
			objWFVals.value="";
		}
	}
}

function GetExtraQSVals()
{
	var strQS="";
	var SEL_ID_ALWAYS_SELECT_BEST_MATCH = "-9999";
	
	if(m_objLookupItemInfo.FieldID){
		strQS+="&MqFID=" + m_objLookupItemInfo.FieldID;
	}
	
	if(m_objLookupItemInfo.FieldName){
		strQS+="&MqFN=" + m_objLookupItemInfo.FieldName;
	}
	
	if(!m_objLookupItemInfo.AlwaysSelectBestMatch){
		if(m_objLookupItemInfo.MultiSelect){
			if (m_arrCurrentSelectedIDs_FullList){
				strQS+="&SelID=" + m_arrCurrentSelectedIDs_FullList.join(";");
	
			}else{
				strQS+="&SelID=";
			}
	
		}else{
			if(m_arrSelectedIDs){
				strQS+="&SelID=" + m_arrSelectedIDs.join(";");
			}else{
				strQS+="&SelID=";
			}
		}
	}else{
		strQS+="&SelID=" + SEL_ID_ALWAYS_SELECT_BEST_MATCH;
	}
	
	if(m_objLookupItemInfo.MultiSelect){
		strQS+="&MC=1";
	}else{
		strQS+="&MC=0";
	}
	
	if(m_objLookupItemInfo.RecordsPerPage){
		strQS+="&RPP=" + m_objLookupItemInfo.RecordsPerPage;
	}
	
	return strQS;
}

function UpdateSearchSettings(objLst, strHTMLTableName)
{
	if(m_objLookupItemInfo){
		if (objLst.id=="SearchField_List"){
			m_objLookupItemInfo.QueryFields[0]=objLst.options[objLst.selectedIndex].value;
		}
		if (objLst.id=="SearchType_List" && !IsInvList(strHTMLTableName)){
			m_objLookupItemInfo.QueryID=objLst.options[objLst.selectedIndex].value;
		}
		if (objLst.id=="SearchTypeInvFld_List"){
			m_objLookupItemInfo.QueryFields[0]=objLst.options[objLst.selectedIndex].value;
		}
		if (objLst.id=="SearchTypeInv_List" && IsInvList(strHTMLTableName)){
			m_objLookupItemInfo.QueryID=objLst.options[objLst.selectedIndex].value;
		}
		
		DoSearch(strHTMLTableName);
	}
}

function ShowAdvancedSearch()
{
	OpenChildWindow(m_objLookupItemInfo.AdvancedSearchURL, "AdvancedSearch", "toolbar=no,directories=no,resizable=yes,scrollbars=yes,width=350,height=175", true, 350, 175);
}

function MoveFirst(strHTMLTableName)
{
	ViewListWithParam("Pos=FirstRecord", strHTMLTableName);
}

function MoveLast(strHTMLTableName)
{
	ViewListWithParam("Pos=LastRecord", strHTMLTableName);
}

function MovePrev(strHTMLTableName)
{
	ViewListWithParam("PN="+(Number(m_lngCurrentPage)-1), strHTMLTableName);
}

function MoveNext(strHTMLTableName)
{
	ViewListWithParam("PN="+(Number(m_lngCurrentPage)+1), strHTMLTableName);
}

function ViewListWithParam(strParam, strHTMLTableName)
{
	var strURL=GetLookupURL(strHTMLTableName) + "&" + strParam;
	
	SetIFrameSrc(strURL, GetTargetFrame(strHTMLTableName));
	ResetSelection();
}


function OnListLoaded(strHTMLTableName)
{
	SetPageCaption(strHTMLTableName);
	HandleButtonStates(strHTMLTableName);

	HideLoadingDiv();
		
	if(IsInvList(strHTMLTableName)){
		if(window.frames){
			if(window.frames["fraDisplayInv"]){
				if(window.frames["fraDisplayInv"].m_lngSelectedRow=="-1"){
					window.frames["fraDisplayInv"].m_lngSelectedRow=="0";
					window.frames["fraDisplayInv"].SelectRow(0);
				}
			}
		}
	}	
	
	if(m_objLookupItemInfo.AlwaysSelectBestMatch){	
		if(m_objRef){
			if(m_objRef.OnListFinishedLoading){
				if(m_blnAutoComplete != false)
				{
					m_objRef.OnListFinishedLoading();
				}
			}
		}
	}
}

function InitAutoComplete(blnAutoComplete)
{
	
	if (blnAutoComplete)
	{
		m_blnAutoComplete = true;
	}
	else
	{
		m_blnAutoComplete = false;
	}
}

function SetPageCaption(strHTMLTableName)
{
	var objPageCaption;
	
	if(IsInvList(strHTMLTableName)){
		objPageCaption=document.getElementById("PageCaptionInv");
	}else{
		objPageCaption=document.getElementById("PageCaption");
	}


	if (objPageCaption){
		var strPC=GetPageCaption(strHTMLTableName);
		objPageCaption.innerHTML=strPC;
		objPageCaption.title=strPC;
	}				
}

function GetTotalRecordCount()
{
	return m_lngTotalRecord;
}

function GetPageCaption(strHTMLTableName){
	var strReturn;
	
	if (!m_lngCurrentPage && !m_lngTotalRecord){
		strReturn=g_MqRef.RESX['DISPLAY_PAGE_NO_MATCHES'];
	}else{	
		strReturn=g_MqRef.MqStr.FormatString(g_MqRef.RESX['DISPLAY_PAGE_NUMBERS'], m_lngCurrentPage+";"+m_lngPageCount+";"+m_lngTotalRecord+";",";"); 
	}
		
	return strReturn;
}


function HandleButtonStates(strHTMLTableName)
{
	if(IsInvList(strHTMLTableName)){
		if (m_lngCurrentPage==1 || m_lngCurrentPage==0){ 
			m_objMqButton.DisableButton("MoveFirstInv");
			m_objMqButton.DisableButton("PageDownInv");
		}else{
			m_objMqButton.EnableButton("MoveFirstInv");
			m_objMqButton.EnableButton("PageDownInv");
		}
	
		if (m_lngCurrentPage==m_lngPageCount) {
			m_objMqButton.DisableButton("MoveLastInv");
			m_objMqButton.DisableButton("PageUpInv");
		}else{
			m_objMqButton.EnableButton("MoveLastInv");
			m_objMqButton.EnableButton("PageUpInv");
		}
	}else{	
		if (m_lngCurrentPage==1 || m_lngCurrentPage==0){ 
			m_objMqButton.DisableButton("FirstPage");	
			m_objMqButton.DisableButton("PreviousPage");
		}else{
			m_objMqButton.EnableButton("FirstPage");
			m_objMqButton.EnableButton("PreviousPage");
		}
	
		if (m_lngCurrentPage==m_lngPageCount) {
			m_objMqButton.DisableButton("LastPage");
			m_objMqButton.DisableButton("NextPage");	
		}else{
			m_objMqButton.EnableButton("LastPage");
			m_objMqButton.EnableButton("NextPage");
		}
	}
}

function getPosition()
{
	var intPosition;
	
	var POSITION_FIRSTPAGE=16;
	var POSITION_LASTPAGE=32;
	var POSITION_ONEPAGE=64;

	intPosition=0;
	// POSITION_FIRSTPAGE
	if (m_lngCurrentPage==1 || m_lngCurrentPage==0){ 
		intPosition+=POSITION_FIRSTPAGE;
	}
		
	// POSITION_LASTPAGE
	if (m_lngCurrentPage==m_lngPageCount) {
		intPosition+=POSITION_LASTPAGE;
	}
		
	// POSITION_ONEPAGE
	if ((intPosition&POSITION_FIRSTPAGE) && (intPosition&POSITION_LASTPAGE)){
		intPosition+=POSITION_ONEPAGE;
	}
		
	return intPosition;
}

function RemoveMultiSelectItem(strName)
{	
	var lngCount;
	strName = g_MqRef.MqStr.MqDecodeURIComponent(strName);
	
	if(m_arrSelectedValues){
		for(lngCount=0; lngCount<m_arrSelectedValues.length; lngCount++){
			if(g_MqRef.MqStr.MqDecodeURIComponent(m_arrSelectedValues[lngCount])==strName){
				m_arrSelectedValues.splice(lngCount, 1);
				
				if(m_arrSelectedIDs){
					m_arrSelectedIDs.splice(lngCount, 1);
				}
				break;
			}
		}
		SetSelectedItemsSimpleList(m_arrSelectedValues);
		
		var objDisplaySelItemsAdv = document.getElementById("fraDisplaySelItemsAdv");
		if(objDisplaySelItemsAdv){
			objDisplaySelItemsAdv.src=document.getElementById("fraDisplaySelItemsAdv").src;
		}
	}
}

function SetSelectedItemsSimpleList(arrSelectedValues)
{
	var objMemSelectedItems = document.getElementById("memSelectedItems");
	if(objMemSelectedItems){
		if(arrSelectedValues){
			objMemSelectedItems.value=arrSelectedValues.join("; ");
		}
	}
}


function AddMultiSelectItemsFromList()
{	
	var lngCount;
	var strName="";
	var strID="";
	
	for(lngCount=0; lngCount<m_arrCurrentSelectedIDs_FullList.length; lngCount++){
		strName=m_arrCurrentSelectedNames_FullList[lngCount];
		strID=m_arrCurrentSelectedIDs_FullList[lngCount];
		AddToList(strName, strID);
	}
	if(window.frames){
		if(window.frames["fraDisplayItems"]){
			window.frames["fraDisplayItems"].UnSelectAllRows();
		}
	}
	ResetSelection();
}

function ResetSelection()
{
	m_arrCurrentSelectedIDs_FullList=new Array();
	m_arrCurrentSelectedNames_FullList=new Array();
	m_arrCurrentSelectedIDs_SelList=new Array();
	m_arrCurrentSelectedNames_SelList=new Array();
}

function RemoveMultiSelectItemsFromList()
{
	var lngCount;
	
	for(lngCount=0; lngCount<m_arrCurrentSelectedNames_SelList.length; lngCount++){
		RemoveMultiSelectItem(m_arrCurrentSelectedNames_SelList[lngCount]);
	}
	m_arrCurrentSelectedIDs_SelList=new Array();
	m_arrCurrentSelectedNames_SelList=new Array();
}

function UserHasAccessToView(lngViewID)
{
	var blnReturn=true;
	
	if(parent){
		if(parent.m_strValidViewIDs){
			var arrValidViews=parent.m_strValidViewIDs.split(";");
		
			if(!g_MqRef.MqArr.IsValueInArray(lngViewID, arrValidViews)){
				blnReturn=false;
			}
		}
	}
	
	return blnReturn;
}

function GetVDURL(strBaseVD, strAddRedirQS)
{
	var co = m_objRef.objRequest.Get(m_objRef.mstrCurrentLocation + "wcProdInv.asp?WCI=wciGetDiffVDURL&Base=" + strBaseVD + 
										"&AddQS=" + g_MqRef.MqStr.MqEncodeURIComponent(strAddRedirQS));
	if (co!=m_objRef.objRequest.CANCEL_PROCESS){

		var objResponse=m_objRef.objRequest.Response(co);
									
		if (objResponse){
			if (objResponse.HasErrors()){
				objResponse.ProcessErrors("",true,window);
			}else{
				return co;
			}
		}
	}
				
	return true;
}

function HideLoadingDiv(){
	var objLoadingDiv = document.getElementById("divLoading");
	if(objLoadingDiv){
		objLoadingDiv.style.display = "none";
	}
}

function ShowLoadingDiv(){

	var objLoadingDiv = document.getElementById("divLoading");

	if(objLoadingDiv){
		var objDisplayItemsFra = document.getElementById("fraDisplayItems");
		
		if(objDisplayItemsFra){
			var lngXPos = m_objFormElement.GetPosition(objDisplayItemsFra, true);
			var lngYPos = m_objFormElement.GetPosition(objDisplayItemsFra, false);
			
			var lngGridWidth = 0;
			var lngGridHeight = 0;
			var lngLoadingDivWidth = 0;
			var intLoadingDivHeight = 0;
			
			lngGridWidth = objDisplayItemsFra.offsetWidth;
			lngGridHeight = objDisplayItemsFra.offsetHeight;

			lngLoadingDivWidth = lngXPos + ((lngGridWidth/2) - (objLoadingDiv.offsetWidth/2))
			intLoadingDivHeight = lngYPos + ((lngGridHeight/2) - (objLoadingDiv.offsetHeight/2))
			
			objLoadingDiv.style.left = lngLoadingDivWidth + "px";
			objLoadingDiv.style.top = intLoadingDivHeight + "px";
		}
	}
}

function IsInvList(strTableName)
{
	if(strTableName=="tblInvLst"){
		return true;
	}else{
		return false;
	}
}

function LoadInv(strInvNum)
{
	m_strSelInv=unescape(strInvNum);
	GetInvDetails(m_strSelInv);
	DoSearch("tblInvPartLst");
}

function GetInvDetails(strInvNum)
{
	if(m_objRef.objRequest){
		var lngPODat=g_MqRef.MqStr.GetQueryStringValue(location.search, "PADat");
		var co = m_objRef.objRequest.Get(m_objRef.mstrCurrentLocation + "WCDisplayChoices.asp?WCI=GetPOInfo&Inv=" + escape(strInvNum) + 
						"&Flds=" + escape("Invoice_Number,Invoice_Date,Total_with_Tax,PO_Number,Sold_to_Person,Company") + "&Tbl=tblDts" +
						"&DSType=" + lngPODat);
		
		if (co!=m_objRef.objRequest.CANCEL_PROCESS){
									
			var objResponse=m_objRef.objRequest.Response(co);
										
			if (objResponse){
				if (objResponse.HasErrors()){
					objResponse.ProcessErrors("",true,window);
				}else{
					var arrValues=co.split("*|*");
					var arrFields=new Array("dvInvNum",	"dvInvDate", "dvTotal", "dvPONum",	"dvCustName", "dvSupplier");
					var objField;
					var strValue;
					
					if(arrValues.length >= arrFields.length){
						for(x=0; x<arrFields.length; x++){
							objField=document.getElementById(arrFields[x]);
								
							if(objField){
								var strValue=g_MqRef.MqStr.TrimString(arrValues[x]);
								if(strValue.length==0){
									objField.innerHTML="--";
								}else{
									objField.innerHTML=FormatValue(strValue, arrFields[x]);
								}
							}
						}
					}
				}
			}
		}
	}
}

function FormatValue(strValue, strFieldID)
{
	if(strFieldID=="dvTotal"){
		strValue=g_MqRef.MqStr.FormatCurrency(strValue);
	}else{
		if(strFieldID=="dvCustName"){
			strValue=GetName(strValue, 13);
		}else{
			if(strFieldID=="dvSupplier"){
				strValue=GetName(strValue, 721);
			}
		}
	}
	
	return strValue;
}

function GetName(strValue, lngFieldID)
{
	if(parent){
		if(parent.objRequest){
			var strHttpRequest=g_MqRef.MqFS.GetCurrentLocation(window) +
					"wcTopToolbar.asp?WCI=wciGetLookupName&FieldID="+lngFieldID+"&ItemID="+strValue;
			var co=parent.objRequest.Get(strHttpRequest);

			if (co!=parent.objRequest.CANCEL_PROCESS){
				var objResponse=parent.objRequest.Response(co);
				if (objResponse.HasErrors()){
					objResponse.ProcessErrors("",true);
				}else{
					var objMsg=objResponse.GetContent();
					if (objMsg){
						strValue=g_MqRef.MqStr.MqDecodeURIComponent(objMsg.GetText());
					}				
				}
			}
		}
	}
	return strValue;
}

function SetDefaultSearchField(strSearchField)
{
	var objSrcFld=document.getElementById("SearchField");
	if(!objSrcFld){
		objSrcFld=document.getElementById("SearchTypeInvFld");
	}
	if(objSrcFld){
		m_objLookupItemInfo.QueryFields[0]=strSearchField;
		objSrcFld.setAttribute("mqvalue", strSearchField);
	}
}

function SetDefaultSearchMode(strSearchMode)
{
	var objSrcType=document.getElementById("SearchType");
	
	if(!objSrcType){
		objSrcType=document.getElementById("SearchTypeInv");
	}
	
	if(objSrcType){
		var strSearchType=g_MqRef.RESX["CL.FILTER_STARTS_WITH"];
		if(strSearchMode=="1"){
			strSearchType=g_MqRef.RESX["CL.FILTER_CONTAINS"];
		}
		m_objLookupItemInfo.QueryID=strSearchMode;
		objSrcType.setAttribute("mqvalue", strSearchMode);
		objSrcType.innerHTML=strSearchType;
		objSrcType.innerText=strSearchType;
	}
}