// Dependencies:
// jquery
// 

var g_MqRef;

try{
  if (window==top){
    g_MqRef=window;
  }else{
    if (parent.g_MqRef){
        g_MqRef=parent.g_MqRef;
    }else{
        g_MqRef=window;
    }
  }
}catch(e){
	g_MqRef=window;	
}

function ConfirmBox()
{
	function show(title, message)
    {
		var defer = $.Deferred(); 
        $.confirm({
                    title: title,
                    content:message,
				
					type: 'dark',
					typeAnimated: true,
                    buttons: {
						 confirm: {
							btnClass: 'btn-blue',
							keys: ['enter', 'shift'],
							action: function(){
								defer.resolve(true);
							}
						 },
						 cancel:{
							btnClass: 'btn-blue',
							keys: ['enter', 'shift'],
							action: function(){
								defer.resolve(false);
							}
						 }
                    }
                });

		return defer;
    }

	this.show = show;
}

function AlertBox()
{
	function show(title, message)
	{
		$.alert({
			title:title,
			content: message,
			theme: 'dark'
		});

		
	}
	this.show = show;
}

function searchForChar(strSearch,strChar,blnRev)
{
	var intPosition;
	
  strSearch=String(strSearch);
  
	intPosition=-1;
			
	if (!blnRev){
    intPosition=strSearch.indexOf(strChar);
	}else{
    intPosition=strSearch.lastIndexOf(strChar);
	}
		
	return intPosition;
}

function getPath(strPath, strPathDelim)
{
  var strReturn;
  if (!strPathDelim){
    strPathDelim="/";
  }
  strReturn=strPath.substring(0,searchForChar(strPath,strPathDelim,true)+1);
  return strReturn;
}

function CMqArrayMgr()
{
	function IsValueInArray(varValue,varArray)
	{
		
		var blnResult=false;
		if (varArray){
			if (varArray.length){
				for(var lngIndex=0;lngIndex<varArray.length;lngIndex++){
					if (varArray[lngIndex]){
						if (varValue==varArray[lngIndex]){
							blnResult=true;
							break;				
						}
					}
				}
			}
		}
		return blnResult;
	}
	
	function GetIndex(varValue,varArray)
	{
		var lngIndexOut=-1;
		if (varArray){	
			var strValue=String(varValue);
			for(var lngIndex=0;lngIndex<varArray.length;lngIndex++){
				if (varArray[lngIndex]){
					if (strValue==String(varArray[lngIndex])){
						lngIndexOut=lngIndex;
						break;				
					}
				}
			}			
		}
		return lngIndexOut;
	}
	
	//supports one-dimensional arrays only
	function RemoveDuplicateElements(varArray){
		
		var arrUniques = new Array();
		var lngTotalCount=0;
		var x;
				
		for(x=0; x < varArray.length; x++) {
			if(!IsValueInArray(varArray[x], arrUniques)){
				arrUniques[lngTotalCount]=varArray[x];
				lngTotalCount++;
			}
		} 
				
		return arrUniques;
	}	
	this.GetIndex=GetIndex;
	this.IsValueInArray=IsValueInArray;
	this.RemoveDuplicateElements=RemoveDuplicateElements;
} 

function CMqEventUtils() {

	function CancelEventBubble(e, blnBrowserIndependent){
		
		WriteConsole("[CancelEventBubble] Browser independent? " + blnBrowserIndependent);
		
		if(g_MqRef.MqBrowser.ie){
			e.cancelBubble = true;
			e.returnValue = false;
		}else{
			if(blnBrowserIndependent){
				e.cancelBubble = true;
			}
		}
	}
	
	function GetKeyCode(event){
		var keynum;
		
		try{
			if(window.event){
				 keynum = event.keyCode;
			}else{
				if(event.which){ 
					// Netscape/Firefox/Opera
					keynum = event.which;
				}
			}
		}catch(err){
			keynum = 0;
		}
		return keynum;
	}
	
	this.CancelEventBubble=CancelEventBubble;
	this.GetKeyCode=GetKeyCode;
}

function CMqBrowserDetector() {
	var n = navigator;
	// string comparisons are much easier if we lowercase everything now.
	// to make indexOf() tests more compact/readable, we prepend a space 
	// to the userAgent string (to get around '-1' indexOf() comparison)
	var ua = ' ' + n.userAgent.toLowerCase();
	var pl = n.platform.toLowerCase(); // not supported in NS3.0
	var an = n.appName.toLowerCase();

	// browser version
  var appVer=n.appVersion.toLowerCase();
	this.version = appVer;
  
	this.nn = ua.indexOf('mozilla') > 0;

	// 'compatible' versions of mozilla aren't navigator
	if(ua.indexOf('compatible') > 0) {
	  this.nn = false;
	}

	this.opera = ua.indexOf('opera') > 0;
	this.webtv = ua.indexOf('webtv') > 0;
	this.ie = ua.indexOf('trident') > 0;
	if (!this.ie)
	{
		this.ie = ua.indexOf('msie') > 0;
	}
	this.aol = ua.indexOf('aol') > 0;
	this.omniweb = ua.indexOf('omniweb') > 0;
	this.galeon = ua.indexOf('galeon') > 0;  
	this.firefox = ua.indexOf('firefox') > 0; 
	this.chrome = ua.indexOf('chrome') > 0;
	
  // On ie, start of appVersion returns 3 or 4
  // which is the version of Netscape it is compatible with,
  // so look for the real version further on in the string
  if (this.ie) {
    var iePos  = appVer.indexOf('msie');
    if (iePos !=-1) {
	      this.minor = parseFloat(appVer.substring(iePos+5,appVer.indexOf(';',iePos)));
        this.major = parseInt(this.minor);
    }
  }else{
    // Netscape6 is mozilla/5 + Netscape6/6.0!!!
    // Mozilla/5.0 (Windows; U; Win98; en-US; m18) Gecko/20001108 Netscape6/6.0
    var nav6Pos = ua.indexOf('netscape6');
    if (nav6Pos !=-1) {
       this.minor = parseFloat(ua.substring(nav6Pos+10));
       this.major = parseInt(this.minor);
    }else{
        this.major = parseInt( appVer );
	      this.minor = parseFloat( appVer );
    }
  }
  
	function checkMobile() {
		var check = false;
		(function(a){if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i.test(a)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0,4)))check = true})(navigator.userAgent||navigator.vendor||window.opera);
		return check; 
	}
	
	// platform
	this.mac = ua.indexOf('mac') > 0;
	this.mac68k = (ua.indexOf('68k') > 0 || ua.indexOf('68000') > 0);
	this.macppc = (ua.indexOf('ppc') > 0 || ua.indexOf('powerpc') > 0);
	this.win = ua.indexOf('win') > 0;
	this.win16 = (ua.indexOf('16') > 0 && ua.indexOf('win') > 0);
	this.win31 = this.win16;
	this.win95 = (ua.indexOf('95') > 0 && ua.indexOf('win') > 0);
	this.win98 = (ua.indexOf('98') > 0 && ua.indexOf('win') > 0);
	this.winme = (ua.indexOf('win 9x 4.90') > 0 && ua.indexOf('win') > 0);
	this.winnt = (ua.indexOf('nt') > 0 && ua.indexOf('win') > 0);
	this.win2k = (ua.indexOf('nt 5') > 0 && ua.indexOf('win') > 0);
	this.os2 = ua.indexOf('os/2') > 0;
	this.sun = ua.indexOf('sunos') > 0;
	this.irix = ua.indexOf('irix') > 0;
	this.hpux = ua.indexOf('hpux') > 0;
	this.aix = ua.indexOf('aix') > 0;
	this.dec = (ua.indexOf('dec') > 0 || ua.indexOf('alpha') > 0 || ua.indexOf('osf1') > 0 || ua.indexOf('ultrix') > 0);
	this.sco = (ua.indexOf('sco') > 0 || ua.indexOf('unix_sv') > 0);
	this.vms = (ua.indexOf('vax') > 0 || ua.indexOf('openvms') > 0);
	this.linux = ua.indexOf('linux') > 0;
	this.sinix = ua.indexOf('sinix') > 0;
	this.reliant = ua.indexOf('reliantunix') > 0;
	this.freebsd = ua.indexOf('freebsd') > 0;
	this.openbsd = ua.indexOf('openbsd') > 0;
	this.netbsd = ua.indexOf('netbsd') > 0;
	this.bsd = ua.indexOf('bsd') > 0;
	this.unixware = ua.indexOf('unix_system_v') > 0;
	this.mpras = ua.indexOf('ncr') > 0;
	this.unix = ua.indexOf("x11") > 0;
	this.mobile = checkMobile();
	
	// workarounds
	// - IE5/Mac reports itself as version 4.0
	if(this.ie && this.mac) {
	  if(ua.indexOf("msie 5")) {
	    this.major = 5;
	    var actual_index = ua.indexOf("msie 5");
	    var actual_major = ua.substring(actual_index + 5, actual_index + 8);
	    this.minor = parseFloat(actual_major);
	  }
	}

	return this;
}  


function MqString(){
	var DEFAULT_DELIMITER=",";
	var ARG_STRING="%";
	var cenNo_Encode = 0;
    var cenURL_Encode = 1;
    var cenCookie_Encode = 2;
    var cenURI_Encode = 3;
    var cenURIComponent_Encode = 4;
    
	function getChar(intNumber,strString){
		var blnRev;
		var intLength;
		var strReturn;
			
		if (intNumber<0) {
			blnRev=true;
		}else{
			blnRev=false;
		}		
		intNumber=Math.abs(intNumber);
		intLength=strString.length;
		if (intNumber>intLength){
			intNumber=intLength;
		}
		strReturn=(blnRev)?strString.substring(intLength-intNumber,intLength):strString.substring(0,intNumber);
		return strReturn;
	}
		
	function getNullTerminatedString(strString){
		var intCounter;
		var strTemp;
		strString=String(strString);
		for (intCounter=strString.length;intCounter>0;intCounter--){
			strTemp=strString.substr(strString.length-1,1);
			if (strTemp.toString().charCodeAt(0)==13 || strTemp.toString().charCodeAt(0)==10){
				strString=strString.substr(0,strString.length-1);
			}else{
				intCounter=0;
			}
			
		}
	
		return strString;
	}
	
	function TrimString(strToTrim){
			while (strToTrim.charAt(0) == " "){
				strToTrim = strToTrim.substr(1, strToTrim.length);
			}
			while (strToTrim.charAt(strToTrim.length - 1) == " "){
				strToTrim = strToTrim.substr(0, strToTrim.length - 1);
			}
			return (strToTrim);
	}
	function Right(strString,lngLength)
	{
		var intStringLength;
			
		intStringLength=strString.length;
			
		return (strString.substring(intStringLength-lngLength, intStringLength));
			
	}

	function Left(strString,lngLength)
	{
			
		return (strString.substring(0, lngLength));
		
	}
	
	function Mid(strString,lngStart,lngLength)
	{
		return (strString.substr(lngStart, lngLength));	
	}
	
	function GetPropertyValue(strPropertyName, strToSearchIn,blnUnescapeValue, strPropertyDelim,strPropertyValueDelim){
		var strPropertyValue = "";
		var PROPERTY_DELIM=";";
		var PROPERTY_VALUE_DELIM="=";
		var varProperties;
		if (!strPropertyDelim){
			strPropertyDelim=PROPERTY_DELIM;
		}
		
		if (!strPropertyValueDelim){
			strPropertyValueDelim=PROPERTY_VALUE_DELIM;
		}
		if (strToSearchIn && strPropertyName){
			varProperties=strToSearchIn.split(strPropertyDelim);
		}
		
		if (varProperties){
			
			strPropertyValue=GetPropertyValue_FromArray(varProperties,strPropertyName,strPropertyValueDelim);
		}
	
		if (blnUnescapeValue){
			strPropertyValue=MqDecodeURIComponent(strPropertyValue);
		}
		
		return strPropertyValue;
		
		
	}
	
	function ReplacePropertyValue(strCommandLine, strPropertyName, strNewPropertyValue, strDelim, strElementDelim)
	{	
		var NAME_ELEMENT=0;
		var VALUE_ELEMENT=1;
		
		var arrPropertyPair;
		var lngCount;
		var strResult;
		var blnFound=false;
		
		
		var arrProperties=strCommandLine.split(strDelim);
		
		for(lngCount=0; lngCount<arrProperties.length; lngCount++){
			
			arrPropertyPair=arrProperties[lngCount].split(strElementDelim);
			
			if(arrPropertyPair[NAME_ELEMENT]==strPropertyName){
				arrProperties[lngCount]=arrPropertyPair[NAME_ELEMENT] + strElementDelim + strNewPropertyValue;
				lngCount=arrProperties.length;
			}
		}
		
		strResult=arrProperties.join(strDelim);

		return strResult;
	}
	
	function PropertyExists(strCommandLine, strPropertyName, strDelim, strElementDelim)
	{
		var NAME_ELEMENT=0;
		
		var arrPropertyPair;
		var lngCount;
		var lngReturn=-1;
		
		var arrProperties=strCommandLine.split(strDelim);
		
		for(lngCount=0; lngCount<arrProperties.length; lngCount++){
			
			arrPropertyPair=arrProperties[lngCount].split(strElementDelim);
			
			if(arrPropertyPair[NAME_ELEMENT]==strPropertyName){
				lngReturn=lngCount;
				lngCount=arrProperties.length;
			}
		}
		return lngReturn;
	}
	
	function GetQueryStringValue(strCommandLine,strQSName,blnSkipUnescape)
	{
		var QUERY_STRING_DELIM="&";
		var QUESTION_MARK="?";

		if (Left(strCommandLine,QUESTION_MARK.length)==QUESTION_MARK){
			strCommandLine=Right(strCommandLine,(strCommandLine.length-QUESTION_MARK.length));
		}

		if(blnSkipUnescape){
			return GetPropertyValue(strQSName, strCommandLine, false, QUERY_STRING_DELIM);
		}else{
			return GetPropertyValue(strQSName, strCommandLine, true, QUERY_STRING_DELIM);
		}
		
	}		
	
	function FormatString(strString,strArgs,strDelim,blnUnescape)
	{
		if (!strDelim){
			strDelim=DEFAULT_DELIMITER;
		}
		if (strArgs){
			var arrArgs = strArgs.split(strDelim);
			var regExp;
			var strValue;
			for(var lngCount=0; lngCount<arrArgs.length; lngCount++){
				regExp=new RegExp(ARG_STRING+(lngCount+1),"g");
				strValue=arrArgs[lngCount];
				if (blnUnescape){
					 strValue=MqDecodeURIComponent(strValue);
				}
				if (!strString){
					strString="%1";
				}
				strString=strString.replace(regExp, strValue);
			}
		}
		return strString;
	}

	function StripLeading(strString, strRemoveString)
	{
		var strReturn =strString;
		if (strString && strRemoveString) {
			var lngRemoveStringLen=strRemoveString.length;
			var strLeft=strString.substring(0, lngRemoveStringLen);
			if (strLeft.toLowerCase()==strRemoveString.toLowerCase()){
				strReturn=strString.substring(lngRemoveStringLen, strString.length);
			}
		}
		return strReturn;
	}
	function StripTrailing(strString, strRemoveString)
	{
		var strReturn =strString;
		if (strString && strRemoveString) {
			var lngRemoveStringLen=strRemoveString.length;
			var strStringLen=strString.length;
			var strRight=strString.substring(strStringLen -lngRemoveStringLen, strStringLen);
			if (strRight.toLowerCase()==strRemoveString.toLowerCase()){
				strReturn=strString.substring(0, strStringLen -lngRemoveStringLen);
			}
		}
		return strReturn;
	}
	function Format(strString)
	{
		try{
			var regExp;
			if (strString){
				if (arguments){
					for(var i=1;i<arguments.length;i++){
						regExp=new RegExp(ARG_STRING+i,"g");
						strString=strString.replace(regExp,arguments[i]);
					}
				}
			}else{
				if (Format.caller !== null){
					console.log("Invalid string passed from " + Format.caller.toString());
				}else{
					console.log("Invalid string passed to Format");
				}
			}
		}catch(e)
		{
			console.log(e);
		}
		
		return strString;
	}

	function MqDecodeURI(strURI)
	{
		if(window.decodeURI){
			return window.decodeURI(strURI);
		}else{
			return unescape(strURI);
		}
	}
	
	function MqDecodeURIComponent(strURIComponent)
	{
		if(window.decodeURIComponent){
			return window.decodeURIComponent(strURIComponent);
		}else{
			return unescape(strURIComponent);
		}
	}
	
	function MqEncodeURI(strURI)
	{
		if(window.encodeURI){
			return window.encodeURI(strURI);
		}else{
			return GetEncodedString(strURI,cenURI_Encode);
		}
	}
	function MqEncodeURIComponent(strURIComponent)
	{
		if(window.encodeURIComponent){
			return window.encodeURIComponent(strURIComponent);
			
		}else{
			return GetEncodedString(strURIComponent,cenURIComponent_Encode);
		}
	}	
	
	function GetEncodedString(strURIComponent,lngEncodeType)
	{
		var lngCounter;
		var strChar;
		var strEncodeStr="";
	
		var lngStrLength=strURIComponent.length;

		if(lngStrLength > 0){
	        for(lngCounter=0; lngCounter<lngStrLength; lngCounter++){
				strChar = Mid(strURIComponent, lngCounter, 1);
				if(strChar.length > 0){
					if (lngEncodeType===cenURIComponent_Encode){
						strChar=URICompEscapeChar(strChar);
					}else{
						if (lngEncodeType===cenURI_Encode){
							strChar=URIEscapeChar(strChar);
						}
					}
					strEncodeStr+=strChar;
				}
			}
		}
	   return strEncodeStr;
	}
	
	function URICompEscapeChar(strChar)
    {
		var lngAsciiVal=strChar.charCodeAt();
		
		if(lngAsciiVal!=45 && lngAsciiVal!=95 && lngAsciiVal!=46 && 
				lngAsciiVal!=33 && lngAsciiVal!=126 && lngAsciiVal!=42 && 
					lngAsciiVal!=39 && lngAsciiVal!= 40 && lngAsciiVal!=41){
		
			// "-" | "_" | "." | "!" | "~" | "*" | "'" | "(" | ")"
			strChar = URLEncodeChar(strChar, lngAsciiVal);
		}

	    return strChar;
   }

	function URIEscapeChar(strChar)
    {
		var lngAsciiVal=strChar.charCodeAt();
		
		if(lngAsciiVal!=59 && lngAsciiVal!=47 && lngAsciiVal!=63 && 
				lngAsciiVal!=58 && lngAsciiVal!=64 && lngAsciiVal!=61 && 
					lngAsciiVal!=43 && lngAsciiVal!= 36 && lngAsciiVal!=44 && lngAsciiVal!=38 ){
		
			// ";" | "/" | "?" | ":" | "@" | "=" | "+" | "$" | ","| "&"
			strChar = URICompEscapeChar(strChar, lngAsciiVal);
		}

	    return strChar;
    }   
    
	function URLEncodeChar(strChar, lngAsciiVal)
	{    
		var strEncodeChar=strChar;
	        
	    if ((lngAsciiVal < 123) && (lngAsciiVal > 96)){
	        //do not encode
		}else{
			if ((lngAsciiVal < 91) && (lngAsciiVal > 64)){
		        //do not encode
			}else{
				if ((lngAsciiVal < 58) && (lngAsciiVal > 47)){
					//do not encode
				}else{
				     strChar = TrimString(Hex(lngAsciiVal));
				     if(lngAsciiVal < 16){
				         strChar = "%0" + strChar;
				     }else{
				         strChar = "%" + strChar;
				     }
				 }
			}
		}
		return strChar;
	}
	
	function Hex(lngNumber)
	{
		return lngNumber.toString(16);
	}
	
	function MqHtmlEncode(strString, blnReplaceSpace)
	{    
		var regExp;
		
		//replace all the & with &amp;
		regExp=new RegExp("&","g");
		strString=strString.replace(regExp,"&amp;");
    		
		//replace all the < with &lt;
		regExp=new RegExp("<","g");
		strString=strString.replace(regExp,"&lt;");
		
		//replace all the > with &gt;
		regExp=new RegExp(">","g");
		strString=strString.replace(regExp,"&gt;");
		
		//replace all the " with &quot;
		regExp=new RegExp('"',"g");
		strString=strString.replace(regExp,"&quot;");
		
		//replace all the ' with &apos;
		regExp=new RegExp("'","g");
		strString=strString.replace(regExp,"&#39;");
		
		if(blnReplaceSpace!=false){
			//replace all the " " with &#160;
			regExp=new RegExp(" ","g");
			strString=strString.replace(regExp,"&#160;");
		}

		return strString;
	}	
	
	function MqHtmlDecode(strString, blnReplaceSpace)
	{    
		var regExp;
		
		//replace all the &amp; with &
		regExp=new RegExp("&amp;","g");
		strString=strString.replace(regExp,"&");
    		
		//replace all the &lt; with <
		regExp=new RegExp("&lt;","g");
		strString=strString.replace(regExp,"<");
		
		//replace all the &gt; with >
		regExp=new RegExp("&gt;","g");
		strString=strString.replace(regExp,">");
		
		//replace all the &quot; with "
		regExp=new RegExp("&quot;","g");
		strString=strString.replace(regExp,'"');
		
		//replace all the &#39; with '
		regExp=new RegExp("&#39;","g");
		strString=strString.replace(regExp,"'");
		
		if(blnReplaceSpace!=false){
			//replace all the &#160; with " "
			regExp=new RegExp("&#160;","g");
			strString=strString.replace(regExp," ");
			
			// could also be encoded in the standard way
			regExp=new RegExp("&nbsp;", "g");
			strString=strString.replace(regExp," ");
		}

		return strString;
	}
	
	function MqUnformatXMLData(strString)
	{    
		var regExp;
		
		//replace all the encoded & (%26) with &
		regExp=new RegExp(escape("&"),"g");
		strString=strString.replace(regExp,"&");
    		
		//replace all the encoded < (%3C) with <
		regExp=new RegExp(escape("<"),"g");
		strString=strString.replace(regExp,"<");
		
		//replace all the encoded > (%3E) with >
		regExp=new RegExp(escape(">"),"g");
		strString=strString.replace(regExp,">");
		
		//replace all the encoded " (%22) with "
		regExp=new RegExp(escape('"'),"g");
		strString=strString.replace(regExp,'"');
		
		//replace all the encoded ' (%27) with '
		regExp=new RegExp(escape("'"),"g");
		strString=strString.replace(regExp,"'");

		return strString;
	}	
	
	function WriteResString(strResID)
	{
		document.write(RESX[strResID]);
	}

	function PropStringEncode(strString)
	{
		if(strString){
			strString=strString.toString();

			var arrCharsToReplace = new Array("&", ";", "=");
			var strChar;
			var regExp;
			
			for(var lngCount=0;  lngCount<arrCharsToReplace.length;lngCount++){
				//replace the char with a URIComponentEncoded one
				strChar = arrCharsToReplace[lngCount];
				regExp=new RegExp(strChar,"g");
				strString=strString.replace(regExp,MqEncodeURIComponent(strChar));
			}
		}
		return strString;
	}
	
	function PropStringDecode(strString)
	{
		if(strString){
			strString=strString.toString();

			var arrCharsToReplace = new Array("&", ";", "=");
			var strChar;
			var regExp;
			
			for(var lngCount=0;  lngCount<arrCharsToReplace.length;lngCount++){
				//replace the URIComponentEncoded char with a regular one
				strChar = arrCharsToReplace[lngCount];
				regExp=new RegExp(MqEncodeURIComponent(strChar),"g");
				strString=strString.replace(regExp,strChar);
			}
		}
		return strString;
	}
	
	function FormatCurrency(strValue)
	{
		var strDelimiter = ",";
		var strCurrencyType = "$";
		
		if(!isNaN(strValue) && strValue != "")
		{
			strValue = strCurrencyType + " " + parseFloat(strValue.replace(/,/g, ""))
									.toFixed(2)
									.toString()
									.replace(/\B(?=(\d{3})+(?!\d))/g, strDelimiter);
		}
		else
		{
			strValue = strCurrencyType + " 0.00";
		}
		return strValue;
	}
	
	function DecodeHTML(html) 
	{
	    var txt = document.createElement("textarea");
	    txt.innerHTML = html;
	    return txt.value;
	}
	
	this.FormatString=FormatString;
	this.Right=Right;
	this.Left=Left;
	this.Mid=Mid;
	this.getNullTerminatedString=getNullTerminatedString;
	this.searchForChar=searchForChar;
	this.getChar=getChar;
	this.TrimString=TrimString;
	this.GetPropertyValue=GetPropertyValue;
	this.ReplacePropertyValue=ReplacePropertyValue;
	this.PropertyExists=PropertyExists;
	this.GetQueryStringValue=GetQueryStringValue;
	this.StripTrailing=StripTrailing;
	this.StripLeading=StripLeading;
	this.Format=Format;
	this.MqDecodeURIComponent=MqDecodeURIComponent;
	this.MqEncodeURIComponent=MqEncodeURIComponent;
	this.MqHtmlEncode=MqHtmlEncode;
	this.MqHtmlDecode=MqHtmlDecode;
	this.MqDecodeURI=MqDecodeURI;
	this.MqEncodeURI=MqEncodeURI;
	this.MqUnformatXMLData=MqUnformatXMLData;
	this.WriteResString=WriteResString;
	this.PropStringEncode=PropStringEncode;
	this.PropStringDecode=PropStringDecode;
	this.FormatCurrency=FormatCurrency;
	this.DecodeHTML=DecodeHTML;
		
	function GetPropertyValue_FromArray(varProperties,strPropertyName,strValueDelim)
	{
		var varProperty;	
		var strProperty;		
		var lngDelimPos;
		var strPropertValue="";
		var INDX_PROPERTY_NAME=0;
		var PROPERTY_VALUE_DELIM="=";
		if(!strValueDelim){
			strValueDelim=PROPERTY_VALUE_DELIM;
		}
		if (varProperties){
			for(var i=0;i<varProperties.length;i++){
				strProperty=varProperties[i];
				if(strProperty){
					varProperty=strProperty.split(strValueDelim);
					if (varProperty[INDX_PROPERTY_NAME]==strPropertyName){
						lngDelimPos=strProperty.indexOf(strValueDelim);
						strPropertValue=strProperty.substring(lngDelimPos+strValueDelim.length);
						break;
					}
				}
			}
		}
		return strPropertValue ;
	}
	
}	


function MqFiles(){
	var mstrCurrentVD;
	
	function getFileName(strPath,strPathDelim, blnCompleteNAme){
		var strReturn;
		if (!strPathDelim){
			strPathDelim="/";
		}
		
		if (!blnCompleteNAme){
			strReturn=strPath.substring(searchForChar(strPath,strPathDelim,true)+1,searchForChar(strPath,".",true));
		}else{
			strReturn=strPath.substring(searchForChar(strPath,strPathDelim,true)+1);
		}
		
		return strReturn;
	}

	function removeSearchString(strPath){
		var intLastPosition;
		var strReturn;		

		strPath=String(strPath);		
		intLastPosition=searchForChar(strPath,"?",true);
		
		if (intLastPosition==-1){
			intLastPosition=searchForChar(strPath,"#",true);
		}
		
		if (intLastPosition==-1){
			intLastPosition=strPath.length;
		}
		strReturn=strPath.substring(0,intLastPosition);
		
		return strReturn;
	}

	function getFileExtension(strPath){
		var intFirstPosition;
		var strReturn;
		var strCharExt=".";
		strPath=String(strPath);

		strPath=removeSearchString(strPath);
		
		intFirstPosition=searchForChar(strPath,strCharExt,true);		
		
		var intLength=strPath.length;
		strReturn=strPath.substring(intFirstPosition+1,intLength);
	
		return strReturn;
	}
	function GetCurrentLocation(objHTMLWindow)
	{
		var strLocation="";
		
		if (objHTMLWindow){
			if (objHTMLWindow.location){
				
				var objHTMLLocation=objHTMLWindow.location;
				
				try{
					if (objHTMLLocation.href){
					
						strLocation=GetDomainURL(objHTMLLocation);
						
						if(strLocation){
							strLocation+=getPath(objHTMLLocation.pathname);
						}


					}					
				}catch(errorObject){
					strLocation="";
				}
			}
		}
	     
		return strLocation;
	}
	function getCurrentLocation(strDocumentName){
		var objDocument;	


		objDocument=eval(strDocumentName);


		
		var strLocation=GetCurrentLocation(objDocument);
		
		return strLocation;

	}
	
	function GetCurrentVDURL(objHTMLWindow)
	{
		var strURL="";
		
		if(objHTMLWindow){
			if(objHTMLWindow.location){
				strURL=GetDomainURL(objHTMLWindow.location);

				if(strURL){
					strURL+="/" + GetVDName(objHTMLWindow.location.pathname);
				}
			}

		}
		return strURL;
	}
	
	function ConcatenatePath(strFirstPath,strSecondPath, strPathDelim){
		var BACKSLASH="\\";
		if(!strPathDelim){
			strPathDelim=BACKSLASH;
		}
		var objStr=g_MqRef.MqStr;
		strFirstPath=objStr.StripTrailing(strFirstPath,strPathDelim);
		strSecondPath=objStr.StripLeading(strSecondPath,strPathDelim);
		return (strFirstPath +strPathDelim +strSecondPath);    
	}

	function GetCurrentVD()
	{
		if (!mstrCurrentVD){
			mstrCurrentVD=GetVDName();
		}
		return mstrCurrentVD;
	}
	
	function GetVDName(strPathName)
	{
		if (!strPathName){
			strPathName=window.location.pathname;
		}
		
		var strPathDelim="/";
		var strVDName="";
		var lngIndex;
		if(g_MqRef.MqStr.Left(strPathName, strPathDelim.length)==strPathDelim){
			strPathName=g_MqRef.MqStr.Right(strPathName, strPathName.length-strPathDelim.length);
		}
		lngIndex=strPathName.indexOf(strPathDelim);
		if(lngIndex>0){
			strVDName=g_MqRef.MqStr.Left(strPathName, lngIndex);
		}
		return strVDName;
		
	}
	
	function GetCurrentView(strPathName)
	{
		if (!strPathName){
			strPathName=window.location.pathname;
		}
		
		var strPathDelim="/"+GetVDName()+"/";
		var strPathDelim2="/";
		var strCurrentView="";
		var lngIndex;
		
		strCurrentView = strPathName.substring(0, strPathName.indexOf(strPathDelim2));
		if(g_MqRef.MqStr.Left(strPathName, strPathDelim.length)==strPathDelim){
			
			strPathName=g_MqRef.MqStr.Right(strPathName, strPathName.length-strPathDelim.length);
		}
		lngIndex=strPathName.indexOf(strPathDelim2);
		if(lngIndex>0){
			strCurrentView=g_MqRef.MqStr.Left(strPathName, lngIndex);
		}
		return strCurrentView;
		
	}
	
	function LoadScript(sFileURL,callback,HTMLDoc)
	{
		if (!HTMLDoc){
			HTMLDoc=document;
		}
		var script=HTMLDoc.createElement('script');
		var ret=false;
		script.setAttribute("type","text/javascript");
	
		// Support for callback
		if (script.readyState){  //IE
	        script.onreadystatechange = function(){
	            if (script.readyState == "loaded" ||
	                    script.readyState == "complete"){
	                script.onreadystatechange = null;
	                if (callback){
		                callback();
		            }
	            }
	        };
	    } else {  //Others
	        script.onload = function(){
	            if (callback){
	                callback();
	            }
	        };
	    }
		
		script.setAttribute("src", sFileURL);
		if (typeof script!="undefined")
		{
			HTMLDoc.getElementsByTagName("head")[0].appendChild(script);
			ret=true;
		}
		return ret; 		
	}
	
	function LoadScriptSync(sFileURL) 
	{		
		var objXMLHttpReqObj = new XMLHttpRequest();
		var READY_STATE_COMPLETE=4;
		
		if(objXMLHttpReqObj){
			objXMLHttpReqObj.open("GET", sFileURL, false); //synchronous
			objXMLHttpReqObj.onreadystatechange = function(){
				if(objXMLHttpReqObj.readyState==READY_STATE_COMPLETE){
					eval(objXMLHttpReqObj.responseText);
				}
			}
			objXMLHttpReqObj.send(null);			
		}
	}
	
	// Not JSONP. Not for cross-domain
	function LoadJSONSync(sFileURL) 
	{		
		var objXMLHttpReqObj = new XMLHttpRequest();
		var READY_STATE_COMPLETE=4;
		var sRet="";
		
		if(objXMLHttpReqObj){
			objXMLHttpReqObj.open("GET", sFileURL, false); //synchronous
			objXMLHttpReqObj.onreadystatechange = function(){
				if(objXMLHttpReqObj.readyState==READY_STATE_COMPLETE){
					sRet=objXMLHttpReqObj.responseText;
				}
			}
			objXMLHttpReqObj.send(null);	
			return sRet;		
		}
	}
	
	this.getFileName=getFileName;
	this.getFileExtension=getFileExtension;
	this.removeSearchString=removeSearchString;
	this.getPath=getPath;
	this.getCurrentLocation=getCurrentLocation;
	this.ConcatenatePath=ConcatenatePath;
	this.GetCurrentLocation=GetCurrentLocation;
	this.GetCurrentVDURL=GetCurrentVDURL;
	this.GetVDName=GetVDName;
	this.GetCurrentVD=GetCurrentVD;
	this.GetCurrentView=GetCurrentView;
	this.LoadScript=LoadScript;
	this.LoadScriptSync=LoadScriptSync;
	this.LoadJSONSync=LoadJSONSync;
	
	function GetDomainURL(objDocumentLocation)
	{
		var strURL="";
		
		if(objDocumentLocation){
			strURL=objDocumentLocation.protocol +"//" +objDocumentLocation.hostname;
				
			if (objDocumentLocation.port!="80" && objDocumentLocation.port!=="" ){
				 strURL+=":" + objDocumentLocation.port;
			}	
		}
		return strURL;
	}
	
}
function CMqURIUtils(){

	var PROTOCOL_FILE = "file";
	var PROTOCOL_FTP = "ftp";
	var PROTOCOL_GOPHER = "gopher";
	var PROTOCOL_HTTP = "http";
	var PROTOCOL_HTTPS = "https";
	var PROTOCOL_MAILTO = "mailto";
	var PROTOCOL_NEWS = "news";
	var PROTOCOL_NNTP = "nntp";
	var PROTOCOL_SOCKS = "socks";
	var PROTOCOL_JAVASCRIPT = "javascript";
	var PROTOCOL_VBSCRIPT = "vbscript";
	var DELIM_SEGMENT = "/";
	var QUESTION_MARK="?";
	
	function AddURIProtocol(strURL)
	{						
		var strDefaultProtocol=PROTOCOL_HTTP;
		
		var blnHasProtocol=HasProtocol(strURL);

		if(!blnHasProtocol){
			if(!IsRelativeURIPath(strURL)){
				strURL=strDefaultProtocol + GetSchemeDelimiter(strDefaultProtocol) + strURL;
			}
		}
			
		return strURL;
	}
	function ReplaceURIPath(strURI,strPath)
	{
		if (strURI && strPath){
			var varSegments=strURI.split(DELIM_SEGMENT);
			varSegments=varSegments.slice(0,3);
			var strAuthURI=varSegments.join(DELIM_SEGMENT);
			strURI=strAuthURI + DELIM_SEGMENT + strPath;
		}
		return strURI;
	}
	
	function AddToQueryString(strURL, strURIName, strURIValue)
	{
		var strFinalURL="";
		var QUERY_STRING_DELIM="&";
		var QUERY_STRING_ELEMENT_DELIM="=";
		
		var strURLQS=GetQueryStringFromURL(strURL);
		if(strURLQS.indexOf(strURIName) >= 0){									
			strURLQS=g_MqRef.MqStr.ReplacePropertyValue(strURLQS, strURIName, strURIValue, QUERY_STRING_DELIM, QUERY_STRING_ELEMENT_DELIM); 
			var strURLPath=GetPathFromURL(strURL);
			strFinalURL=strURLPath + QUESTION_MARK + strURLQS;
		}else{
			if(strURL.indexOf(QUESTION_MARK) >=0){
				strFinalURL=strURL + QUERY_STRING_DELIM;
			}else{
				strFinalURL=strURL + QUESTION_MARK;
			}
			strFinalURL+=strURIName + QUERY_STRING_ELEMENT_DELIM + strURIValue;
		}
		return strFinalURL;
	}
	
	function RemoveFromQueryString(strURL, strURIName)
	{
		var strFinalURL="";
		var QUERY_STRING_DELIM="&";
		var QUERY_STRING_ELEMENT_DELIM="=";
		
		var strURLQS=GetQueryStringFromURL(strURL);
		if(strURLQS.indexOf(strURIName) >= 0){									
			var strURIValue=g_MqRef.MqStr.GetPropertyValue(strURIName, strURLQS,false, QUERY_STRING_DELIM,QUERY_STRING_ELEMENT_DELIM);
			
			strURLQS = strURLQS.replace(QUERY_STRING_DELIM + strURIName + QUERY_STRING_ELEMENT_DELIM + strURIValue, "");
			var strURLPath=GetPathFromURL(strURL);
			strFinalURL=strURLPath + QUESTION_MARK + strURLQS;
		}else{
			strFinalURL=strURL;
		}
		return strFinalURL;
	}
	
	function GetPathFromURL(strURL)
	{
		var strPath=strURL;
		var lngIndex=strURL.indexOf(QUESTION_MARK);
		
		if(lngIndex >= 0){
        strPath=strURL.substr(0,lngIndex);
		}
		return strPath;
	}
	
	function GetQueryStringFromURL(strURL)
	{
		var strQS="";
		var lngIndex=strURL.indexOf(QUESTION_MARK) + QUESTION_MARK.length;
		if(lngIndex >= 0){
			strQS=strURL.substr(lngIndex);
		}
		
		return strQS;
	}
	
	function GetURIFromUNC(strUNC)
	{

		//replace the initial \\ with file://
		var regExp=new RegExp("^\\\\\\\\","g");
		strUNC=strUNC.replace(regExp,"file://");
    		
		//replace all \ with /
		regExp=new RegExp("\\\\","g");
		strUNC=strUNC.replace(regExp,"/");

		return strUNC;
	
	}
	
	this.AddURIProtocol=AddURIProtocol;
	this.ReplaceURIPath=ReplaceURIPath;
	this.AddToQueryString=AddToQueryString;
	this.GetURIFromUNC=GetURIFromUNC;
	this.RemoveFromQueryString=RemoveFromQueryString;
	
	//private

	function HasProtocol(strURL)
	{
		var PROTOCOL_DELIM=":";
		var PROTOCOL_ELEMENT=0;
		var lngCount;
		var blnHasProtocol=false;
		var lngProtocolDelimIndex=strURL.indexOf(PROTOCOL_DELIM);
		if(lngProtocolDelimIndex>0){
		
			var arrProtocols=new Array(PROTOCOL_FILE,PROTOCOL_FTP,
										PROTOCOL_GOPHER,PROTOCOL_HTTP,
										PROTOCOL_HTTPS,PROTOCOL_MAILTO,
										PROTOCOL_NEWS,PROTOCOL_NNTP,
										PROTOCOL_SOCKS,PROTOCOL_JAVASCRIPT,
										PROTOCOL_VBSCRIPT);
			
			var strProtocol=strURL.substring(0,lngProtocolDelimIndex);
			
			strProtocol=strProtocol.toLowerCase();
		
			strProtocol=g_MqRef.MqStr.TrimString(strProtocol);
		
			for(lngCount=0; lngCount<arrProtocols.length; lngCount++){
				if(strProtocol==arrProtocols[lngCount]){
					blnHasProtocol=true;
					lngCount=arrProtocols.length;
				}
			}
		}		
		return blnHasProtocol;
	}
	
	function IsRelativeURIPath(strPath)
	{    
		var blnIsRelative=false;
		var lngCount;
		
		var FIRST_COMPONENT_ELEMENT=0;
			
		//a relative path could have the following formats:
	        // ./<PATH>
	        // /<PATH>
	        // ../<PATH>
	    //there are other formats, but these are the only ones we currently support
	    
	    var arrURIRelPathFirstComp = new Array(".", "..");
		    
	    var varSegments = strPath.split(DELIM_SEGMENT);
		    
	    var strFirstCompPath = varSegments[FIRST_COMPONENT_ELEMENT];
		    
	    if (strFirstCompPath.length===0){
			//ex: strPath= /HTML , which is a relative path
	        blnIsRelative = true;
		}else{
			//check if the first path component is a relative one
			for(lngCount=0;lngCount<arrURIRelPathFirstComp.length;lngCount++){
				if(arrURIRelPathFirstComp[lngCount]==strFirstCompPath){
					lngCount=arrURIRelPathFirstComp.length;
					blnIsRelative=true;
				}
			}
	    }

	    return blnIsRelative;
	}
		
	function GetSchemeDelimiter(strProtocol)
	{
		var strDelimiter="";
			
		if(strProtocol==PROTOCOL_MAILTO || strProtocol==PROTOCOL_NEWS){
			strDelimiter = ":";
		}else{
			strDelimiter =  "://";
		}
			
		return strDelimiter;
	}
}

//Images related functions ************************

function isImageDisabled(strImage,objImage){
	var blnReturn;
	var intPosition;
	blnReturn=false;

  if (!objImage){
	  objImage=document.images[strImage];
  }
	if (objImage){
    var strSRC=objImage.src;
    
		intPosition=searchForChar(strSRC,".",true);
		
		if (strSRC.substring(intPosition-3,intPosition)=="dis"){
			blnReturn=true;
		}else{
			blnReturn=false;
		}
	}
		
	return blnReturn;
}
	

function MqButton()
{
	var STATE_1="State1";
	var STATE_2="State2";
	var STATE_DIS="StateDis";
	var POSTFIX_SELECTED="Selected";
	var m_objHTMLDocument=document;
	var MQ_BUTTON_BASE_CLASS_PROP="MqBaseClass";
	
	function GetHTMLDocument()
	{
		return m_objHTMLDocument;
	}
	
	function SetHTMLDocument(objHTMLDocument)
	{
		m_objHTMLDocument=objHTMLDocument;
	}
	
	function Toggle(objHTMLElement, strBaseClass)
	{
		if (objHTMLElement){
			if (objHTMLElement.className.indexOf(STATE_1)>=0){
				objHTMLElement.className=strBaseClass + STATE_2;
			}else{
				objHTMLElement.className=strBaseClass + STATE_1;
			}
		}
	}

	function ChangeBaseClass(objHTMLElement, strNewBaseClass, strOldBaseClass)
	{
		SetCSSClass(objHTMLElement, strNewBaseClass, strOldBaseClass);
		objHTMLElement.setAttribute(MQ_BUTTON_BASE_CLASS_PROP, strNewBaseClass);
	}
		
	function Select(objHTMLElement, strState)
	{	
		if(!(strState)){
			strState=STATE_1;	
		}
		
		SetCSSClass(objHTMLElement, strState + POSTFIX_SELECTED, strState);
	}
	
	function UnSelect(objHTMLElement, strState)
	{		
		if(!(strState)){
			strState=STATE_1;	
		}
	
		SetCSSClass(objHTMLElement, strState, strState + POSTFIX_SELECTED);
	}

	function SetCSSClass(objHTMLElement, strNewState, strOldState)
	{
		var strCurrClass="";
	
		if (objHTMLElement){
			strCurrClass=objHTMLElement.className;
			if(Right(strCurrClass, strNewState.length)!=strNewState){
				objHTMLElement.className=strCurrClass.replace(strOldState, strNewState);
			}
		}

	}
	function Right(strString,lngLength)
	{
		var intStringLength;
			
		intStringLength=strString.length;
			
		return (strString.substring(intStringLength-lngLength, intStringLength));
			
	}
	
	function ToggleButton(strName, strBaseClass)
	{
		if(m_objHTMLDocument){
			var oButton=m_objHTMLDocument.getElementById(GetButtonHTMLName(strName));
					
			if(oButton){
				Toggle(oButton,strBaseClass);
			}			
		}
	}
	
	function DisableButton(strName)
	{
		if(m_objHTMLDocument){
			if(IsTextButton(GetButtonHTMLName(strName)))
			{
				DisableTextButton(strName);
			}
			else
			{
				var objLogonButton=m_objHTMLDocument.getElementById(GetButtonHTMLName(strName));
						
				if(objLogonButton){
					Disable(objLogonButton);
				}			
			}
		}
	}
	
	function EnableButton(strName)
	{
		if(m_objHTMLDocument){
			if(IsTextButton(GetButtonHTMLName(strName)))
			{
				EnableTextButton(strName);
			}
			else
			{
				var objLogonButton=m_objHTMLDocument.getElementById(GetButtonHTMLName(strName));
						
				if(objLogonButton){
					ShowHideButton(strName, true);
					Enable(objLogonButton);
				}	
			}
		}
	}
	
	function ShowHideButton(strName, blnVisible)
	{
		if(m_objHTMLDocument){
			var objLogonButton=m_objHTMLDocument.getElementById(GetButtonHTMLName(strName));
					
			if(objLogonButton){
				if(blnVisible){
					objLogonButton.style.display="";
				}else{
					objLogonButton.style.display="none";
				}
			}			
		}
	}
	
	function Enable(objHTMLElement)
	{		
		var blnReturn=false;
		if (objHTMLElement){
			if(IsTextButton(objHTMLElement.id, objHTMLElement)){
				HideTextButton(objHTMLElement.id, false, objHTMLElement);
			}else{
				if (objHTMLElement.className.indexOf(STATE_1)<0){
					var strBaseClass=GetButtonBaseClass(objHTMLElement);
					objHTMLElement.className=strBaseClass + STATE_1;
				}
			}
			blnReturn=true;
		}		
		return blnReturn;
	}
	
	function Disable(objHTMLElement)
	{
		var blnReturn=false;
		
		if (objHTMLElement){
			if(IsTextButton(objHTMLElement.id, objHTMLElement)){
				HideTextButton(objHTMLElement.id, true, objHTMLElement);
			}else{
				if (!IsDisabled(objHTMLElement)){
					var strBaseClass=GetButtonBaseClass(objHTMLElement);
					objHTMLElement.className=strBaseClass + STATE_DIS;
				}
			}
			blnReturn=true;
		}
		
		return blnReturn;
	}
	
	function GetButtonBaseClass(objHTMLElement)
	{
		return objHTMLElement.getAttribute(MQ_BUTTON_BASE_CLASS_PROP);
	}
	
	function GetButtonHTML(strName, strOnClick, strBaseClassName, fToggle,
							strInitialState, strTooltip, strAccessKey,strCaption)
	{
		
		if (strInitialState){
			strInitialState=strBaseClassName + strInitialState;
		}else{
			strInitialState=strBaseClassName + STATE_1;
		}
		
		var strReturnString="<a class=\"" + strInitialState ;
		strReturnString+="\" href=\"#\" id=\"" +GetButtonHTMLName(strName) + "\" ";
		strReturnString+=" onclick=\"if(!m_objMqButton.IsDisabled(this)){" + strOnClick + ";}";
		
		if (fToggle){
			strReturnString+="m_objMqButton.Toggle(this,'" + strBaseClassName + "');";
		}
		
		if(!strCaption)
		{
			strCaption="";
		}
		

		strReturnString+="return false;\" accesskey=\"" + strAccessKey +
							"\" title=\"" + strTooltip + "\" " + 
							MQ_BUTTON_BASE_CLASS_PROP + "=\"" + strBaseClassName + "\" ><span style=\"display:inline-block;\" >" + strCaption + "</span><\/a>";

		
		return strReturnString;
	}

	function WriteButtonHTML(strName, strOnClick, strBaseClassName, fToggle,
							fDisabled, strTooltip, strAccessKey, objDocumentRef, strCaption)
	{
		if(!objDocumentRef){
			objDocumentRef = document;
		}
		
		objDocumentRef.write(GetButtonHTML(strName, strOnClick, strBaseClassName, fToggle,
							fDisabled, strTooltip, strAccessKey, strCaption));
	}
		
	function IsDisabled(objHTMLElement)
	{
		var blnDisabled=false;
		if(objHTMLElement){
			if (objHTMLElement.className.indexOf(STATE_DIS)>=0){
				blnDisabled=true;
			}
				
		}
		return blnDisabled;
	}

	function GetButtonHTMLName(strName)
	{
		return "a_"+ strName;
	}
					
	function GetButtonState(objHTMLElement)
	{
		if(objHTMLElement){
			if(objHTMLElement.className.indexOf(STATE_1)>=0){
				return STATE_1;
			}else{
				if(objHTMLElement.className.indexOf(STATE_2)>=0){
					return STATE_2;
				}
			}
		}
	}	
	
	function SetState(strName,sNewState)
	{
		if(m_objHTMLDocument){
			var oButton=m_objHTMLDocument.getElementById(GetButtonHTMLName(strName));
					
			if(oButton){
				if(sNewState.indexOf(STATE_1)>=0){
					oButton.className=GetButtonBaseClass(oButton) + STATE_1;
				}else{
					if(sNewState.indexOf(STATE_2)>=0){
						oButton.className=GetButtonBaseClass(oButton) + STATE_2;
					}else{
						oButton.className=sNewState;
					}
				}
			}		
		}

	}
	
	function WriteTextButtonHTML(strName, strCaption, strOnClick, strImg, intHeight, strExtraStyle, strTooltip, intWidth)
	{
		document.write(GetTextButtonHTML(strName, strCaption, strOnClick, strImg, intHeight, strExtraStyle, strTooltip, intWidth));
	}
	
	function GetTextButtonHTML(strName, strCaption, strOnClick, strImg, intHeight, strExtraStyle, strTooltip, intWidth, strButtonCSS, strButtonTextCSS)
	{
		var strHTML="";
		var strInitialState="";
		
		if(!strButtonCSS){
			strButtonCSS="HTMLTextButton";
		}
		
		if(!strButtonTextCSS){
			strButtonTextCSS="TextButton";
		}
		
		
		if(!strTooltip){
			var div = document.createElement("div");
			div.innerHTML = strCaption;
			strTooltip=div.innerText;
		}
		
		if(!strExtraStyle){
			strExtraStyle="";
		}
		if(strImg!="")
		{
			strInitialState=strButtonCSS + STATE_1
			strHTML="<div style='height:" + intHeight + "px;" + strExtraStyle +"' class='" + strButtonCSS + " " + strInitialState + "' id='" + 
						GetButtonHTMLName(strName) + "' name='" + GetButtonHTMLName(strName) + "' " + MQ_BUTTON_BASE_CLASS_PROP + "='" + strButtonCSS + "' onmouseover='if(m_objMqButton.IsTextButtonEnabled(m_objMqButton.GetButtonHTMLName(\"" + strName + "\"))){this.className=\"" + strButtonCSS + " HTMLTextButtonState1 HTMLTextButtonHover\"}' " + 
						"onmouseout='if(m_objMqButton.IsTextButtonEnabled(m_objMqButton.GetButtonHTMLName(\"" + strName + "\"))){this.className=\"" + strButtonCSS + " HTMLTextButtonState1\"}' onclick='if(m_objMqButton.IsTextButtonEnabled(m_objMqButton.GetButtonHTMLName(\"" + strName + "\"))){" + strOnClick + "}' MqTextButton='1' title='" + strTooltip + "'>" +
						"<table width='100%'>" +
						"	<tr>" +
						"		<td width='100%' align='center' style='padding:0px !important;'><table><tr><td align='right'><img src='../../theme/images/buttons/" + strImg + "' /></td>" +
						"			<td align='left' class='" + strButtonCSS + " " + strInitialState + "'><span id='lnkAction" + strName + "' style='padding-bottom:4px'>"+strCaption+"</span></td></tr></table>	" +							
						"		</td>" +
						"	</tr>" +
						"</table>" +
						"</div>";
		}else{	
			var strWidth="";
			var strHeight="";
			var strStyle="";
			strInitialState=strButtonTextCSS + STATE_1
			if(intWidth){
				if(isNaN(intWidth)){
					strWidth="width:" + intWidth + ";";
				}else{
					strWidth="width:" + intWidth+"px;";
				}
			}			
			if(intHeight){
				strHeight="height:" + intHeight+"px;'";
			}
			
			if(strWidth!=""||strHeight!=""){
				strStyle=" style='" + strWidth + strHeight + "'";
			}
			
			strHTML='<div style="padding-bottom:10px;' + strExtraStyle + '" id="' + 
							GetButtonHTMLName(strName) + '" name="' + GetButtonHTMLName(strName) + '" class="' + strInitialState + '" MqTextButton="1" ' + MQ_BUTTON_BASE_CLASS_PROP +'="' + strButtonTextCSS + '"><div class="' + strButtonTextCSS + ' ' + strInitialState + '"' + strStyle + ' onclick="if(m_objMqButton.IsTextButtonEnabled(m_objMqButton.GetButtonHTMLName(\''+strName+'\'))){' + strOnClick + '}" id="btnAction' + strName + '"' +
						 '	onmouseover="if(m_objMqButton.IsTextButtonEnabled(m_objMqButton.GetButtonHTMLName(\''+strName+'\'))){this.className=\'' + strButtonTextCSS + ' TextButtonState1 TextButtonOver\'; document.getElementById(\'lnkAction' + strName + '\').className=\'' + strButtonTextCSS + ' TextButtonState1 TextButtonOver\'}" ' +
						 '	onmouseout="if(m_objMqButton.IsTextButtonEnabled(m_objMqButton.GetButtonHTMLName(\''+strName+'\'))){this.className=\'' + strButtonTextCSS + ' TextButtonState1\'; document.getElementById(\'lnkAction' + strName + '\').className=\'' + strButtonTextCSS + ' TextButtonState1\'}" title="' + strTooltip + '">' +
						 '	<table height="100%" width="100%"><tr>' +
						 '	<td valign="middle" class="' + strButtonTextCSS + ' ' + strInitialState + '" width="100%" id="lnkAction' + strName + '">' + strCaption + 
						 '  </td></tr></table>' +
						 '	</div></div>';
		}
		
		return strHTML;
	}
	
	function HideTextButton(strName, blnHidden, objButton)
	{
		var objTextButton;
		if(objButton){
			objTextButton=objButton;
		}else{
			if(m_objHTMLDocument){
				objTextButton=m_objHTMLDocument.getElementById(strName);
			}
		}
		if(objTextButton){
			if(blnHidden){
				objTextButton.style.display="none";
				objTextButton.style.visibility="hidden";
			}else{
				objTextButton.style.display="";
				objTextButton.style.visibility="visible";
			}
		}
	}
	
	function EnableTextButton(strName)
	{
		var blnReturn = false;
		if(m_objHTMLDocument)
		{
			var objTextButton=m_objHTMLDocument.getElementById(GetButtonHTMLName(strName));
			if(objTextButton)
			{
				if (objTextButton.className.indexOf(STATE_1)<0){
					var strBaseClass=GetButtonBaseClass(objTextButton);
					objTextButton.className=strBaseClass + STATE_1;
					
					m_objHTMLDocument.getElementById("btnAction" + strName).className=strBaseClass + " " + strBaseClass + STATE_1;
					m_objHTMLDocument.getElementById("lnkAction" + strName).className=strBaseClass + " " + strBaseClass + STATE_1;
					
				}
				blnReturn = true;
			}
		}
		return blnReturn;
	}
	
	function DisableTextButton(strName)
	{
		var blnReturn = false;
		if(m_objHTMLDocument)
		{
			var objTextButton=m_objHTMLDocument.getElementById(GetButtonHTMLName(strName));
			if(objTextButton)
			{
				if (!IsDisabled(objTextButton)){
					var strBaseClass=GetButtonBaseClass(objTextButton);
					objTextButton.className=strBaseClass + STATE_DIS;
					if(strBaseClass!="HTMLTextButton")
					{
						m_objHTMLDocument.getElementById("btnAction" + strName).className=strBaseClass + " " + strBaseClass + STATE_DIS;
					}
					m_objHTMLDocument.getElementById("lnkAction" + strName).className=strBaseClass + " " + strBaseClass + STATE_DIS;
				}
				blnReturn=true;
			}
		}
		return blnReturn;
	}
	
	function IsTextButton(strName, objButton)
	{
		var blnReturn=false;
		var objTextButton;
		if(objButton){
			objTextButton=objButton;
		}else{
			if(m_objHTMLDocument){
				objTextButton=m_objHTMLDocument.getElementById(strName);
			}
		}
		
		if(objTextButton){
			blnReturn=(objTextButton.getAttribute("MqTextButton")=="1");
		}
		return blnReturn;
	}
	
	function IsTextButtonEnabled(strName)
	{
		var blnEnabled=false;
		if(m_objHTMLDocument)
		{
			var objTextButton=m_objHTMLDocument.getElementById(strName);
			if(objTextButton)
			{
				if (objTextButton.className.indexOf(STATE_1)>=0){
					blnEnabled=true;
				}
			}
		}
		return blnEnabled;
	}
	
	function SetTextButtonCaption(strName, strCaption)
	{
		var objTextButtonCaption=m_objHTMLDocument.getElementById("lnkAction" + strName);
		if(objTextButtonCaption){
			objTextButtonCaption.innerHTML=strCaption;
		}
	}

	function SetTooltip(strName, strResID)
	{
		if(m_objHTMLDocument){
			var objElement=m_objHTMLDocument.getElementById(strName);
			if(objElement){
				objElement.title=g_MqRef.RESX[strResID];
			}
		}
	}
		
	this.Toggle=Toggle;
	this.Enable=Enable;
	this.Disable=Disable;
	this.GetButtonHTML=GetButtonHTML;
	this.WriteButtonHTML=WriteButtonHTML;
	this.IsDisabled=IsDisabled;
	this.GetButtonHTMLName=GetButtonHTMLName;
	this.STATE_1=STATE_1;
	this.STATE_2=STATE_2;
	this.STATE_DIS=STATE_DIS;
	this.Select=Select;
	this.UnSelect=UnSelect;
	this.ToggleButton=ToggleButton;
	this.EnableButton=EnableButton;
	this.DisableButton=DisableButton;
	this.GetHTMLDocument=GetHTMLDocument;
	this.SetHTMLDocument=SetHTMLDocument;
	this.ChangeBaseClass=ChangeBaseClass;
	this.GetButtonBaseClass=GetButtonBaseClass;
	this.GetButtonState=GetButtonState;
	this.SetState=SetState;
	this.ShowHideButton=ShowHideButton;
	this.GetTextButtonHTML=GetTextButtonHTML;
	this.WriteTextButtonHTML=WriteTextButtonHTML;
	this.HideTextButton=HideTextButton;
	this.IsTextButton=IsTextButton;
	this.IsTextButtonEnabled=IsTextButtonEnabled;
	this.SetTextButtonCaption=SetTextButtonCaption;
	this.EnableTextButton=EnableTextButton;
	this.DisableTextButton=DisableTextButton;
	this.SetTooltip=SetTooltip;
}

function MqDebug()
{
	var mbEnableLog=false;
	
	// Start by checking if in debug mode
	ProcessMode(window);
	
	function GetEnableLog()
	{
		return mbEnableLog;
	}
	
	function SetEnableLog(bEnableLog)
	{
		mbEnableLog=bEnableLog;
	}

	function ProcessMode(oWindow)
	{
		if (oWindow){
			var oQS=new CMqQueryString(oWindow.location.search);
		    
		    if (oQS.QSVals["d"]==1){
				mbEnableLog=true;
			}else{
				mbEnableLog=false;
			}
		}
	}

	this.GetEnableLog=GetEnableLog;
	this.SetEnableLog=SetEnableLog;
	this.ProcessMode=ProcessMode;
}



function CMqQueryString(strQS)
{
	var m_varQSVals=new Array();
	var QUERY_STRING_DELIM="&";
	var QUERY_STRING_ELEMENT_DELIM="=";
	var m_objMqStr=g_MqRef.MqStr;
	

  if (strQS){
    BuildQSHashArray(strQS);
  }
  
	function Initialize(strQS)
	{
		BuildQSHashArray(strQS);
	}
	
	function GetQS(blnEncodeValues)
	{
		var strQS="";
		var oElement;
		var strValue;
		for(oElement in m_varQSVals){
		
			strValue=m_varQSVals[oElement];
			if(blnEncodeValues){
				strValue=m_objMqStr.MqEncodeURIComponent(strValue);
			}
			strQS+=oElement + QUERY_STRING_ELEMENT_DELIM + strValue + QUERY_STRING_DELIM;
		}

		if(m_objMqStr.Right(strQS,QUERY_STRING_DELIM.length)==QUERY_STRING_DELIM){
			strQS=m_objMqStr.Left(strQS,(strQS.length-QUERY_STRING_DELIM.length));
		}

		return strQS;
	}
	
	this.Initialize=Initialize;
	this.QSVals=m_varQSVals;
	this.GetQS=GetQS;
	
	function BuildQSHashArray(strQS)
	{
		var arrQSTemp;
		var lngCount;
		var arrQSElements;
		var QUESTION_MARK="?";
		var NAME_ELEMENT_INDEX=0;
		var VALUE_ELEMENT_INDEX=1;
		
		if(m_objMqStr.Left(strQS,QUESTION_MARK.length)==QUESTION_MARK){
			strQS=m_objMqStr.Right(strQS,(strQS.length-QUESTION_MARK.length));
		}
	
		if(m_objMqStr.Right(strQS,QUERY_STRING_DELIM.length)==QUERY_STRING_DELIM){
			strQS=m_objMqStr.Left(strQS,(strQS.length-QUERY_STRING_DELIM.length));
		}
		
		if(strQS.length > 0){
			arrQSTemp=strQS.split(QUERY_STRING_DELIM);
		
			for(lngCount=0; lngCount<arrQSTemp.length; lngCount++){
			
				arrQSElements=arrQSTemp[lngCount].split(QUERY_STRING_ELEMENT_DELIM);
								
				m_varQSVals[arrQSElements[NAME_ELEMENT_INDEX].toLowerCase()]=arrQSElements[VALUE_ELEMENT_INDEX];
			}	
		}
	}
}

function MqResMgr()
{
	var _me=this;
	
	function ProcessAll(oRootElem)
	{
		if (!oRootElem){
			oRootElem=document;
		}
		
		$("[translate='yes']",oRootElem).text( function( i) {
			return g_MqRef.RESX[ $(this).attr('data-res')];
			});
	}
	
	function LoadJSON( jsonRes) 
	{
		if (!g_MqRef.RESX)
		{
			g_MqRef.RESX=new Object();
		}
		
		if (Object.assign)
		{
			Object.assign(g_MqRef.RESX, jsonRes);
		}else{
			for (var attrname in jsonRes) 
			{ 
				g_MqRef.RESX[attrname] = jsonRes[attrname]; 
			}
		}
	
	}
	
	function LoadGlobalRes() 
	{
		_me.LoadJSON(JSON.parse(g_MqRef.MqFS.LoadJSONSync("/" + g_MqRef.MqFS.GetCurrentVD() + "/Localization/Resources.js.asp")));
	
	}

	function LoadViewRes( sViewPath) 
	{
		_me.LoadJSON(JSON.parse(g_MqRef.MqFS.LoadJSONSync( sViewPath + "/Localization/Resourcesv.js.asp")));
	
	}

	this.ProcessAll=ProcessAll;
	this.LoadJSON=LoadJSON;
	this.LoadGlobalRes=LoadGlobalRes;
	this.LoadViewRes=LoadViewRes;
}

function MqLogonFrm(sUserFld, sPwdFld, sLogonButtonName, oMqButton, bIsMobile)
{
	if (sUserFld){
		var _UserFld=document.getElementById(sUserFld);
	}
	if (sPwdFld){
		var _PwdFld=document.getElementById(sPwdFld);
	}
	var _sLogonButtonName=sLogonButtonName;
	var _oMqButton=oMqButton;
	
	function SetFocus(){
		try{
			if(_UserFld.value.length == 0){
				_UserFld.focus();
			}else{
				_PwdFld.focus();
			}
		}
		
		catch(e){
			// element cannot accept focus	
		}
	}

	function AdjustUI()
	{
		try{
			if(_UserFld){
				var PwdLbl=GetAssociatedLabel(_PwdFld.id);
			
				if(_UserFld.value.length >=2 || bIsMobile){
					_PwdFld.style.visibility="visible";
					if (PwdLbl){
						PwdLbl.style.visibility="visible";
					}
					_oMqButton.SetState(_sLogonButtonName,_oMqButton.STATE_1);
		
				}else{
					_PwdFld.style.visibility="hidden";
				
					if (PwdLbl){
						PwdLbl.style.visibility="hidden";
					}
				
					_oMqButton.SetState(_sLogonButtonName,_oMqButton.STATE_2);
				}
			}
		}catch(e){
		}
	}
	
	this.SetFocus=SetFocus;
	this.AdjustUI=AdjustUI;
	
	function GetAssociatedLabel(sElementID)
	{
		try{
		 	var labels = document.getElementsByTagName("label");
	            
	        for (var i = 0; i < labels.length; i++) {
	            if (sElementID==labels[i].htmlFor){
	            	return labels[i];
	            }
	        }
        }catch(e){
        }
	}

}

function MqURIOpener()
{
	var m_oMacros;
	var m_oLoadDataMgr;

	function InitForMacros(oMacros, oLoadDataMgr)
	{
		m_oMacros=oMacros;
		m_oLoadDataMgr=oLoadDataMgr;
	
	}
	
	function OpenUNC(strUNC)
	{               
		
		if (strUNC){
	
			if(m_oMacros && m_oLoadDataMgr){
				strUNC=m_oMacros.ResolveFieldMacros(strUNC,m_oLoadDataMgr,false,false);
				
			}
			        
			strUNC=g_MqRef.MqURI.GetURIFromUNC(strUNC);
			
			WriteConsole("Opening UNC as URL: " + strUNC); 
			window.open(strUNC,"_blank","toolbar=no,directories=no,resizable=yes,scrollbars=yes");
		}
		
    }
    
    this.InitForMacros=InitForMacros;
    this.OpenUNC=OpenUNC;

}

function MqMsgHelper()
{
	function DisplayMessage(strMsg)
	{
		var MSG_PART_DELIM="&";
		var IDX_MSG_VAL=0;
		var IDX_MSG_ARGS=1;
		
		if(strMsg!=""){
			var strMsgToDisplay=strMsg;
			var arrMsgParts=strMsg.split(MSG_PART_DELIM);
			if(arrMsgParts.length>IDX_MSG_VAL){
				strResString=GetResStr(g_MqRef.MqStr.PropStringDecode(arrMsgParts[IDX_MSG_VAL]));
				if(strResString!=""){
					strMsgToDisplay=g_MqRef.MqStr.FormatString(strResString,g_MqRef.MqStr.PropStringDecode(arrMsgParts[IDX_MSG_ARGS]));
				}
			}
			
			if(strMsgToDisplay!=""){
				alert(strMsgToDisplay);
			}
		}
	}
	
	function GetResStr(strString)
	{
		var strResString="";
		
		try{
			if(g_MqRef.RESX[strString]){
				strResString=g_MqRef.RESX[strString];
			}
		}catch(e){
			strResString="";
		}
		
		return strResString;
	}
	
	this.DisplayMessage=DisplayMessage;
}

//***** start initialize objects

if (!g_MqRef.MqBrowser){
  g_MqRef.MqBrowser=new CMqBrowserDetector();
}
if (!g_MqRef.MqStr){
  g_MqRef.MqStr=new MqString();
}
if (!g_MqRef.MqFS){
  g_MqRef.MqFS=new MqFiles();
}

if (!g_MqRef.MqURI){
   g_MqRef.MqURI=new CMqURIUtils();
}
if (!g_MqRef.MqArr){
   g_MqRef.MqArr=new CMqArrayMgr();
}
if (!g_MqRef.Deb){
	g_MqRef.Deb=new MqDebug();
}
if (!g_MqRef.ResMgr){
	g_MqRef.ResMgr=new MqResMgr();  
}

if (!g_MqRef.RESX){
	// Load localized resources
	g_MqRef.ResMgr.LoadGlobalRes();
	
}
if(!g_MqRef.MsgHlpr){
	g_MqRef.MsgHlpr=new MqMsgHelper();
}

if(!g_MqRef.ConfirmBox.show){
	g_MqRef.ConfirmBox=new ConfirmBox();


}
if(!g_MqRef.AlertBox.show){
	g_MqRef.AlertBox=new AlertBox();
}

//***** end initialize objects

// Global functions

function WriteConsole(strContent) {
	var wnMain=top;
	var CONTENT_DIV="jsconsole";
	var blnCreateNewWin=false;
	var objDiv;
	
	if (g_MqRef.Deb.GetEnableLog()){
    try{
        var wnConsole=wnMain.consoleRef;
        
        if (wnConsole){
            var docTmp=wnMain.consoleRef.document;
            objDiv=docTmp.getElementById(CONTENT_DIV);
        }
    }catch(e){
        blnCreateNewWin=true;
    }
    
		strContent=Date() + " : " + g_MqRef.MqStr.MqHtmlEncode(strContent);
		
		if (!wnConsole || blnCreateNewWin ){
			
			wnMain.consoleRef=window.open('/' + g_MqRef.MqFS.GetCurrentVD() + '/diagnostics/diag.htm','mqjsconsole',
				'width=1000,height=750'
				+',menubar=0'
				+',toolbar=1'
				+',status=0'
				+',scrollbars=1'
				+',resizable=1');
		 
			wnConsole=wnMain.consoleRef;
			
			var divContent=wnConsole.document.getElementById(CONTENT_DIV);
			if (divContent){
				divContent.innerHTML+=strContent;
			}
		}else{
			if (objDiv){
				objDiv.innerHTML=objDiv.innerHTML + "<br>" + strContent + "</br>";
            if (objDiv.scrollIntoView){
                objDiv.scrollIntoView(false);
            }
			}
		}
	}
}

function GetURL(lngLevel, oLevel){
	var strVD='';
	for(var c=0;c<=lngLevel;c++){
		strVD += (!oLevel ? document : oLevel).location.href.split('/')[c] + '/';	
	}	
	return strVD;
}

function IncludeScriptFile(strFile){
	var js = document.createElement("script"); 
	 
	js.type = "text/javascript"; 
	js.src = strFile; 
	
	document.body.appendChild(js);
}

// Images Related Event Handlers **********************
function onOver(strName){
	var strPath;

  var objImage=document.images["img" + strName];
  if (objImage){
	  strPath=getPath(objImage.src);

	  if (!isImageDisabled("",objImage)){
		    objImage.src=strPath+strName+"on.gif";
	  }
  }
}

function onOut(strName){
	var strPath;

  var objImage=document.images["img" + strName];
  if (objImage){
	  strPath=getPath(objImage.src);

	  if (!isImageDisabled("",objImage)){
		    objImage.src=strPath+strName+"off.gif";
	  }
  }
}


function writeImageAlt(strName,strSrc,strLink,intWidth,intHeight,blnDisabled,strAlt){
    var strJS;
    var strReturnString;
    var strLinkTemp;
    strReturnString="";
    if (strLink.length>0){
        if (strLink.substring(0,3)=="js:"){
            strJS=strLink.substring(3,strLink.length);
            strLinkTemp="#";
        }else{
            strLinkTemp=strLink;
        }
    }else{
        strLinkTemp="#";
    }
    
    strReturnString+="<a href=\"" + strLinkTemp + "\" id='a_" + strName + "' name='a_" + strName + "'";
  
    if (strJS){
      strReturnString+=(" onClick=\"if (!isImageDisabled('img"+strName+"')){" + strJS + ";return false;}\" ");
    }
    strReturnString+=" onMouseOver=\"onOver('" +strName+ "');\" ";
    strReturnString+=" onMouseOut=\"onOut('" +strName+ "');\" ";
    strReturnString+="><img name='img"+strName+"' ";
    strReturnString+="id='img"+strName+"' ";

    if (blnDisabled){
        strReturnString+="src='"+strSrc+strName.toLowerCase()+"dis.gif' ";
    }else{
        strReturnString+="src='"+strSrc+strName+"off.gif' ";
    }
    strReturnString+="width='"+intWidth+"' ";
    strReturnString+="height='"+intHeight+"' ";
    
    if (strAlt){
        if (strAlt.length>0){
            strReturnString+="alt='"+strAlt+"' title='"+strAlt+"' ";
        }else{
            strReturnString+="alt='"+strName+"' title='"+strName+"' ";
        }
    }else{
        strReturnString+="alt='"+strName+"' title='"+strName+"' ";
    }
    strReturnString+="border='0'></a>";
    
    return strReturnString;
}
	
function disableImage(strImage){
	var objImage;
	var blnReturn;

	blnReturn=true;

  objImage=document.images["img" + strImage];
	
	if (objImage){
		var strPath;
			
		strPath=getPath(objImage.src);
		objImage.src=strPath+strImage+"dis.gif";
    objImage.style.cursor = "default";
    
	}else{
		blnReturn=false;
	}
		
	return blnReturn;
}
	
function enableImage(strImage){
	var objImage;
	var blnReturn;
		
	blnReturn=true;

  objImage=document.images["img" + strImage];
	if (objImage){
		var strPath;

		strPath=getPath(objImage.src);
		objImage.src=strPath+strImage+"off.gif";
    objImage.style.cursor = "";
	}else{
		blnReturn=false;
	}
		
	return blnReturn;
}
	
function disableSCC(){

	parent.objControlsUi.disableControlSCC();
}

function MqStyles()
{
	function LoadJS(strFilename)		//Add JS file to the HEAD
	{
		var fileref=document.createElement('script')
		fileref.setAttribute("type","text/javascript")
		fileref.setAttribute("src", strFilename)
		if (typeof fileref!="undefined")
		{
			document.getElementsByTagName("head")[0].appendChild(fileref)
		}
	}
	
	function LoadCSS(strFilename)		//Add CSS file to the HEAD
	{
		var fileref=document.createElement("link")
		fileref.setAttribute("rel", "stylesheet")
		fileref.setAttribute("type", "text/css")
		fileref.setAttribute("href", strFilename)
		if (typeof fileref!="undefined")
		{
			document.getElementsByTagName("head")[0].appendChild(fileref)
		}
	}
	
	this.LoadJS = LoadJS;
	this.LoadCSS = LoadCSS;
}