var winMain = parent;

function Pressed()
{
    if(window.event.keyCode == 13){
		SaveGroup();
	}else{
		if(window.event.keyCode == 27){
			winMain.CloseChildWindow(WIN_ADD_GROUP);
		}
	}
}

function Form_OnLoad()
{
	HandleUI();
	
	if(m_lngGroupID!=""){
		LoadVals();
	}
	
	SetFocus();
}

function ToggleChk(strChkID)
{
	var objChk=document.getElementById(strChkID);
	
	if(objChk){
		objChk.checked=!objChk.checked;
	}
}

function HandleUI()
{
	if(m_lngGroupID!=""){
		var objTitle=document.getElementById("HeaderText");
		if(objTitle){
			objTitle.innerHTML="Edit Business Rule";
		}
		var objTypeLst=document.getElementById("cboActionType");
		if(objTypeLst){
			objTypeLst.disabled=true;
		}
	}
}

function LoadVals()
{
	SetGroupName(m_strName);	
	SetDescription(m_strDesc); 
	SetType(m_lngType);
	HandleUIByType();
	SetConditions(m_strCondFields);
	SetActions(m_strActFields);
	SetOnChange(m_blnOnChange);
	SetEnabled(m_blnEnabled);
}

function SetFocus(){
	var objTxtGroupName=document.getElementById("txtGroupName");
	if(objTxtGroupName){
		objTxtGroupName.focus(); 
	}
}

function SaveGroup(){
	var strGroupName=GetGroupName();
	var strAvailParams=GetType();
	
	if(!(strGroupName.length > 0)){
		alert(MSG_ENTER_GROUP_NAME);
		SetFocus();	
	}else if (!(strAvailParams.length > 0)){
		alert(MSG_SELECT_PARAMETER);
	}else{
		var objRequest=winMain.mobjHTTPrequest;

		var strCurrentProject=winMain.GetProject();
	
		var strCurrentLocation=winMain.mstrCurrentLocation;
		
		var strDescription=GetDescription();
	
		var strCondFields=GetConditions();
		var strActionFields=GetActions();
		var blnEnabled=GetEnabled();
		var blnOnChange=GetOnChange();
		
		var strAddGroup = objRequest.Get(strCurrentLocation + "MqWorkflow.ASP?WCI=SaveTmpl&CurrentProject=" 
							+  g_MqRef.MqStr.MqEncodeURIComponent(strCurrentProject) + 
							"&GroupID=" + m_lngGroupID + "&GroupName=" + g_MqRef.MqStr.MqEncodeURIComponent(strGroupName) + 
							"&Description=" + g_MqRef.MqStr.MqEncodeURIComponent(strDescription) +
							"&AvailParams=" + g_MqRef.MqStr.MqEncodeURIComponent(strAvailParams) + 
							"&State=" + blnEnabled + "&Trigger=" + blnOnChange + 
							"&CF=" + g_MqRef.MqStr.MqEncodeURIComponent(strCondFields) + 
							"&AF=" + g_MqRef.MqStr.MqEncodeURIComponent(strActionFields), "ADMIN");

		if (strAddGroup>0){
			
			winMain.GetGroupsByProject(0,strAddGroup);
			winMain.OpenToLastGroup(strAddGroup);
			winMain.CloseModalWindow()
		}else{
			if (strAddGroup!=HTTP_REQ_CANCEL_PROCESS) {
				alert(strAddGroup);
			}
		}
		
	}
}

function GetGroupName(){
	var strGroupName="";
	var objTxtGroupName=document.getElementById("txtGroupName");
	
	if(objTxtGroupName){
		strGroupName=objTxtGroupName.value;
	}
	return strGroupName;
}

function SetGroupName(strGroupName){
	var objTxtGroupName=document.getElementById("txtGroupName");
	
	if(objTxtGroupName){
		strGroupName=objTxtGroupName.value=strGroupName;
	}
}

function GetDescription(){
	var strDescription="";
	var objTxtGroupDesc=document.getElementById("txtGroupDesc");
	if(objTxtGroupDesc){
		strDescription=objTxtGroupDesc.value;
	}
	return strDescription;
}

function SetDescription(strDescription){
	var objTxtGroupDesc=document.getElementById("txtGroupDesc");
	if(objTxtGroupDesc){
		objTxtGroupDesc.value=strDescription;
	}
}

function GetType()
{
	var strType="";
	var objTypeLst=document.getElementById("cboActionType");
	if(objTypeLst){
		var lngType=objTypeLst.options[objTypeLst.selectedIndex].id;
		
		if(lngType==ACTION_TYPE_POSS_VAL){
			strType="PossVals";
		}
	
		if(lngType==ACTION_TYPE_SET_VAL){
			strType="SetVals";
		}
		
		if(lngType==ACTION_TYPE_HIDDEN_FLDS){
			strType="HidFlds";
		}
		
		if(lngType==ACTION_TYPE_REQ_FLDS){
			strType="ReqFlds";
		}
		
		if(lngType==ACTION_TYPE_HIDDEN_TABS){
			strType="HidTabs";
		}
		
		if(lngType==ACTION_TYPE_DISABLED_FLDS){
			strType="DisFlds";
		}
		
		if(lngType==ACTION_TYPE_DISABLED_TICKET){
			strType="DisRec";
		}
	}
	return strType;
}

function SetType(lngType)
{
	var objTypeLst=document.getElementById("cboActionType");
	if(objTypeLst){
		for(x=0;x<objTypeLst.options.length;x++){
			if(objTypeLst.options[x].id==lngType){
				objTypeLst.options[x].selected=true;
				break;
			}
		}
	}
}

function HandleUIByType()
{
	var objTypeLst=document.getElementById("cboActionType");
	if(objTypeLst){
		var lngType=objTypeLst.options[objTypeLst.selectedIndex].id;
		var blnShowActionFlds=false;
		var blnDefaultOnChange=true;
		
		if(lngType==ACTION_TYPE_POSS_VAL || lngType==ACTION_TYPE_SET_VAL){
			blnShowActionFlds=true;
		}
		
		if(lngType==ACTION_TYPE_POSS_VAL){
			blnDefaultOnChange=false;
		}
		
		var objActionFlds=document.getElementById("ActionFlds");
		
		if(objActionFlds){
			if(blnShowActionFlds){
				objActionFlds.style.visibility="visible";
			}else{
				SetActions("");
				objActionFlds.style.visibility="hidden";
			}
		}
		
		SetOnChange(blnDefaultOnChange);
	}
}

function GetConditions()
{
	return GetFieldIDs(1);
}

function SetConditions(strConditionFields)
{
	var arrSelectedValues=strConditionFields.split(";");
	
	SetFieldValue(1, null, arrSelectedValues);
}

function GetActions()
{
	return GetFieldIDs(2);
}

function SetActions(strActionFields)
{
	var arrSelectedValues=strActionFields.split(";");
	
	SetFieldValue(2, null, arrSelectedValues);
}

function GetEnabled()
{
	var blnReturn=true;
	var objEnabledChk=document.getElementById("chkState");
		
	if(objEnabledChk){
		blnReturn=objEnabledChk.checked;
	}
	
	if(blnReturn){
		return "1";
	}else{
		return "0";
	}
}

function SetEnabled(blnEnabled)
{
	var objEnabledChk=document.getElementById("chkState");
		
	if(objEnabledChk){
		objEnabledChk.checked=blnEnabled;
	}
}

function GetOnChange()
{
	var blnReturn=true;
	var objOnChangeChk=document.getElementById("chkTrigger");
		
	if(objOnChangeChk){
		blnReturn=objOnChangeChk.checked;
	}
	
	if(blnReturn){
		return "1";
	}else{
		return "0";
	}
}

function SetOnChange(blnOnChange)
{
	var objOnChangeChk=document.getElementById("chkTrigger");
		
	if(objOnChangeChk){
		objOnChangeChk.checked=blnOnChange;
	}
}


function MqOpenURL(strURL,strName, strFeatures,blnGetIDText,blnAsChildWin, blnAsModalWin, lngWidth, lngHeight)
{               
	var MAX_URL_LEN=2020;
	if (!strName){
		strName="_blank";
	}
				
	if (!strFeatures){
		strFeatures="toolbar=no,directories=no,resizable=yes,scrollbars=yes";
	}
				
			
		var objURIUtils=new CMqURIUtils();
		if(objURIUtils){
			strURL=objURIUtils.AddURIProtocol(strURL);
		}
		if (strURL.length>MAX_URL_LEN){
			strURL=strURL.substr(0,MAX_URL_LEN);
		}
		if(blnAsChildWin){
			if(blnAsModalWin){
				OpenModalWindow(strURL, lngWidth, lngHeight, false);
			}else{
				OpenChildWindow(strURL,strName,strFeatures);
			}
		}else{
			window.open(strURL,strName,strFeatures);
		}
}
		
function AddURLButton(strURL,strCSSClassName,strFieldID, strFieldName, objDocumentRef, objCensusMainRef)
{
	var strTooltipButton="";
	var URL_BUTTON_NAME="RC";
	var RC_CSS_CLASS_NAME="RemoteControl";
	var strURLButtonName;
	var objString=new MqString();
	var USER_DETAILS_CLASS_NAME ="UserDetails";
	var BROWSE_ALT_CHOICE_LIST_CLASS_NAME ="BrowseAlternateChoiceList";
	var strButtonAction="MqOpenURL('"+strURL+"')";
	var strButtonNamePostfix;
	
	if (!objCensusMainRef) {
		objCensusMainRef = parent;
	}
	
	if (RC_CSS_CLASS_NAME==objString.Left(strCSSClassName,RC_CSS_CLASS_NAME.length)){
		strTooltipButton=g_MqRef.RESX['TITLE_START_REMOTE_CONTROL'];
	}else{			
		if(USER_DETAILS_CLASS_NAME.toLowerCase()==objString.Left(strCSSClassName,USER_DETAILS_CLASS_NAME.length).toLowerCase()){
			strTooltipButton=g_MqRef.RESX['TITLE_USER_DETAILS'];
			strButtonAction=strURL;
		}else{	
			if(BROWSE_ALT_CHOICE_LIST_CLASS_NAME.toLowerCase()==objString.Left(strCSSClassName,BROWSE_ALT_CHOICE_LIST_CLASS_NAME.length).toLowerCase()){
				strTooltipButton=g_MqRef.RESX['TITLE_SELECT_VALUE'];
				strButtonAction=strURL;
				strButtonNamePostfix="_SelVal";
			}else{
				strTooltipButton=g_MqRef.RESX['TITLE_CONNECT_TO_WEB_ADDRESS'];
			}
		}
	}
			
	if(m_objMqButton){	
		if(strFieldName){
			if(strButtonNamePostfix){
				strURLButtonName=strFieldName+strButtonNamePostfix;
			}else{
				strURLButtonName=URL_BUTTON_NAME+strFieldName;
			}
		}else{
			strURLButtonName=URL_BUTTON_NAME+strFieldID;		
		}
		
		m_objMqButton.WriteButtonHTML(strURLButtonName,strButtonAction,strCSSClassName,false,m_objMqButton.STATE_1,strTooltipButton, null, objDocumentRef);
	}
}

function LoadLargeListOrCombo(lngFieldID, strFieldCaption, strSearchResultsURL, strTableName, blnAutoComplete, lngRecordsPerPage, strFieldName, blnHideAddNewButton, lngWidth, lngHeight, blnMultiSelect)
{ 
	
	var blnShowWin=false;
	if(parent){
		if(parent.objRecord){
			if(parent.objRecord.GetRecordId() > 0){
				blnShowWin=true;
			}else{
				blnShowWin=false;
				if(parent.objFeatures){
					if(parent.objFeatures.getFeature(parent.FEATURE_SUBMIT)){
						blnShowWin=true;
					}
				}
			}
		}else{
			blnShowWin=true;
		}
	}
			
	if(blnShowWin){
		var arrSelectedIDs;
		var arrSelectedValues;
		var fnSetValue=SetFieldValue;
		var strWorkflowValues="";
		var objHTMLElement;
		var strSelectedValue=GetFieldValue(lngFieldID);
		if(strSelectedValue!=""){
			arrSelectedValues=strSelectedValue.split(";");
		}
		var strSelectedIDs=GetFieldIDs(lngFieldID);
		if(strSelectedIDs!=""){
			arrSelectedIDs=strSelectedIDs.split(";");
		}
		
		InitLookupItemVals(lngFieldID, arrSelectedIDs, arrSelectedValues, fnSetValue, blnMultiSelect, strFieldCaption, strWorkflowValues, strSearchResultsURL, blnAutoComplete, lngRecordsPerPage, strFieldName, blnHideAddNewButton);
					
		if(!lngWidth){
			if(blnMultiSelect){
				lngWidth=780;
			}else{
				lngWidth=650;
			}
		}
		if(!lngHeight){
			if(blnMultiSelect){
				lngHeight=580;
			}else{
				lngHeight=500;
			}
		}
		var strWinFeatures=GetWinFeaturesToCenter(lngWidth, lngHeight); 

		if(!blnAutoComplete){
			if(blnMultiSelect){
				MqOpenURL(m_strPathToAdminHTML + "TmplLookupItemMultiSelect.htm?TBL=" + g_MqRef.MqStr.MqEncodeURIComponent(strTableName) + "&FID=" + lngFieldID,"ChoicesList"+lngFieldID+m_strWinID,"scrollbars=no,resizable=yes,toolbar=no,directories=no" + strWinFeatures, false, true, true, lngWidth, lngHeight);
			}else{
				MqOpenURL(m_strPathToAdminHTML + "TmplLookupItem.htm?TBL=" + g_MqRef.MqStr.MqEncodeURIComponent(strTableName) + "&FID=" + lngFieldID,"ChoicesList"+lngFieldID+m_strWinID,"scrollbars=no,resizable=yes,toolbar=no,directories=no" + strWinFeatures, false, true, true, lngWidth, lngHeight);
			}
		}else{
			return m_strPathToAdminHTML + "TmplLookupItemCompact.htm?TBL=" + g_MqRef.MqStr.MqEncodeURIComponent(strTableName) + "&FID=" + lngFieldID;
		}
	}
}

function SetFieldValue(lngFieldID, arrSelectedIDs, arrSelectedValues)
{
	var selectedValues="";
	if(arrSelectedValues){
		for (var i=0; i < arrSelectedValues.length; i++)
		{
			if (i > 0){
				selectedValues += DEFAULT_VALUE_DELIM;
			}
						
			selectedValues += g_MqRef.MqStr.MqDecodeURIComponent(arrSelectedValues[i]);
		}
	}
	
	var strCtrl="";
	
	if(lngFieldID==1){
		strCtrl="CondFields";
		if(arrSelectedIDs){
			m_strCondFieldIDs=arrSelectedIDs.join(";");
		}	
		if(arrSelectedValues){
			m_strCondFields=arrSelectedValues.join(";");
		}	
	}else{
		if(lngFieldID==2){
			strCtrl="ActionFields";
			if(arrSelectedIDs){
				m_strActFieldIDs=arrSelectedIDs.join(";");
			}
			if(arrSelectedValues){
				m_strActFields=arrSelectedValues.join(";");
			}
		}
	}
	
	if(strCtrl!=""){
		var objCtrl=document.getElementById(strCtrl);
		
		if(objCtrl){
			var objFormElement=new CMqFormElement();
			objFormElement.SetValue(selectedValues,false,objCtrl,CTRL_TYPE_LARGE_LIST);
		}
	}
}


function GetFieldIDs(lngFieldID)
{
	var selectedValues="";

	
	if(lngFieldID==1){
		selectedValues=m_strCondFieldIDs;
	}else{
		if(lngFieldID==2){
			selectedValues=m_strActFieldIDs;
		}
	}
	return selectedValues;
}

function GetFieldValue(lngFieldID)
{
	var selectedValues="";

	
	if(lngFieldID==1){
		selectedValues=m_strCondFields;
	}else{
		if(lngFieldID==2){
			selectedValues=m_strActFields;
		}
	}
	return selectedValues;
}