function MqCustomCode(){
	// These functions are customizable. You can add your own 
	// custom code in this sections to modify Web view behavior.
	//
	//	Examples of customizations implemented through this MqCustomCode:	
	//		+ Memo fields Timestamp 
	//		+ Workflow
	//		+ Dependent fields
	//		+ Custom actions when saving, canceling, or creating a new record
	//
	
	var strCurrentLocation=location.protocol+"//"+location.hostname + ":" + location.port+getPath(location.pathname);
	var DEP_PREFIX_MEMO_FIELD="mem";
	var m_intTSSubstateFldID=21; //Usually Substate;
	var DEP_CATEGORY_FIELD="cbo_23_cboType";
	var CONTEXT="Record.document.Record";
	var FLD_PLACE_HOLDER = "<PlaceHolderDontSaveValue>";
	var m_objContext;
	var m_objContextFrame;
	var mobjViewFields;
	var m_objTSFormatter;
	var mblnAddWorkflowRules=true;
	var m_arrDupFldIDs=new Array();
	var m_arrDupFldLastVisibleTabIDs=new Array();
	var m_WVExtensions=new MqWVExtensions();
	
	// Change the size of the array to according to the number of
	// dependent fields or workflow rules defined.
	var m_strTimestampFields="";
	var TIMESTAMP_SEP=";";
	var TIMESTAMP_PAIR_SEP=",";
	
	function GetContextDoc()
	{
		if(!m_objContext){
			if(Record){
				if(Record.document){
					m_objContext=Record.document;
				}
			}
		}
		return m_objContext;
	}
	
	function GetContextFrame()
	{
		if(!m_objContextFrame){
			if(Record){
				m_objContextFrame=Record;
			}
		}
		return m_objContextFrame;
	}
	
	function SetViewFields(objViewFields)
	{
		mobjViewFields=objViewFields;
	}
	
	
	function addNewBefore()
	{
		// this is called before we call the server
		// to get a new record id and filling the
		// form with empty data
		var blnAdd;
		
		blnAdd=true;
		
		// Return value:
		//		true if you want to add the new record
		//		false if you don't want to add the new record
		
		if(blnAdd){
			if (m_WVExtensions)
			{
				var objExtHandler=m_WVExtensions.addNewBefore();
				
				if(objExtHandler){
					if(objExtHandler.GetCancelProcess()){
						var strMsg=objExtHandler.GetErrorMsg();
						if(strMsg!=""){
							alert(strMsg);
						}
						blnAdd=false;
					}
				}
			}
		}
		
		return blnAdd;
	}
	
	function addNewAfter()
	{
		// this is called when finishing the treatment
		// of getting a new record id
		
		if (m_WVExtensions)
		{
			m_WVExtensions.addNewAfter();
		}
	}
	
	function saveBefore(lngRecordId)
	{
		// this is called before saving the current 
		// record and validating the required fields
		var blnSave=true;
		
		//if you want to prompt before saving, uncomment the next line
		//blnSave=window.confirm(g_MqRef.MqStr.Format(MSG_SAVE_CHANGES_TO_ISSUE,lngRecordId));
		// Return value:
		//		true if you want to save
		//		false if you don't want to save
		if(blnSave){
			if (m_WVExtensions)
			{
				var objExtHandler=m_WVExtensions.saveBefore();
				if(objExtHandler){
					if(objExtHandler.GetCancelProcess()){
						var strMsg=objExtHandler.GetErrorMsg();
						if(strMsg!=""){
							alert(strMsg);
						}
						blnSave=false;
					}
				}
			}
		}
		return blnSave;
	}
	
	function saveAfter()
	{
		// this is called after saving the record
		// and enabling the control buttons
		
		if (m_WVExtensions)
		{
			m_WVExtensions.saveAfter();
		}
	}
	
	function cancelBefore(bSilent,blnExistingRecord)
	{
		// this is called before cancelling the
		// changes to the current record
		var blnCancel=true;
		
		if (!bSilent){
			if (blnExistingRecord){
				blnCancel=window.confirm(MSG_CANCEL_CHANGES_TO_ISSUE);
			}else{
				blnCancel=window.confirm(MSG_CANCEL_NEW_ISSUE);
			}
			// Return value:
			//		true if you want to cancel
			//		false if you don't want to cancel
		}
		
		if(blnCancel){
			if (m_WVExtensions)
			{
				var objExtHandler=m_WVExtensions.cancelBefore();
				
				if(objExtHandler){
					if(objExtHandler.GetCancelProcess()){
						var strMsg=objExtHandler.GetErrorMsg();
						if(strMsg!=""){
							alert(strMsg);
						}
						blnCancel=false;
					}
				}
			}
		}
		
		return blnCancel;
	}
	
	function cancelAfter()
	{
		// this is called after cancelling the changes
		// (reloading the good database data)
		if (m_WVExtensions)
		{
			m_WVExtensions.cancelAfter();
		}
	}
	
	function submitBefore()
	{
		// this is called before submitting the data
		var blnSubmit;
		
		blnSubmit=true;
		
		// Return value:
		//		true if you want to submit
		//		false if you don't want to submit
		
		if(blnSubmit){
			if (m_WVExtensions)
			{
				var objExtHandler=m_WVExtensions.submitBefore();
				
				if(objExtHandler){
					if(objExtHandler.GetCancelProcess()){
						var strMsg=objExtHandler.GetErrorMsg();
						if(strMsg!=""){
							alert(strMsg);
						}
						blnSubmit=false;
					}
				}
			}
		}
		
		return blnSubmit;
	}
	
	function submitAfter(lngRecordId)
	{
		var blnRedirect=true;
		// this is called after submitting the data
		var arrResult=lngRecordId.split(";");
		if (Number(arrResult[0])>0){
			if (m_WVExtensions)
			{
				var objExtHandler=m_WVExtensions.submitAfter(lngRecordId);
				if(objExtHandler){
					if(objExtHandler.GetCancelProcess()){
						var strMsg=objExtHandler.GetErrorMsg();
						if(strMsg!=""){
							alert(strMsg);
						}
						blnRedirect=false;
					}
				}
			}
			
			if(blnRedirect){
				var strUrlPath=strCurrentLocation + "../ASP/ExitCensusSession.asp?";		
				//exit the session
				var strReturnVal = objRequest.Get(strUrlPath);
		
				var lngSrcFldID=g_MqRef.MqStr.GetQueryStringValue(location.search, "SrcFld");
			
				window.location = "confirm.htm?ID=" + lngRecordId + "&SrcFld=" + lngSrcFldID;
			}
		}else{
			g_MqRef.MsgHlpr.DisplayMessage(lngRecordId);
		}
	}
	
	function BatchSubmitBefore()
	{
		// this is called before batch submitting the data
		var blnSubmit;
		
		var strNames=g_MqRef.MqStr.GetQueryStringValue(location.search, "Nms");
		var regExp=new RegExp(";","g");
		strNames=strNames.replace(regExp,"\n");

		blnSubmit=window.confirm("Are you sure you want to terminate the following employees?\n\n" + strNames);
		
		// Return value:
		//		true if you want to submit
		//		false if you don't want to submit
		
		if(blnSubmit){
			if (m_WVExtensions)
			{
				var objExtHandler=m_WVExtensions.BatchSubmitBefore();
				
				if(objExtHandler){
					if(objExtHandler.GetCancelProcess()){
						var strMsg=objExtHandler.GetErrorMsg();
						if(strMsg!=""){
							alert(strMsg);
						}
						blnSubmit=false;
					}
				}
			}
		}
		return blnSubmit;
	}
	
	function BatchSubmitAfter(strReturn)
	{
		if(strReturn==""){
			// this is called after batch submitting the data
			if (m_WVExtensions)
			{
				m_WVExtensions.BatchSubmitAfter();
			}
				
			var strUrlPath=strCurrentLocation + "../ASP/ExitCensusSession.asp?";		
			//exit the session
			var strReturnVal = objRequest.Get(strUrlPath);
	
			window.location = "confirm.htm";
		}else{
			g_MqRef.MsgHlpr.DisplayMessage(strReturn);
		}
	}
	
	function copyBefore(bSilent, lngIssueID)
	{
		// this is called before we call the server
		// to get a new issue id and filling the
		// form with copied issue data
		if (bSilent){
			return true;
		}else{
			var blnCopy=window.confirm(g_MqRef.MqStr.Format(MSG_CONFIRM_COPY_ISSUE,lngIssueID));
			
			// Return value:
			//		true if you want to copy the issue
			//		false if you don't want to copy the issue
			
			if(blnCopy){
				if (m_WVExtensions)
				{
					var objExtHandler=m_WVExtensions.copyBefore();
					
					if(objExtHandler){
						if(objExtHandler.GetCancelProcess()){
							var strMsg=objExtHandler.GetErrorMsg();
							if(strMsg!=""){
								alert(strMsg);
							}
							blnCopy=false;
						}
					}
				}
			}
			
			return blnCopy;
		}
	}
	
	function copyAfter()
	{
		// this is called when finishing the treatment
		// of getting a new issue id and copying an existing issue
		
		if (m_WVExtensions)
		{
			m_WVExtensions.copyAfter();
		}
	}

	function deleteBefore(bSilent, lngIssueID)
	{
		// this is called before we call the server
		// to to delete the issue
		var blnDelete;
		
		blnDelete=true;
				
		// Return value:
		//		true if you want to delete the issue
		//		false if you don't want to delete the issue
		
		if(blnDelete){
			if (m_WVExtensions)
			{
				var objExtHandler=m_WVExtensions.deleteBefore(lngIssueID);
				
				if(objExtHandler){
					if(objExtHandler.GetCancelProcess()){
						var strMsg=objExtHandler.GetErrorMsg();
						if(strMsg!=""){
							alert(strMsg);
						}
						blnDelete=false;
					}
				}
			}
		}
		
		return blnDelete;
	}
	
	function deleteAfter()
	{
		// this is called when finishing the treatment
		// of deleting an existing issue
		
		if (m_WVExtensions)
		{
			m_WVExtensions.deleteAfter();
		}
	}
	
	function onConflict(lngRecordId)
	{
		// this is called when a conflit occurs; when the
		// current record id was modified between the time
		// that you get the record information and the time
		// that you want to save
		var blnOverwrite=window.confirm(g_MqRef.MqStr.Format(MSG_ON_CONFLICT,lngRecordId));
		
		// Return value:
		//		true if you want to overwrite
		//		false if you want to cancel the changes
		return blnOverwrite;
	}

	function reloadAfterConflitCancel(lngRecordId)
	{
		// this is called when a conflit occurs; when the
		// current record id was modified between the time
		// that you get the record information and the time
		// that you want to save
		var blnReload;

		blnReload=confirm(MSG_DROP_CHANGES_OR_COPY_TO_CLIPBOARD);
		
		// Return value:
		//		true:  if you want to reload the datas 
		//			   from the database
		//		false: if you want to keep the current data
		return blnReload;
	}

	function getCodeBeforeField(strFieldName,strParam)
	{
		var strReturn="";

		// Return value:
		//	strReturn:  Html Code To Write
		return strReturn;
	}

	function getCodeAfterField(strFieldName,strParam, objTSFormatter,strTgtCtl2,strChkCtl2)
	{
		var strReturn="";

		if (strFieldName.substring(0,3)==DEP_PREFIX_MEMO_FIELD){
			if (strParam.length){
				
				if (this.TimeStampFields!==""){
					this.TimeStampFields+=TIMESTAMP_SEP + escape(strFieldName) + TIMESTAMP_PAIR_SEP + escape(strParam);
				}else{
					this.TimeStampFields+=escape(strFieldName) + TIMESTAMP_PAIR_SEP + escape(strParam);
				}
				
				if(strTgtCtl2!=="" && typeof(strTgtCtl2)!=="undefined"){
					this.TimeStampFields+= TIMESTAMP_PAIR_SEP + escape(strTgtCtl2) + TIMESTAMP_PAIR_SEP + escape(strChkCtl2);
				}
            if (objTSFormatter){
                m_objTSFormatter=objTSFormatter;
            }
			}else{
				strReturn=getHtmlCodeForTimeStampMemoFieldTarget(strFieldName);			
			}
		}
		
		// Return value:
		//	strReturn:  Html Code To Write
		return strReturn;
	}

	function getSubmitControlCaption()
	{
		return "&nbsp;Next&nbsp;";
	}
	
	function getIntervalForSummaryList()
	{
		return 15000;
	}
	

	function MoveControlData(strSourceControl,strTargetControl, strTgtCtl2, strTgtChk2)
	{
		var strReturn="";
		var objContext=GetContextDoc();
		if(objContext){
			var objSourceControl=objContext.getElementById(strSourceControl);
			var objTargetControl=objContext.getElementById(strTargetControl);
			if(strTgtCtl2!=="" && typeof(strTgtCtl2)!=="undefined"){
				var objTgtCtl2=objContext.getElementById(strTgtCtl2);
			}
			var objFormElement=new CMqFormElement();
			var strSourceContent = objFormElement.GetValue(false, objSourceControl);
						
			if ((objSourceControl) && (objTargetControl)){
				if(mobjViewFields){
					var lngSourceFieldID=mobjViewFields.GetFieldIDByBoundCtrl(objSourceControl.id);
					var lngTargetFieldID=mobjViewFields.GetFieldIDByBoundCtrl(objTargetControl.id);
					if (objTgtCtl2){
						var lngTgtFldID2=mobjViewFields.GetFieldIDByBoundCtrl(objTgtCtl2.id);
					}
				}
				var strAppendVal = objFormElement.GetValueFromCustomAttribute(objTargetControl,"MqAppendVal");
				var strAddTimestamp = objFormElement.GetValueFromCustomAttribute(objTargetControl,"MqTimestamp");
				
				if (strSourceContent!==""){
					if (lngSourceFieldID){
						if(strAddTimestamp=="1"){
							//add the timestamp if needed
							strSourceContent=getTSContents(objSourceControl, null, objFormElement);
						}
						
						strReturn=lngSourceFieldID + "=" + g_MqRef.MqStr.PropStringEncode(FLD_PLACE_HOLDER) + "&";
						
						if(strAppendVal=="1"){
							//move the source val to the target val
							strReturn+=lngTargetFieldID + "=" + g_MqRef.MqStr.PropStringEncode(strSourceContent) + "&";
						}else{
							//append now
							var strTargetContent = objFormElement.GetValue(false, objTargetControl);
							objFormElement.SetValue(strSourceContent + strTargetContent, 
														false, objTargetControl);
						}
					}
					if (lngTgtFldID2){
						var bCopy=true;
						if (objTgtCtl2){
							var strAppendVal2 = objFormElement.GetValueFromCustomAttribute(objTgtCtl2,"MqAppendVal");
							var strAddTimestamp2 = objFormElement.GetValueFromCustomAttribute(objTgtCtl2,"MqTimestamp");
						}
						if(strTgtChk2!=="" && typeof(strTgtChk2)!=="undefined"){
							var objTgtChk2=objContext.getElementById(strTgtChk2);
							if (objTgtChk2.checked==false){
								bCopy=false;
							}
						}
						
						if (bCopy){
							if(strAppendVal2=="1"){
								//move the source val to the target val
								strReturn+=lngTgtFldID2 + "=" + g_MqRef.MqStr.PropStringEncode(strSourceContent) + "&"
							}else{
								//append now
								var strTargetContent2 = objFormElement.GetValue(false, objTgtCtl2);
								objFormElement.SetValue(strSourceContent + strTargetContent2, 
														false, objTgtCtl2);
							}
						}
					}
					
					//If the field isn't the new Activity Log type, then wipe out the input.
					//Otherwise, we can leave the input intact - in case the save fails and they want to edit this text.(Bug 3988)
					if(!(strAppendVal=="1")){
						objFormElement.SetValue("", false, objSourceControl);
					}
				}else{
					if(strAppendVal=="1"){
						strReturn=lngSourceFieldID + "=" + g_MqRef.MqStr.PropStringEncode(FLD_PLACE_HOLDER) + "&" + lngTargetFieldID + "=&";
					}
				}
			}		
		}
		return strReturn;
	}
		
	function getTSContents(objSourceControl , objTargetControl, objFormElement)
	{
		var blnDefaultTS=true;
		var strNewTSText="";
		var strNewLineChar="\r";
				
		if(objTargetControl){
			if(objFormElement.GetControlType(objTargetControl)==CTRL_TYPE_DIV){
				strNewLineChar="<br />";
			}
		}
		
		if (m_objTSFormatter){
		    if (m_objTSFormatter.GetTimeStamp){
		        try{
		            strNewTSText=m_objTSFormatter.GetTimeStamp(objSourceControl , objTargetControl);
		            blnDefaultTS=false;
		        }catch(e){}
		    }
		}
    
		if (blnDefaultTS){
		    
		    strNewTSText="|*Mq_TimeStamp*|                    " + getUsername() + "   (<ValOfField>" + m_intTSSubstateFldID + "</ValOfField>)";
		    
			var objMacros=new CMqMacros();
			if(objMacros){
				strNewTSText=objMacros.ResolveFieldMacros(strNewTSText,m_objLoadDataMgr,false, true);
			}
			
		    strNewTSText+=strNewLineChar + objFormElement.GetValue(false, objSourceControl) + strNewLineChar + strNewLineChar + 
							objFormElement.GetValue(false, objTargetControl) + strNewLineChar;
							
		}
		return strNewTSText;
		
	}

	function CommitTimestamp()
	{
		var arrTimeStampPairs,intCount;
		var SOURCE_FIELD_ID=0;
		var TARGET_FIELD_ID=1;
		var TGT_FLD2=2;
		var TGT_COND2=3;
		var strReturn="";
		
		var arrTimeStampFields=this.TimeStampFields.split(TIMESTAMP_SEP);
		for(intCount=0; intCount<arrTimeStampFields.length; intCount++){
			arrTimeStampPairs=arrTimeStampFields[intCount].split(TIMESTAMP_PAIR_SEP);
			
			if(arrTimeStampPairs[SOURCE_FIELD_ID]){
				if(arrTimeStampPairs[TARGET_FIELD_ID]){
					strReturn=strReturn + this.MoveControlData(unescape(arrTimeStampPairs[SOURCE_FIELD_ID]),unescape(arrTimeStampPairs[TARGET_FIELD_ID]),unescape(arrTimeStampPairs[TGT_FLD2]),unescape(arrTimeStampPairs[TGT_COND2]));
				}
			}
		}
	
		return strReturn;
	}
	
	function AddWorkflowRules(objWorkflowRules,objFieldCollection, strHTMLContainer, objMqAutoList,objDisplayElements, blnOverrideAddWorkflowRules){
	
		if(blnOverrideAddWorkflowRules){
			mblnAddWorkflowRules=blnOverrideAddWorkflowRules;
		}

		if(objWorkflowRules && objFieldCollection && mblnAddWorkflowRules){
			var FLD_ID_OWNER="<Mq:FieldID>nUserID</Mq:FieldID>";
			var FLD_ID_WORK_TEAM="<Mq:FieldID>nAssignedWorkTeam</Mq:FieldID>";
			var FLD_ID_CONTACT="<Mq:FieldID>nOriginatorID</Mq:FieldID>";
			var FLD_ID_COMPANY_NAME="<Mq:FieldID>Company_Name</Mq:FieldID>";
			var FLD_ID_VAR_CONTACT="<Mq:FieldID>VAR_Contact</Mq:FieldID>";
			var FLD_ID_VAR_NAME="<Mq:FieldID>VAR_Name</Mq:FieldID>";
			
			var FLD_ID_ROLES="<Mq:FieldID>Roles</Mq:FieldID>";
			
			var FLD_EMP_DEPT="<Mq:FieldID>Department</Mq:FieldID>";
			if(FLD_EMP_DEPT=="-1"){
				FLD_EMP_DEPT="<Mq:FieldID>Department;2</Mq:FieldID>";
			}
			
			var FLD_EMP_UNIT="<Mq:FieldID>Unit</Mq:FieldID>";
			if(FLD_EMP_UNIT=="-1"){
				FLD_EMP_UNIT="<Mq:FieldID>Unit;2</Mq:FieldID>";
			}
			
			var FLD_EMP_JOB_TITLE="<Mq:FieldID>Job_Title</Mq:FieldID>";
			if(FLD_EMP_JOB_TITLE=="-1"){
				FLD_EMP_JOB_TITLE="<Mq:FieldID>Job_Title;2</Mq:FieldID>";
			}
			
			var FLD_EMP_JOB_POS="<Mq:FieldID>Job_Position</Mq:FieldID>";
			if(FLD_EMP_JOB_POS=="-1"){
				FLD_EMP_JOB_POS="<Mq:FieldID>Job_Position;2</Mq:FieldID>";
			}
			
			var FLD_EMP_WORK_TEAM="<Mq:FieldID>nWorkTeam</Mq:FieldID>";
			if(FLD_EMP_WORK_TEAM=="-1"){
				FLD_EMP_WORK_TEAM="<Mq:FieldID>nWorkTeam;2</Mq:FieldID>";
			}
			
			var FLD_EMP_WORK_LOC="<Mq:FieldID>Location</Mq:FieldID>";
			if(FLD_EMP_WORK_LOC=="-1"){
				FLD_EMP_WORK_LOC="<Mq:FieldID>Location;2</Mq:FieldID>";
			}
			
			
			var varDependentFields=objWorkflowRules.GetDependentFields();
			if(!varDependentFields){
				varDependentFields=new Array();
			}
			var intOrder=varDependentFields.length+1;
			var arrTargetField;
			var arrCondFields;
			
						
			//*****************************************************
			//********* Employees Jobs ****************************
			//*****************************************************
			
						
			if(FLD_EMP_UNIT!="-1" && FLD_EMP_JOB_POS!="-1"){
												
				//*** Job Position/Unit Rule
				arrTargetField = new Array();
				arrTargetField[1]= new Array (FLD_EMP_UNIT, "Unit",0);
				
				arrCondFields = new Array();
				arrCondFields[1] = new Array(FLD_EMP_JOB_POS, "nID", true);
				
				varDependentFields=AddCustomWorkflowTemplate(varDependentFields,objWorkflowRules, objFieldCollection, strHTMLContainer, objMqAutoList, "../ASP/GetWorkflowByRoleDept.asp", 
								arrCondFields, arrTargetField, true, "tblDts", objDisplayElements, null, null, true);

			}
			
			if(FLD_EMP_DEPT!="-1" && FLD_EMP_JOB_POS!="-1"){
												
				//*** Job Position/Department Rule
				arrTargetField = new Array();
				arrTargetField[1]= new Array (FLD_EMP_DEPT, "Department",0);
				
				arrCondFields = new Array();
				arrCondFields[1] = new Array(FLD_EMP_JOB_POS, "nID", true);
				
				varDependentFields=AddCustomWorkflowTemplate(varDependentFields,objWorkflowRules, objFieldCollection, strHTMLContainer, objMqAutoList, "../ASP/GetWorkflowByRoleDept.asp", 
								arrCondFields, arrTargetField, true, "tblDts", objDisplayElements, null, null, true);

			}
			
			if(FLD_EMP_JOB_POS!="-1" && FLD_EMP_JOB_TITLE!="-1"){
				//*** Job Position/Job Title Rule
				arrTargetField = new Array();
				arrTargetField[1]= new Array (FLD_EMP_JOB_TITLE,"Job_Title",0);
				
				arrCondFields = new Array();
				arrCondFields[1] = new Array(FLD_EMP_JOB_POS, "nID", true);
				
				varDependentFields=AddCustomWorkflowTemplate(varDependentFields,objWorkflowRules, objFieldCollection, strHTMLContainer, objMqAutoList, "../ASP/GetWorkflowByRoleDept.asp", 
								arrCondFields, arrTargetField, true, "tblDts", objDisplayElements, null, null, true);
								
			}
			
			if(FLD_EMP_WORK_TEAM!="-1" && FLD_EMP_JOB_POS!="-1"){
												
				//*** Job Position/Work Team Rule
				arrTargetField = new Array();
				arrTargetField[1]= new Array (FLD_EMP_WORK_TEAM, "Work_Team",1);
				
				arrCondFields = new Array();
				arrCondFields[1] = new Array(FLD_EMP_JOB_POS, "nID",true);
				
				varDependentFields=AddCustomWorkflowTemplate(varDependentFields,objWorkflowRules, objFieldCollection, strHTMLContainer, objMqAutoList, "../ASP/GetWorkflowByRoleDept.asp", 
								arrCondFields, arrTargetField, true, "tblDts", objDisplayElements, null, null, true);

			}
			
			if(FLD_EMP_WORK_LOC!="-1" && FLD_EMP_JOB_POS!="-1"){
												
				//*** Job Position/Location Rule
				arrTargetField = new Array();
				arrTargetField[1]= new Array (FLD_EMP_WORK_LOC, "Location",1);
				
				arrCondFields = new Array();
				arrCondFields[1] = new Array(FLD_EMP_JOB_POS, "nID", true);
				
				varDependentFields=AddCustomWorkflowTemplate(varDependentFields,objWorkflowRules, objFieldCollection, strHTMLContainer, objMqAutoList, "../ASP/GetWorkflowByRoleDept.asp", 
								arrCondFields, arrTargetField, true, "tblDts", objDisplayElements, null, null, true);

			}
			
			
			
			
			//************************************
			//********* HelpDesk *****************
			//************************************
			
			if(FLD_ID_OWNER!="-1" && FLD_ID_WORK_TEAM!="-1"){
				//*** WorkTeam/Owner Rule
				
				arrTargetField = new Array();	
				arrTargetField[1]= new Array(FLD_ID_OWNER,"nID",0);
					
				arrCondFields = new Array();
				arrCondFields[1] = new Array(FLD_ID_WORK_TEAM,"nWorkTeam");

				varDependentFields=AddCustomWorkflowTemplate(varDependentFields, objWorkflowRules, objFieldCollection, strHTMLContainer, objMqAutoList, "../ASP/GetWorkflowContacts.asp", 
								arrCondFields, arrTargetField, true, "tblUser", objDisplayElements, "parent.");
			
			}
			
			
			if(FLD_ID_COMPANY_NAME!="-1" && FLD_ID_CONTACT!="-1"){
				//*** Company/Contact Rule
				
				arrTargetField = new Array();	
				arrTargetField[1]= new Array(FLD_ID_CONTACT,"nID",0);
					
				arrCondFields = new Array();
				arrCondFields[1] = new Array(FLD_ID_COMPANY_NAME,"nCompanyName");

				varDependentFields=AddCustomWorkflowTemplate(varDependentFields, objWorkflowRules, objFieldCollection, strHTMLContainer, objMqAutoList, "../ASP/GetWorkflowContacts.asp", 
								arrCondFields, arrTargetField, true, "tblUser", objDisplayElements, "parent.");
			
			}
			
			if(FLD_ID_VAR_NAME!="-1" && FLD_ID_VAR_CONTACT!="-1"){
				//*** VAR/VAR Contact Rule
				
				arrTargetField = new Array();	
				arrTargetField[1]= new Array(FLD_ID_VAR_CONTACT,"nID",0);
					
				arrCondFields = new Array();
				arrCondFields[1] = new Array(FLD_ID_VAR_NAME,"VAR_NAME");

				varDependentFields=AddCustomWorkflowTemplate(varDependentFields, objWorkflowRules, objFieldCollection, strHTMLContainer, objMqAutoList, "../ASP/GetWorkflowContacts.asp", 
								arrCondFields, arrTargetField, true, "tblUser", objDisplayElements, "parent.");
			
			}
			objWorkflowRules.SetDependentFields(varDependentFields);
			mblnAddWorkflowRules=false;
		}
		
	}
	
	function AddCustomWorkflowTemplate(varDependentFields, objWorkflowRules, objFieldCollection, strHTMLContainer, objMqAutoList, strSourcePage, 
										arrCondFields, arrTargetField, fTriggerOnFieldChange, strTableName, objDisplayElements, strRefToWkflObj, blnSelectFirstVal, fDontTriggerOnLoadRec)
	{
		var INDEX_FIELD_ID=0;
		var intOrder=varDependentFields.length+1;
			
		if(!strRefToWkflObj){
			strRefToWkflObj="";
		}
		//<Begin_Template*******************
		if (!varDependentFields[intOrder]){

			varDependentFields[intOrder]=new MqDependentFields(objFieldCollection,strHTMLContainer,objMqAutoList);

			if (fTriggerOnFieldChange){
				for (i=0;i<arrCondFields.length;i++){
					if (arrCondFields[i]){
						var strFieldID=arrCondFields[i][INDEX_FIELD_ID];
						if (strFieldID){
							varDependentFields[intOrder].SetOnChange(strFieldID,strRefToWkflObj+"m_objWorkFlow.OnChange("+intOrder+", true,"+strFieldID+");");
						}
					}
				}
				// Assumption: most of dependent fields don't display current value - workflow does
				varDependentFields[intOrder].DisplayCurrentValue=false;
			}else{
				varDependentFields[intOrder].DisplayCurrentValue=true;
			}
			
			if(fDontTriggerOnLoadRec){
				varDependentFields[intOrder].SetTriggerOnLoadRec(false);
			}
			
			varDependentFields[intOrder].Initialize(arrTargetField,arrCondFields, 
							strSourcePage,strTableName, false, objDisplayElements); 

			if(blnSelectFirstVal!=null){
				varDependentFields[intOrder].SetIsSelectFirstValue(blnSelectFirstVal);
			}
		}else{
			varDependentFields[intOrder].InitializeTargetFields();
		}			
		//*******************   <End_Template>
			
		return varDependentFields;
	}
	
	function MoveTextToSecondFld(strSrcFld, strTgtFld, blnNewIssueOnly)
	{
		var objContext=GetContextDoc();
		if(objContext){
			var objSrcFld=objContext.getElementById(strSrcFld);
			var objTgtFld=objContext.getElementById(strTgtFld);
			if(objSrcFld && objTgtFld){
				var objFunction;
				objFunction=function(){parent.objCustomCode.DoMoveTextToSecondFld(strSrcFld, strTgtFld, blnNewIssueOnly);};
				if(objFunction){
					if(objSrcFld.attachEvent){
						objSrcFld.attachEvent("onkeyup", objFunction);
					}else{
						if(objSrcFld.addEventListener){
							objSrcFld.addEventListener("keyup", objFunction, false);
						}
					}
				}
			}
		}
	}
	
	function DoMoveTextToSecondFld(strSrcFld, strTgtFld, blnNewIssueOnly)
	{
		var objContext=GetContextDoc();
		if(objContext){
			var objSrcFld=objContext.getElementById(strSrcFld);
			var objTgtFld=objContext.getElementById(strTgtFld);
			
			if(objSrcFld && objTgtFld){
				var blnMoveText=true;
				if(blnNewIssueOnly){
					if(objControlsSs){
						var lngRevNum=g_VWS.RecordMgr().CurrentRecord().GetRevisionNumber();
						if(lngRevNum>0){
							blnMoveText=false;
						}
					}
				}
				if(blnMoveText){
					var strSrcText=objSrcFld.value;
					var lngMaxLen=objTgtFld.maxLength;
					
					var strTgtText="";
					var lngSentenceEnd=strSrcText.indexOf(".");
					var lngLineEnd=strSrcText.indexOf(unescape("%0D%0A"));
					if(lngLineEnd > lngSentenceEnd){
						if(lngLineEnd>0 && lngLineEnd<=lngMaxLen){
							strTgtText=strSrcText.substring(0, lngLineEnd);
						}else{
							if(strSrcText.length>=lngMaxLen){
								strTgtText=strSrcText.substring(0, lngMaxLen);
							}else{
								strTgtText=strSrcText;
							}
						}		
					}else{
						if(lngSentenceEnd>0 && lngSentenceEnd<=lngMaxLen){
							strTgtText=strSrcText.substring(0, lngSentenceEnd);
						}else{
							if(strSrcText.length>=lngMaxLen){
								strTgtText=strSrcText.substring(0, lngMaxLen);
							}else{
								strTgtText=strSrcText;
							}
						}					
					}
					objTgtFld.value=strTgtText;
					objTgtFld.onchange();
				}
			}
		}
	}	
	
	function ShowFieldOnSeveralTabs(strFieldID, strAutoAdjustWidthFldIDs, objTabsMgr)
	{
		var lngIndex=m_arrDupFldIDs.length;
		m_arrDupFldIDs.length++;
		m_arrDupFldIDs[lngIndex]=strFieldID;
		
		m_arrDupFldLastVisibleTabIDs.length++;
		m_arrDupFldLastVisibleTabIDs[lngIndex]=-1;
		
		if(objTabsMgr)
		{
			var arrTabs=objTabsMgr.GetAllTabs();
			var objTab;
			for (i=0;i<arrTabs.length;i++){
				objTab=arrTabs[i];
				if (objTab){
					objTab.SetOnClick("objCustomCode.ShowHideDupFlds(" + objTab.GetID() + "," + strAutoAdjustWidthFldIDs + ");return true;");
				}
			}
		}
	}

	function ShowHideDupFlds(lngTabID, strAutoAdjustWidthFldIDs)
	{
		for(x=0; x<m_arrDupFldIDs.length; x++){
			var lngFldID=m_arrDupFldIDs[x];
			var lngLastVisibleTab=m_arrDupFldLastVisibleTabIDs[x];
			var objContext=GetContextDoc();
			if(objContext){
				var objSrcCtrlCaption=objContext.getElementById("MqFC_" + lngFldID);
				var objSrcCtrl=objContext.getElementById("MqF_" + lngFldID);
				
				if(objSrcCtrlCaption && objSrcCtrl){
					if(lngLastVisibleTab>=0){
						objSrcCtrlCaption=objContext.getElementById("MqFC_PH_" + lngFldID + "_" + lngLastVisibleTab);
						objSrcCtrl=objContext.getElementById("MqF_PH_" + lngFldID + "_" + lngLastVisibleTab);
						
						if(!(objSrcCtrlCaption && objSrcCtrl)){
							//the src tab held the original fields
							objSrcCtrlCaption=objContext.getElementById("MqFC_" + lngFldID);
							objSrcCtrl=objContext.getElementById("MqF_" + lngFldID);
						}
					}
				
					if(objSrcCtrlCaption && objSrcCtrl){
						var objTgtCtrlCaption=objContext.getElementById("MqFC_PH_" + lngFldID + "_" + lngTabID);
						var objTgtCtrl=objContext.getElementById("MqF_PH_" + lngFldID + "_" + lngTabID);
				
						if(!(objTgtCtrlCaption && objTgtCtrl)){
							//set it back to the original control
							var objTgtCtrlCaption=objContext.getElementById("MqFC_" + lngFldID);
							var objTgtCtrl=objContext.getElementById("MqF_" + lngFldID);
						}
						
						if(objTgtCtrl!=objSrcCtrl)
						{
							while(objSrcCtrlCaption.firstChild){
								objTgtCtrlCaption.appendChild(objSrcCtrlCaption.firstChild);
							}
							
							while(objSrcCtrl.firstChild){
								objTgtCtrl.appendChild(objSrcCtrl.firstChild);
							}
													
							m_arrDupFldLastVisibleTabIDs[x]=lngTabID;
							
							objSrcCtrlCaption.innerHTML="";
							objSrcCtrl.innerHTML="";
							var arrAutoAdjustWidthFldIDs=strAutoAdjustWidthFldIDs.toString().split(",");
							if(arrAutoAdjustWidthFldIDs){
								for(y=0; y<arrAutoAdjustWidthFldIDs.length; y++){
									var objFld=objContext.getElementById("MqF_" + arrAutoAdjustWidthFldIDs[y]);
									if(objFld){
										objFld.colSpan="1";
									}
								}
							}
						}
					}
				}
			}
		}
	}
	
	function OnBeforeLoadRec()
	{
		if (m_WVExtensions)
		{
			m_WVExtensions.OnBeforeLoadRec();
		}

	}

	
	function OnAfterLoadRec()
	{
		if (m_WVExtensions)
		{
			m_WVExtensions.OnAfterLoadRec();

		}

	}
		
	function SetAddWorkflowRules(blnAddWorkflowRules)
	{
		mblnAddWorkflowRules=blnAddWorkflowRules
	}

	function SetTSSubstateFldID(intTSSubstateFldID)
	{
		m_intTSSubstateFldID=intTSSubstateFldID
	}

	function GetWVExtensions()
	{
		return m_WVExtensions;
	}
	
	// ! DO NOT erase these declarations

	// Declaration of the public functions
	this.addNewBefore=addNewBefore;
	this.addNewAfter=addNewAfter;
	this.saveBefore=saveBefore;
	this.saveAfter=saveAfter;
	this.cancelBefore=cancelBefore;
	this.cancelAfter=cancelAfter;
	this.submitBefore=submitBefore;
	this.submitAfter=submitAfter;
	this.BatchSubmitBefore=BatchSubmitBefore;
	this.BatchSubmitAfter=BatchSubmitAfter;
	this.copyBefore=copyBefore;
	this.copyAfter=copyAfter;
	this.onConflict=onConflict;
	this.reloadAfterConflitCancel=reloadAfterConflitCancel;
	this.deleteBefore=deleteBefore;
	this.deleteAfter=deleteAfter;
	this.OnBeforeLoadRec=OnBeforeLoadRec;
	this.OnAfterLoadRec=OnAfterLoadRec;
	
	this.getCodeAfterField=getCodeAfterField;
	this.getCodeBeforeField=getCodeBeforeField;

	this.getSubmitControlCaption=getSubmitControlCaption;
	
	this.getIntervalForSummaryList=getIntervalForSummaryList;
	
	this.MoveControlData=MoveControlData;
	this.CommitTimestamp=CommitTimestamp;
	this.TimeStampFields=m_strTimestampFields;
	this.SetViewFields=SetViewFields;
	this.AddWorkflowRules=AddWorkflowRules;
	this.MoveTextToSecondFld=MoveTextToSecondFld;
	this.DoMoveTextToSecondFld=DoMoveTextToSecondFld;
	this.ShowFieldOnSeveralTabs=ShowFieldOnSeveralTabs;
	this.ShowHideDupFlds=ShowHideDupFlds;
	this.SetAddWorkflowRules=SetAddWorkflowRules;
	this.SetTSSubstateFldID=SetTSSubstateFldID;
	this.GetWVExtensions=GetWVExtensions;

	// Private functions

	function getHtmlCodeForTimeStampMemoFieldCaller(strFieldName,strParam)
	{
		var strReturn;
		strReturn="";
		strReturn+="<input type='submit' value=' V ' onclick='";
		strReturn+="parent.objCustomCode.MoveControlData(\"" + strFieldName + "\",\"" + strParam +"\");";
		strReturn+="parent.OnRecordChanged();";
		strReturn+="return false;'";
		strReturn+="><br>";
		return strReturn;
	}

	function formatDate(intNumber)
	{
		if (intNumber<10){
			return "0"+intNumber;
		}else{
			return intNumber;
		}
	}

	function getHtmlCodeForTimeStampMemoFieldTarget(strFieldName)
	{
		var strReturn;
		var str_mfrmRecord="mfrmRecord";

		strReturn="";
		strReturn="<script type='text/javascript'>";
		
		strReturn+="var objField=document.getElementById('" +strFieldName + "');";
		strReturn+="parent.m_objDisplayElements.ExcludeElement('"+strFieldName+"');";		
		strReturn+="if(objField){";
		strReturn+="objField.readOnly=true;";
		strReturn+="if(objField.getAttribute('MqAppendVal') == '1'){";
		strReturn+="objField.style.border='0px solid';";
		strReturn+="}else{";
		strReturn+="objField.style.backgroundColor='#c0c0c0';";
		strReturn+="}";
		strReturn+="objField.setAttribute('MqROFld', '1');";
		
		strReturn+="var objElementButton;";
		strReturn+="var strBaseClass;";
		strReturn+="var strNewBaseClass;";
		
		strReturn+="if(m_objMqButton){";
		strReturn+="	objElementButton=document.getElementById(m_objMqButton.GetButtonHTMLName('" + strFieldName + "_MemoEdit'));";
		strReturn+="	if(objElementButton){";
		strReturn+="		strBaseClass=m_objMqButton.GetButtonBaseClass(objElementButton);";
		strReturn+="		strNewBaseClass=strBaseClass.replace('MemoEditor','ROMemoEditor');";
		strReturn+="		m_objMqButton.ChangeBaseClass(objElementButton, strNewBaseClass, strBaseClass); ";
		strReturn+="	}";
		strReturn+="}";
		
		strReturn+="if(m_objMqButton){";
		strReturn+="	objElementButton=document.getElementById(m_objMqButton.GetButtonHTMLName('" + strFieldName + "_HTMLEdit'));";
		strReturn+="	if(objElementButton){";
		strReturn+="		strBaseClass=m_objMqButton.GetButtonBaseClass(objElementButton);";
		strReturn+="		strNewBaseClass=strBaseClass.replace('HTMLEditor','ROHTMLEditor');";
		strReturn+="		m_objMqButton.ChangeBaseClass(objElementButton, strNewBaseClass, strBaseClass); ";
		strReturn+="	}";
		strReturn+="}";
		
		strReturn+="}";
		strReturn+="</sc" + "ript>";
		return strReturn;
	}

	function getUsername()
	{
		var strCurrentLocation;
		var strUrl;
		var strOutput;	
		var objString = new MqString;	
		strCurrentLocation=location.protocol+"//"+location.hostname+":"+ location.port +getPath(location.pathname);
		strUrl=strCurrentLocation+"../asp/GetUsername.asp";
		strOutput=objRequest.Get(strUrl);
		
		if (strOutput!=objRequest.CANCEL_PROCESS){
			strOutput=objString.getNullTerminatedString(strOutput);			
			return  strOutput ;
		}else{
			return "";
		}
	}

	function ClearFields(arrFields)
	{
		var objFieldTemp;
		if (arrFields){
			if (arrFields.length>0){
				for (var i=0; i< arrFields.length;i++){
					if (arrFields[i]){
						objFieldTemp=eval(CONTEXT + arrFields[i]);
						
						if(objFieldTemp){
							objFieldTemp.value="";
						}
					}
				}
			}
		}
	}

}


function MqWVExtensions()
{
	WriteConsole("MqWVExtensions: Initializing Web View Extensions");

	var m_arrWVExtensions=new Array();

	function OnBeforeLoadRec()
	{
		for(var lngIndex=0;lngIndex<m_arrWVExtensions.length;lngIndex++){
			if (m_arrWVExtensions[lngIndex]){
				if (m_arrWVExtensions[lngIndex].OnBeforeLoadRec){
					WriteConsole("MqWVExtensions: Calling OnBeforeLoadRec on extension object " + m_arrWVExtensions[lngIndex].Name );
					m_arrWVExtensions[lngIndex].OnBeforeLoadRec();
				}
			}
		}
	}
	

	function OnAfterLoadRec()
	{
		for(var lngIndex=0;lngIndex<m_arrWVExtensions.length;lngIndex++){
			if (m_arrWVExtensions[lngIndex]){
				if (m_arrWVExtensions[lngIndex].OnAfterLoadRec){
					WriteConsole("MqWVExtensions: Calling OnAfterLoadRec on extension object " + m_arrWVExtensions[lngIndex].Name );				
					m_arrWVExtensions[lngIndex].OnAfterLoadRec();
				}
			}
		}
	}

	function saveBefore()
	{
		var objExtHandler=new MqExtensionHandler();
		
		for(var lngIndex=0;lngIndex<m_arrWVExtensions.length;lngIndex++){
			if (m_arrWVExtensions[lngIndex]){
				if (m_arrWVExtensions[lngIndex].saveBefore){
					WriteConsole("MqWVExtensions: Calling saveBefore on extension object " + m_arrWVExtensions[lngIndex].Name );	
					var objExtHdlrTemp=new MqExtensionHandler();			
					objExtHdlrTemp=m_arrWVExtensions[lngIndex].saveBefore(objExtHdlrTemp);
					objExtHandler=HandleEvents(objExtHandler, objExtHdlrTemp);
				}
			}
		}
		
		return objExtHandler;
	}
	
	function saveAfter()
	{
		for(var lngIndex=0;lngIndex<m_arrWVExtensions.length;lngIndex++){
			if (m_arrWVExtensions[lngIndex]){
				if (m_arrWVExtensions[lngIndex].saveAfter){
					WriteConsole("MqWVExtensions: Calling saveAfter on extension object " + m_arrWVExtensions[lngIndex].Name );				
					m_arrWVExtensions[lngIndex].saveAfter();
				}
			}
		}
	}
	
	function submitBefore()
	{
		for(var lngIndex=0;lngIndex<m_arrWVExtensions.length;lngIndex++){
			if (m_arrWVExtensions[lngIndex]){
				if (m_arrWVExtensions[lngIndex].submitBefore){
					WriteConsole("MqWVExtensions: Calling submitBefore on extension object " + m_arrWVExtensions[lngIndex].Name );				
					m_arrWVExtensions[lngIndex].submitBefore();
				}
			}
		}
	}
					
	function submitAfter(lngRecordId)
	{
		var objExtHandler=new MqExtensionHandler();
		
		for(var lngIndex=0;lngIndex<m_arrWVExtensions.length;lngIndex++){
			if (m_arrWVExtensions[lngIndex]){
				if (m_arrWVExtensions[lngIndex].submitAfter){
					WriteConsole("MqWVExtensions: Calling submitAfter on extension object " + m_arrWVExtensions[lngIndex].Name );				
					var objExtHdlrTemp=new MqExtensionHandler();
					m_arrWVExtensions[lngIndex].submitAfter(lngRecordId, objExtHdlrTemp);
					objExtHandler=HandleEvents(objExtHandler, objExtHdlrTemp);
				}
			}
		}
		return objExtHandler;
	}
	
	function BatchSubmitBefore()
	{
		for(var lngIndex=0;lngIndex<m_arrWVExtensions.length;lngIndex++){
			if (m_arrWVExtensions[lngIndex]){
				if (m_arrWVExtensions[lngIndex].BatchSubmitBefore){
					WriteConsole("MqWVExtensions: Calling BatchSubmitBefore on extension object " + m_arrWVExtensions[lngIndex].Name );				
					m_arrWVExtensions[lngIndex].BatchSubmitBefore();
				}
			}
		}
	}
	
	function BatchSubmitAfter()
	{
		for(var lngIndex=0;lngIndex<m_arrWVExtensions.length;lngIndex++){
			if (m_arrWVExtensions[lngIndex]){
				if (m_arrWVExtensions[lngIndex].BatchSubmitAfter){
					WriteConsole("MqWVExtensions: Calling BatchSubmitAfter on extension object " + m_arrWVExtensions[lngIndex].Name );				
					m_arrWVExtensions[lngIndex].BatchSubmitAfter();
				}
			}
		}
	}

	function cancelBefore()
	{
		for(var lngIndex=0;lngIndex<m_arrWVExtensions.length;lngIndex++){
			if (m_arrWVExtensions[lngIndex]){
				if (m_arrWVExtensions[lngIndex].cancelBefore){
					WriteConsole("MqWVExtensions: Calling cancelBefore on extension object " + m_arrWVExtensions[lngIndex].Name );				
					m_arrWVExtensions[lngIndex].cancelBefore();
				}
			}
		}
	}
	
	function cancelAfter()
	{
		for(var lngIndex=0;lngIndex<m_arrWVExtensions.length;lngIndex++){
			if (m_arrWVExtensions[lngIndex]){
				if (m_arrWVExtensions[lngIndex].cancelAfter){
					WriteConsole("MqWVExtensions: Calling cancelAfter on extension object " + m_arrWVExtensions[lngIndex].Name );				
					m_arrWVExtensions[lngIndex].cancelAfter();
				}
			}
		}
	}
	
	function addNewBefore()
	{
		for(var lngIndex=0;lngIndex<m_arrWVExtensions.length;lngIndex++){
			if (m_arrWVExtensions[lngIndex]){
				if (m_arrWVExtensions[lngIndex].addNewBefore){
					WriteConsole("MqWVExtensions: Calling addNewBefore on extension object " + m_arrWVExtensions[lngIndex].Name );				
					m_arrWVExtensions[lngIndex].addNewBefore();
				}
			}
		}
	}
	
	function addNewAfter()
	{
		for(var lngIndex=0;lngIndex<m_arrWVExtensions.length;lngIndex++){
			if (m_arrWVExtensions[lngIndex]){
				if (m_arrWVExtensions[lngIndex].addNewAfter){
					WriteConsole("MqWVExtensions: Calling addNewAfter on extension object " + m_arrWVExtensions[lngIndex].Name );				
					m_arrWVExtensions[lngIndex].addNewAfter();
				}
			}
		}
	}
	
	function copyBefore()
	{
		for(var lngIndex=0;lngIndex<m_arrWVExtensions.length;lngIndex++){
			if (m_arrWVExtensions[lngIndex]){
				if (m_arrWVExtensions[lngIndex].copyBefore){
					WriteConsole("MqWVExtensions: Calling copyBefore on extension object " + m_arrWVExtensions[lngIndex].Name );				
					m_arrWVExtensions[lngIndex].copyBefore();
				}
			}
		}
	}
	
	function copyAfter()
	{
		for(var lngIndex=0;lngIndex<m_arrWVExtensions.length;lngIndex++){
			if (m_arrWVExtensions[lngIndex]){
				if (m_arrWVExtensions[lngIndex].copyAfter){
					WriteConsole("MqWVExtensions: Calling copyAfter on extension object " + m_arrWVExtensions[lngIndex].Name );				
					m_arrWVExtensions[lngIndex].copyAfter();
				}
			}
		}
	}
	
	function deleteBefore(lngIssueID)
	{
		var objExtHandler=new MqExtensionHandler();
		for(var lngIndex=0;lngIndex<m_arrWVExtensions.length;lngIndex++){
			if (m_arrWVExtensions[lngIndex]){
				if (m_arrWVExtensions[lngIndex].deleteBefore){
					WriteConsole("MqWVExtensions: Calling deleteBefore on extension object " + m_arrWVExtensions[lngIndex].Name );				
					var objExtHdlrTemp=new MqExtensionHandler();			
					objExtHdlrTemp=m_arrWVExtensions[lngIndex].deleteBefore(objExtHdlrTemp, lngIssueID);
					objExtHandler=HandleEvents(objExtHandler, objExtHdlrTemp);
				}
			}
		}
		return objExtHandler;
	}
	
	function deleteAfter()
	{
		for(var lngIndex=0;lngIndex<m_arrWVExtensions.length;lngIndex++){
			if (m_arrWVExtensions[lngIndex]){
				if (m_arrWVExtensions[lngIndex].deleteAfter){
					WriteConsole("MqWVExtensions: Calling deleteAfter on extension object " + m_arrWVExtensions[lngIndex].Name );				
					m_arrWVExtensions[lngIndex].deleteAfter();
				}
			}
		}
	}
	
	function AddExtension(oWVExtension)
	{
		if (oWVExtension){
			if(!ExtensionExists(oWVExtension)){
				m_arrWVExtensions[m_arrWVExtensions.length]=oWVExtension;
				WriteConsole("MqWVExtensions: Adding extension object " + oWVExtension.Name + " to active extensions.");
			}
		}
	}

	function ExtensionExists(oWVExtension)
	{
		var blnReturn=false;
		
		for(var lngIndex=0;lngIndex<m_arrWVExtensions.length;lngIndex++){
			if (m_arrWVExtensions[lngIndex]){
				if (m_arrWVExtensions[lngIndex].Name==oWVExtension.Name){
					blnReturn=true;
					break;
				}
			}
		}
		return blnReturn;
	}

	function HandleEvents(objExtHandler, objExtHdlrTemp)
	{
		var strMsgTemp="";
		var strMsgFull="";
		
		if(objExtHdlrTemp){
			if(objExtHdlrTemp.GetCancelProcess()){
				objExtHandler.SetCancelProcess(true);
							
				strMsgTemp=objExtHdlrTemp.GetErrorMsg();
							
				if(strMsgTemp!=""){
					strMsgFull=objExtHandler.GetErrorMsg();
								
					if(strMsgFull!=""){
						strMsgFull+="\n\n";			
					}
					objExtHandler.SetErrorMsg(strMsgFull + strMsgTemp);
				}
			}
		}
		
		return objExtHandler;
	}
	
	this.AddExtension=AddExtension;
	this.OnBeforeLoadRec=OnBeforeLoadRec;	
	this.OnAfterLoadRec=OnAfterLoadRec;
	this.saveBefore=saveBefore;
	this.saveAfter=saveAfter;
	this.submitBefore=submitBefore;
	this.submitAfter=submitAfter;
	this.BatchSubmitBefore=BatchSubmitBefore;
	this.BatchSubmitAfter=BatchSubmitAfter;
	this.cancelBefore=cancelBefore;
	this.cancelAfter=cancelAfter;	
	this.addNewBefore=addNewBefore;
	this.addNewAfter=addNewAfter;	
	this.copyBefore=copyBefore;
	this.copyAfter=copyAfter;
	this.deleteBefore=deleteBefore;
	this.deleteAfter=deleteAfter;
}


function MqExtensionHandler()
{
	var mblnCancelled=false;
	var mstrErrMsg="";
	
	function GetCancelProcess()
	{
		return mblnCancelled;
	}
	
	function SetCancelProcess(blnCancel)
	{
		mblnCancelled=blnCancel;
	}
	
	function GetErrorMsg()
	{
		return mstrErrMsg;
	}
	
	function SetErrorMsg(strErrMsg)
	{
		mstrErrMsg=strErrMsg;
	}
	
	this.GetCancelProcess=GetCancelProcess;
	this.SetCancelProcess=SetCancelProcess;
	this.GetErrorMsg=GetErrorMsg;
	this.SetErrorMsg=SetErrorMsg;
}