function VNReportManager()
{
	var m_arrReportInstances = [];
	var m_strOpenReportBaseURL="../Reports/WCMqWebReport.ASP";
	
	function Report(strReportID)
	{
		if(!Exists(strReportID)){
			m_arrReportInstances[strReportID]=new VNReportInstance();
			m_arrReportInstances[strReportID].ID=strReportID;
		}
		return m_arrReportInstances[strReportID];
	}
	
	function Exists(strReportID)
	{
		if(m_arrReportInstances[strReportID]){
			return true;
		}else{
			return false;
		}
	}
	function Load(arrReportsColl, lngReportGroup)
	{	
		var x;
		var RPT_IDX_ID=0;
		var RPT_IDX_NAME=1;
		var RPT_IDX_CR=2;
		var arrReport;
		var strID;
		var strName;
		var blnIsCR;
		
		if (arrReportsColl){
			for(x=0; x<arrReportsColl.length; x++){	
				arrReport = arrReportsColl[x];
				strID=arrReport[RPT_IDX_ID];
				strName=arrReport[RPT_IDX_NAME];
				blnIsCR=(arrReport[RPT_IDX_CR]=="1");
				
				if(Exists(strID)){
					objReportInstance = m_arrReportInstances[strID];
				}else{
					objReportInstance = new VNReportInstance();
					objReportInstance.ID=strID;
				}
				
				//create temp obj and merge with other if it exists
				if(objReportInstance.Name==""){
					objReportInstance.Name=strName;
				}
				objReportInstance.IsCR=blnIsCR;
				objReportInstance.ReportGroup=lngReportGroup;
				
				m_arrReportInstances[strID]=objReportInstance;
			}	
		}
		return true;
	}
	
	function OpenReport(lngReportID, strOpenReportBaseURL) //remove url
	{
		var objReportInstance=Report(lngReportID);

		if(objReportInstance){		
			if(!strOpenReportBaseURL){
				strOpenReportBaseURL=m_strOpenReportBaseURL;
			}
			objReportInstance.Show(strOpenReportBaseURL);
		}
	}
	
	this.Load=Load;
	this.OpenReport=OpenReport;
	this.Reports=m_arrReportInstances;
	this.Report=Report;
}


function VNReportInstance()
{	
	var m_strName="";
	var m_strID="";
	var m_strDescription="";
	var m_blnIsCR=false;
	var m_lngQryType=1; //selected by the report
	var m_blnShowOptions=true; //for all for now
	var m_strViewerType="";
	var m_strOrientation="portrait";
	var m_arrParams;
	var m_lngReportGroup=0;
	var m_strQueryValue="";

	var _me=this;
	var intWinPadding = 140; //Height of windows start menu, browser menu bar, etc. + room for margin
	var intRptWinHeight; //Height of the report window
	var intRptWinWidth; //Width of the report window
	var intWinOffset = 22; //Standard height offset of new window in Windows
	var intRptWinLeft;

	if(screen.height > (intWinPadding * 2)) {
		intRptWinHeight = (screen.height - intWinPadding);
	} else {
		intRptWinHeight = screen.height;
	}

	if(screen.width > 1000) {
		intRptWinWidth = 1000 - intWinOffset;
	} else {
		intRptWinWidth = screen.width - intWinOffset;
	}
	intRptWinLeft = (screen.width - intRptWinWidth) / 2; //Center the report window horizontally

	var WIN_PROPS="menubar=yes,toolbar=yes,directories=no,resizable=yes,scrollbars=yes,,width="+ intRptWinWidth + ",height=" +intRptWinHeight + ",top=" + intWinOffset + ",left=" + intRptWinLeft; //menu bar for print for html reports
	var WIN_PROPS_CR="toolbar=no,directories=no,resizable=yes,scrollbars=yes,width="+ intRptWinWidth + ",height=" +intRptWinHeight + ",top=" + intWinOffset + ",left=" + intRptWinLeft;
	
	this.ACTIVEX_VIEWER="activex";
	this.PDF_VIEWER="pdf";
	this.EXCEL_VIEWER="excel";
	this.CSV_VIEWER="csv";
		  
	function Show(strOpenReportBaseURL) 
	{
		var strWindowProperties=WIN_PROPS;
		if(this.IsCR){
			strWindowProperties=WIN_PROPS_CR;
		}
		
		var strViewerQS=GetViewerQS(GetViewerType()); //check if need to call with this.
		
		var strParamsQS=GetParamsQS(this.Params);
		
		var strAddSQLQS=GetAddSQLQS(this.QueryType, this.QueryValue);
		
		strQueryString="LayoutType=" + this.Orientation + "&ReportKey=" + this.ID + strViewerQS + strParamsQS + strAddSQLQS + "&FeatureID=" + this.ReportGroup;
		
		var objWindow = window.open(strOpenReportBaseURL + "?WCI=ViewReport&" + strQueryString,"",strWindowProperties);
	}
	
	function GetViewerType()
	{
		if(m_strViewerType==""){
			if (g_MqRef.MqBrowser.ie){
				m_strViewerType=_me.ACTIVEX_VIEWER;
			}else{
				m_strViewerType=_me.PDF_VIEWER;
			}
		}
		
		return m_strViewerType;
	}
	
	function SetViewerType(strViewerType)
	{
		m_strViewerType=strViewerType;
	}
	
	function GetViewerQS(strViewerType)
	{			
		var strViewerQS="&ViewerType=" + strViewerType;
		
		if(strViewerType.toLowerCase()==_me.PDF_VIEWER){
			strViewerQS+="&export=31&ext=pdf";
		}else{
			if(strViewerType.toLowerCase()==_me.EXCEL_VIEWER){
				strViewerQS+="&export=36&ext=xls";
			}else{
				if(strViewerType.toLowerCase()==_me.CSV_VIEWER){
					strViewerQS+="&export=7&ext=csv";
				}
			}
		}
		
		return strViewerQS;
	}
	
	function GetParamsQS(arrParams)
	{
		var PLACEHOLDER_REC_ID = '$itemid$';
		var strParamsQS="";
		if(arrParams){
			for(var x=0; x<arrParams.length; x++){
				strParamsQS+="param" + (x+1) + "=" + g_MqRef.MqStr.MqEncodeURIComponent(arrParams[x]);
			}
		}
		
		strParamsQS = strParamsQS.replace(PLACEHOLDER_REC_ID,"");
		
		return strParamsQS;
	}
	
	function GetAddSQLQS(lngQryType, strQryVal)
	{
		var strAddSQLQS="";
		
		if(lngQryType=="2"){
			strAddSQLQS="&AddSQL=MainSL";
		}else{
			if(lngQryType=="3"){
				strAddSQLQS="&AddSQL=CurrentRec";
			}else{
				if(strQryVal!=""){
					strAddSQLQS="&AddSQL="+strQryVal;
				}	
			}
		}
		return strAddSQLQS;
	}
	
	this.Show=Show;
	
	this.ID=m_strID;
	this.Name=m_strName;
	this.Description=m_strDescription;
	this.IsCR=m_blnIsCR;
	this.ShowOptions=m_blnShowOptions;
	this.QueryType=m_lngQryType;
	this.QueryValue=m_strQueryValue;
	this.Orientation=m_strOrientation;
	this.Params=m_arrParams;
	this.ReportGroup=m_lngReportGroup;
	this.SetViewerType=SetViewerType;
	this.GetViewerType=GetViewerType;
}
