/***********************************************************************/
/****Upgrade scripts for U303*******************************************/
/***********************************************************************/

USE Censusweb_mdb
GO

INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (72, NULL, 1115, 5, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (44, NULL, 1134, 21, 2)
GO

ALTER TABLE [Censusweb_mdb].[dbo].[tblFieldAttribute] ALTER COLUMN [tAttributeValue] nvarchar(MAX)
GO

INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (72, 1115, 56, N'no', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 1100, 89, N'Select the users or devices from the list and click OK to begin the allocation. You can allocate software to multiple users or devices at the same time. If the number of available software assets is less than the number of users or devices selected, Vizor will allocate the assets until there are not enough in stock. If you allocate to both users and devices at the same time, Vizor will allocate in pairs of user-device. That is, the first allocation will be set to the first user in the list and the first devices in the list. This way you can designate when users should use a specified device.', NULL)
GO

DELETE FROM [Censusweb_mdb].[dbo].tblViewGroupAccess WHERE nViewID=65 AND tGroup='Managers'
DELETE FROM [Censusweb_mdb].[dbo].tblViewGroupAccess WHERE nViewID=29 AND tGroup='HelpDesk-Analysts'
GO

INSERT [Censusweb_mdb].[dbo].[tblViewGroupAccess] ([tGroup], [nViewID], [nAccessType]) VALUES (N'IT Asset Managers', 77, NULL);
INSERT [Censusweb_mdb].[dbo].[tblViewGroupAccess] ([tGroup], [nViewID], [nAccessType]) VALUES (N'IT Asset Managers', 46, NULL);
INSERT [Censusweb_mdb].[dbo].[tblViewGroupAccess] ([tGroup], [nViewID], [nAccessType]) VALUES (N'IT Asset Managers', 18, NULL);

INSERT [Censusweb_mdb].[dbo].[tblViewGroupAccess] ([tGroup], [nViewID], [nAccessType]) VALUES (N'Teachers', 6, NULL);
INSERT [Censusweb_mdb].[dbo].[tblViewGroupAccess] ([tGroup], [nViewID], [nAccessType]) VALUES (N'Teachers', 8, NULL);
INSERT [Censusweb_mdb].[dbo].[tblViewGroupAccess] ([tGroup], [nViewID], [nAccessType]) VALUES (N'Teachers', 16, NULL);
INSERT [Censusweb_mdb].[dbo].[tblViewGroupAccess] ([tGroup], [nViewID], [nAccessType]) VALUES (N'Teachers', 62, NULL);
INSERT [Censusweb_mdb].[dbo].[tblViewGroupAccess] ([tGroup], [nViewID], [nAccessType]) VALUES (N'Teachers', 65, NULL);
INSERT [Censusweb_mdb].[dbo].[tblViewGroupAccess] ([tGroup], [nViewID], [nAccessType]) VALUES (N'Students', 6, NULL);
INSERT [Censusweb_mdb].[dbo].[tblViewGroupAccess] ([tGroup], [nViewID], [nAccessType]) VALUES (N'Students', 8, NULL);
INSERT [Censusweb_mdb].[dbo].[tblViewGroupAccess] ([tGroup], [nViewID], [nAccessType]) VALUES (N'Students', 16, NULL);
INSERT [Censusweb_mdb].[dbo].[tblViewGroupAccess] ([tGroup], [nViewID], [nAccessType]) VALUES (N'Students', 62, NULL);
INSERT [Censusweb_mdb].[dbo].[tblViewGroupAccess] ([tGroup], [nViewID], [nAccessType]) VALUES (N'Students', 65, NULL);
GO

INSERT [Censusweb_mdb].[dbo].[tblWebViewAttributeType] ([nID], [tDefaultValue], [tName], [nType], [tValueSourceTable], [nCustomAction], [tCACaption], [tCADisplay], [tValidationRule], [tDescription]) VALUES (37, NULL, N'Quick Links Icon', 10, NULL, NULL, NULL, NULL, NULL, N'The file name of the icon to use in the quick links in the user''s dashboard for this view. The file must be located in the CensusWebVD\theme\images\images folder.')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttributeType] ([nID], [tDefaultValue], [tName], [nType], [tValueSourceTable], [nCustomAction], [tCACaption], [tCADisplay], [tValidationRule], [tDescription]) VALUES (38, NULL, N'Order to Show View in Quick Links', 10, NULL, NULL, NULL, NULL, NULL, N'The order to put this view in the quick links list in the user''s dashboard.')
GO

INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (54, 37, N'lmicon_small.gif')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (54, 38, N'115')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (29, 37, N'QLActions.png')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (29, 38, N'135')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (44, 37, N'QLResourcesCatalog.png')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (44, 38, N'100')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (72, 37, N'scannericon_small.png')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (72, 38, N'105')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (65, 37, N'requestassets_small.gif')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (65, 38, N'110')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (68, 37, N'software_installations.gif')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (68, 38, N'120')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (18, 37, N'QLEmployeeResources.png')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (18, 38, N'125')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (50, 37, N'location.png')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (50, 38, N'130')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (46, 37, N'QLInvoices.png')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (46, 38, N'140')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (17, 37, N'QLResourcePolicies.png')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (17, 38, N'145')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (6, 37, N'hdicon_small.gif')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (6, 38, N'150')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (5, 37, N'hdicon_small.gif')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (5, 38, N'155')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (34, 37, N'cricon_small.gif')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (34, 38, N'160')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (14, 37, N'cricon_small.gif')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (14, 38, N'165')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (9, 37, N'kbicon_small.gif')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (9, 38, N'170')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (8, 37, N'kbicon_small.gif')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (8, 38, N'175')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (2, 37, N'bticon_small.gif')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (2, 38, N'180')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (1, 37, N'bticon_small.gif')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (1, 38, N'185')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (66, 37, N'rmicon_small.gif')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (66, 38, N'190')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (77, 37, N'QLEmployeeResources.png')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (77, 38, N'195')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (38, 37, N'qlepas.png')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (38, 38, N'200')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (39, 37, N'qlepaemployees.png')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (39, 38, N'205')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (41, 37, N'qlepaorg.png')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (41, 38, N'210')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (43, 37, N'qlepaadmin.png')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (43, 38, N'215')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (38, 7, N'View My Appraisals')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (29, 27, N'Manage my Vizor Approvals & Actions')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (72, 27, N'Check out and assign assets to people. Check them in when returned. Use barcode readers for faster processing.')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (65, 27, N'Request equipment, access or services that I need')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (67, 27, N'View the inventory of software installations collected by the Vector Discovery, by Microsoft SCCM or by other discovery tools.')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (68, 27, N'View the catalog of software collected by the Vector Discovery, by Microsoft SCCM or by other discovery tools.')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (18, 27, N'View and manage employee, contractor & student profiles and assets')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (50, 27, N'View and manage locations')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (46, 27, N'View and manage all agreements, maintenance contracts, purchases and invoices')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (17, 27, N'View and manage departments, teams, jobs and projects and role-based asset provisioning policies')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (66, 27, N'Add and edit planned development releases')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (77, 7, N'Vendors and Suppliers')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (77, 27, N'View and manage Vendors and Suppliers')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (38, 27, N'View all your appraisals from the current and past years')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (39, 7, N'Employee Appraisals')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (39, 27, N'View appraisals for all employees on my team')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (41, 7, N'Organizational Competencies')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (41, 27, N'View and edit the organizational competencies')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (43, 7, N'Edit Appraisals (Admin Mode)')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (43, 27, N'View and edit all appraisals')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (19, 29, N'no')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (64, 29, N'no')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (20, 29, N'no')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (30, 29, N'no')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (13, 29, N'no')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (62, 29, N'no')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (74, 29, N'no')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (79, 29, N'no')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (67, 29, N'no')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (53, 29, N'no')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (4, 29, N'no')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (7, 29, N'no')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (3, 29, N'no')
GO

UPDATE [Censusweb_mdb].[dbo].[tblWebViewAttribute] SET tValue='Vendors and Suppliers' WHERE nViewID=77 AND nViewAttributeID=8
UPDATE [Censusweb_mdb].[dbo].[tblWebViewAttribute] SET tValue='Release Management' WHERE nViewID=66 AND nViewAttributeID=7
UPDATE [Censusweb_mdb].[dbo].[tblWebViewAttribute] SET tValue='Request Portal' WHERE nViewID=65 AND nViewAttributeID=7
UPDATE [Censusweb_mdb].[dbo].[tblWebViewAttribute] SET tValue='Request Portal' WHERE nViewID=65 AND nViewAttributeID=8
UPDATE [Censusweb_mdb].[dbo].[tblWebViewAttribute] SET tValue='Record, analyze and allocate software licenses; integrate with Software Inventory to ensure compliance and optimization' WHERE nViewID=54 AND nViewAttributeID=27
UPDATE [Censusweb_mdb].[dbo].[tblWebViewAttribute] SET tValue='Agreements & Purchases' WHERE nViewID=46 AND nViewAttributeID=8
UPDATE [Censusweb_mdb].[dbo].[tblWebViewAttribute] SET tValue='Agreements & Purchases' WHERE nViewID=46 AND nViewAttributeID=7
UPDATE [Censusweb_mdb].[dbo].[tblWebViewAttribute] SET tValue='View all asset instances in the library' WHERE nViewID=44 AND nViewAttributeID=27
UPDATE [Censusweb_mdb].[dbo].[tblWebViewAttribute] SET tValue='Assets' WHERE nViewID=44 AND nViewAttributeID=8
UPDATE [Censusweb_mdb].[dbo].[tblWebViewAttribute] SET tValue='Assets' WHERE nViewID=44 AND nViewAttributeID=7
UPDATE [Censusweb_mdb].[dbo].[tblWebViewAttribute] SET tValue='Edit Appraisals (Admin Mode)' WHERE nViewID=43 AND nViewAttributeID=8
UPDATE [Censusweb_mdb].[dbo].[tblWebViewAttribute] SET tValue='Organizational Competencies' WHERE nViewID=41 AND nViewAttributeID=8
UPDATE [Censusweb_mdb].[dbo].[tblWebViewAttribute] SET tValue='Employee Appraisals' WHERE nViewID=39 AND nViewAttributeID=8
UPDATE [Censusweb_mdb].[dbo].[tblWebViewAttribute] SET tValue='View My Appraisals' WHERE nViewID=38 AND nViewAttributeID=8
UPDATE [Censusweb_mdb].[dbo].[tblWebViewAttribute] SET tValue='My Approvals & Actions' WHERE nViewID=29 AND nViewAttributeID=8
UPDATE [Censusweb_mdb].[dbo].[tblWebViewAttribute] SET tValue='My Approvals & Actions' WHERE nViewID=29 AND nViewAttributeID=7
GO

INSERT [Censusweb_mdb].[dbo].[tblQuery] ([nViewID], [nQueryID], [nStatus]) VALUES (44, 58, 2)
GO


INSERT [Censusweb_mdb].[dbo].[tblWebViews] ([nViewID], [tViewName], [nProjectID], [tFileLocation], [tAlias], [nTimeOut], [bLocked], [tLastFileLocation], [bGenerated], [nWebSite], [nMaxLinesPerPage], [tWebServer], [tVdPath], [nFeatureId], [bIntegrateSCC], [bReadOnly], [tURL], [tAnonUser], [tAnonPwd], [nVDInfoDirty], [dLastGen], [dNextGen]) VALUES (81, N'AddComputer', 15, (SELECT [tFileLocation] FROM [Censusweb_mdb].[dbo].tblWebViews WHERE nViewID=1), N'connect', NULL, 0, (SELECT [tLastFileLocation] FROM [Censusweb_mdb].[dbo].tblWebViews WHERE nViewID=1), 0, (SELECT [nWebSite] FROM [Censusweb_mdb].[dbo].tblWebViews WHERE nViewID=1), NULL, (SELECT [tWebServer] FROM [Censusweb_mdb].[dbo].tblWebViews WHERE nViewID=1), (SELECT [tVdPath] FROM [Censusweb_mdb].[dbo].tblWebViews WHERE nViewID=1), 8289, 0, 0, (SELECT [tURL] FROM [Censusweb_mdb].[dbo].tblWebViews WHERE nViewID=1), (SELECT [tAnonUser] FROM [Censusweb_mdb].[dbo].tblWebViews WHERE nViewID=1), (SELECT [tAnonPwd] FROM [Censusweb_mdb].[dbo].tblWebViews WHERE nViewID=1), -1, NULL, NULL)
GO

INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (81, 1092, 14, N'2', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (81, 1092, 56, N'no', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (81, 1092, 60, N'SpanTwoWidthOne', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (81, 1092, 79, N'yes', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (81, 886, 14, N'2', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (81, 886, 56, N'no', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (81, 886, 60, N'SpanTwoWidthOne', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (81, 30, 5, N'2', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (81, 30, 62, N'SpanTwoWidthOne', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (81, 909, 5, N'2', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (81, 909, 62, N'SpanTwoWidthOne', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (81, 1093, 56, N'no', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (81, 894, 5, N'2', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (81, 894, 62, N'SpanTwoWidthOne', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (81, 29, 23, NULL, NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (81, 29, 61, N'SpanTwoWidthOne', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (81, 29, 71, N'none', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (81, 943, 14, N'2', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (81, 943, 56, N'no', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (81, 943, 60, N'SpanTwoWidthOne', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (81, 943, 81, N'no', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (81, 801, 14, N'2', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (81, 801, 56, N'no', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (81, 801, 60, N'SpanTwoWidthOne', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (81, 806, 56, N'no', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (81, 32, 5, N'2', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (81, 32, 62, N'SpanTwoWidthOne', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (81, 898, 5, N'2', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (81, 901, 56, N'no', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (81, 627, 71, N'none', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (81, 20, 56, N'no', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (81, 865, 56, N'no', NULL)
GO

INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 911, 1, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 1092, 1, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 886, 2, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 912, 2, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 30, 3, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 909, 3, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 908, 4, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 1093, 4, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 894, 5, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 947, 5, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 918, 6, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 948, 6, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 29, 7, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 949, 7, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 919, 8, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 927, 8, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 928, 9, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 943, 9, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 801, 10, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 929, 10, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 806, 11, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 930, 11, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 32, 12, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 931, 12, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 898, 13, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 932, 13, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 901, 14, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 933, 14, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 627, 15, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 934, 15, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 20, 16, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 1032, 16, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 865, 17, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 1031, 17, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 935, 18, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 936, 19, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 1090, 20, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 925, 21, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 926, 22, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 952, 23, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 913, 24, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 950, 25, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 914, 26, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 924, 27, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 910, 28, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 1041, 29, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 951, 30, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 937, 31, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 938, 32, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 939, 33, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 940, 34, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 941, 35, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 1044, 36, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 972, 37, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 973, 38, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 975, 39, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 353, 0, 2)
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (81, NULL, 354, 0, 2)
GO

INSERT [Censusweb_mdb].[dbo].[tblViewGroupAccess] ([tGroup], [nViewID], [nAccessType]) VALUES (N'Users', 81, NULL)
GO

INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (81, 6, N'<None>')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (81, 8, N'Resources / AddComputer')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (81, 23, N'asset type')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (81, 24, N'asset types')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (81, 28, N'an')
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (81, 29, N'no')
GO

DELETE FROM [Censusweb_mdb].[dbo].tblFieldAttribute WHERE nViewID=57 AND nFieldID=45 AND nAttributeID=56
GO

DELETE FROM [Censusweb_mdb].[dbo].tblWebViewAttribute WHERE nViewID=74 AND nViewAttributeID=13
GO
INSERT [Censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (74, 13, N'11')
GO

UPDATE [Censusweb_mdb].[dbo].[tblView] SET nFieldIndex=9 WHERE nViewID=74 AND nFieldID=1095 AND nFieldIndex=8
GO
UPDATE [Censusweb_mdb].[dbo].[tblView] SET nFieldIndex=8 WHERE nViewID=74 AND nFieldID=1021 AND nFieldIndex=7
GO
UPDATE [Censusweb_mdb].[dbo].[tblView] SET nFieldIndex=7 WHERE nViewID=74 AND nFieldID=1019 AND nFieldIndex=6
GO
INSERT [Censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 882, 6, 2)
GO

INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 882, 60, N'SpanTwoWidthOne', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 1019, 60, N'SpanTwoWidthOne', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 1021, 60, N'SpanTwoWidthOne', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 1095, 60, N'SpanTwoWidthOne', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 882, 14, N'2', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 1019, 14, N'2', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 1021, 14, N'2', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 1095, 14, N'2', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 1095, 81, N'no', NULL)
GO

INSERT [censusweb_mdb].[dbo].[tblWebViews] ([nViewID], [tViewName], [nProjectID], [tFileLocation], [tAlias], [nTimeOut], [bLocked], [tLastFileLocation], [bGenerated], [nWebSite], [nMaxLinesPerPage], [tWebServer], [tVdPath], [nFeatureId], [bIntegrateSCC], [bReadOnly], [tURL], [tAnonUser], [tAnonPwd], [nVDInfoDirty], [dLastGen], [dNextGen]) VALUES (82, N'SWAssets', 15, (SELECT [tFileLocation] FROM [Censusweb_mdb].[dbo].tblWebViews WHERE nViewID=1), N'connect', NULL, 0, (SELECT [tLastFileLocation] FROM [Censusweb_mdb].[dbo].tblWebViews WHERE nViewID=1), 0, (SELECT [nWebSite] FROM [Censusweb_mdb].[dbo].tblWebViews WHERE nViewID=1), NULL, (SELECT [tWebServer] FROM [Censusweb_mdb].[dbo].tblWebViews WHERE nViewID=1), (SELECT [tVdPath] FROM [Censusweb_mdb].[dbo].tblWebViews WHERE nViewID=1), 8191, 0, 0, (SELECT [tURL] FROM [Censusweb_mdb].[dbo].tblWebViews WHERE nViewID=1), (SELECT [tAnonUser] FROM [Censusweb_mdb].[dbo].tblWebViews WHERE nViewID=1), (SELECT [tAnonPwd] FROM [Censusweb_mdb].[dbo].tblWebViews WHERE nViewID=1), -1, NULL, NULL)
INSERT [censusweb_mdb].[dbo].[tblWebViews] ([nViewID], [tViewName], [nProjectID], [tFileLocation], [tAlias], [nTimeOut], [bLocked], [tLastFileLocation], [bGenerated], [nWebSite], [nMaxLinesPerPage], [tWebServer], [tVdPath], [nFeatureId], [bIntegrateSCC], [bReadOnly], [tURL], [tAnonUser], [tAnonPwd], [nVDInfoDirty], [dLastGen], [dNextGen]) VALUES (83, N'SWAssetTypes', 15, (SELECT [tFileLocation] FROM [Censusweb_mdb].[dbo].tblWebViews WHERE nViewID=1), N'connect', NULL, 0, (SELECT [tLastFileLocation] FROM [Censusweb_mdb].[dbo].tblWebViews WHERE nViewID=1), 0, (SELECT [nWebSite] FROM [Censusweb_mdb].[dbo].tblWebViews WHERE nViewID=1), NULL, (SELECT [tWebServer] FROM [Censusweb_mdb].[dbo].tblWebViews WHERE nViewID=1), (SELECT [tVdPath] FROM [Censusweb_mdb].[dbo].tblWebViews WHERE nViewID=1), 8191, 0, 0, (SELECT [tURL] FROM [Censusweb_mdb].[dbo].tblWebViews WHERE nViewID=1), (SELECT [tAnonUser] FROM [Censusweb_mdb].[dbo].tblWebViews WHERE nViewID=1), (SELECT [tAnonPwd] FROM [Censusweb_mdb].[dbo].tblWebViews WHERE nViewID=1), -1, NULL, NULL)
GO

INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 829, 2, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 987, 91, N'(Optional). Once everyone in the Level 1 Approvers list approves the request, anyone in this list would then need to approve it before the Action Owner can allocate the asset to the employee.', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 829, 64, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1027, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1034, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 803, 14, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 803, 60, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 986, 91, N'People who must first approve this asset before the Action Owner can allocate the asset to the employee.', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1026, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1035, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 804, 14, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 804, 60, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1069, 80, N'yes', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1069, 91, N'If the asset is requested for someone who belongs to one of these groups, the approval at this level will not be required.', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1104, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 816, 14, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 816, 60, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 844, 14, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 844, 60, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 886, 14, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 886, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 981, 5, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 981, 62, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1004, 14, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1004, 60, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1030, 82, N'yes', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1112, 13, N'Showing Life Cycle Stage', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1112, 14, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1112, 95, N'fld_AssetLifeCycle.htmpl', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 30, 5, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 30, 55, N'<script type="text/javascript">HandleDisableTabFields("1;22;23");</script>', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 30, 62, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 30, 86, N'yes', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 30, 95, N'TmplAutoCompleteText.htmpl', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 842, 14, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 842, 60, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 982, 5, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 982, 62, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 999, 11, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 999, 63, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1037, 82, N'yes', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1045, 17, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1045, 80, N'yes', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1045, 95, N'tmplVisibleRequestFlds.htmpl', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 894, 5, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 894, 62, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 983, 5, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 983, 62, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 991, 91, N'Specified in hours. If someone requests an asset and needs it in less time than the minimum specified for that Asset Type, there will be a warning displayed to them.', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1001, 11, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1001, 63, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1079, 85, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 954, 79, N'yes', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1002, 11, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1002, 63, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1039, 55, N'</td></tr><tr><td colspan="4"><hr style="width:98%">', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1055, 23, N'3', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1055, 55, N'</td></tr><tr><td id="MqFExt_%fieldid%" colspan="4" style="padding-top:20px !important; padding-bottom:10px !important;text-align:left;font-weight:700"><script type="text/javascript">document.write(g_MqRef.RESX["TITLE_REQUEST_INFO"]);</script>', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1055, 91, N'Enter an additional message to display when the request falls outside the normal hours or before the minumum hours. (e.g. Contact Bob at 555-1234 if you need this asset ASAP). ', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 29, 23, N'-33', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 29, 61, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 29, 71, N'none', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 989, 81, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1025, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 990, 91, N'If you can''t set the Action Owner to a specific person, set the Work Team that will be responsible for allocating the asset to the employee once the approvals are complete.', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1040, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 799, 2, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 799, 64, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 992, 14, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 992, 60, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1028, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1036, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 801, 14, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 801, 60, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1029, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1033, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 11, 14, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 11, 60, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 11, 81, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 807, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1008, 54, N'<script type="text/javascript">blnAddR_Enabled=false;</script>', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1038, 82, N'yes', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 808, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 882, 14, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 882, 60, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 882, 79, N'yes', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1016, 95, N'fld_RO_Grp_Currency_Value_Caption.htmpl', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1025, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1017, 95, N'fld_RO_Grp_Currency_Value_Caption.htmpl', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1020, 14, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1020, 60, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1020, 79, N'yes', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1026, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1013, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1019, 14, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1019, 60, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1019, 79, N'yes', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1027, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 954, 79, N'yes', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 954, 81, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1009, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1021, 14, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1021, 60, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1021, 79, N'yes', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1040, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1028, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1099, 14, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1099, 60, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1099, 79, N'yes', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1108, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1029, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1087, 14, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1087, 60, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1087, 79, N'yes', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1105, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1095, 14, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1095, 60, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1095, 81, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1095, 91, N'Person responsible for a pool of assets. This person is not necessarily the person assigned the asset. The responsible of the pool often assigns these assets to people.', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1104, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1109, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1096, 14, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1096, 60, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1096, 79, N'yes', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1107, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1117, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1106, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1113, 5, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1113, 95, N'fldRelatedHDIssues.htmpl', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 627, 23, N'5', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 917, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 801, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 21, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 29, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 800, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 803, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 20, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 804, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 886, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 993, 68, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 993, 82, N'yes', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 806, 13, N'Allocation Type', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 806, 14, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 806, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 806, 60, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1093, 79, N'yes', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1086, 79, N'yes', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1023, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 898, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1121, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1092, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (82, 1092, 79, N'yes', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1114, 91, N'Name of the software reported by the Key discovery tool. Tools that discover keys in computers may use a different name than the Product Name. Keys reported with this name will be added to these software installations', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1070, 80, N'yes', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1070, 91, N'If the asset is requested for someone who belongs to one of these groups, the approval at this level will not be required.', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1080, 66, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1080, 102, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1117, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 988, 91, N'(Optional). Once everyone in the Level 1 Approvers and Level 2 Approvers lists approves the request, anyone in this list would then need to approve it before the Action Owner can allocate the asset to the employee.', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 993, 14, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 993, 60, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1023, 14, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1023, 60, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1071, 80, N'yes', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1071, 91, N'If the asset is requested for someone who belongs to one of these groups, the approval at this level will not be required.', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1022, 14, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1022, 60, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1084, 14, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1084, 60, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 806, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 32, 5, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 32, 62, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 901, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 627, 71, N'none', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1092, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1092, 79, N'yes', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1093, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1093, 79, N'yes', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (83, 1133, 79, N'yes', NULL)
GO

INSERT [censusweb_mdb].[dbo].[tblLayout] ([nViewID], [nLayoutID], [nStatus]) VALUES (83, 1, 2)
INSERT [censusweb_mdb].[dbo].[tblLayout] ([nViewID], [nLayoutID], [nStatus]) VALUES (83, 10, 2)
INSERT [censusweb_mdb].[dbo].[tblLayout] ([nViewID], [nLayoutID], [nStatus]) VALUES (83, 11, 2)
INSERT [censusweb_mdb].[dbo].[tblLayout] ([nViewID], [nLayoutID], [nStatus]) VALUES (82, 2, 2)
INSERT [censusweb_mdb].[dbo].[tblLayout] ([nViewID], [nLayoutID], [nStatus]) VALUES (82, 6, 2)
INSERT [censusweb_mdb].[dbo].[tblLayout] ([nViewID], [nLayoutID], [nStatus]) VALUES (82, 9, 2)
INSERT [censusweb_mdb].[dbo].[tblLayout] ([nViewID], [nLayoutID], [nStatus]) VALUES (82, 1, 2)
GO

INSERT [censusweb_mdb].[dbo].[tblQuery] ([nViewID], [nQueryID], [nStatus]) VALUES (83, 1, 2)
INSERT [censusweb_mdb].[dbo].[tblQuery] ([nViewID], [nQueryID], [nStatus]) VALUES (83, 4, 2)
INSERT [censusweb_mdb].[dbo].[tblQuery] ([nViewID], [nQueryID], [nStatus]) VALUES (83, 5, 2)
INSERT [censusweb_mdb].[dbo].[tblQuery] ([nViewID], [nQueryID], [nStatus]) VALUES (83, 22, 2)
INSERT [censusweb_mdb].[dbo].[tblQuery] ([nViewID], [nQueryID], [nStatus]) VALUES (83, 42, 2)
INSERT [censusweb_mdb].[dbo].[tblQuery] ([nViewID], [nQueryID], [nStatus]) VALUES (82, 9, 2)
INSERT [censusweb_mdb].[dbo].[tblQuery] ([nViewID], [nQueryID], [nStatus]) VALUES (82, 10, 2)
INSERT [censusweb_mdb].[dbo].[tblQuery] ([nViewID], [nQueryID], [nStatus]) VALUES (82, 11, 2)
INSERT [censusweb_mdb].[dbo].[tblQuery] ([nViewID], [nQueryID], [nStatus]) VALUES (82, 12, 2)
INSERT [censusweb_mdb].[dbo].[tblQuery] ([nViewID], [nQueryID], [nStatus]) VALUES (82, 13, 2)
INSERT [censusweb_mdb].[dbo].[tblQuery] ([nViewID], [nQueryID], [nStatus]) VALUES (82, 15, 2)
INSERT [censusweb_mdb].[dbo].[tblQuery] ([nViewID], [nQueryID], [nStatus]) VALUES (82, 25, 2)
INSERT [censusweb_mdb].[dbo].[tblQuery] ([nViewID], [nQueryID], [nStatus]) VALUES (82, 27, 2)
INSERT [censusweb_mdb].[dbo].[tblQuery] ([nViewID], [nQueryID], [nStatus]) VALUES (82, 33, 2)
INSERT [censusweb_mdb].[dbo].[tblQuery] ([nViewID], [nQueryID], [nStatus]) VALUES (82, 34, 2)
INSERT [censusweb_mdb].[dbo].[tblQuery] ([nViewID], [nQueryID], [nStatus]) VALUES (82, 39, 2)
INSERT [censusweb_mdb].[dbo].[tblQuery] ([nViewID], [nQueryID], [nStatus]) VALUES (82, 43, 2)
INSERT [censusweb_mdb].[dbo].[tblQuery] ([nViewID], [nQueryID], [nStatus]) VALUES (82, 44, 2)
GO

INSERT [censusweb_mdb].[dbo].[tblSort] ([nViewID], [nSortID], [nStatus]) VALUES (83, 1, 2)
INSERT [censusweb_mdb].[dbo].[tblSort] ([nViewID], [nSortID], [nStatus]) VALUES (82, 1, 2)
INSERT [censusweb_mdb].[dbo].[tblSort] ([nViewID], [nSortID], [nStatus]) VALUES (82, 2, 2)
INSERT [censusweb_mdb].[dbo].[tblSort] ([nViewID], [nSortID], [nStatus]) VALUES (82, 3, 2)
INSERT [censusweb_mdb].[dbo].[tblSort] ([nViewID], [nSortID], [nStatus]) VALUES (82, 6, 2)
INSERT [censusweb_mdb].[dbo].[tblSort] ([nViewID], [nSortID], [nStatus]) VALUES (82, 7, 2)
INSERT [censusweb_mdb].[dbo].[tblSort] ([nViewID], [nSortID], [nStatus]) VALUES (82, 8, 2)
INSERT [censusweb_mdb].[dbo].[tblSort] ([nViewID], [nSortID], [nStatus]) VALUES (82, 9, 2)
INSERT [censusweb_mdb].[dbo].[tblSort] ([nViewID], [nSortID], [nStatus]) VALUES (82, 10, 2)
INSERT [censusweb_mdb].[dbo].[tblSort] ([nViewID], [nSortID], [nStatus]) VALUES (82, 11, 2)
INSERT [censusweb_mdb].[dbo].[tblSort] ([nViewID], [nSortID], [nStatus]) VALUES (82, 12, 2)
INSERT [censusweb_mdb].[dbo].[tblSort] ([nViewID], [nSortID], [nStatus]) VALUES (82, 15, 2)
INSERT [censusweb_mdb].[dbo].[tblSort] ([nViewID], [nSortID], [nStatus]) VALUES (82, 16, 2)
INSERT [censusweb_mdb].[dbo].[tblSort] ([nViewID], [nSortID], [nStatus]) VALUES (82, 17, 2)
INSERT [censusweb_mdb].[dbo].[tblSort] ([nViewID], [nSortID], [nStatus]) VALUES (82, 18, 2)
INSERT [censusweb_mdb].[dbo].[tblSort] ([nViewID], [nSortID], [nStatus]) VALUES (82, 19, 2)
INSERT [censusweb_mdb].[dbo].[tblSort] ([nViewID], [nSortID], [nStatus]) VALUES (82, 25, 2)
INSERT [censusweb_mdb].[dbo].[tblSort] ([nViewID], [nSortID], [nStatus]) VALUES (82, 26, 2)
GO

INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 805, 1, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 812, 1, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 844, 1, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 881, 1, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 886, 1, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 981, 1, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1004, 1, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1030, 1, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1112, 1, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 30, 2, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 813, 2, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 842, 2, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 982, 2, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 999, 2, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1037, 2, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1045, 2, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 9, 3, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 894, 3, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 983, 3, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 991, 3, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1001, 3, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1079, 3, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 10, 4, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 954, 4, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1002, 4, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1039, 4, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1055, 4, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 2, 5, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 29, 5, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 989, 5, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1025, 5, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 3, 6, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 943, 6, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 990, 6, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1040, 6, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 7, 7, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 799, 7, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 992, 7, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1028, 7, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1036, 7, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 8, 8, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 801, 8, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1029, 8, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1033, 8, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1083, 8, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 829, 9, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1027, 9, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1034, 9, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1102, 9, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1116, 9, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 803, 10, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 986, 10, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1026, 10, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1035, 10, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 804, 11, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1069, 11, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1104, 11, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 816, 12, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 987, 12, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1114, 12, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1070, 13, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1080, 13, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1117, 13, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 988, 14, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 993, 14, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1023, 15, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1071, 15, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1022, 16, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1084, 16, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 806, 17, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1, 18, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 32, 19, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 898, 20, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 901, 21, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 627, 22, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1091, 23, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1092, 24, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1093, 25, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 1133, 26, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 353, 0, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (83, NULL, 354, 0, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 2, 1, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 11, 1, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 30, 1, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 805, 1, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 807, 1, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1000, 1, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1008, 1, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1038, 1, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1074, 1, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 3, 2, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 808, 2, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 865, 2, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 882, 2, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1004, 2, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1016, 2, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1025, 2, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 9, 3, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 894, 3, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 999, 3, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1017, 3, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1020, 3, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1026, 3, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 10, 4, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 918, 4, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1006, 4, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1013, 4, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1019, 4, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1027, 4, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 7, 5, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 954, 5, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1001, 5, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1009, 5, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1021, 5, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1040, 5, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 8, 6, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 919, 6, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1007, 6, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1028, 6, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1099, 6, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1108, 6, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 5, 7, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1002, 7, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1029, 7, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1087, 7, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1097, 7, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1105, 7, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 813, 8, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1018, 8, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1095, 8, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1098, 8, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1104, 8, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1109, 8, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 830, 9, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 921, 9, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 995, 9, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1096, 9, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1107, 9, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1117, 9, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 812, 10, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 920, 10, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1106, 10, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 969, 11, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 968, 12, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1115, 12, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 799, 13, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1113, 13, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 627, 14, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 848, 15, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 907, 16, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 917, 17, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 801, 18, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 21, 19, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 29, 20, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 800, 21, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 803, 22, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 20, 23, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 804, 24, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1015, 25, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 886, 26, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 993, 27, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1120, 28, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1, 29, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 806, 30, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1078, 31, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 32, 32, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1093, 33, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1132, 34, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1086, 35, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1023, 36, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 898, 37, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1121, 38, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 1092, 39, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 353, 0, 0)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (82, NULL, 354, 0, 0)
GO

INSERT [censusweb_mdb].[dbo].[tblViewGroupAccess] ([tGroup], [nViewID], [nAccessType]) VALUES (N'Asset Type Admins', 83, NULL)
INSERT [censusweb_mdb].[dbo].[tblViewGroupAccess] ([tGroup], [nViewID], [nAccessType]) VALUES (N'Admins', 83, NULL)
INSERT [censusweb_mdb].[dbo].[tblViewGroupAccess] ([tGroup], [nViewID], [nAccessType]) VALUES (N'Admins', 82, NULL)
INSERT [censusweb_mdb].[dbo].[tblViewGroupAccess] ([tGroup], [nViewID], [nAccessType]) VALUES (N'Asset Type Admins', 82, NULL)
INSERT [censusweb_mdb].[dbo].[tblViewGroupAccess] ([tGroup], [nViewID], [nAccessType]) VALUES (N'SoftwareManagers', 82, NULL)
GO

INSERT [censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (83, 2, N'100')
INSERT [censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (83, 6, N'<None>')
INSERT [censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (83, 7, N'Software Asset Types')
INSERT [censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (83, 8, N'Software Asset Types')
INSERT [censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (83, 13, N'1')
INSERT [censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (83, 16, N'0')
INSERT [censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (83, 22, N'798')
INSERT [censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (83, 23, N'software asset type')
INSERT [censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (83, 24, N'software asset types')
INSERT [censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (83, 28, N'an')
INSERT [censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (83, 15, N'1')
INSERT [censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (83, 21, N'59')
INSERT [censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (83, 29, N'no')
INSERT [censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (82, 15, N'6')
INSERT [censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (82, 16, N'0')
INSERT [censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (82, 21, N'57')
INSERT [censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (82, 27, N'View all software asset instances')
INSERT [censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (82, 23, N'asset')
INSERT [censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (82, 22, N'798')
INSERT [censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (82, 24, N'software assets')
INSERT [censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (82, 14, N'1')
INSERT [censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (82, 2, N'100')
INSERT [censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (82, 6, N'<None>')
INSERT [censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (82, 7, N'Software Assets')
INSERT [censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (82, 8, N'Software Assets')
INSERT [censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (82, 13, N'10')
INSERT [censusweb_mdb].[dbo].[tblWebViewAttribute] ([nViewID], [nViewAttributeID], [tValue]) VALUES (82, 29, N'no')
GO

UPDATE [censusweb_mdb].[dbo].[tblWebViewAttribute] SET tValue=60 WHERE [nViewID]=20 AND [nViewAttributeID]=21
GO

DELETE FROM [censusweb_mdb].[dbo].[tblQuery] WHERE [nViewID]=44 AND [nQueryID]=33
DELETE FROM [censusweb_mdb].[dbo].[tblQuery] WHERE [nViewID]=20 AND [nQueryID]=22
GO

UPDATE [censusweb_mdb].[dbo].[tblFieldAttribute] SET [tAttributeValue]='Calculation is based on the purchase unit price. Usually a positive number indicates a surplus of licenses, but this depends on the licensing calculation.' WHERE nFieldID=697 AND nViewID=54 AND nAttributeID=91 
GO

UPDATE [censusweb_mdb].[dbo].[tblFieldAttribute] SET tAttributeValue='<script type="text/javascript">parent.m_objLoadDataMgr.SetOnAfterLoad("g_VWS.RecordMgr().CurrentRecord().FldVals(%fieldid%).SetValue(3);", true);</script>' WHERE nViewID IN(31,33) AND nFieldID=90 and nAttributeID=55
GO

UPDATE [censusweb_mdb].[dbo].[tblWebViewAttribute] SET tValue='Software' WHERE nViewID=54 AND nViewAttributeID IN (7,8) AND tValue='Software Licenses'
GO

INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 894, 3, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 918, 4, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 954, 5, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 919, 6, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 1097, 7, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 1098, 8, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 921, 9, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 920, 10, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 969, 11, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 968, 12, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 799, 13, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 627, 14, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 848, 15, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 907, 16, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 917, 17, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 801, 18, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 21, 19, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 29, 20, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 800, 21, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 803, 22, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 20, 23, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 804, 24, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 1015, 25, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 886, 26, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 993, 27, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 1120, 28, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 1, 29, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 1078, 31, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 32, 32, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 1093, 33, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 1132, 34, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 1023, 36, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 1092, 39, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 2, 1, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 3, 2, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 9, 3, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 10, 4, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 7, 5, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 8, 6, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 5, 7, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 813, 8, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 830, 9, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 812, 10, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 1115, 12, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 1113, 13, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (74, NULL, 1135, 10, 2)
GO

INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 20, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 21, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 29, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 627, 23, N'5', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 800, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 801, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 803, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 804, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 806, 13, N'Allocation Type', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 806, 14, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 806, 60, N'SpanTwoWidthOne', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 886, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 917, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 954, 79, N'yes', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 954, 81, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 993, 68, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 993, 82, N'yes', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 1023, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 1092, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 1092, 79, N'yes', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 1093, 79, N'yes', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 1113, 5, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 1113, 95, N'fldRelatedHDIssues.htmpl', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 1135, 13, N'See More Details', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (74, 1135, 95, N'fld_switch.htmpl', NULL)
GO

INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (79, NULL, 1023, 5, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (79, NULL, 806, 6, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (79, NULL, 886, 7, 2)
INSERT [censusweb_mdb].[dbo].[tblView] ([nViewID], [nTabID], [nFieldID], [nFieldIndex], [nStatus]) VALUES (79, NULL, 1092, 8, 2)
GO

INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (79, 806, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (79, 886, 56, N'no', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (79, 1092, 56, N'no', NULL)
GO

INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (5, 866, 17, N'2', NULL)
INSERT [censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (5, 866, 59, N'SpanTwoWidthOne', NULL)
GO

INSERT INTO censusweb_mdb.dbo.tblQuery ([nViewID], [nQueryID], [nStatus]) VALUES (54, 12, 2)
GO

INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (17, 836, 56, N'no', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (21, 836, 56, N'no', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (25, 836, 56, N'no', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (50, 836, 56, N'no', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (51, 836, 56, N'no', NULL)
INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (52, 836, 56, N'no', NULL)
GO

INSERT [Censusweb_mdb].[dbo].[tblFieldAttribute] ([nViewID], [nFieldID], [nAttributeID], [tAttributeValue], [nStatus]) VALUES (57, 45, 56, N'no', NULL)
GO

DELETE FROM [censusweb_mdb].[dbo].[tblQuery] WHERE nQueryID=25 AND nViewID=46
DELETE FROM [censusweb_mdb].[dbo].[tblQuery] WHERE nQueryID=38 AND nViewID=44
DELETE FROM [censusweb_mdb].[dbo].[tblQuery] WHERE nQueryID IN(35,36) AND nViewID=18
GO

/***********************************************************************/

USE [HelpDesk01_Dat]
GO

UPDATE [HelpDesk01_Dat].[dbo].tblDts SET mDetailedDescription='<div><div>2/7/2017 9:40:10 AM&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; analyst</div>
<div><br>Please help, I cant get my email on my iPhone</div></div>' WHERE nID=11
UPDATE [HelpDesk01_Dat].[dbo].tblDts SET tBriefDescription='Email help on my phone' WHERE nID=11
UPDATE [HelpDesk01_Dat].[dbo].tblDts SET Activity$Log='<table style="position:relative;width:100%;top:0px;left:0%" cellpadding="0" cellspacing="0" border="0"><tr style="height: 20px"><td width="14" style="vertical-align: bottom;padding: 0px"><div class="BoxTLeft"></div></td><td class="BoxTCenter">&#160;</td><td width="14" style="vertical-align: bottom;padding: 0px"><div class="BoxTRight"></div></td></tr><tr style="width:100%;"><td width="14" class="BoxMLeft">&#160;</td><td style="width:100%;" class="BoxMCenter"><table class="TSLog" cellspacing="0" cellpadding="0" border="0"><tr><td class="TSLogCellTitle" style="width: 24px;"><a href="javascript:m_objMe.ShowConversation(5)" class="TSLog" title="View this e-mail in the E-mail Conversation"><img src="..\..\Theme\images\images\incoming.gif" alt="Incoming E-mail" title="Incoming E-mail" width="16" height="16" style="border: 0px" /></a></td><td class="TSLogCellTitle" style="width: 70%;text-align: left;"><span style="position: relative;left: 5px"><a href="javascript:m_objMe.ShowConversation(5)" class="TSLog" title="View this e-mail in the E-mail Conversation"><b>&quot;Chris Hubbard&quot; &lt;email@yourcompany&gt; </b></a></span></td><td class="TSLogCellTitle" style="width: 200px;text-align: right;padding-right: 2px;">2/7/2017 9:52 AM</td></tr><tr><td class="TSLogCellBody" colspan="3"><hr class="LineSep" size="1" /><a href="javascript:m_objMe.ShowConversation(5)" class="TSLog" title="View this e-mail in the E-mail Conversation"><b>Subject:</b> RE: Email help on my phone (Issue ID: 11)<br /><b>To:</b> &quot;Vector Networks Inc&quot; &lt;vectornetworks@outlook.com&gt;</a><br /><br /><br/><br/>Im using:<br/>XXX<br/>YYY<br/>ZZZ<br/> <br/><br/><br/>From: Vector Networks Inc [mailto:vectornetworks@outlook.com]<br/> Sent: Tuesday, February 07, 2017 9:49 AM<br/>To: Chris Hubbard<br/>Subject: RE: Email help on my phone (Iss<br /><a href="javascript:m_objMe.ShowConversation(5)" class="TSLog" title="View this e-mail in the E-mail Conversation"><b>(view e-mail)</b></a><br /></td></tr></table></td><td width="14" class="BoxMRight">&#160;</td></tr><tr style="height: 20px"><td width="14" style="vertical-align: top;padding: 0px"><div class="BoxBLeft"></div></td><td class="BoxBCenter">&#160;</td><td width="14" style="vertical-align: top;padding: 0px"><div class="BoxBRight"></div></td></tr></table><table style="position:relative;width:100%;top:0px;left:0%" cellpadding="0" cellspacing="0" border="0"><tr style="height: 20px"><td width="14" style="vertical-align: bottom;padding: 0px"><div class="BoxTLeft"></div></td><td class="BoxTCenter">&#160;</td><td width="14" style="vertical-align: bottom;padding: 0px"><div class="BoxTRight"></div></td></tr><tr style="width:100%;"><td width="14" class="BoxMLeft">&#160;</td><td style="width:100%;" class="BoxMCenter"><table class="TSLog" cellspacing="0" cellpadding="0" border="0"><tr><td class="TSLogCellTitle" style="width: 24px;"><a href="javascript:m_objMe.ShowConversation(4)" class="TSLog" title="View this e-mail in the E-mail Conversation"><img src="..\..\Theme\images\images\outgoing.gif" alt="Outgoing E-mail" title="Outgoing E-mail" width="16" height="16" style="border: 0px" /></a></td><td class="TSLogCellTitle" style="width: 70%;text-align: left;"><span style="position: relative;left: 5px"><a href="javascript:m_objMe.ShowConversation(4)" class="TSLog" title="View this e-mail in the E-mail Conversation"><b>vectornetworks@outlook.com </b></a></span></td><td class="TSLogCellTitle" style="width: 200px;text-align: right;padding-right: 2px;">2/7/2017 9:49 AM</td></tr><tr><td class="TSLogCellBody" colspan="3"><hr class="LineSep" size="1" /><a href="javascript:m_objMe.ShowConversation(4)" class="TSLog" title="View this e-mail in the E-mail Conversation"><b>Subject:</b> RE: Email help on my phone (Issue ID: 11)<br /><b>To:</b> &quot;Chris Hubbard&quot; &lt;email@yourcompany&gt;</a><br /><br /><br/>Please send the mail account settings you are using.From: &quot;Chris Hubbard&quot; &lt;email@yourcompany&gt;<br/>Sent: 2/7/2017 9:39:20 AM<br/>To: vectornetworks@outlook.com<br/>Subject: Email help on my phone<br/> <br/><br/>P<br /><a href="javascript:m_objMe.ShowConversation(4)" class="TSLog" title="View this e-mail in the E-mail Conversation"><b>(view e-mail)</b></a><br /></td></tr></table></td><td width="14" class="BoxMRight">&#160;</td></tr><tr style="height: 20px"><td width="14" style="vertical-align: top;padding: 0px"><div class="BoxBLeft"></div></td><td class="BoxBCenter">&#160;</td><td width="14" style="vertical-align: top;padding: 0px"><div class="BoxBRight"></div></td></tr></table><table style="position:relative;width:100%;top:0px;left:0%" cellpadding="0" cellspacing="0" border="0"><tr style="height: 20px"><td width="14" style="vertical-align: bottom;padding: 0px"><div class="BoxTLeft"></div></td><td class="BoxTCenter">&#160;</td><td width="14" style="vertical-align: bottom;padding: 0px"><div class="BoxTRight"></div></td></tr><tr style="width:100%;"><td width="14" class="BoxMLeft">&#160;</td><td style="width:100%;" class="BoxMCenter"><table class="TSLog" cellspacing="0" cellpadding="0" border="0"><tr><td class="TSLogCellTitle" style="width: 24px;"><a href="javascript:m_objMe.ShowConversation(3)" class="TSLog" title="View this e-mail in the E-mail Conversation"><img src="..\..\Theme\images\images\incoming.gif" alt="Incoming E-mail" title="Incoming E-mail" width="16" height="16" style="border: 0px" /></a></td><td class="TSLogCellTitle" style="width: 70%;text-align: left;"><span style="position: relative;left: 5px"><a href="javascript:m_objMe.ShowConversation(3)" class="TSLog" title="View this e-mail in the E-mail Conversation"><b>&quot;Chris Hubbard&quot; &lt;email@yourcompany&gt; </b></a></span></td><td class="TSLogCellTitle" style="width: 200px;text-align: right;padding-right: 2px;">2/7/2017 9:40 AM</td></tr><tr><td class="TSLogCellBody" colspan="3"><hr class="LineSep" size="1" /><a href="javascript:m_objMe.ShowConversation(3)" class="TSLog" title="View this e-mail in the E-mail Conversation"><b>Subject:</b> Email help on my phone<br /><b>To:</b> vectornetworks@outlook.com</a><br /><br /><br/><br/>Please help, I cant get my email on my iPhone<br/> <br /><a href="javascript:m_objMe.ShowConversation(3)" class="TSLog" title="View this e-mail in the E-mail Conversation"><b>(view e-mail)</b></a><br /></td></tr></table></td><td width="14" class="BoxMRight">&#160;</td></tr><tr style="height: 20px"><td width="14" style="vertical-align: top;padding: 0px"><div class="BoxBLeft"></div></td><td class="BoxBCenter">&#160;</td><td width="14" style="vertical-align: top;padding: 0px"><div class="BoxBRight"></div></td></tr></table>' WHERE nID=11
UPDATE [HelpDesk01_Dat].[dbo].tblDts SET nSource=2 WHERE nID=11
GO

INSERT [HelpDesk01_Dat].[dbo].[tblMailIntegrationQueue] ([nID], [nIssueID], [tFrom], [tRecipients], [mCC], [tSubject], [mBodyText], [mAttachments], [bHTMLBody], [nIntegrationID], [dTimeStamp], [bIncoming], [bSent], [dTimeStampProcessed], [mBCC]) VALUES (5, 11, N'"Chris Hubbard" <email@yourcompany>', N'"Vector Networks Inc" <vectornetworks@outlook.com>', N'', N'RE: Email help on my phone (Issue ID: 11)', N'<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html xmlns:v="urn:schemas-microsoft-com:vml" xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:w="urn:schemas-microsoft-com:office:word" xmlns:m="http://schemas.microsoft.com/office/2004/12/omml" xmlns="http://www.w3.org/TR/REC-html40">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-16LE">
<meta name="Generator" content="Microsoft Word 14 (filtered medium)"><!--[if !mso]><style>v\:* {behavior:url(#default#VML);}
o\:* {behavior:url(#default#VML);}
w\:* {behavior:url(#default#VML);}
.shape {behavior:url(#default#VML);}
</style><![endif]-->
<style type="text/css">
<!--
/* Font Definitions */
@font-face
        {font-family:"Cambria Math";
        panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
        {font-family:Calibri;
        panose-1:2 15 5 2 2 2 4 3 2 4;}
@font-face
        {font-family:Tahoma;
        panose-1:2 11 6 4 3 5 4 4 2 4;}
/* Style Definitions */
p.MsoNormal, li.MsoNormal, div.MsoNormal
        {margin:0in;
        margin-bottom:.0001pt;
        font-size:11.0pt;
        font-family:"Calibri","sans-serif";}
a:link, span.MsoHyperlink
        {mso-style-priority:99;
        color:blue;
        text-decoration:underline;}
a:visited, span.MsoHyperlinkFollowed
        {mso-style-priority:99;
        color:purple;
        text-decoration:underline;}
p.MsoAcetate, li.MsoAcetate, div.MsoAcetate
        {mso-style-priority:99;
        mso-style-link:"Balloon Text Char";
        margin:0in;
        margin-bottom:.0001pt;
        font-size:8.0pt;
        font-family:"Tahoma","sans-serif";}
span.EmailStyle17
        {mso-style-type:personal;
        font-family:"Calibri","sans-serif";
        color:windowtext;}
span.BalloonTextChar
        {mso-style-name:"Balloon Text Char";
        mso-style-priority:99;
        mso-style-link:"Balloon Text";
        font-family:"Tahoma","sans-serif";}
span.EmailStyle20
        {mso-style-type:personal-reply;
        font-family:"Calibri","sans-serif";
        color:#548DD4;}
.MsoChpDefault
        {mso-style-type:export-only;
        font-size:10.0pt;}
@page WordSection1
        {size:8.5in 11.0in;
        margin:1.0in 1.0in 1.0in 1.0in;}
div.WordSection1
        {page:WordSection1;}
-->
</style>
<!--[if gte mso 9]><xml>
<o:shapedefaults v:ext="edit" spidmax="1026" />
</xml><![endif]--><!--[if gte mso 9]><xml>
<o:shapelayout v:ext="edit">
<o:idmap v:ext="edit" data="1" />
</o:shapelayout></xml><![endif]-->
<title></title>
</head>
<body lang="EN-US" link="blue" vlink="purple">
<div class="WordSection1">
<p class="MsoNormal"><span style="color:#548DD4">Im using:</span></p>
<p class="MsoNormal"><span style="color:#548DD4">XXX</span></p>
<p class="MsoNormal"><span style="color:#548DD4">YYY</span></p>
<p class="MsoNormal"><span style="color:#548DD4">ZZZ</span></p>
<p class="MsoNormal"><span style="color:#548DD4">&nbsp;</span></p>
<div>
<div style="border:none;border-top:solid #B5C4DF 1.0pt;padding:3.0pt 0in 0in 0in">
<p class="MsoNormal"><b><span style="font-size:10.0pt;font-family:&quot;Tahoma&quot;,&quot;sans-serif&quot;">From:</span></b> <span style="font-size:10.0pt;font-family:&quot;Tahoma&quot;,&quot;sans-serif&quot;">Vector Networks Inc [mailto:vectornetworks@outlook.com]<br>
 <b>Sent:</b> Tuesday, February 07, 2017 9:49 AM<br>
<b>To:</b> Chris Hubbard<br>
<b>Subject:</b> RE: Email help on my phone (Issue ID: 11)</span></p></div></div>
<p class="MsoNormal">&nbsp;</p>
<div>
<p class="MsoNormal"><span style="font-size:12.0pt;font-family:&quot;Times New Roman&quot;,&quot;serif&quot;">Please send the mail account settings you are using.</span></p>
<div class="MsoNormal" align="center" style="text-align:center">
<hr size="2" width="100%" align="center"></div>
<p class="MsoNormal"><b><span style="font-size:12.0pt;font-family:&quot;Times New Roman&quot;,&quot;serif&quot;">From:</span></b> <span style="font-size:12.0pt;font-family:&quot;Times New Roman&quot;,&quot;serif&quot;">"Chris Hubbard" &lt;<a href="mailto:email@yourcompany">email@yourcompany</a>&gt;<br>
<b>Sent:</b> 2/7/2017 9:39:20 AM<br>
<b>To:</b> <a href="mailto:vectornetworks@outlook.com">vectornetworks@outlook.com</a><br>
<b>Subject:</b> Email help on my phone<br>
&nbsp;</span></p>
<p class="MsoNormal">Please help, I cant get my email on my iPhone</p>
<p class="MsoNormal">&nbsp;</p></div></div>
</body>
</html>
', N'', 1, 4, CAST(0x0000A71300A253DC AS DateTime), 1, 0, CAST(0x0000A71300A2C45C AS DateTime), N'')
GO
INSERT [HelpDesk01_Dat].[dbo].[tblMailIntegrationQueue] ([nID], [nIssueID], [tFrom], [tRecipients], [mCC], [tSubject], [mBodyText], [mAttachments], [bHTMLBody], [nIntegrationID], [dTimeStamp], [bIncoming], [bSent], [dTimeStampProcessed], [mBCC]) VALUES (4, 11, N'vectornetworks@outlook.com', N'"Chris Hubbard" <email@yourcompany>', N'', N'RE: Email help on my phone (Issue ID: 11)', N'<meta content="Microsoft Word 14 (filtered medium)" name="Generator" /><style type="text/css"><!--/* Font Definitions */@font-face        {font-family:"Cambria Math";        panose-1:2 4 5 3 5 4 6 3 2 4;}@font-face        {font-family:Calibri;        panose-1:2 15 5 2 2 2 4 3 2 4;}/* Style Definitions */p.MsoNormal, li.MsoNormal, div.MsoNormal        {margin:0in;        margin-bottom:.0001pt;        font-size:11.0pt;        font-family:"Calibri","sans-serif";}a:link, span.MsoHyperlink        {mso-style-priority:99;        color:blue;        text-decoration:underline;}a:visited, span.MsoHyperlinkFollowed        {mso-style-priority:99;        color:purple;        text-decoration:underline;}span.EmailStyle17        {mso-style-type:personal-compose;        font-family:"Calibri","sans-serif";        color:windowtext;}.MsoChpDefault        {mso-style-type:export-only;        font-family:"Calibri","sans-serif";}@page WordSection1        {size:8.5in 11.0in;        margin:1.0in 1.0in 1.0in 1.0in;}div.WordSection1        {page:WordSection1;}--></style><!--[if gte mso 9]><xml><o:shapedefaults v:ext="edit" spidmax="1026" /></xml><![endif]--><!--[if gte mso 9]><xml><o:shapelayout v:ext="edit"><o:idmap v:ext="edit" data="1" /></o:shapelayout></xml><![endif]--><title></title><div>Please send the mail account settings you are using.<hr /><b>From:</b> "Chris Hubbard" &lt;email@yourcompany&gt;<br /><b>Sent:</b> 2/7/2017 9:39:20 AM<br /><b>To:</b> vectornetworks@outlook.com<br /><b>Subject:</b> Email help on my phone<br />&nbsp;<div class="WordSection1"><p class="MsoNormal">Please help, I cant get my email on my iPhone</p>
<p class="MsoNormal">&nbsp;</p></div></div>', N'', 1, 0, CAST(0x0000A71300A1D2F4 AS DateTime), 0, 1, CAST(0x0000A71300A1D2F4 AS DateTime), N'')
GO
INSERT [HelpDesk01_Dat].[dbo].[tblMailIntegrationQueue] ([nID], [nIssueID], [tFrom], [tRecipients], [mCC], [tSubject], [mBodyText], [mAttachments], [bHTMLBody], [nIntegrationID], [dTimeStamp], [bIncoming], [bSent], [dTimeStampProcessed], [mBCC]) VALUES (3, 11, N'"Chris Hubbard" <email@yourcompany>', N'vectornetworks@outlook.com', N'', N'Email help on my phone', N'<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html xmlns:v="urn:schemas-microsoft-com:vml" xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:w="urn:schemas-microsoft-com:office:word" xmlns:m="http://schemas.microsoft.com/office/2004/12/omml" xmlns="http://www.w3.org/TR/REC-html40">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-16LE">
<meta name="Generator" content="Microsoft Word 14 (filtered medium)">
<style type="text/css">
<!--
/* Font Definitions */
@font-face
        {font-family:"Cambria Math";
        panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
        {font-family:Calibri;
        panose-1:2 15 5 2 2 2 4 3 2 4;}
/* Style Definitions */
p.MsoNormal, li.MsoNormal, div.MsoNormal
        {margin:0in;
        margin-bottom:.0001pt;
        font-size:11.0pt;
        font-family:"Calibri","sans-serif";}
a:link, span.MsoHyperlink
        {mso-style-priority:99;
        color:blue;
        text-decoration:underline;}
a:visited, span.MsoHyperlinkFollowed
        {mso-style-priority:99;
        color:purple;
        text-decoration:underline;}
span.EmailStyle17
        {mso-style-type:personal-compose;
        font-family:"Calibri","sans-serif";
        color:windowtext;}
.MsoChpDefault
        {mso-style-type:export-only;
        font-family:"Calibri","sans-serif";}
@page WordSection1
        {size:8.5in 11.0in;
        margin:1.0in 1.0in 1.0in 1.0in;}
div.WordSection1
        {page:WordSection1;}
-->
</style>
<!--[if gte mso 9]><xml>
<o:shapedefaults v:ext="edit" spidmax="1026" />
</xml><![endif]--><!--[if gte mso 9]><xml>
<o:shapelayout v:ext="edit">
<o:idmap v:ext="edit" data="1" />
</o:shapelayout></xml><![endif]-->
<title></title>
</head>
<body lang="EN-US" link="blue" vlink="purple">
<div class="WordSection1">
<p class="MsoNormal">Please help, I cant get my email on my iPhone</p>
<p class="MsoNormal">&nbsp;</p></div>
</body>
</html>
', N'', 1, 4, CAST(0x0000A713009F1E60 AS DateTime), 1, 0, CAST(0x0000A713009F4188 AS DateTime), N'')
GO

DELETE FROM HelpDesk01_Dat.dbo.tblDts WHERE nID=15 and tBriefDescription IS NULL
GO

UPDATE HelpDesk01_Dat.dbo.tblDts SET Computer=367, ComputerName='QA-COMP-004' WHERE nID IN(5, 6, 7, 11) AND Computer IS NULL
UPDATE HelpDesk01_Dat.dbo.tblDts SET Computer=359, ComputerName='QA-COMP-002' WHERE nID IN(13) AND Computer IS NULL
UPDATE HelpDesk01_Dat.dbo.tblDts SET Computer=571, ComputerName='SUPPORT-COMP-018' WHERE nID IN(14) AND Computer IS NULL
UPDATE HelpDesk01_Dat.dbo.tblDts SET Computer=359, ComputerName='QA-COMP-002' WHERE nID IN(12) AND ComputerName IS NULL
UPDATE HelpDesk01_Dat.dbo.tblDts SET Computer=365, ComputerName='ACCT-COMP-002' WHERE nID IN(10,16) AND Computer IS NULL
UPDATE HelpDesk01_Dat.dbo.tblDts SET Computer=358, ComputerName='DEV-COMP-003' WHERE nID IN(1) AND Computer IS NULL
UPDATE HelpDesk01_Dat.dbo.tblDts SET Computer=30, ComputerName='SAMPLELAPTOP1' WHERE nID IN(2,3) AND Computer IS NULL
UPDATE HelpDesk01_Dat.dbo.tblDts SET Computer=561, ComputerName='SUPPORT-COMP-008' WHERE nID IN(4) AND Computer IS NULL
UPDATE HelpDesk01_Dat.dbo.tblDts SET Computer=362, ComputerName='SALES-COMP-001' WHERE nID IN(8) AND Computer IS NULL
GO


/***********************************************************************/

USE HelpDesk02_Def
GO

UPDATE [HelpDesk02_Def].[dbo].tblDtsFields SET tWhere='Where (([nID] >= 0 And  [tName]  <> '''') Or [tName]  = ''<User>'' Or tUserName=''mailagent'') And (Security_Type = 1 OR Security_Type = 8)' WHERE nID=12 AND tWhere='Where (([nID] >= 0 And  [tName]  <> '''') Or [tName]  = ''<User>'' Or tUserName=''mailagent'') And Security_Type = 1'
GO

ALTER TABLE HelpDesk02_Def.dbo.tblSystemCustomQueries ADD nDefaultSort int
ALTER TABLE HelpDesk02_Def.dbo.tblSystemCustomQueries ADD nDefaultLayout int 
GO

UPDATE [HelpDesk02_Def].[dbo].[tblSystemCustomReports] SET tCaption='* Activity Effort Time - By Issue' WHERE nID=173 AND tCaption='Activity Effort Time - By Issue'
UPDATE [HelpDesk02_Def].[dbo].[tblSystemCustomReports] SET tCaption='* HelpDesk Summary - Year to Date' WHERE nID=49 AND tCaption='HelpDesk Summary - Year to Date'
UPDATE [HelpDesk02_Def].[dbo].[tblSystemCustomReports] SET tCaption='* Key Performance Indicators' WHERE nID=174 AND tCaption='Key Performance Indicators'
UPDATE [HelpDesk02_Def].[dbo].[tblSystemCustomReports] SET tCaption='* Open Issues - Overdue Listing' WHERE nID=37 AND tCaption='Open Issues - Overdue Listing'
UPDATE [HelpDesk02_Def].[dbo].[tblSystemCustomReports] SET tCaption='* Resolved Issues - Avg Age and Time Spent' WHERE nID=44 AND tCaption='Resolved Issues - Avg Age and Time Spent'
UPDATE [HelpDesk02_Def].[dbo].[tblSystemCustomReports] SET tCaption='* Open Issues - Average Age' WHERE nID=30 AND tCaption='Open Issues - Average Age'
UPDATE [HelpDesk02_Def].[dbo].[tblSystemCustomReports] SET tCaption='* Open Issues - by Priority' WHERE nID=28 AND tCaption='Open Issues - by Priority'
GO

/***********************************************************************/

USE Installations02_Def
GO

ALTER TABLE Installations02_Def.dbo.tblSystemCustomQueries ADD nDefaultSort int
ALTER TABLE Installations02_Def.dbo.tblSystemCustomQueries ADD nDefaultLayout int 
GO

/***********************************************************************/

USE InventoriedSoftware02_Def
GO

ALTER TABLE InventoriedSoftware02_Def.dbo.tblSystemCustomQueries ADD nDefaultSort int
ALTER TABLE InventoriedSoftware02_Def.dbo.tblSystemCustomQueries ADD nDefaultLayout int 
GO

/***********************************************************************/
USE LicenseManager02_Def
GO

UPDATE [LicenseManager02_Def].[dbo].[tblNotification] SET tDescription='The Status of the Software License was updated.' WHERE nID=8 and tDescription='The Status f the Software Licenses was updated.'
GO

UPDATE [LicenseManager02_Def].[dbo].[tblRule] SET nTrigger=1 WHERE nID=62
GO

UPDATE [LicenseManager02_Def].[dbo].[tblDtsFields] SET tCaption='Value of Unused Installations', tLabelCaption='Value of Unused Installations' WHERE nID=697
GO

UPDATE [LicenseManager02_Def].[dbo].[tblDtsFields] SET fRequired=1 WHERE nID=706 AND tName='Licensing_Calculation'
GO

UPDATE [LicenseManager02_Def].[dbo].[tblDtsFields] SET tCaption='Vendor', tLabelCaption='Vendor' WHERE tName='Software_Publisher' AND tCaption='Software Publisher' and tLabelCaption='Software Publisher'
UPDATE [LicenseManager02_Def].[dbo].[tblDtsFields] SET tFieldValuesTable='Vendor' WHERE tName='Software_Publisher' AND tFieldValuesTable='Supplier'
GO

UPDATE [LicenseManager02_Def].[dbo].tblSystemReportListings SET tTitle='Vendor' WHERE tTitle='Software Publisher' AND nDtsFieldID=408
GO

UPDATE [LicenseManager02_Def].[dbo].[tblSystemLayouts] SET nWidth=0 WHERE nID=22 AND nDtsFieldID=740
UPDATE [LicenseManager02_Def].[dbo].[tblSystemLayouts] SET tTitle='Start Date' WHERE nID=22 AND nDtsFieldID=678 AND tTitle='From'
UPDATE [LicenseManager02_Def].[dbo].[tblSystemLayouts] SET tTitle='End Date' WHERE nID=22 AND nDtsFieldID=679 AND tTitle='To'
GO

INSERT [LicenseManager02_Def].[dbo].[tblSystemLayouts] ([nID], [tAlign], [nWidth], [tTitle], [nRow], [nDtsFieldID]) VALUES (22, N'Left', 10, N'Purchase Date', 16, 674)
GO
UPDATE LicenseManager02_Def.dbo.tblSystemLayouts SET nRow = nRow+2 WHERE nID=22
GO
UPDATE LicenseManager02_Def.dbo.tblSystemLayouts SET nRow=1 WHERE nID=22 AND nDtsFieldID=678
GO
UPDATE LicenseManager02_Def.dbo.tblSystemLayouts SET nRow=2 WHERE nID=22 AND nDtsFieldID=679
GO

UPDATE [LicenseManager02_Def].[dbo].[tblSystemCustomReports] SET tCaption='* Licenses by Application' WHERE nID=233 AND tCaption='Licenses by Application'
UPDATE [LicenseManager02_Def].[dbo].[tblSystemCustomReports] SET tCaption='* Renewals & Compliance Overview' WHERE nID=285 AND tCaption='Renewals & Compliance Overview'
UPDATE [LicenseManager02_Def].[dbo].[tblSystemCustomReports] SET tCaption='* Software Expenses' WHERE nID=276 AND tCaption='Software Expenses'
UPDATE [LicenseManager02_Def].[dbo].[tblSystemCustomReports] SET tCaption='* Software License Compliance - Simple' WHERE nID=275 AND tCaption='Software License Compliance - Simple'
GO

/***********************************************************************/

USE Licenses_mdb
GO

INSERT [Licenses_mdb].[dbo].[tblSettings] ([nID], [tValue], [tName], [nType], [tDescription], [tValidationRule], [nCustomAction], [tCACaption], [tCADisplay], [tValueSourceTable]) VALUES (464, N'Yes', N'Show "Log in with my network account" on Logon Page', 103, N'Enable this option to allow users to log in with their network account from the logon page.  This change will only be applied after you regenerate a Web view (per virtual directory).', NULL, NULL, NULL, NULL, N'tblSystemBooleanValue')
GO

INSERT [Licenses_mdb].[dbo].[tblGroupPrivileges] ([tGroup], [nFeatureID], [fEnabled]) VALUES (N'IT Asset Managers', 20, 0)
GO

INSERT [Licenses_mdb].[dbo].[tblProjectAccess] ([nID], [tGroup]) VALUES (8, N'IT Asset Managers')
INSERT [Licenses_mdb].[dbo].[tblProjectAccess] ([nID], [tGroup]) VALUES (22, N'IT Asset Managers')
INSERT [Licenses_mdb].[dbo].[tblProjectAccess] ([nID], [tGroup]) VALUES (4, N'Students')
INSERT [Licenses_mdb].[dbo].[tblProjectAccess] ([nID], [tGroup]) VALUES (4, N'Teachers')
INSERT [Licenses_mdb].[dbo].[tblProjectAccess] ([nID], [tGroup]) VALUES (9, N'Students')
INSERT [Licenses_mdb].[dbo].[tblProjectAccess] ([nID], [tGroup]) VALUES (9, N'Teachers')
INSERT [Licenses_mdb].[dbo].[tblProjectAccess] ([nID], [tGroup]) VALUES (15, N'Students')
INSERT [Licenses_mdb].[dbo].[tblProjectAccess] ([nID], [tGroup]) VALUES (15, N'Teachers')
INSERT [Licenses_mdb].[dbo].[tblProjectAccess] ([nID], [tGroup]) VALUES (15, N'SoftwareManagers')
GO

DELETE FROM Licenses_mdb.dbo.tblProjectAccess WHERE nID=29 AND nID IN (SELECT nProjectID FROM Licenses_mdb.dbo.tblProjectDS WHERE nProjectID=29 AND tName='Projects01_Dat' AND nDSType=32)
DELETE FROM Licenses_mdb.dbo.tblProjectDS WHERE nProjectID=29 AND nProjectID IN (SELECT nProjectID FROM Licenses_mdb.dbo.tblProjectDS WHERE nProjectID=29 AND tName='Projects01_Dat' AND nDSType=32)
GO

/***********************************************************************/

USE [Purchases&Agreements01_Dat]
GO

UPDATE [Purchases&Agreements01_Dat].[dbo].[tblDts] SET Asset_Type=417 WHERE nID IN(1009, 1073, 1074, 1075, 1076) AND Asset_Type IS NULL
UPDATE [Purchases&Agreements01_Dat].[dbo].[tblDts] SET Asset_Type=550 WHERE nID IN(1085) AND Asset_Type IS NULL
UPDATE [Purchases&Agreements01_Dat].[dbo].[tblDts] SET Asset_Type=416 WHERE nID IN(1105, 1107, 1109) AND Asset_Type IS NULL
UPDATE [Purchases&Agreements01_Dat].[dbo].[tblDts] SET Asset_Type=540 WHERE nID IN(1111, 1112) AND Asset_Type IS NULL
UPDATE [Purchases&Agreements01_Dat].[dbo].[tblDts] SET Asset_Type=419 WHERE nID IN(1095, 1097, 1099, 1103) AND Asset_Type IS NULL
UPDATE [Purchases&Agreements01_Dat].[dbo].[tblDts] SET Asset_Type=420 WHERE nID IN(1114) AND Asset_Type IS NULL
UPDATE [Purchases&Agreements01_Dat].[dbo].[tblDts] SET Asset_Type=421 WHERE nID IN(1058, 1119) AND Asset_Type IS NULL
UPDATE [Purchases&Agreements01_Dat].[dbo].[tblDts] SET Asset_Type=138 WHERE nID IN(1121) AND Asset_Type IS NULL
UPDATE [Purchases&Agreements01_Dat].[dbo].[tblDts] SET Asset_Type=345 WHERE nID IN(1010, 1011, 1027, 1043, 1052) AND Asset_Type IS NULL
UPDATE [Purchases&Agreements01_Dat].[dbo].[tblDts] SET Asset_Type=343 WHERE nID IN(1057, 1080, 1081, 1082) AND Asset_Type IS NULL
UPDATE [Purchases&Agreements01_Dat].[dbo].[tblDts] SET Asset_Type=547 WHERE nID IN(1083, 1127, 1143) AND Asset_Type IS NULL
UPDATE [Purchases&Agreements01_Dat].[dbo].[tblDts] SET Asset_Type=546 WHERE nID IN(1084, 1129, 1142) AND Asset_Type IS NULL
UPDATE [Purchases&Agreements01_Dat].[dbo].[tblDts] SET Asset_Type=422 WHERE nID IN(1101) AND Asset_Type IS NULL
UPDATE [Purchases&Agreements01_Dat].[dbo].[tblDts] SET Asset_Type=1808 WHERE nID IN(1079) AND Asset_Type IS NULL
UPDATE [Purchases&Agreements01_Dat].[dbo].[tblDts] SET Asset_Type=5 WHERE nID IN(1131, 1133, 1135) AND Asset_Type IS NULL
UPDATE [Purchases&Agreements01_Dat].[dbo].[tblDts] SET Asset_Type=415 WHERE nID IN(1137) AND Asset_Type IS NULL
GO

/***********************************************************************/

USE [Purchases&Agreements02_Def]
GO

UPDATE [Purchases&Agreements02_Def].dbo.tblSystemQueries SET tValue='Purchase' WHERE nID=30 AND nDtsFieldID=912 AND tValue='Purchase Order'
GO

/***********************************************************************/

USE Resources01_Dat
GO

ALTER TABLE [Resources01_Dat].[dbo].tblDts ADD [Source_Creation_Date] [datetime] NULL
GO

ALTER TABLE [Resources01_Dat].[dbo].tblDts ADD [View_Details] [int] NULL
GO

INSERT [Resources01_Dat].[dbo].[tblDts] ([nID], [nRevisionNumber], [tShowInSummary], [nUserID], [dAssignedDate], [dAssignedTime], [dClosedDate], [dClosedTime], [dLastUpdateDate], [dSubmittedDate], [dSubmittedTime], [dUpdateTime], [mDetailedDescription], [nOriginatorID], [nPriorityID], [nSubmitterID], [nSubstateID], [tBriefDescription], [nStateID], [Activity], [Activity$Log], [Estimated$Effort], [Planned$Start$Date], [Planned$End$Date], [ComputerName], [nControlledByParent], [nSource], [Purchased_Date], [Comments], [Resource_Will_Expire_On], [Mandatory], [Provisioned], [Has_Been_Utilized], [Is_Sensitive], [nUsageType], [Estimated_Duration], [Historical_Duration], [Status], [Estimated_Start_Time], [Estimated_Closure_Time], [Access_Level], [Training], [Vendor], [Has_An_Associated_Cost_], [Printer_Name], [Active_Directory_Groups], [Allow_Multiple_Instances_Per_Role_or_Employee], [Open_Role_Allocation], [Complete_Provisioning_By], [Training_Level], [Share_Name], [Access_Code_Location], [Fileshare_Department], [Brand], [Model], [Serial_Number], [Barcode_Tag], [Asset_Tag], [Supplier_Seller], [Unit_Price], [Service_Contractor], [Delivery_Date], [Depreciation_Scheme], [Warranty_Until], [Expected_Life], [Salvage_Value], [Invoice_Reference], [Rest_Value], [Retired_Date], [Asset_Sub_status], [Quantity], [Asset_Location], [Total_Assets], [Assets_in_Use], [Assets_Remaining], [Item_Level], [UNSPSC_Code], [ASIN], [Manufacturer_ID], [Rating], [Parent], [Has_Child_Asset_Groups], [Bulk_Assets], [Managed], [CPU], [Memory], [SN], [OS_Name], [OS_Version], [Manufacturer], [PC_Model], [tSID], [License_Key], [Short_Name], [Image_Version], [Key_Name], [Base_Board_Manufacturer], [Base_Board_Product], [Base_Board_Version], [Bios_Major_Release], [Bios_Minor_Release], [Bios_Release_Date], [Bios_Vendor], [Bios_Version], [EC_Firmware_Major_Release], [EC_Firmware_Minor_Release], [System_Family], [System_Manufacturer], [System_Product_Name], [System_SKU], [System_Version], [Responsible], [Import_Source], [Import_Source_Details], [CPU_Speed], [Domain_Name], [IP_Address], [Network_Card], [Subnet_Mask], [MAC_Address], [Software_Publisher], [Accessible_To], [Warranty_Description], [Warranty_Start_Date], [Warranty_Status], [Warranty_ID], [Asset_Expires_], [Folder_Security], [Account_Type], [Account_Name], [VM_Platform], [VM_Type], [Host_Server], [VM_URL], [Source_Type], [Source_Name], [Import_Alias_1], [Import_Alias_2], [Import_Alias_3], [Last_Imported_Date], [Last_Imported_Time], [Asset_Request_Level_1_Approvers], [Asset_Request_Level_2_Approvers], [Asset_Request_Level_3_Approvers], [Asset_Request_Owner], [Asset_Request_Work_Team], [Minimum_Provisioning_Time], [Request_Priority], [Track_As], [Minimum_Quantity], [Current_Quantity], [Maximum_Quantity], [Need_to_Order_Quantity], [Allocation_Units], [Total_Allocated], [Total_Purchased], [Total_Costs_Over_Time], [Average_Total_Cost_Per_Unit], [Amount_to_Order], [Allocated_to_Department], [Allocated_to_Unit_Division], [Allocated_to_Project], [Can_Be_Requested], [Visible], [Software_Discovery_Mappings], [CPU_Count], [CPU_Cores_Count], [Primary_Owner], [Source_Timestamp], [Last_Imported_Timestamp], [Top_Console_User], [Visible_Request_Fields], [Request_Required_By_Date], [Request_Required_By_Time], [Number_Requested], [For_international_travel], [Requested_Until], [Request_Warning_Message], [Need_an_RSA_token], [Deliver_To], [Special_Instructions], [Laptop_Accessories_Needed], [For_Travel], [Litigation_Software], [Content_Loaded_on_Device], [Matter_Number], [Matter_Name], [Reason_for_Request], [Training_is_Requested], [Device_will_contain_Confidential_Data], [Needed_for_Device], [No_Approval_Needed_Level_1], [No_Approval_Needed_Level_2], [No_Approval_Needed_Level_3], [SIM_Card_Number], [IMEI], [Phone_Number], [Auto_Import_Installations], [Associated_Cost], [Approval_Needed_For], [Allocation_Rule], [Requested_Until_Time], [Related_License], [Location], [Sample_Data], [Environment], [Authorization_Required], [Application], [Access_Level_Is_Required_], [Training_Is_Required_], [ComputerName_Is_Required_], [Application_Is_Required_], [Vendor_Is_Required_], [Printer_Name_Is_Required_], [Active_Directory_Groups_Is_Required_], [Is_Missing_Required_Value], [Training_Level_Is_Required_], [Share_Name_Is_Required_], [Access_Code_Location_Is_Required_], [Room_Number], [Room_Number_Is_Required_], [Fileshare_Department_Is_Required_], [Invoice_Date], [Asset_Status], [PO_Number], [Purchased_From], [Contract_Duration__Years_], [Serial_Number_Is_Required_], [Auto_Create_License_Record], [Level_1], [Level_2], [Pool_Responsible], [Key], [Version], [Edition], [Allocated_to_Device___Computer], [dActualIRTDate], [dActualIRTTime], [ComputerChoiceList], [dTargetClosureTime], [dTargetIRT], [nAssociatedSLA], [Minimum_Approvers_Required], [Needs_Attention___Not_Seen_Recently], [Related_Bulk_Asset], [Asset_Life_Cycle_Stage], [Related_HelpDesk_Issues], [Key_Discovery___Application_Name], [Borrowable], [Software_Category], [Recurring_Costs], [Custom_Approvers], [Is_Bulk_Instance], [Reference_ID], [Family], [Source_Creation_Date]) VALUES (7180, 2, N'-1', 0, NULL, NULL, NULL, NULL, CAST(0x0000A83C00000000 AS DateTime), CAST(0x0000A83C00000000 AS DateTime), CAST(0xFFFFFFFE00E00088 AS DateTime), CAST(0xFFFFFFFE00E00088 AS DateTime), NULL, 2, NULL, 2, NULL, N'Chromebook', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 3, NULL, NULL, NULL, NULL, NULL, 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0.0000, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, 314, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
INSERT [Resources01_Dat].[dbo].[tblDts] ([nID], [nRevisionNumber], [tShowInSummary], [nUserID], [dAssignedDate], [dAssignedTime], [dClosedDate], [dClosedTime], [dLastUpdateDate], [dSubmittedDate], [dSubmittedTime], [dUpdateTime], [mDetailedDescription], [nOriginatorID], [nPriorityID], [nSubmitterID], [nSubstateID], [tBriefDescription], [nStateID], [Activity], [Activity$Log], [Estimated$Effort], [Planned$Start$Date], [Planned$End$Date], [ComputerName], [nControlledByParent], [nSource], [Purchased_Date], [Comments], [Resource_Will_Expire_On], [Mandatory], [Provisioned], [Has_Been_Utilized], [Is_Sensitive], [nUsageType], [Estimated_Duration], [Historical_Duration], [Status], [Estimated_Start_Time], [Estimated_Closure_Time], [Access_Level], [Training], [Vendor], [Has_An_Associated_Cost_], [Printer_Name], [Active_Directory_Groups], [Allow_Multiple_Instances_Per_Role_or_Employee], [Open_Role_Allocation], [Complete_Provisioning_By], [Training_Level], [Share_Name], [Access_Code_Location], [Fileshare_Department], [Brand], [Model], [Serial_Number], [Barcode_Tag], [Asset_Tag], [Supplier_Seller], [Unit_Price], [Service_Contractor], [Delivery_Date], [Depreciation_Scheme], [Warranty_Until], [Expected_Life], [Salvage_Value], [Invoice_Reference], [Rest_Value], [Retired_Date], [Asset_Sub_status], [Quantity], [Asset_Location], [Total_Assets], [Assets_in_Use], [Assets_Remaining], [Item_Level], [UNSPSC_Code], [ASIN], [Manufacturer_ID], [Rating], [Parent], [Has_Child_Asset_Groups], [Bulk_Assets], [Managed], [CPU], [Memory], [SN], [OS_Name], [OS_Version], [Manufacturer], [PC_Model], [tSID], [License_Key], [Short_Name], [Image_Version], [Key_Name], [Base_Board_Manufacturer], [Base_Board_Product], [Base_Board_Version], [Bios_Major_Release], [Bios_Minor_Release], [Bios_Release_Date], [Bios_Vendor], [Bios_Version], [EC_Firmware_Major_Release], [EC_Firmware_Minor_Release], [System_Family], [System_Manufacturer], [System_Product_Name], [System_SKU], [System_Version], [Responsible], [Import_Source], [Import_Source_Details], [CPU_Speed], [Domain_Name], [IP_Address], [Network_Card], [Subnet_Mask], [MAC_Address], [Software_Publisher], [Accessible_To], [Warranty_Description], [Warranty_Start_Date], [Warranty_Status], [Warranty_ID], [Asset_Expires_], [Folder_Security], [Account_Type], [Account_Name], [VM_Platform], [VM_Type], [Host_Server], [VM_URL], [Source_Type], [Source_Name], [Import_Alias_1], [Import_Alias_2], [Import_Alias_3], [Last_Imported_Date], [Last_Imported_Time], [Asset_Request_Level_1_Approvers], [Asset_Request_Level_2_Approvers], [Asset_Request_Level_3_Approvers], [Asset_Request_Owner], [Asset_Request_Work_Team], [Minimum_Provisioning_Time], [Request_Priority], [Track_As], [Minimum_Quantity], [Current_Quantity], [Maximum_Quantity], [Need_to_Order_Quantity], [Allocation_Units], [Total_Allocated], [Total_Purchased], [Total_Costs_Over_Time], [Average_Total_Cost_Per_Unit], [Amount_to_Order], [Allocated_to_Department], [Allocated_to_Unit_Division], [Allocated_to_Project], [Can_Be_Requested], [Visible], [Software_Discovery_Mappings], [CPU_Count], [CPU_Cores_Count], [Primary_Owner], [Source_Timestamp], [Last_Imported_Timestamp], [Top_Console_User], [Visible_Request_Fields], [Request_Required_By_Date], [Request_Required_By_Time], [Number_Requested], [For_international_travel], [Requested_Until], [Request_Warning_Message], [Need_an_RSA_token], [Deliver_To], [Special_Instructions], [Laptop_Accessories_Needed], [For_Travel], [Litigation_Software], [Content_Loaded_on_Device], [Matter_Number], [Matter_Name], [Reason_for_Request], [Training_is_Requested], [Device_will_contain_Confidential_Data], [Needed_for_Device], [No_Approval_Needed_Level_1], [No_Approval_Needed_Level_2], [No_Approval_Needed_Level_3], [SIM_Card_Number], [IMEI], [Phone_Number], [Auto_Import_Installations], [Associated_Cost], [Approval_Needed_For], [Allocation_Rule], [Requested_Until_Time], [Related_License], [Location], [Sample_Data], [Environment], [Authorization_Required], [Application], [Access_Level_Is_Required_], [Training_Is_Required_], [ComputerName_Is_Required_], [Application_Is_Required_], [Vendor_Is_Required_], [Printer_Name_Is_Required_], [Active_Directory_Groups_Is_Required_], [Is_Missing_Required_Value], [Training_Level_Is_Required_], [Share_Name_Is_Required_], [Access_Code_Location_Is_Required_], [Room_Number], [Room_Number_Is_Required_], [Fileshare_Department_Is_Required_], [Invoice_Date], [Asset_Status], [PO_Number], [Purchased_From], [Contract_Duration__Years_], [Serial_Number_Is_Required_], [Auto_Create_License_Record], [Level_1], [Level_2], [Pool_Responsible], [Key], [Version], [Edition], [Allocated_to_Device___Computer], [dActualIRTDate], [dActualIRTTime], [ComputerChoiceList], [dTargetClosureTime], [dTargetIRT], [nAssociatedSLA], [Minimum_Approvers_Required], [Needs_Attention___Not_Seen_Recently], [Related_Bulk_Asset], [Asset_Life_Cycle_Stage], [Related_HelpDesk_Issues], [Key_Discovery___Application_Name], [Borrowable], [Software_Category], [Recurring_Costs], [Custom_Approvers], [Is_Bulk_Instance], [Reference_ID], [Family], [Source_Creation_Date]) VALUES (7181, 5, N'-1', 0, NULL, NULL, NULL, NULL, CAST(0x0000A80E00000000 AS DateTime), CAST(0x0000A7EA00000000 AS DateTime), CAST(0xFFFFFFFE013C9938 AS DateTime), CAST(0xFFFFFFFE00909930 AS DateTime), NULL, 2, NULL, 2, NULL, N'01ca052a-b65f-4ca2-aca8-b4fe80b9b289', 1, NULL, NULL, NULL, NULL, NULL, N'01ca052a-b65f-4ca2-aca8-b4fe80b9b289', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, 4, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, N'Acer Chromebook R11 (CB5-132T / C738T)', N'NXG55AA011716156977600', NULL, N'CB517', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2, NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, N'Chrome OS', N'Google_Cyan.7287.57.100', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, N'9878734449f9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, 314, 7180, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
INSERT [Resources01_Dat].[dbo].[tblDts] ([nID], [nRevisionNumber], [tShowInSummary], [nUserID], [dAssignedDate], [dAssignedTime], [dClosedDate], [dClosedTime], [dLastUpdateDate], [dSubmittedDate], [dSubmittedTime], [dUpdateTime], [mDetailedDescription], [nOriginatorID], [nPriorityID], [nSubmitterID], [nSubstateID], [tBriefDescription], [nStateID], [Activity], [Activity$Log], [Estimated$Effort], [Planned$Start$Date], [Planned$End$Date], [ComputerName], [nControlledByParent], [nSource], [Purchased_Date], [Comments], [Resource_Will_Expire_On], [Mandatory], [Provisioned], [Has_Been_Utilized], [Is_Sensitive], [nUsageType], [Estimated_Duration], [Historical_Duration], [Status], [Estimated_Start_Time], [Estimated_Closure_Time], [Access_Level], [Training], [Vendor], [Has_An_Associated_Cost_], [Printer_Name], [Active_Directory_Groups], [Allow_Multiple_Instances_Per_Role_or_Employee], [Open_Role_Allocation], [Complete_Provisioning_By], [Training_Level], [Share_Name], [Access_Code_Location], [Fileshare_Department], [Brand], [Model], [Serial_Number], [Barcode_Tag], [Asset_Tag], [Supplier_Seller], [Unit_Price], [Service_Contractor], [Delivery_Date], [Depreciation_Scheme], [Warranty_Until], [Expected_Life], [Salvage_Value], [Invoice_Reference], [Rest_Value], [Retired_Date], [Asset_Sub_status], [Quantity], [Asset_Location], [Total_Assets], [Assets_in_Use], [Assets_Remaining], [Item_Level], [UNSPSC_Code], [ASIN], [Manufacturer_ID], [Rating], [Parent], [Has_Child_Asset_Groups], [Bulk_Assets], [Managed], [CPU], [Memory], [SN], [OS_Name], [OS_Version], [Manufacturer], [PC_Model], [tSID], [License_Key], [Short_Name], [Image_Version], [Key_Name], [Base_Board_Manufacturer], [Base_Board_Product], [Base_Board_Version], [Bios_Major_Release], [Bios_Minor_Release], [Bios_Release_Date], [Bios_Vendor], [Bios_Version], [EC_Firmware_Major_Release], [EC_Firmware_Minor_Release], [System_Family], [System_Manufacturer], [System_Product_Name], [System_SKU], [System_Version], [Responsible], [Import_Source], [Import_Source_Details], [CPU_Speed], [Domain_Name], [IP_Address], [Network_Card], [Subnet_Mask], [MAC_Address], [Software_Publisher], [Accessible_To], [Warranty_Description], [Warranty_Start_Date], [Warranty_Status], [Warranty_ID], [Asset_Expires_], [Folder_Security], [Account_Type], [Account_Name], [VM_Platform], [VM_Type], [Host_Server], [VM_URL], [Source_Type], [Source_Name], [Import_Alias_1], [Import_Alias_2], [Import_Alias_3], [Last_Imported_Date], [Last_Imported_Time], [Asset_Request_Level_1_Approvers], [Asset_Request_Level_2_Approvers], [Asset_Request_Level_3_Approvers], [Asset_Request_Owner], [Asset_Request_Work_Team], [Minimum_Provisioning_Time], [Request_Priority], [Track_As], [Minimum_Quantity], [Current_Quantity], [Maximum_Quantity], [Need_to_Order_Quantity], [Allocation_Units], [Total_Allocated], [Total_Purchased], [Total_Costs_Over_Time], [Average_Total_Cost_Per_Unit], [Amount_to_Order], [Allocated_to_Department], [Allocated_to_Unit_Division], [Allocated_to_Project], [Can_Be_Requested], [Visible], [Software_Discovery_Mappings], [CPU_Count], [CPU_Cores_Count], [Primary_Owner], [Source_Timestamp], [Last_Imported_Timestamp], [Top_Console_User], [Visible_Request_Fields], [Request_Required_By_Date], [Request_Required_By_Time], [Number_Requested], [For_international_travel], [Requested_Until], [Request_Warning_Message], [Need_an_RSA_token], [Deliver_To], [Special_Instructions], [Laptop_Accessories_Needed], [For_Travel], [Litigation_Software], [Content_Loaded_on_Device], [Matter_Number], [Matter_Name], [Reason_for_Request], [Training_is_Requested], [Device_will_contain_Confidential_Data], [Needed_for_Device], [No_Approval_Needed_Level_1], [No_Approval_Needed_Level_2], [No_Approval_Needed_Level_3], [SIM_Card_Number], [IMEI], [Phone_Number], [Auto_Import_Installations], [Associated_Cost], [Approval_Needed_For], [Allocation_Rule], [Requested_Until_Time], [Related_License], [Location], [Sample_Data], [Environment], [Authorization_Required], [Application], [Access_Level_Is_Required_], [Training_Is_Required_], [ComputerName_Is_Required_], [Application_Is_Required_], [Vendor_Is_Required_], [Printer_Name_Is_Required_], [Active_Directory_Groups_Is_Required_], [Is_Missing_Required_Value], [Training_Level_Is_Required_], [Share_Name_Is_Required_], [Access_Code_Location_Is_Required_], [Room_Number], [Room_Number_Is_Required_], [Fileshare_Department_Is_Required_], [Invoice_Date], [Asset_Status], [PO_Number], [Purchased_From], [Contract_Duration__Years_], [Serial_Number_Is_Required_], [Auto_Create_License_Record], [Level_1], [Level_2], [Pool_Responsible], [Key], [Version], [Edition], [Allocated_to_Device___Computer], [dActualIRTDate], [dActualIRTTime], [ComputerChoiceList], [dTargetClosureTime], [dTargetIRT], [nAssociatedSLA], [Minimum_Approvers_Required], [Needs_Attention___Not_Seen_Recently], [Related_Bulk_Asset], [Asset_Life_Cycle_Stage], [Related_HelpDesk_Issues], [Key_Discovery___Application_Name], [Borrowable], [Software_Category], [Recurring_Costs], [Custom_Approvers], [Is_Bulk_Instance], [Reference_ID], [Family], [Source_Creation_Date]) VALUES (7182, 5, N'-1', 0, NULL, NULL, NULL, NULL, CAST(0x0000A80E00000000 AS DateTime), CAST(0x0000A7EA00000000 AS DateTime), CAST(0xFFFFFFFE013FED2C AS DateTime), CAST(0xFFFFFFFE00918138 AS DateTime), NULL, 2, NULL, 2, NULL, N'02815b0c-b7c5-4959-8974-354e1222f214', 1, NULL, NULL, NULL, NULL, NULL, N'02815b0c-b7c5-4959-8974-354e1222f214', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, 4, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, N'Acer Chromebook R11 (CB5-132T / C738T)', N'NXG55AA011716145F77600', NULL, N'CB698', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2, NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, N'Chrome OS', N'Google_Cyan.7287.57.100', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, N'9878733f64d9', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, 314, 7180, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
INSERT [Resources01_Dat].[dbo].[tblDts] ([nID], [nRevisionNumber], [tShowInSummary], [nUserID], [dAssignedDate], [dAssignedTime], [dClosedDate], [dClosedTime], [dLastUpdateDate], [dSubmittedDate], [dSubmittedTime], [dUpdateTime], [mDetailedDescription], [nOriginatorID], [nPriorityID], [nSubmitterID], [nSubstateID], [tBriefDescription], [nStateID], [Activity], [Activity$Log], [Estimated$Effort], [Planned$Start$Date], [Planned$End$Date], [ComputerName], [nControlledByParent], [nSource], [Purchased_Date], [Comments], [Resource_Will_Expire_On], [Mandatory], [Provisioned], [Has_Been_Utilized], [Is_Sensitive], [nUsageType], [Estimated_Duration], [Historical_Duration], [Status], [Estimated_Start_Time], [Estimated_Closure_Time], [Access_Level], [Training], [Vendor], [Has_An_Associated_Cost_], [Printer_Name], [Active_Directory_Groups], [Allow_Multiple_Instances_Per_Role_or_Employee], [Open_Role_Allocation], [Complete_Provisioning_By], [Training_Level], [Share_Name], [Access_Code_Location], [Fileshare_Department], [Brand], [Model], [Serial_Number], [Barcode_Tag], [Asset_Tag], [Supplier_Seller], [Unit_Price], [Service_Contractor], [Delivery_Date], [Depreciation_Scheme], [Warranty_Until], [Expected_Life], [Salvage_Value], [Invoice_Reference], [Rest_Value], [Retired_Date], [Asset_Sub_status], [Quantity], [Asset_Location], [Total_Assets], [Assets_in_Use], [Assets_Remaining], [Item_Level], [UNSPSC_Code], [ASIN], [Manufacturer_ID], [Rating], [Parent], [Has_Child_Asset_Groups], [Bulk_Assets], [Managed], [CPU], [Memory], [SN], [OS_Name], [OS_Version], [Manufacturer], [PC_Model], [tSID], [License_Key], [Short_Name], [Image_Version], [Key_Name], [Base_Board_Manufacturer], [Base_Board_Product], [Base_Board_Version], [Bios_Major_Release], [Bios_Minor_Release], [Bios_Release_Date], [Bios_Vendor], [Bios_Version], [EC_Firmware_Major_Release], [EC_Firmware_Minor_Release], [System_Family], [System_Manufacturer], [System_Product_Name], [System_SKU], [System_Version], [Responsible], [Import_Source], [Import_Source_Details], [CPU_Speed], [Domain_Name], [IP_Address], [Network_Card], [Subnet_Mask], [MAC_Address], [Software_Publisher], [Accessible_To], [Warranty_Description], [Warranty_Start_Date], [Warranty_Status], [Warranty_ID], [Asset_Expires_], [Folder_Security], [Account_Type], [Account_Name], [VM_Platform], [VM_Type], [Host_Server], [VM_URL], [Source_Type], [Source_Name], [Import_Alias_1], [Import_Alias_2], [Import_Alias_3], [Last_Imported_Date], [Last_Imported_Time], [Asset_Request_Level_1_Approvers], [Asset_Request_Level_2_Approvers], [Asset_Request_Level_3_Approvers], [Asset_Request_Owner], [Asset_Request_Work_Team], [Minimum_Provisioning_Time], [Request_Priority], [Track_As], [Minimum_Quantity], [Current_Quantity], [Maximum_Quantity], [Need_to_Order_Quantity], [Allocation_Units], [Total_Allocated], [Total_Purchased], [Total_Costs_Over_Time], [Average_Total_Cost_Per_Unit], [Amount_to_Order], [Allocated_to_Department], [Allocated_to_Unit_Division], [Allocated_to_Project], [Can_Be_Requested], [Visible], [Software_Discovery_Mappings], [CPU_Count], [CPU_Cores_Count], [Primary_Owner], [Source_Timestamp], [Last_Imported_Timestamp], [Top_Console_User], [Visible_Request_Fields], [Request_Required_By_Date], [Request_Required_By_Time], [Number_Requested], [For_international_travel], [Requested_Until], [Request_Warning_Message], [Need_an_RSA_token], [Deliver_To], [Special_Instructions], [Laptop_Accessories_Needed], [For_Travel], [Litigation_Software], [Content_Loaded_on_Device], [Matter_Number], [Matter_Name], [Reason_for_Request], [Training_is_Requested], [Device_will_contain_Confidential_Data], [Needed_for_Device], [No_Approval_Needed_Level_1], [No_Approval_Needed_Level_2], [No_Approval_Needed_Level_3], [SIM_Card_Number], [IMEI], [Phone_Number], [Auto_Import_Installations], [Associated_Cost], [Approval_Needed_For], [Allocation_Rule], [Requested_Until_Time], [Related_License], [Location], [Sample_Data], [Environment], [Authorization_Required], [Application], [Access_Level_Is_Required_], [Training_Is_Required_], [ComputerName_Is_Required_], [Application_Is_Required_], [Vendor_Is_Required_], [Printer_Name_Is_Required_], [Active_Directory_Groups_Is_Required_], [Is_Missing_Required_Value], [Training_Level_Is_Required_], [Share_Name_Is_Required_], [Access_Code_Location_Is_Required_], [Room_Number], [Room_Number_Is_Required_], [Fileshare_Department_Is_Required_], [Invoice_Date], [Asset_Status], [PO_Number], [Purchased_From], [Contract_Duration__Years_], [Serial_Number_Is_Required_], [Auto_Create_License_Record], [Level_1], [Level_2], [Pool_Responsible], [Key], [Version], [Edition], [Allocated_to_Device___Computer], [dActualIRTDate], [dActualIRTTime], [ComputerChoiceList], [dTargetClosureTime], [dTargetIRT], [nAssociatedSLA], [Minimum_Approvers_Required], [Needs_Attention___Not_Seen_Recently], [Related_Bulk_Asset], [Asset_Life_Cycle_Stage], [Related_HelpDesk_Issues], [Key_Discovery___Application_Name], [Borrowable], [Software_Category], [Recurring_Costs], [Custom_Approvers], [Is_Bulk_Instance], [Reference_ID], [Family], [Source_Creation_Date]) VALUES (7183, 5, N'-1', 0, NULL, NULL, NULL, NULL, CAST(0x0000A80E00000000 AS DateTime), CAST(0x0000A7EA00000000 AS DateTime), CAST(0xFFFFFFFE013F40E8 AS DateTime), CAST(0xFFFFFFFE00924168 AS DateTime), NULL, 2, NULL, 2, NULL, N'0253cf0d-4f7d-4b13-95e7-23ebf137cf1e', 1, NULL, NULL, NULL, NULL, NULL, N'0253cf0d-4f7d-4b13-95e7-23ebf137cf1e', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, 4, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, N'Acer Chromebook R11 (CB5-132T / C738T)', N'NXG55AA01171815D509600', NULL, N'CB680', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2, NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, N'Chrome OS', N'Google_Cyan.7287.57.100', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, N'98787336b901', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, 314, 7180, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO

UPDATE Resources01_Dat.dbo.tblDts SET tBriefDescription='Android' WHERE (nID=68 OR Level_2=68) AND Level_1=322 AND tBriefDescription='Smart Phone'
GO

DELETE FROM Resources01_Dat.dbo.tblDts WHERE Level_2=68 AND nID=386 AND Manufacturer_ID='Apple'
GO

UPDATE Resources01_Dat.dbo.tblDts SET Level_1=355 WHERE nID=7 or Level_2=7
GO

UPDATE Resources01_Dat.dbo.tblDts SET dAssignedDate = (SELECT TOP 1 dDate FROM Resources01_Dat.dbo.tblRevisionHistory AS B WHERE B.nRecordID = Resources01_Dat.dbo.tblDts.nID AND B.nModifiedDtsFieldID=882 AND NOT tCurrentValue ='' ORDER BY B.nRevisionNumber) WHERE Asset_Sub_status=1 AND dAssignedDate IS NULL AND nID<10000
UPDATE Resources01_Dat.dbo.tblDts SET dAssignedTime = (SELECT TOP 1 dTime FROM Resources01_Dat.dbo.tblRevisionHistory AS B WHERE B.nRecordID = Resources01_Dat.dbo.tblDts.nID AND B.nModifiedDtsFieldID=882 AND NOT tCurrentValue ='' ORDER BY B.nRevisionNumber) WHERE Asset_Sub_status=1 AND dAssignedTime IS NULL AND nID<10000
GO

UPDATE Resources01_Dat.dbo.tblDts SET mDetailedDescription='Projectors, TVs, Whiteboards, Speakers, Audio Mixers' WHERE nID=355 AND mDetailedDescription IS NULL
UPDATE Resources01_Dat.dbo.tblDts SET mDetailedDescription='Laptops, Desktops, Servers, Virtual Machines, Chromebooks' WHERE nID=314 AND mDetailedDescription IS NULL
UPDATE Resources01_Dat.dbo.tblDts SET mDetailedDescription='USB Memory Sticks, Keyboards, Mice, Toners, Cabling' WHERE nID=350 AND mDetailedDescription IS NULL
UPDATE Resources01_Dat.dbo.tblDts SET mDetailedDescription='Signed Agreements, Manuals' WHERE nID=315 AND mDetailedDescription IS NULL
UPDATE Resources01_Dat.dbo.tblDts SET mDetailedDescription='Email Accounts, Routers, Switches' WHERE nID=1439 AND mDetailedDescription IS NULL
UPDATE Resources01_Dat.dbo.tblDts SET mDetailedDescription='Desks, Chairs, Filing Cabinets' WHERE nID=316 AND mDetailedDescription IS NULL
UPDATE Resources01_Dat.dbo.tblDts SET mDetailedDescription='Printers, Monitors, Photo Copiers' WHERE nID=317 AND mDetailedDescription IS NULL
UPDATE Resources01_Dat.dbo.tblDts SET mDetailedDescription='Networks shares which are required by the business' WHERE nID=318 AND mDetailedDescription IS NULL
UPDATE Resources01_Dat.dbo.tblDts SET mDetailedDescription='ID Badges, Electronic Key Cards, Keys' WHERE nID=320 AND mDetailedDescription IS NULL
UPDATE Resources01_Dat.dbo.tblDts SET mDetailedDescription='VoIP Phones, iPhones, Android Phones' WHERE nID=322 AND mDetailedDescription IS NULL
UPDATE Resources01_Dat.dbo.tblDts SET mDetailedDescription='IT Services' WHERE nID=1430 AND mDetailedDescription IS NULL
UPDATE Resources01_Dat.dbo.tblDts SET mDetailedDescription='Software and Cloud Applications' WHERE nID=321 AND mDetailedDescription IS NULL
GO

UPDATE Resources01_Dat.dbo.tblDts SET Visible=2 WHERE nID IN(47, 63, 64, 319)
GO

/***********************************************************************/

USE Resources02_Def
GO

INSERT [Resources02_Def].[dbo].[tblDtsFields] ([nID], [tTableName], [nTableDSType], [tName], [nDataViewID], [nDataType], [nDataSize], [tCaption], [fChoiceOrder], [fRequired], [tFieldValuesTable], [nValueTableDSType], [fEnabled], [fKeepHistory], [fCanQueryBy], [tDestinationTab], [fEditable], [fVisible], [nRelatedField], [tLabelCaption], [tAliasSourceTable], [tBoundControlName], [nDestinationTabID], [tWhere], [fIncludeInDefaultReports], [nRelationshipType], [nContainerType], [nControlType], [tValueTableIDFld], [tValueTableNameFld], [nRevisionNumber], [tOrigCaption]) VALUES (1134, N'tblDts', 32, N'Source_Creation_Date', 1, 109, 0, N'Source Creation Date', 0, 0, NULL, 0, 0, 0, 1, NULL, 1, 1, 0, N'Source Creation Date', NULL, N'dt_1134_Source_Creation_Date', 26, NULL, 0, -1, 1, NULL, NULL, NULL, 1, NULL);
INSERT [Resources02_Def].[dbo].[tblDtsFields] ([nID], [tTableName], [nTableDSType], [tName], [nDataViewID], [nDataType], [nDataSize], [tCaption], [fChoiceOrder], [fRequired], [tFieldValuesTable], [nValueTableDSType], [fEnabled], [fKeepHistory], [fCanQueryBy], [tDestinationTab], [fEditable], [fVisible], [nRelatedField], [tLabelCaption], [tAliasSourceTable], [tBoundControlName], [nDestinationTabID], [tWhere], [fIncludeInDefaultReports], [nRelationshipType], [nContainerType], [nControlType], [tValueTableIDFld], [tValueTableNameFld], [nRevisionNumber], [tOrigCaption]) VALUES (1135, N'tblDts', 32, N'View_Details', 1, 103, 3, N'View Details', 0, 0, N'tblYesNo', 16, 1, 1, 1, NULL, 1, 1, NULL, N'View Details', NULL, N'cbo_1135_View_Details', 30, NULL, 0, -1, 1, NULL, NULL, NULL, 2, NULL)
GO

INSERT [Resources02_Def].[dbo].[tblSystemCustomQueries] ([nID], [tName], [tCaption], [nParentTableID], [fFieldsChanged], [nDefaultSort], [nDefaultLayout]) VALUES (55, N'Overdue$Assets', N'Overdue Assets', 6, 2, NULL, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemCustomQueries] ([nID], [tName], [tCaption], [nParentTableID], [fFieldsChanged], [nDefaultSort], [nDefaultLayout]) VALUES (56, N'My$Overdue$Assets', N'My Overdue Assets', 6, 2, NULL, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemCustomQueries] ([nID], [tName], [tCaption], [nParentTableID], [fFieldsChanged], [nDefaultSort], [nDefaultLayout]) VALUES (57, N'Managed$Software$Asset$Instances', N'Managed Software Asset Instances', 6, 5, NULL, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemCustomQueries] ([nID], [tName], [tCaption], [nParentTableID], [fFieldsChanged], [nDefaultSort], [nDefaultLayout]) VALUES (58, N'Chromebooks', N'Chromebooks', 6, 5, NULL, 12)
INSERT [Resources02_Def].[dbo].[tblSystemCustomQueries] ([nID], [tName], [tCaption], [nParentTableID], [fFieldsChanged], [nDefaultSort], [nDefaultLayout]) VALUES (59, N'SW$Asset$Types', N'SW Asset Types', 6, 2, NULL, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemCustomQueries] ([nID], [tName], [tCaption], [nParentTableID], [fFieldsChanged], [nDefaultSort], [nDefaultLayout]) VALUES (60, N'Base$Asset$Types', N'Base Asset Types', 6, 2, NULL, NULL)
GO


INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (55, N'Usage Type', N'<>', N'Asset Type', N'And', 0, 0, 0, 2, 1, 806, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (55, N'Requested Until Date', N'<', N'<Today>', N'And', 0, 0, 0, 1, 2, 1054, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (55, N'Status', N'=', N'Assigned', NULL, NULL, NULL, NULL, 2, 3, 865, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (56, N'Usage Type', N'<>', N'Asset Type', N'And', 0, 0, 0, 2, 1, 806, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (56, N'Requested Until Date', N'<', N'<Today>', N'And', 0, 0, 0, 1, 2, 1054, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (56, N'Status', N'=', N'Assigned', N'And', NULL, NULL, NULL, 2, 3, 865, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (56, N'Allocated to Person', N'=', N'<User>', NULL, NULL, NULL, NULL, 3, 4, 11, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (58, N'Asset Type', N'=', N'Chromebook', N'And', 0, 0, 0, 2, 1, 1093, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (58, N'Usage Type', N'=', N'Asset Instance', NULL, NULL, NULL, NULL, 1, 2, 806, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (57, N'    Managed', N'Like', N'<Null>', N'And', 1, 1, NULL, 0, 2, 907, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (57, N'Visible', N'=', N'Yes', N'Or', NULL, NULL, 1, 1, 3, 1023, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (57, N'    Visible', N'Like', N'<Null>', N'And', 1, 3, 0, 0, 4, 1023, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (57, N'Item Level', N'=', N'Asset Class', N'And', NULL, NULL, 2, 5, 7, 886, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (57, N'Department (Allocation Tab)', N'=', N'<Is Accessible Department>', N'Or', NULL, NULL, 1, 3, 5, 1019, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (57, N'    Current Location', N'=', N'<Is Accessible Location>', N'And', 1, 5, NULL, 0, 6, 1087, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (57, N'    Name', N'=', N'Software', N'Or', 1, 7, NULL, 9, 8, 30, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (57, N'        Asset Class', N'=', N'Software', NULL, 2, 9, NULL, 0, 10, 1092, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (57, N'Managed', N'=', N'Yes', N'Or', NULL, NULL, 1, 3, 1, 907, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (57, N'    Item Level', N'=', N'Asset Type', N'And', 1, 7, 1, 8, 9, 886, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (59, N'Item Level', N'=', N'Asset Class', N'And', NULL, NULL, 2, 3, 4, 886, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (59, N'        Asset Class', N'=', N'Software', NULL, 2, 6, NULL, 0, 7, 1092, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (59, N'Visible', N'=', N'Yes', N'Or', 0, 0, 1, 3, 1, 1023, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (59, N'    Visible', N'Like', N'<Null>', N'And', 1, 0, 0, 0, 2, 1023, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (59, N'Usage Type', N'=', N'Asset Type', N'And', 0, 0, 0, 1, 3, 806, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (59, N'    Name', N'=', N'Software', N'Or', 1, 4, NULL, 6, 5, 30, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (59, N'    Item Level', N'=', N'Asset Type', N'And', 1, 4, 1, 5, 6, 886, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (60, N'Visible', N'=', N'Yes', N'Or', 0, 0, 1, 3, 1, 1023, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (60, N'    Visible', N'Like', N'<Null>', N'And', 1, 0, 0, 0, 2, 1023, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (60, N'Usage Type', N'=', N'Asset Type', N'And', 0, 0, 0, 1, 3, 806, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (60, N'Item Level', N'=', N'Asset Class', N'And', NULL, NULL, 2, 3, 4, 886, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (60, N'    Name', N'<>', N'Software', N'Or', 1, 4, NULL, 6, 5, 30, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (60, N'    Item Level', N'=', N'Asset Type', N'And', 1, 4, 1, 5, 6, 886, NULL)
INSERT [Resources02_Def].[dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (60, N'        Asset Class', N'<>', N'Software', NULL, 2, 6, NULL, 0, 7, 1092, NULL)
GO

DELETE FROM [Resources02_Def].[dbo].[tblSystemQueries] WHERE nID=24
GO

INSERT [dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (24, N'Managed', N'=', N'Yes', N'Or', 0, 0, 1, 3, 1, 907, NULL)
INSERT [dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (24, N'    Managed', N'Like', N'<Null>', N'And', 1, 0, 0, 0, 2, 907, NULL)
INSERT [dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (24, N'Visible', N'=', N'Yes', N'Or', 0, 0, 1, 1, 3, 1023, NULL)
INSERT [dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (24, N'    Visible', N'Like', N'<Null>', N'And', 1, 0, 0, 0, 4, 1023, NULL)
INSERT [dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (24, N'Usage Type', N'<>', N'Asset Specifications', N'And', 1, 5, 0, 0, 7, 806, NULL)
INSERT [dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (24, N'Allocated to Department', N'=', N'<Is Accessible Department>', N'Or', NULL, 0, 1, 5, 8, 1019, NULL)
INSERT [dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (24, N'    Current Location', N'=', N'<Is Accessible Location>', N'And', 1, 8, NULL, 0, 10, 1087, NULL)
INSERT [dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (24, N'Item Level', N'=', N'Asset Class', N'And', NULL, 0, 3, 8, 12, 886, NULL)
INSERT [dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (24, N'    Name', N'<>', N'Software', N'Or', 1, 12, 0, 14, 16, 30, NULL)
INSERT [dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (24, N'    Item Level', N'=', N'Asset Type', N'And', 1, 12, 2, 16, 18, 886, NULL)
INSERT [dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (24, N'        Asset Class', N'<>', N'Software', N'And', 2, 18, NULL, 22, 20, 1092, NULL)
INSERT [dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (24, N'    Name', N'<>', N'Services', N'And', 1, 12, 0, 16, 14, 30, NULL)
INSERT [dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (24, N'Usage Type', N'<>', N'Asset Request', N'And', 0, 0, 1, 3, 5, 806, NULL)
INSERT [dbo].[tblSystemQueries] ([nID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [nDtsFieldID], [nValueType]) VALUES (24, N'        Asset Class', N'<>', N'Services', NULL, 2, 18, NULL, 20, 22, 1092, NULL)
GO


UPDATE [Resources02_Def].[dbo].[tblSystemCustomQueries] SET nDefaultSort=1, nDefaultLayout=6 WHERE nID=10
UPDATE [Resources02_Def].[dbo].[tblSystemCustomQueries] SET nDefaultSort=1, nDefaultLayout=1 WHERE nID=1
GO

UPDATE [Resources02_Def].[dbo].tblDtsFields SET tCaption='Allocated to Person', tLabelCaption='Allocated to Person' WHERE nID=11 AND tCaption='Assigned to Person'
UPDATE [Resources02_Def].[dbo].tblDtsFields SET tCaption='Location', tLabelCaption='Location' WHERE nID=882 AND tCaption='Assigned to Location'
UPDATE [Resources02_Def].[dbo].tblDtsFields SET tCaption='Department (Allocation Tab)', tLabelCaption='Department' WHERE nID=1019 AND tCaption='Allocated to Department'
UPDATE [Resources02_Def].[dbo].tblDtsFields SET tCaption='Project', tLabelCaption='Project' WHERE nID=1021 AND tCaption='Allocated to Project'
UPDATE [Resources02_Def].[dbo].tblDtsFields SET tCaption='Allocated to Person (Overview Tab)', tLabelCaption='Allocated to Person' WHERE nID=1082 AND tCaption='Assigned to Person (Overview Tab)'
UPDATE [Resources02_Def].[dbo].tblDtsFields SET tCaption='Allocated to Person (Bulk Allocate)', tLabelCaption='Allocated to Person' WHERE nID=1100 AND tCaption='Assigned to Person (Bulk Allocate)'
UPDATE [Resources02_Def].[dbo].tblDtsFields SET tCaption='Allocated to Person (Request Details Tab)' WHERE nID=19 AND tCaption='Assigned to Person (Request Details Tab)'
GO

INSERT [Resources02_Def].[dbo].[tblRule] ([nID], [nParentID], [tName], [tCaption], [tTmplNameRule], [tTableName], [nDBType], [nTrigger], [nState], [tDescription], [nValidationLevel], [bFinished], [nOrder]) VALUES (236, 0, N'Hide Tabs By View Details', N'Hide Tabs By View Details', N'%Value0%-%Value1%', N'tblWrk_Hide_Tabs_By_View_Details_236', 64, 1, 1, N'', NULL, 0, 44)
INSERT [Resources02_Def].[dbo].[tblRule] ([nID], [nParentID], [tName], [tCaption], [tTmplNameRule], [tTableName], [nDBType], [nTrigger], [nState], [tDescription], [nValidationLevel], [bFinished], [nOrder]) VALUES (237, 236, N'New Rule (237)', N'No-', N'%Value0%-%Value1%', N'tblWrk_Hide_Tabs_By_View_Details_236', 64, 1, 1, N'', NULL, 0, 44)
GO

INSERT [Resources02_Def].[dbo].[tblRuleCondition] ([nID], [nRuleID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [tValuesSource], [nFieldID]) VALUES (370, 236, N'View Details', N'=', N'', N'AND', 0, 0, 0, 0, 1, NULL, 1135)
INSERT [Resources02_Def].[dbo].[tblRuleCondition] ([nID], [nRuleID], [tName], [tTest], [tValue], [tAndOr], [nLevel], [nParent], [nChild], [nBrother], [nRow], [tValuesSource], [nFieldID]) VALUES (371, 237, N'View Details', N'=', N'2', N'AND', 0, 0, 0, 0, 1, NULL, 1135)
GO

INSERT [Resources02_Def].[dbo].[tblPossibleValue] ([nID], [nRuleID], [tName], [tValue], [nRowID], [nFieldID], [nActionType]) VALUES (236, 236, NULL, NULL, 1, NULL, 4)
INSERT [Resources02_Def].[dbo].[tblPossibleValue] ([nID], [nRuleID], [tName], [tValue], [nRowID], [nFieldID], [nActionType]) VALUES (237, 237, N'', N'1;3', 1, 0, 4)
GO


INSERT [Resources02_Def].[dbo].[tblUIElement_Rule] ([nID], [nRuleID], [nElementID], [nAttributeID]) VALUES (1770, 236, 1, 6)
INSERT [Resources02_Def].[dbo].[tblUIElement_Rule] ([nID], [nRuleID], [nElementID], [nAttributeID]) VALUES (1771, 236, 2, 6)
INSERT [Resources02_Def].[dbo].[tblUIElement_Rule] ([nID], [nRuleID], [nElementID], [nAttributeID]) VALUES (1772, 236, 32, 6)
INSERT [Resources02_Def].[dbo].[tblUIElement_Rule] ([nID], [nRuleID], [nElementID], [nAttributeID]) VALUES (1773, 236, 64, 6)
INSERT [Resources02_Def].[dbo].[tblUIElement_Rule] ([nID], [nRuleID], [nElementID], [nAttributeID]) VALUES (1774, 236, 128, 5)
INSERT [Resources02_Def].[dbo].[tblUIElement_Rule] ([nID], [nRuleID], [nElementID], [nAttributeID]) VALUES (1775, 236, 256, 6)
INSERT [Resources02_Def].[dbo].[tblUIElement_Rule] ([nID], [nRuleID], [nElementID], [nAttributeID]) VALUES (1776, 236, 3, 3)
INSERT [Resources02_Def].[dbo].[tblUIElement_Rule] ([nID], [nRuleID], [nElementID], [nAttributeID]) VALUES (1777, 236, 4, 3)
INSERT [Resources02_Def].[dbo].[tblUIElement_Rule] ([nID], [nRuleID], [nElementID], [nAttributeID]) VALUES (1778, 237, 1, 6)
INSERT [Resources02_Def].[dbo].[tblUIElement_Rule] ([nID], [nRuleID], [nElementID], [nAttributeID]) VALUES (1779, 237, 2, 6)
INSERT [Resources02_Def].[dbo].[tblUIElement_Rule] ([nID], [nRuleID], [nElementID], [nAttributeID]) VALUES (1780, 237, 32, 6)
INSERT [Resources02_Def].[dbo].[tblUIElement_Rule] ([nID], [nRuleID], [nElementID], [nAttributeID]) VALUES (1781, 237, 64, 6)
INSERT [Resources02_Def].[dbo].[tblUIElement_Rule] ([nID], [nRuleID], [nElementID], [nAttributeID]) VALUES (1782, 237, 128, 5)
INSERT [Resources02_Def].[dbo].[tblUIElement_Rule] ([nID], [nRuleID], [nElementID], [nAttributeID]) VALUES (1783, 237, 256, 6)
INSERT [Resources02_Def].[dbo].[tblUIElement_Rule] ([nID], [nRuleID], [nElementID], [nAttributeID]) VALUES (1784, 237, 3, 4)
INSERT [Resources02_Def].[dbo].[tblUIElement_Rule] ([nID], [nRuleID], [nElementID], [nAttributeID]) VALUES (1785, 237, 4, 4)
GO

UPDATE [Resources02_Def].[dbo].[tblDtsFields] SET tCaption='Vendor', tLabelCaption='Vendor'  WHERE tName='Software_Publisher' AND tCaption='Software Publisher' and tLabelCaption='Software Publisher'
UPDATE [Resources02_Def].[dbo].[tblDtsFields] SET tFieldValuesTable='Vendor' WHERE tName='Software_Publisher' AND tFieldValuesTable='Supplier'
GO

UPDATE [Resources02_Def].[dbo].[tblSystemQueries] SET tValue='Email, Internet and Network' WHERE nID=37 AND nDtsFieldID=1092 AND tValue='Email, Internet & Network'
GO

UPDATE [Resources02_Def].[dbo].[tblSystemLayouts] SET nWidth=0 WHERE nID=1 AND nDtsFieldID=1093
GO

UPDATE [Resources02_Def].[dbo].[tblSystemCustomReports] SET tCaption='* All Assets' WHERE nID=39 AND tCaption='All Assets'
UPDATE [Resources02_Def].[dbo].[tblSystemCustomReports] SET tCaption='* Assets by Department' WHERE nID=45 AND tCaption='Assets by Department'
UPDATE [Resources02_Def].[dbo].[tblSystemCustomReports] SET tCaption='* Assets by User' WHERE nID=49 AND tCaption='Assets by User'
UPDATE [Resources02_Def].[dbo].[tblSystemCustomReports] SET tCaption='* Assets Checked Out - Overdue' WHERE nID=42 AND tCaption='Assets Checked Out - Overdue'
GO

/***********************************************************************/

USE Users_mdb
GO

INSERT [Users_mdb].[dbo].[tblFieldMap_ImpRule] ([nID], [tInternalFieldName], [tInternalTableName], [nInternalDSID], [tExternalFieldName], [nValueTableID], [tExternalFieldFormat], [bForeignKey], [bSyncOnlyNewRecord], [nCVLookupMode]) VALUES (-13, N'Source_Creation_Date', N'tblDts', 32, N'Src_Creation_Date', NULL, NULL, 0, 0, NULL);
INSERT [Users_mdb].[dbo].[tblFieldMap_ImpRule] ([nID], [tInternalFieldName], [tInternalTableName], [nInternalDSID], [tExternalFieldName], [nValueTableID], [tExternalFieldFormat], [bForeignKey], [bSyncOnlyNewRecord], [nCVLookupMode]) VALUES (1, N'Source_Creation_Date', N'tblDts', 32, N'Src_Creation_Date', NULL, NULL, 0, 0, NULL);
INSERT [Users_mdb].[dbo].[tblFieldMap_ImpRule] ([nID], [tInternalFieldName], [tInternalTableName], [nInternalDSID], [tExternalFieldName], [nValueTableID], [tExternalFieldFormat], [bForeignKey], [bSyncOnlyNewRecord], [nCVLookupMode]) VALUES (2, N'Source_Creation_Date', N'tblDts', 32, N'Src_Creation_Date', NULL, NULL, 0, 0, NULL);
INSERT [Users_mdb].[dbo].[tblFieldMap_ImpRule] ([nID], [tInternalFieldName], [tInternalTableName], [nInternalDSID], [tExternalFieldName], [nValueTableID], [tExternalFieldFormat], [bForeignKey], [bSyncOnlyNewRecord], [nCVLookupMode]) VALUES (5, N'Source_Creation_Date', N'tblDts', 32, N'Src_Creation_Date', NULL, NULL, 0, 0, NULL);
GO

INSERT [Users_mdb].[dbo].[tblWidget] ([nID], [tTitle], [tDescription], [nHeight], [tPath], [tCategory], [bOptional], [tLibraryImage], [bTemplateWidget], [tSubTitle], [nQueryID], [nSecondaryQueryID], [nFieldID], [nViewID]) VALUES (69, N'My overdue assets', N'Displays total number of overdue assets assigned to me.', 1, N'~/WidgetComponents/WidgetTotal.ascx', N'Resources', 1, N'total.png', 1, N'Overdue assets', 56, NULL, NULL, 62)
INSERT [Users_mdb].[dbo].[tblWidget] ([nID], [tTitle], [tDescription], [nHeight], [tPath], [tCategory], [bOptional], [tLibraryImage], [bTemplateWidget], [tSubTitle], [nQueryID], [nSecondaryQueryID], [nFieldID], [nViewID]) VALUES (70, N'My assets', N'Displays total number of assets allocated to me.', 1, N'~/WidgetComponents/WidgetTotal.ascx', N'Resources', 1, N'total.png', 1, N'Assets', 27, NULL, NULL, 62)
INSERT [Users_mdb].[dbo].[tblWidget] ([nID], [tTitle], [tDescription], [nHeight], [tPath], [tCategory], [bOptional], [tLibraryImage], [bTemplateWidget], [tSubTitle], [nQueryID], [nSecondaryQueryID], [nFieldID], [nViewID]) VALUES (71, N'My requested assets', N'Displays total number of assets requested by me.', 1, N'~/WidgetComponents/WidgetTotal.ascx', N'Actions', 1, N'total.png', 1, N'Assets', 21, NULL, NULL, 64)
GO

DROP VIEW AssetTypeAdv
GO

CREATE VIEW [AssetTypeAdv]
AS
SELECT     A.[nID], A.[tBriefDescription] AS tName, (SELECT tBriefDescription FROM Resources01_Dat.dbo.tblDts WHERE (nID = A.Level_1)) AS Level_1, A.[Has_An_Associated_Cost_], B.tAttachments AS 'tblAttachments_tAttachments', A.Level_2, A.Track_As, A.Can_Be_Requested, A.Assets_Remaining
FROM         [Resources01_Dat].[dbo].[tblDts] AS A LEFT JOIN [Resources01_Dat].[dbo].[tblAttachments] AS B ON A.[nID]=B.[nID]
WHERE (A.[nUsageType]=2 AND A.[Item_Level]=3 AND A.[tShowInSummary]='-1' AND (A.[Visible] = 1 OR A.[Visible] IS NULL))
GO

INSERT INTO [Users_mdb].dbo.tblBin(nID,tValue) VALUES (-15, HASHBYTES('SHA2_512', '149051193033029188142'))
GO

UPDATE [Users_mdb].[dbo].[tblImport_ImpRule] SET tName='Vector Discovery Computers' WHERE tName='VAM Computers'
UPDATE [Users_mdb].[dbo].[tblImport_ImpRule] SET tName='Vector Discovery Servers' WHERE tName='VAM Servers'
UPDATE [Users_mdb].[dbo].[tblImport_ImpRule] SET tName='Vector Discovery Installed Software Catalog' WHERE tName='VAM Installed Software Catalog'
UPDATE [Users_mdb].[dbo].[tblImport_ImpRule] SET tName='Vector Discovery Installed Software' WHERE tName='VAM Installed Software'
UPDATE [Users_mdb].[dbo].[tblImport_ImpRule] SET tName='Vector Discovery SNMP Assets' WHERE tName='VAM SNMP Assets'
GO

UPDATE [Users_mdb].[dbo].[tblImportSource] SET tName='Computers from Vector Discovery - XML' WHERE tName='Computers from Vector Asset Management (VAM) - XML'
UPDATE [Users_mdb].[dbo].[tblImportSource] SET tName='Inventoried Software from Vector Discovery - XML' WHERE tName='Inventoried Software from Vector Asset Management (VAM) - XML'
UPDATE [Users_mdb].[dbo].[tblImportSource] SET tName='Inventoried Software Installations from Vector Discovery - XML' WHERE tName='Inventoried Software Installations from Vector Asset Management (VAM) - XML'
UPDATE [Users_mdb].[dbo].[tblImportSource] SET tName='SNMP Assets from Vector Discovery - XML' WHERE tName='SNMP Assets from Vector Asset Management (VAM) - XML'
GO




INSERT [Users_mdb].[dbo].[tblImport_ImpRule] ([nID], [nAuthID], [tName], [mFilter], [bAddNew], [bSynch], [nMailExt], [tExchangeServer], [nImportAuthType], [nSearchType], [bUseGlobalMappings], [nTypeProvisioningActions], [nImportType], [nProjectID], [tUniqueFields], [nImportSrc], [bImpADExtras]) VALUES (45, 45, N'Chromebooks from Excel', N'', 1, 0, 0, N'', 10, 1, 0, 1, 2, 15, N'Serial_Number', 10, 0)
GO
INSERT [Users_mdb].[dbo].[tblAuthentication] ([nID], [nAuthType], [tName]) VALUES (45, 10, N'C:\Program Files (x86)\Vector\ConnectServer\Import\ExternalData\Chromebooks\Chromebooks.xls')
GO
INSERT [Users_mdb].[dbo].[tblImportDB] ([nID], [tName], [tLocation], [nProviderType], [tSecurityAccess], [tTableName]) VALUES (45, N'Chromebooks.xls', N'C:\Program Files (x86)\Vector\ConnectServer\Import\ExternalData\Chromebooks', 128, N':', N'')
GO

INSERT [Users_mdb].[dbo].[tblFieldMap_ImpRule] ([nID], [tInternalFieldName], [tInternalTableName], [nInternalDSID], [tExternalFieldName], [nValueTableID], [tExternalFieldFormat], [bForeignKey], [bSyncOnlyNewRecord], [nCVLookupMode]) VALUES (45, N'Domain_Name', N'tblDts', 32, N'Org Unit Path', 0, NULL, 0, 0, 0)
INSERT [Users_mdb].[dbo].[tblFieldMap_ImpRule] ([nID], [tInternalFieldName], [tInternalTableName], [nInternalDSID], [tExternalFieldName], [nValueTableID], [tExternalFieldFormat], [bForeignKey], [bSyncOnlyNewRecord], [nCVLookupMode]) VALUES (45, N'Asset_Tag', N'tblDts', 32, N'Annotated Asset Id', 0, NULL, 0, 0, 0)
INSERT [Users_mdb].[dbo].[tblFieldMap_ImpRule] ([nID], [tInternalFieldName], [tInternalTableName], [nInternalDSID], [tExternalFieldName], [nValueTableID], [tExternalFieldFormat], [bForeignKey], [bSyncOnlyNewRecord], [nCVLookupMode]) VALUES (45, N'MAC_Address', N'tblDts', 32, N'Mac Address', 0, NULL, 0, 0, 0)
INSERT [Users_mdb].[dbo].[tblFieldMap_ImpRule] ([nID], [tInternalFieldName], [tInternalTableName], [nInternalDSID], [tExternalFieldName], [nValueTableID], [tExternalFieldFormat], [bForeignKey], [bSyncOnlyNewRecord], [nCVLookupMode]) VALUES (45, N'ComputerName', N'tblDts', 32, N'Device Id', 0, NULL, 0, 0, 0)
INSERT [Users_mdb].[dbo].[tblFieldMap_ImpRule] ([nID], [tInternalFieldName], [tInternalTableName], [nInternalDSID], [tExternalFieldName], [nValueTableID], [tExternalFieldFormat], [bForeignKey], [bSyncOnlyNewRecord], [nCVLookupMode]) VALUES (45, N'Model', N'tblDts', 32, N'Model', 0, NULL, 0, 0, 0)
INSERT [Users_mdb].[dbo].[tblFieldMap_ImpRule] ([nID], [tInternalFieldName], [tInternalTableName], [nInternalDSID], [tExternalFieldName], [nValueTableID], [tExternalFieldFormat], [bForeignKey], [bSyncOnlyNewRecord], [nCVLookupMode]) VALUES (45, N'PC_Model', N'tblDts', 32, N'Model', 0, NULL, 0, 0, 0)
INSERT [Users_mdb].[dbo].[tblFieldMap_ImpRule] ([nID], [tInternalFieldName], [tInternalTableName], [nInternalDSID], [tExternalFieldName], [nValueTableID], [tExternalFieldFormat], [bForeignKey], [bSyncOnlyNewRecord], [nCVLookupMode]) VALUES (45, N'Location', N'tblDts', 32, N'Annotated Location', 0, NULL, 0, 0, 0)
INSERT [Users_mdb].[dbo].[tblFieldMap_ImpRule] ([nID], [tInternalFieldName], [tInternalTableName], [nInternalDSID], [tExternalFieldName], [nValueTableID], [tExternalFieldFormat], [bForeignKey], [bSyncOnlyNewRecord], [nCVLookupMode]) VALUES (45, N'OS_Version', N'tblDts', 32, N'Firmware Version', 0, NULL, 0, 0, 0)
INSERT [Users_mdb].[dbo].[tblFieldMap_ImpRule] ([nID], [tInternalFieldName], [tInternalTableName], [nInternalDSID], [tExternalFieldName], [nValueTableID], [tExternalFieldFormat], [bForeignKey], [bSyncOnlyNewRecord], [nCVLookupMode]) VALUES (45, N'Comments', N'tblDts', 32, N'Notes', 0, NULL, 0, 0, 0)
INSERT [Users_mdb].[dbo].[tblFieldMap_ImpRule] ([nID], [tInternalFieldName], [tInternalTableName], [nInternalDSID], [tExternalFieldName], [nValueTableID], [tExternalFieldFormat], [bForeignKey], [bSyncOnlyNewRecord], [nCVLookupMode]) VALUES (45, N'tBriefDescription', N'tblDts', 32, N'Device Id', 0, NULL, 0, 0, 0)
INSERT [Users_mdb].[dbo].[tblFieldMap_ImpRule] ([nID], [tInternalFieldName], [tInternalTableName], [nInternalDSID], [tExternalFieldName], [nValueTableID], [tExternalFieldFormat], [bForeignKey], [bSyncOnlyNewRecord], [nCVLookupMode]) VALUES (45, N'Serial_Number', N'tblDts', 32, N'Serial Number', 0, NULL, 0, 0, 0)
INSERT [Users_mdb].[dbo].[tblFieldMap_ImpRule] ([nID], [tInternalFieldName], [tInternalTableName], [nInternalDSID], [tExternalFieldName], [nValueTableID], [tExternalFieldFormat], [bForeignKey], [bSyncOnlyNewRecord], [nCVLookupMode]) VALUES (45, N'SN', N'tblDts', 32, N'Serial Number', 0, NULL, 0, 0, 0)
INSERT [Users_mdb].[dbo].[tblFieldMap_ImpRule] ([nID], [tInternalFieldName], [tInternalTableName], [nInternalDSID], [tExternalFieldName], [nValueTableID], [tExternalFieldFormat], [bForeignKey], [bSyncOnlyNewRecord], [nCVLookupMode]) VALUES (45, N'tSID', N'tblDts', 32, N'Device Id', 0, NULL, 0, 0, 0)
INSERT [Users_mdb].[dbo].[tblFieldMap_ImpRule] ([nID], [tInternalFieldName], [tInternalTableName], [nInternalDSID], [tExternalFieldName], [nValueTableID], [tExternalFieldFormat], [bForeignKey], [bSyncOnlyNewRecord], [nCVLookupMode]) VALUES (45, N'MqAssetOwnerLookup', N'tblDts', 32, N'Annotated User', 0, NULL, 0, 0, 0)
INSERT [Users_mdb].[dbo].[tblFieldMap_ImpRule] ([nID], [tInternalFieldName], [tInternalTableName], [nInternalDSID], [tExternalFieldName], [nValueTableID], [tExternalFieldFormat], [bForeignKey], [bSyncOnlyNewRecord], [nCVLookupMode]) VALUES (45, N'Source_Timestamp', N'tblDts', 32, N'Last Sync', 0, NULL, 0, 0, 0)
GO

INSERT [Users_mdb].[dbo].[tblDefaultValue_ImpRule] ([nID], [tInternalFieldName], [tInternalTableName], [nInternalDSID], [tDefaultValue], [tConditionField], [tConditionValue], [nConditionIndex], [nCVLookupMode]) VALUES (45, N'nUsageType', N'tblDts', 32, N'1', NULL, NULL, 0, 0)
INSERT [Users_mdb].[dbo].[tblDefaultValue_ImpRule] ([nID], [tInternalFieldName], [tInternalTableName], [nInternalDSID], [tDefaultValue], [tConditionField], [tConditionValue], [nConditionIndex], [nCVLookupMode]) VALUES (45, N'MqAssetTypeLookup', N'tblDts', 32, N'Chromebook', NULL, NULL, NULL, NULL)
INSERT [Users_mdb].[dbo].[tblDefaultValue_ImpRule] ([nID], [tInternalFieldName], [tInternalTableName], [nInternalDSID], [tDefaultValue], [tConditionField], [tConditionValue], [nConditionIndex], [nCVLookupMode]) VALUES (45, N'OS_Name', N'tblDts', 32, N'Chrome OS', NULL, NULL, NULL, NULL)
INSERT [Users_mdb].[dbo].[tblDefaultValue_ImpRule] ([nID], [tInternalFieldName], [tInternalTableName], [nInternalDSID], [tDefaultValue], [tConditionField], [tConditionValue], [nConditionIndex], [nCVLookupMode]) VALUES (45, N'Item_Level', N'tblDts', 32, N'3', NULL, NULL, NULL, NULL)
GO

INSERT INTO [Users_mdb].[dbo].tblGroup (nID, tName) VALUES((SELECT MAX(nID) FROM [Users_mdb].[dbo].tblGroup) + 1, 'Students')
INSERT INTO [Users_mdb].[dbo].tblGroup (nID, tName) VALUES((SELECT MAX(nID) FROM [Users_mdb].[dbo].tblGroup) + 1, 'Teachers')
GO

DELETE FROM [Users_mdb].[dbo].tblGroupMembership WHERE nGroupID=4 AND nUserID=22
GO

UPDATE Users_mdb.dbo.tblWidget SET tPath='~/WidgetComponents/WidgetTotal.ascx' WHERE nID=41
UPDATE Users_mdb.dbo.tblWidget SET tPath='~/WidgetComponents/WidgetBar.ascx' WHERE nID=42
UPDATE Users_mdb.dbo.tblWidget SET tPath='~/WidgetComponents/WidgetTotal.ascx' WHERE nID=43
UPDATE Users_mdb.dbo.tblWidget SET tPath='~/WidgetComponents/WidgetBar.ascx' WHERE nID=44
UPDATE Users_mdb.dbo.tblWidget SET nQueryID=12 WHERE nID IN(49, 51)
GO

INSERT [Users_mdb].[dbo].[tblDefaultValue_ImpRule] ([nID], [tInternalFieldName], [tInternalTableName], [nInternalDSID], [tDefaultValue], [tConditionField], [tConditionValue], [nConditionIndex], [nCVLookupMode]) VALUES (13, N'MqAssetTypeLookup', N'tblDts', 32, N'Desktop', NULL, NULL, 0, NULL)
INSERT [Users_mdb].[dbo].[tblDefaultValue_ImpRule] ([nID], [tInternalFieldName], [tInternalTableName], [nInternalDSID], [tDefaultValue], [tConditionField], [tConditionValue], [nConditionIndex], [nCVLookupMode]) VALUES (17, N'MqAssetTypeLookup', N'tblDts', 32, N'iPhone', NULL, NULL, 0, NULL)
INSERT [Users_mdb].[dbo].[tblDefaultValue_ImpRule] ([nID], [tInternalFieldName], [tInternalTableName], [nInternalDSID], [tDefaultValue], [tConditionField], [tConditionValue], [nConditionIndex], [nCVLookupMode]) VALUES (18, N'MqAssetTypeLookup', N'tblDts', 32, N'Monitor', NULL, NULL, 0, NULL)
INSERT [Users_mdb].[dbo].[tblDefaultValue_ImpRule] ([nID], [tInternalFieldName], [tInternalTableName], [nInternalDSID], [tDefaultValue], [tConditionField], [tConditionValue], [nConditionIndex], [nCVLookupMode]) VALUES (19, N'MqAssetTypeLookup', N'tblDts', 32, N'Printer', NULL, NULL, 0, NULL)
INSERT [Users_mdb].[dbo].[tblDefaultValue_ImpRule] ([nID], [tInternalFieldName], [tInternalTableName], [nInternalDSID], [tDefaultValue], [tConditionField], [tConditionValue], [nConditionIndex], [nCVLookupMode]) VALUES (20, N'MqAssetTypeLookup', N'tblDts', 32, N'RSA Token', NULL, NULL, 0, NULL)
INSERT [Users_mdb].[dbo].[tblDefaultValue_ImpRule] ([nID], [tInternalFieldName], [tInternalTableName], [nInternalDSID], [tDefaultValue], [tConditionField], [tConditionValue], [nConditionIndex], [nCVLookupMode]) VALUES (21, N'MqAssetTypeLookup', N'tblDts', 32, N'Mobile Broadband', NULL, NULL, 0, NULL)
GO

DELETE FROM [Users_mdb].[dbo].[tblFieldMap_ImpRule] WHERE nID IN(13, 17, 18, 19, 20, 21) AND tInternalFieldName='MqAssetTypeLookup'
GO

UPDATE [Users_mdb].[dbo].[tblSystemQueries] SET tName='State' WHERE tName='Employment Status' AND nDtsFieldID=90
GO

UPDATE [Users_mdb].[dbo].[tblSystemQueries] SET tName='Employment Status (Employment Tab)', nDtsFieldID=266 WHERE nDtsFieldID=90 AND tValue='Terminated'
GO

/***********************************************************************/

ALTER TABLE BugTrk02_Def.dbo.tblSystemCustomQueries ADD nDefaultSort int
ALTER TABLE BugTrk02_Def.dbo.tblSystemCustomQueries ADD nDefaultLayout int 
GO

ALTER TABLE ChangeRequests02_Def.dbo.tblSystemCustomQueries ADD nDefaultSort int
ALTER TABLE ChangeRequests02_Def.dbo.tblSystemCustomQueries ADD nDefaultLayout int 
GO

ALTER TABLE Configuration02_Def.dbo.tblSystemCustomQueries ADD nDefaultSort int
ALTER TABLE Configuration02_Def.dbo.tblSystemCustomQueries ADD nDefaultLayout int 
GO

ALTER TABLE Knowledgebase02_Def.dbo.tblSystemCustomQueries ADD nDefaultSort int
ALTER TABLE Knowledgebase02_Def.dbo.tblSystemCustomQueries ADD nDefaultLayout int 
GO

ALTER TABLE ReleaseMgmt02_Def.dbo.tblSystemCustomQueries ADD nDefaultSort int
ALTER TABLE ReleaseMgmt02_Def.dbo.tblSystemCustomQueries ADD nDefaultLayout int 
GO


/***********************************************************************/

UPDATE LicenseManager01_Dat.dbo.tblDts SET dSubmittedDate=DATEADD(YEAR, 1, dSubmittedDate) WHERE nID<=25
UPDATE LicenseManager01_Dat.dbo.tblDts SET dLastUpdateDate=DATEADD(YEAR, 1, dLastUpdateDate) WHERE nID<=25
UPDATE LicenseManager01_Dat.dbo.tblDts SET dAssignedDate=DATEADD(YEAR, 1, dAssignedDate) WHERE nID<=25
UPDATE LicenseManager01_Dat.dbo.tblDts SET dClosedDate=DATEADD(YEAR, 1, dClosedDate) WHERE nID<=25 
UPDATE LicenseManager01_Dat.dbo.tblRevisionHistory SET dDate=DATEADD(YEAR, 1, dDate) WHERE nRecordID<=25
GO

UPDATE [Purchases&Agreements01_Dat].dbo.tblDts SET dSubmittedDate=DATEADD(YEAR, 1, dSubmittedDate) WHERE nID<=1143
UPDATE [Purchases&Agreements01_Dat].dbo.tblDts SET dLastUpdateDate=DATEADD(YEAR, 1, dLastUpdateDate) WHERE nID<=1143
UPDATE [Purchases&Agreements01_Dat].dbo.tblDts SET dAssignedDate=DATEADD(YEAR, 1, dAssignedDate) WHERE nID<=1143
UPDATE [Purchases&Agreements01_Dat].dbo.tblDts SET dClosedDate=DATEADD(YEAR, 1, dClosedDate) WHERE nID<=1143
UPDATE [Purchases&Agreements01_Dat].dbo.tblDts SET Invoice_Date=DATEADD(YEAR, 1, Invoice_Date) WHERE nID<=1143
UPDATE [Purchases&Agreements01_Dat].dbo.tblDts SET [Start_Date]=DATEADD(YEAR, 1, [Start_Date]) WHERE nID<=1143
UPDATE [Purchases&Agreements01_Dat].dbo.tblDts SET End_Date=DATEADD(YEAR, 1, End_Date) WHERE nID<=1143
UPDATE [Purchases&Agreements01_Dat].dbo.tblDts SET Ordered_Date=DATEADD(YEAR, 1, Ordered_Date) WHERE nID<=1143
UPDATE [Purchases&Agreements01_Dat].dbo.tblDts SET Received_Date=DATEADD(YEAR, 1, Received_Date) WHERE nID<=1143
UPDATE [Purchases&Agreements01_Dat].dbo.tblDts SET Approved_Date=DATEADD(YEAR, 1, Approved_Date) WHERE nID<=1143
UPDATE [Purchases&Agreements01_Dat].dbo.tblRevisionHistory SET dDate=DATEADD(YEAR, 1, dDate) WHERE nRecordID<=1143
GO

UPDATE [Purchases&Agreements01_Dat].dbo.tblDts SET Line_Item_Status = 3 WHERE Line_Item_Status = 4 AND End_Date >= GETDATE() AND nID<=1143
GO

UPDATE HelpDesk01_Dat.dbo.tblDts SET dLastUpdateDate=DATEADD(YEAR, 1, dLastUpdateDate) WHERE nID<=16 AND dSubmittedDate<'2017/01/01'
UPDATE HelpDesk01_Dat.dbo.tblDts SET dAssignedDate=DATEADD(YEAR, 1, dAssignedDate) WHERE nID<=16 AND dSubmittedDate<'2017/01/01'
UPDATE HelpDesk01_Dat.dbo.tblDts SET dClosedDate=DATEADD(YEAR, 1, dClosedDate) WHERE nID<=16 AND dSubmittedDate<'2017/01/01'
UPDATE HelpDesk01_Dat.dbo.tblDts SET dTargetIRT=DATEADD(YEAR, 1, dTargetIRT) WHERE nID<=16 AND dSubmittedDate<'2017/01/01'
UPDATE HelpDesk01_Dat.dbo.tblDts SET dTargetClosureTime=DATEADD(YEAR, 1, dTargetClosureTime) WHERE nID<=16 AND dSubmittedDate<'2017/01/01'
UPDATE HelpDesk01_Dat.dbo.tblDts SET [Planned$Start$Date]=DATEADD(YEAR, 1, [Planned$Start$Date]) WHERE nID<=16 AND dSubmittedDate<'2017/01/01'
UPDATE HelpDesk01_Dat.dbo.tblDts SET [Planned$End$Date]=DATEADD(YEAR, 1, [Planned$End$Date]) WHERE nID<=16 AND dSubmittedDate<'2017/01/01'
UPDATE HelpDesk01_Dat.dbo.tblDts SET Activity$Log=REPLACE(Activity$Log, '/2016', '/2017') WHERE nID<=16 AND dSubmittedDate<'2017/01/01'
UPDATE HelpDesk01_Dat.dbo.tblDts SET Activity$Log=REPLACE(Activity$Log, '/2015', '/2016') WHERE nID<=16 AND dSubmittedDate<'2017/01/01'
UPDATE HelpDesk01_Dat.dbo.tblDts SET Activity$Log=REPLACE(Activity$Log, '/2014', '/2015') WHERE nID<=16 AND dSubmittedDate<'2017/01/01'
UPDATE HelpDesk01_Dat.dbo.tblRevisionHistory SET dDate=DATEADD(YEAR, 1, dDate) WHERE nRecordID<=16 AND (SELECT dSubmittedDate FROM HelpDesk01_Dat.dbo.tblDts AS B WHERE tblRevisionHistory.nRecordID=B.nID) <'2017/01/01'
UPDATE HelpDesk01_Dat.dbo.tblDts SET dSubmittedDate=DATEADD(YEAR, 1, dSubmittedDate) WHERE nID<=16 AND dSubmittedDate<'2017/01/01'
GO

UPDATE Roles01_Dat.dbo.tblDts SET dClosedDate=DATEADD(YEAR, 1, dClosedDate) WHERE nID<=682 AND dSubmittedDate<'2017/01/01'
UPDATE Roles01_Dat.dbo.tblDts SET dLastUpdateDate=DATEADD(YEAR, 1, dLastUpdateDate) WHERE nID<=682 AND dSubmittedDate<'2017/01/01'
UPDATE Roles01_Dat.dbo.tblRevisionHistory SET dDate=DATEADD(YEAR, 1, dDate) WHERE nRecordID<=16 AND (SELECT dSubmittedDate FROM Roles01_Dat.dbo.tblDts AS B WHERE tblRevisionHistory.nRecordID=B.nID) <'2017/01/01'
UPDATE Roles01_Dat.dbo.tblDts SET dSubmittedDate=DATEADD(YEAR, 1, dSubmittedDate) WHERE nID<=682 AND dSubmittedDate<'2017/01/01'
GO

UPDATE Actions01_Dat.dbo.tblDts SET dLastUpdateDate=DATEADD(YEAR, 1, dLastUpdateDate) WHERE nID<=365 AND dSubmittedDate<'2017/01/01'
UPDATE Actions01_Dat.dbo.tblDts SET dAssignedDate=DATEADD(YEAR, 1, dAssignedDate) WHERE nID<=365 AND dSubmittedDate<'2017/01/01'
UPDATE Actions01_Dat.dbo.tblDts SET dClosedDate=DATEADD(YEAR, 1, dClosedDate) WHERE nID<=365 AND dSubmittedDate<'2017/01/01'
UPDATE Actions01_Dat.dbo.tblRevisionHistory SET dDate=DATEADD(YEAR, 1, dDate) WHERE nRecordID<=365 AND (SELECT dSubmittedDate FROM Actions01_Dat.dbo.tblDts AS B WHERE tblRevisionHistory.nRecordID=B.nID) <'2017/01/01'
UPDATE Actions01_Dat.dbo.tblDts SET dSubmittedDate=DATEADD(YEAR, 1, dSubmittedDate) WHERE nID<=365 AND dSubmittedDate<'2017/01/01'
GO

UPDATE Resources01_Dat.dbo.tblDts SET dLastUpdateDate=DATEADD(YEAR, 1, dLastUpdateDate) WHERE nID<=7183 AND dSubmittedDate<'2017/01/01'
UPDATE Resources01_Dat.dbo.tblDts SET dAssignedDate=DATEADD(YEAR, 1, dAssignedDate) WHERE nID<=7183 AND dSubmittedDate<'2017/01/01'
UPDATE Resources01_Dat.dbo.tblDts SET dClosedDate=DATEADD(YEAR, 1, dClosedDate) WHERE nID<=7183 AND dSubmittedDate<'2017/01/01'
UPDATE Resources01_Dat.dbo.tblDts SET Delivery_Date=DATEADD(YEAR, 1, Delivery_Date) WHERE nID<=7183 AND dSubmittedDate<'2017/01/01'
UPDATE Resources01_Dat.dbo.tblDts SET Last_Imported_Date=DATEADD(YEAR, 1, Last_Imported_Date) WHERE nID<=7183 AND dSubmittedDate<'2017/01/01'
UPDATE Resources01_Dat.dbo.tblDts SET Purchased_Date=DATEADD(YEAR, 1, Purchased_Date) WHERE nID<=7183 AND dSubmittedDate<'2017/01/01'
UPDATE Resources01_Dat.dbo.tblDts SET Request_Required_By_Date=DATEADD(YEAR, 1, Request_Required_By_Date) WHERE 7183<=16 AND dSubmittedDate<'2017/01/01'
UPDATE Resources01_Dat.dbo.tblDts SET Requested_Until=DATEADD(YEAR, 1, Requested_Until) WHERE nID<=7183 AND dSubmittedDate<'2017/01/01'
UPDATE Resources01_Dat.dbo.tblDts SET Retired_Date=DATEADD(YEAR, 1, Retired_Date) WHERE nID<=7183 AND dSubmittedDate<'2017/01/01'
UPDATE Resources01_Dat.dbo.tblDts SET Warranty_Start_Date=DATEADD(YEAR, 1, Warranty_Start_Date) WHERE nID<=7183 AND dSubmittedDate<'2017/01/01'
UPDATE Resources01_Dat.dbo.tblDts SET Warranty_Until=DATEADD(YEAR, 1, Warranty_Start_Date) WHERE nID<=7183 AND dSubmittedDate<'2017/01/01'
UPDATE Resources01_Dat.dbo.tblRevisionHistory SET dDate=DATEADD(YEAR, 1, dDate) WHERE nRecordID<=7183 AND (SELECT dSubmittedDate FROM Resources01_Dat.dbo.tblDts AS B WHERE tblRevisionHistory.nRecordID=B.nID) <'2017/01/01'
UPDATE Resources01_Dat.dbo.tblDts SET dSubmittedDate=DATEADD(YEAR, 1, dSubmittedDate) WHERE nID<=7183 AND dSubmittedDate<'2017/01/01'
GO

/***********************************************************************/

CREATE TABLE [Actions02_Def].[dbo].[tblNextID](
	[tName] [nvarchar](255) NULL,
	[nID] [int] NULL
)
GO

INSERT [Actions02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblDtsFields', 10000)
INSERT [Actions02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblTabs', 10000)
INSERT [Actions02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblRule', 10000)
INSERT [Actions02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblRuleCondition', 10000)
INSERT [Actions02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblPossibleValue', 10000)
INSERT [Actions02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblUIElement_Rule', 10000)
GO

UPDATE [Actions02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Actions02_Def].dbo.tblDtsFields) + 1) WHERE tName='tblDtsFields' AND ((SELECT MAX(nID) FROM [Actions02_Def].dbo.tblDtsFields) >=10000)
UPDATE [Actions02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Actions02_Def].dbo.tblTabs) + 1) WHERE tName='tblTabs' AND ((SELECT MAX(nID) FROM [Actions02_Def].dbo.tblTabs) >=10000)
UPDATE [Actions02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Actions02_Def].dbo.tblRule) + 1) WHERE tName='tblRule' AND ((SELECT MAX(nID) FROM [Actions02_Def].dbo.tblRule) >=10000)
UPDATE [Actions02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Actions02_Def].dbo.tblRuleCondition) + 1) WHERE tName='tblRuleCondition' AND ((SELECT MAX(nID) FROM [Actions02_Def].dbo.tblRuleCondition) >=10000)
UPDATE [Actions02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Actions02_Def].dbo.tblPossibleValue) + 1) WHERE tName='tblPossibleValue' AND ((SELECT MAX(nID) FROM [Actions02_Def].dbo.tblPossibleValue) >=10000)
UPDATE [Actions02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Actions02_Def].dbo.tblUIElement_Rule) + 1) WHERE tName='tblUIElement_Rule' AND ((SELECT MAX(nID) FROM [Actions02_Def].dbo.tblUIElement_Rule) >=10000)
GO

CREATE TABLE [Appraisals02_Def].[dbo].[tblNextID](
	[tName] [nvarchar](255) NULL,
	[nID] [int] NULL
)
GO

INSERT [Appraisals02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblDtsFields', 10000)
INSERT [Appraisals02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblTabs', 10000)
INSERT [Appraisals02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblRule', 10000)
INSERT [Appraisals02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblRuleCondition', 10000)
INSERT [Appraisals02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblPossibleValue', 10000)
INSERT [Appraisals02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblUIElement_Rule', 10000)
GO

UPDATE [Appraisals02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Appraisals02_Def].dbo.tblDtsFields) + 1) WHERE tName='tblDtsFields' AND ((SELECT MAX(nID) FROM [Appraisals02_Def].dbo.tblDtsFields) >=10000)
UPDATE [Appraisals02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Appraisals02_Def].dbo.tblTabs) + 1) WHERE tName='tblTabs' AND ((SELECT MAX(nID) FROM [Appraisals02_Def].dbo.tblTabs) >=10000)
UPDATE [Appraisals02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Appraisals02_Def].dbo.tblRule) + 1) WHERE tName='tblRule' AND ((SELECT MAX(nID) FROM [Appraisals02_Def].dbo.tblRule) >=10000)
UPDATE [Appraisals02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Appraisals02_Def].dbo.tblRuleCondition) + 1) WHERE tName='tblRuleCondition' AND ((SELECT MAX(nID) FROM [Appraisals02_Def].dbo.tblRuleCondition) >=10000)
UPDATE [Appraisals02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Appraisals02_Def].dbo.tblPossibleValue) + 1) WHERE tName='tblPossibleValue' AND ((SELECT MAX(nID) FROM [Appraisals02_Def].dbo.tblPossibleValue) >=10000)
UPDATE [Appraisals02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Appraisals02_Def].dbo.tblUIElement_Rule) + 1) WHERE tName='tblUIElement_Rule' AND ((SELECT MAX(nID) FROM [Appraisals02_Def].dbo.tblUIElement_Rule) >=10000)
GO


CREATE TABLE [AppraisalSections02_Def].[dbo].[tblNextID](
	[tName] [nvarchar](255) NULL,
	[nID] [int] NULL
)
GO

INSERT [AppraisalSections02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblDtsFields', 10000)
INSERT [AppraisalSections02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblTabs', 10000)
INSERT [AppraisalSections02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblRule', 10000)
INSERT [AppraisalSections02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblRuleCondition', 10000)
INSERT [AppraisalSections02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblPossibleValue', 10000)
INSERT [AppraisalSections02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblUIElement_Rule', 10000)
GO

UPDATE [AppraisalSections02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [AppraisalSections02_Def].dbo.tblDtsFields) + 1) WHERE tName='tblDtsFields' AND ((SELECT MAX(nID) FROM [AppraisalSections02_Def].dbo.tblDtsFields) >=10000)
UPDATE [AppraisalSections02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [AppraisalSections02_Def].dbo.tblTabs) + 1) WHERE tName='tblTabs' AND ((SELECT MAX(nID) FROM [AppraisalSections02_Def].dbo.tblTabs) >=10000)
UPDATE [AppraisalSections02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [AppraisalSections02_Def].dbo.tblRule) + 1) WHERE tName='tblRule' AND ((SELECT MAX(nID) FROM [AppraisalSections02_Def].dbo.tblRule) >=10000)
UPDATE [AppraisalSections02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [AppraisalSections02_Def].dbo.tblRuleCondition) + 1) WHERE tName='tblRuleCondition' AND ((SELECT MAX(nID) FROM [AppraisalSections02_Def].dbo.tblRuleCondition) >=10000)
UPDATE [AppraisalSections02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [AppraisalSections02_Def].dbo.tblPossibleValue) + 1) WHERE tName='tblPossibleValue' AND ((SELECT MAX(nID) FROM [AppraisalSections02_Def].dbo.tblPossibleValue) >=10000)
UPDATE [AppraisalSections02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [AppraisalSections02_Def].dbo.tblUIElement_Rule) + 1) WHERE tName='tblUIElement_Rule' AND ((SELECT MAX(nID) FROM [AppraisalSections02_Def].dbo.tblUIElement_Rule) >=10000)
GO

CREATE TABLE [BugTrk02_Def].[dbo].[tblNextID](
	[tName] [nvarchar](255) NULL,
	[nID] [int] NULL
)
GO

INSERT [BugTrk02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblDtsFields', 10000)
INSERT [BugTrk02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblTabs', 10000)
INSERT [BugTrk02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblRule', 10000)
INSERT [BugTrk02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblRuleCondition', 10000)
INSERT [BugTrk02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblPossibleValue', 10000)
INSERT [BugTrk02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblUIElement_Rule', 10000)
GO

UPDATE [BugTrk02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [BugTrk02_Def].dbo.tblDtsFields) + 1) WHERE tName='tblDtsFields' AND ((SELECT MAX(nID) FROM [BugTrk02_Def].dbo.tblDtsFields) >=10000)
UPDATE [BugTrk02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [BugTrk02_Def].dbo.tblTabs) + 1) WHERE tName='tblTabs' AND ((SELECT MAX(nID) FROM [BugTrk02_Def].dbo.tblTabs) >=10000)
UPDATE [BugTrk02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [BugTrk02_Def].dbo.tblRule) + 1) WHERE tName='tblRule' AND ((SELECT MAX(nID) FROM [BugTrk02_Def].dbo.tblRule) >=10000)
UPDATE [BugTrk02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [BugTrk02_Def].dbo.tblRuleCondition) + 1) WHERE tName='tblRuleCondition' AND ((SELECT MAX(nID) FROM [BugTrk02_Def].dbo.tblRuleCondition) >=10000)
UPDATE [BugTrk02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [BugTrk02_Def].dbo.tblPossibleValue) + 1) WHERE tName='tblPossibleValue' AND ((SELECT MAX(nID) FROM [BugTrk02_Def].dbo.tblPossibleValue) >=10000)
UPDATE [BugTrk02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [BugTrk02_Def].dbo.tblUIElement_Rule) + 1) WHERE tName='tblUIElement_Rule' AND ((SELECT MAX(nID) FROM [BugTrk02_Def].dbo.tblUIElement_Rule) >=10000)
GO

CREATE TABLE [ChangeRequests02_Def].[dbo].[tblNextID](
	[tName] [nvarchar](255) NULL,
	[nID] [int] NULL
)
GO

INSERT [ChangeRequests02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblDtsFields', 10000)
INSERT [ChangeRequests02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblTabs', 10000)
INSERT [ChangeRequests02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblRule', 10000)
INSERT [ChangeRequests02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblRuleCondition', 10000)
INSERT [ChangeRequests02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblPossibleValue', 10000)
INSERT [ChangeRequests02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblUIElement_Rule', 10000)
GO

UPDATE [ChangeRequests02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [ChangeRequests02_Def].dbo.tblDtsFields) + 1) WHERE tName='tblDtsFields' AND ((SELECT MAX(nID) FROM [ChangeRequests02_Def].dbo.tblDtsFields) >=10000)
UPDATE [ChangeRequests02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [ChangeRequests02_Def].dbo.tblTabs) + 1) WHERE tName='tblTabs' AND ((SELECT MAX(nID) FROM [ChangeRequests02_Def].dbo.tblTabs) >=10000)
UPDATE [ChangeRequests02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [ChangeRequests02_Def].dbo.tblRule) + 1) WHERE tName='tblRule' AND ((SELECT MAX(nID) FROM [ChangeRequests02_Def].dbo.tblRule) >=10000)
UPDATE [ChangeRequests02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [ChangeRequests02_Def].dbo.tblRuleCondition) + 1) WHERE tName='tblRuleCondition' AND ((SELECT MAX(nID) FROM [ChangeRequests02_Def].dbo.tblRuleCondition) >=10000)
UPDATE [ChangeRequests02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [ChangeRequests02_Def].dbo.tblPossibleValue) + 1) WHERE tName='tblPossibleValue' AND ((SELECT MAX(nID) FROM [ChangeRequests02_Def].dbo.tblPossibleValue) >=10000)
UPDATE [ChangeRequests02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [ChangeRequests02_Def].dbo.tblUIElement_Rule) + 1) WHERE tName='tblUIElement_Rule' AND ((SELECT MAX(nID) FROM [ChangeRequests02_Def].dbo.tblUIElement_Rule) >=10000)
GO


CREATE TABLE [Configuration02_Def].[dbo].[tblNextID](
	[tName] [nvarchar](255) NULL,
	[nID] [int] NULL
)
GO

INSERT [Configuration02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblDtsFields', 10000)
INSERT [Configuration02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblTabs', 10000)
INSERT [Configuration02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblRule', 10000)
INSERT [Configuration02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblRuleCondition', 10000)
INSERT [Configuration02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblPossibleValue', 10000)
INSERT [Configuration02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblUIElement_Rule', 10000)
GO

UPDATE [Configuration02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Configuration02_Def].dbo.tblDtsFields) + 1) WHERE tName='tblDtsFields' AND ((SELECT MAX(nID) FROM [Configuration02_Def].dbo.tblDtsFields) >=10000)
UPDATE [Configuration02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Configuration02_Def].dbo.tblTabs) + 1) WHERE tName='tblTabs' AND ((SELECT MAX(nID) FROM [Configuration02_Def].dbo.tblTabs) >=10000)
UPDATE [Configuration02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Configuration02_Def].dbo.tblRule) + 1) WHERE tName='tblRule' AND ((SELECT MAX(nID) FROM [Configuration02_Def].dbo.tblRule) >=10000)
UPDATE [Configuration02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Configuration02_Def].dbo.tblRuleCondition) + 1) WHERE tName='tblRuleCondition' AND ((SELECT MAX(nID) FROM [Configuration02_Def].dbo.tblRuleCondition) >=10000)
UPDATE [Configuration02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Configuration02_Def].dbo.tblPossibleValue) + 1) WHERE tName='tblPossibleValue' AND ((SELECT MAX(nID) FROM [Configuration02_Def].dbo.tblPossibleValue) >=10000)
UPDATE [Configuration02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Configuration02_Def].dbo.tblUIElement_Rule) + 1) WHERE tName='tblUIElement_Rule' AND ((SELECT MAX(nID) FROM [Configuration02_Def].dbo.tblUIElement_Rule) >=10000)
GO

CREATE TABLE [HelpDesk02_Def].[dbo].[tblNextID](
	[tName] [nvarchar](255) NULL,
	[nID] [int] NULL
)
GO

INSERT [HelpDesk02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblDtsFields', 10000)
INSERT [HelpDesk02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblTabs', 10000)
INSERT [HelpDesk02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblRule', 10000)
INSERT [HelpDesk02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblRuleCondition', 10000)
INSERT [HelpDesk02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblPossibleValue', 10000)
INSERT [HelpDesk02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblUIElement_Rule', 10000)
GO

UPDATE [HelpDesk02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [HelpDesk02_Def].dbo.tblDtsFields) + 1) WHERE tName='tblDtsFields' AND ((SELECT MAX(nID) FROM [HelpDesk02_Def].dbo.tblDtsFields) >=10000)
UPDATE [HelpDesk02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [HelpDesk02_Def].dbo.tblTabs) + 1) WHERE tName='tblTabs' AND ((SELECT MAX(nID) FROM [HelpDesk02_Def].dbo.tblTabs) >=10000)
UPDATE [HelpDesk02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [HelpDesk02_Def].dbo.tblRule) + 1) WHERE tName='tblRule' AND ((SELECT MAX(nID) FROM [HelpDesk02_Def].dbo.tblRule) >=10000)
UPDATE [HelpDesk02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [HelpDesk02_Def].dbo.tblRuleCondition) + 1) WHERE tName='tblRuleCondition' AND ((SELECT MAX(nID) FROM [HelpDesk02_Def].dbo.tblRuleCondition) >=10000)
UPDATE [HelpDesk02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [HelpDesk02_Def].dbo.tblPossibleValue) + 1) WHERE tName='tblPossibleValue' AND ((SELECT MAX(nID) FROM [HelpDesk02_Def].dbo.tblPossibleValue) >=10000)
UPDATE [HelpDesk02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [HelpDesk02_Def].dbo.tblUIElement_Rule) + 1) WHERE tName='tblUIElement_Rule' AND ((SELECT MAX(nID) FROM [HelpDesk02_Def].dbo.tblUIElement_Rule) >=10000)
GO

CREATE TABLE [Installations02_Def].[dbo].[tblNextID](
	[tName] [nvarchar](255) NULL,
	[nID] [int] NULL
)
GO

INSERT [Installations02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblDtsFields', 10000)
INSERT [Installations02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblTabs', 10000)
INSERT [Installations02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblRule', 10000)
INSERT [Installations02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblRuleCondition', 10000)
INSERT [Installations02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblPossibleValue', 10000)
INSERT [Installations02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblUIElement_Rule', 10000)
GO

UPDATE [Installations02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Installations02_Def].dbo.tblDtsFields) + 1) WHERE tName='tblDtsFields' AND ((SELECT MAX(nID) FROM [Installations02_Def].dbo.tblDtsFields) >=10000)
UPDATE [Installations02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Installations02_Def].dbo.tblTabs) + 1) WHERE tName='tblTabs' AND ((SELECT MAX(nID) FROM [Installations02_Def].dbo.tblTabs) >=10000)
UPDATE [Installations02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Installations02_Def].dbo.tblRule) + 1) WHERE tName='tblRule' AND ((SELECT MAX(nID) FROM [Installations02_Def].dbo.tblRule) >=10000)
UPDATE [Installations02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Installations02_Def].dbo.tblRuleCondition) + 1) WHERE tName='tblRuleCondition' AND ((SELECT MAX(nID) FROM [Installations02_Def].dbo.tblRuleCondition) >=10000)
UPDATE [Installations02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Installations02_Def].dbo.tblPossibleValue) + 1) WHERE tName='tblPossibleValue' AND ((SELECT MAX(nID) FROM [Installations02_Def].dbo.tblPossibleValue) >=10000)
UPDATE [Installations02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Installations02_Def].dbo.tblUIElement_Rule) + 1) WHERE tName='tblUIElement_Rule' AND ((SELECT MAX(nID) FROM [Installations02_Def].dbo.tblUIElement_Rule) >=10000)
GO

CREATE TABLE [InventoriedSoftware02_Def].[dbo].[tblNextID](
	[tName] [nvarchar](255) NULL,
	[nID] [int] NULL
)
GO

INSERT [InventoriedSoftware02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblDtsFields', 10000)
INSERT [InventoriedSoftware02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblTabs', 10000)
INSERT [InventoriedSoftware02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblRule', 10000)
INSERT [InventoriedSoftware02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblRuleCondition', 10000)
INSERT [InventoriedSoftware02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblPossibleValue', 10000)
INSERT [InventoriedSoftware02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblUIElement_Rule', 10000)
GO

UPDATE [InventoriedSoftware02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [InventoriedSoftware02_Def].dbo.tblDtsFields) + 1) WHERE tName='tblDtsFields' AND ((SELECT MAX(nID) FROM [InventoriedSoftware02_Def].dbo.tblDtsFields) >=10000)
UPDATE [InventoriedSoftware02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [InventoriedSoftware02_Def].dbo.tblTabs) + 1) WHERE tName='tblTabs' AND ((SELECT MAX(nID) FROM [InventoriedSoftware02_Def].dbo.tblTabs) >=10000)
UPDATE [InventoriedSoftware02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [InventoriedSoftware02_Def].dbo.tblRule) + 1) WHERE tName='tblRule' AND ((SELECT MAX(nID) FROM [InventoriedSoftware02_Def].dbo.tblRule) >=10000)
UPDATE [InventoriedSoftware02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [InventoriedSoftware02_Def].dbo.tblRuleCondition) + 1) WHERE tName='tblRuleCondition' AND ((SELECT MAX(nID) FROM [InventoriedSoftware02_Def].dbo.tblRuleCondition) >=10000)
UPDATE [InventoriedSoftware02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [InventoriedSoftware02_Def].dbo.tblPossibleValue) + 1) WHERE tName='tblPossibleValue' AND ((SELECT MAX(nID) FROM [InventoriedSoftware02_Def].dbo.tblPossibleValue) >=10000)
UPDATE [InventoriedSoftware02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [InventoriedSoftware02_Def].dbo.tblUIElement_Rule) + 1) WHERE tName='tblUIElement_Rule' AND ((SELECT MAX(nID) FROM [InventoriedSoftware02_Def].dbo.tblUIElement_Rule) >=10000)
GO

CREATE TABLE [KnowledgeBase02_Def].[dbo].[tblNextID](
	[tName] [nvarchar](255) NULL,
	[nID] [int] NULL
)
GO

INSERT [KnowledgeBase02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblDtsFields', 10000)
INSERT [KnowledgeBase02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblTabs', 10000)
INSERT [KnowledgeBase02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblRule', 10000)
INSERT [KnowledgeBase02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblRuleCondition', 10000)
INSERT [KnowledgeBase02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblPossibleValue', 10000)
INSERT [KnowledgeBase02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblUIElement_Rule', 10000)
GO

UPDATE [KnowledgeBase02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [KnowledgeBase02_Def].dbo.tblDtsFields) + 1) WHERE tName='tblDtsFields' AND ((SELECT MAX(nID) FROM [KnowledgeBase02_Def].dbo.tblDtsFields) >=10000)
UPDATE [KnowledgeBase02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [KnowledgeBase02_Def].dbo.tblTabs) + 1) WHERE tName='tblTabs' AND ((SELECT MAX(nID) FROM [KnowledgeBase02_Def].dbo.tblTabs) >=10000)
UPDATE [KnowledgeBase02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [KnowledgeBase02_Def].dbo.tblRule) + 1) WHERE tName='tblRule' AND ((SELECT MAX(nID) FROM [KnowledgeBase02_Def].dbo.tblRule) >=10000)
UPDATE [KnowledgeBase02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [KnowledgeBase02_Def].dbo.tblRuleCondition) + 1) WHERE tName='tblRuleCondition' AND ((SELECT MAX(nID) FROM [KnowledgeBase02_Def].dbo.tblRuleCondition) >=10000)
UPDATE [KnowledgeBase02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [KnowledgeBase02_Def].dbo.tblPossibleValue) + 1) WHERE tName='tblPossibleValue' AND ((SELECT MAX(nID) FROM [KnowledgeBase02_Def].dbo.tblPossibleValue) >=10000)
UPDATE [KnowledgeBase02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [KnowledgeBase02_Def].dbo.tblUIElement_Rule) + 1) WHERE tName='tblUIElement_Rule' AND ((SELECT MAX(nID) FROM [KnowledgeBase02_Def].dbo.tblUIElement_Rule) >=10000)
GO

CREATE TABLE [LicenseManager02_Def].[dbo].[tblNextID](
	[tName] [nvarchar](255) NULL,
	[nID] [int] NULL
)
GO

INSERT [LicenseManager02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblDtsFields', 10000)
INSERT [LicenseManager02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblTabs', 10000)
INSERT [LicenseManager02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblRule', 10000)
INSERT [LicenseManager02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblRuleCondition', 10000)
INSERT [LicenseManager02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblPossibleValue', 10000)
INSERT [LicenseManager02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblUIElement_Rule', 10000)
GO

UPDATE [LicenseManager02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [LicenseManager02_Def].dbo.tblDtsFields) + 1) WHERE tName='tblDtsFields' AND ((SELECT MAX(nID) FROM [LicenseManager02_Def].dbo.tblDtsFields) >=10000)
UPDATE [LicenseManager02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [LicenseManager02_Def].dbo.tblTabs) + 1) WHERE tName='tblTabs' AND ((SELECT MAX(nID) FROM [LicenseManager02_Def].dbo.tblTabs) >=10000)
UPDATE [LicenseManager02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [LicenseManager02_Def].dbo.tblRule) + 1) WHERE tName='tblRule' AND ((SELECT MAX(nID) FROM [LicenseManager02_Def].dbo.tblRule) >=10000)
UPDATE [LicenseManager02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [LicenseManager02_Def].dbo.tblRuleCondition) + 1) WHERE tName='tblRuleCondition' AND ((SELECT MAX(nID) FROM [LicenseManager02_Def].dbo.tblRuleCondition) >=10000)
UPDATE [LicenseManager02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [LicenseManager02_Def].dbo.tblPossibleValue) + 1) WHERE tName='tblPossibleValue' AND ((SELECT MAX(nID) FROM [LicenseManager02_Def].dbo.tblPossibleValue) >=10000)
UPDATE [LicenseManager02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [LicenseManager02_Def].dbo.tblUIElement_Rule) + 1) WHERE tName='tblUIElement_Rule' AND ((SELECT MAX(nID) FROM [LicenseManager02_Def].dbo.tblUIElement_Rule) >=10000)
GO

CREATE TABLE [Purchases&Agreements02_Def].[dbo].[tblNextID](
	[tName] [nvarchar](255) NULL,
	[nID] [int] NULL
)
GO

INSERT [Purchases&Agreements02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblDtsFields', 10000)
INSERT [Purchases&Agreements02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblTabs', 10000)
INSERT [Purchases&Agreements02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblRule', 10000)
INSERT [Purchases&Agreements02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblRuleCondition', 10000)
INSERT [Purchases&Agreements02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblPossibleValue', 10000)
INSERT [Purchases&Agreements02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblUIElement_Rule', 10000)
GO

UPDATE [Purchases&Agreements02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Purchases&Agreements02_Def].dbo.tblDtsFields) + 1) WHERE tName='tblDtsFields' AND ((SELECT MAX(nID) FROM [Purchases&Agreements02_Def].dbo.tblDtsFields) >=10000)
UPDATE [Purchases&Agreements02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Purchases&Agreements02_Def].dbo.tblTabs) + 1) WHERE tName='tblTabs' AND ((SELECT MAX(nID) FROM [Purchases&Agreements02_Def].dbo.tblTabs) >=10000)
UPDATE [Purchases&Agreements02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Purchases&Agreements02_Def].dbo.tblRule) + 1) WHERE tName='tblRule' AND ((SELECT MAX(nID) FROM [Purchases&Agreements02_Def].dbo.tblRule) >=10000)
UPDATE [Purchases&Agreements02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Purchases&Agreements02_Def].dbo.tblRuleCondition) + 1) WHERE tName='tblRuleCondition' AND ((SELECT MAX(nID) FROM [Purchases&Agreements02_Def].dbo.tblRuleCondition) >=10000)
UPDATE [Purchases&Agreements02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Purchases&Agreements02_Def].dbo.tblPossibleValue) + 1) WHERE tName='tblPossibleValue' AND ((SELECT MAX(nID) FROM [Purchases&Agreements02_Def].dbo.tblPossibleValue) >=10000)
UPDATE [Purchases&Agreements02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Purchases&Agreements02_Def].dbo.tblUIElement_Rule) + 1) WHERE tName='tblUIElement_Rule' AND ((SELECT MAX(nID) FROM [Purchases&Agreements02_Def].dbo.tblUIElement_Rule) >=10000)
GO

CREATE TABLE [ReleaseMgmt02_Def].[dbo].[tblNextID](
	[tName] [nvarchar](255) NULL,
	[nID] [int] NULL
)
GO

INSERT [ReleaseMgmt02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblDtsFields', 10000)
INSERT [ReleaseMgmt02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblTabs', 10000)
INSERT [ReleaseMgmt02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblRule', 10000)
INSERT [ReleaseMgmt02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblRuleCondition', 10000)
INSERT [ReleaseMgmt02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblPossibleValue', 10000)
INSERT [ReleaseMgmt02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblUIElement_Rule', 10000)
GO

UPDATE [ReleaseMgmt02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [ReleaseMgmt02_Def].dbo.tblDtsFields) + 1) WHERE tName='tblDtsFields' AND ((SELECT MAX(nID) FROM [ReleaseMgmt02_Def].dbo.tblDtsFields) >=10000)
UPDATE [ReleaseMgmt02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [ReleaseMgmt02_Def].dbo.tblTabs) + 1) WHERE tName='tblTabs' AND ((SELECT MAX(nID) FROM [ReleaseMgmt02_Def].dbo.tblTabs) >=10000)
UPDATE [ReleaseMgmt02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [ReleaseMgmt02_Def].dbo.tblRule) + 1) WHERE tName='tblRule' AND ((SELECT MAX(nID) FROM [ReleaseMgmt02_Def].dbo.tblRule) >=10000)
UPDATE [ReleaseMgmt02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [ReleaseMgmt02_Def].dbo.tblRuleCondition) + 1) WHERE tName='tblRuleCondition' AND ((SELECT MAX(nID) FROM [ReleaseMgmt02_Def].dbo.tblRuleCondition) >=10000)
UPDATE [ReleaseMgmt02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [ReleaseMgmt02_Def].dbo.tblPossibleValue) + 1) WHERE tName='tblPossibleValue' AND ((SELECT MAX(nID) FROM [ReleaseMgmt02_Def].dbo.tblPossibleValue) >=10000)
UPDATE [ReleaseMgmt02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [ReleaseMgmt02_Def].dbo.tblUIElement_Rule) + 1) WHERE tName='tblUIElement_Rule' AND ((SELECT MAX(nID) FROM [ReleaseMgmt02_Def].dbo.tblUIElement_Rule) >=10000)
GO

CREATE TABLE [Resources02_Def].[dbo].[tblNextID](
	[tName] [nvarchar](255) NULL,
	[nID] [int] NULL
)
GO

INSERT [Resources02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblDtsFields', 10000)
INSERT [Resources02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblTabs', 10000)
INSERT [Resources02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblRule', 10000)
INSERT [Resources02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblRuleCondition', 10000)
INSERT [Resources02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblPossibleValue', 10000)
INSERT [Resources02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblUIElement_Rule', 10000)
GO

UPDATE [Resources02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Resources02_Def].dbo.tblDtsFields) + 1) WHERE tName='tblDtsFields' AND ((SELECT MAX(nID) FROM [Resources02_Def].dbo.tblDtsFields) >=10000)
UPDATE [Resources02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Resources02_Def].dbo.tblTabs) + 1) WHERE tName='tblTabs' AND ((SELECT MAX(nID) FROM [Resources02_Def].dbo.tblTabs) >=10000)
UPDATE [Resources02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Resources02_Def].dbo.tblRule) + 1) WHERE tName='tblRule' AND ((SELECT MAX(nID) FROM [Resources02_Def].dbo.tblRule) >=10000)
UPDATE [Resources02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Resources02_Def].dbo.tblRuleCondition) + 1) WHERE tName='tblRuleCondition' AND ((SELECT MAX(nID) FROM [Resources02_Def].dbo.tblRuleCondition) >=10000)
UPDATE [Resources02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Resources02_Def].dbo.tblPossibleValue) + 1) WHERE tName='tblPossibleValue' AND ((SELECT MAX(nID) FROM [Resources02_Def].dbo.tblPossibleValue) >=10000)
UPDATE [Resources02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Resources02_Def].dbo.tblUIElement_Rule) + 1) WHERE tName='tblUIElement_Rule' AND ((SELECT MAX(nID) FROM [Resources02_Def].dbo.tblUIElement_Rule) >=10000)
GO

CREATE TABLE [Roles02_Def].[dbo].[tblNextID](
	[tName] [nvarchar](255) NULL,
	[nID] [int] NULL
)
GO

INSERT [Roles02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblDtsFields', 10000)
INSERT [Roles02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblTabs', 10000)
INSERT [Roles02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblRule', 10000)
INSERT [Roles02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblRuleCondition', 10000)
INSERT [Roles02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblPossibleValue', 10000)
INSERT [Roles02_Def].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblUIElement_Rule', 10000)
GO

UPDATE [Roles02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Roles02_Def].dbo.tblDtsFields) + 1) WHERE tName='tblDtsFields' AND ((SELECT MAX(nID) FROM [Roles02_Def].dbo.tblDtsFields) >=10000)
UPDATE [Roles02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Roles02_Def].dbo.tblTabs) + 1) WHERE tName='tblTabs' AND ((SELECT MAX(nID) FROM [Roles02_Def].dbo.tblTabs) >=10000)
UPDATE [Roles02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Roles02_Def].dbo.tblRule) + 1) WHERE tName='tblRule' AND ((SELECT MAX(nID) FROM [Roles02_Def].dbo.tblRule) >=10000)
UPDATE [Roles02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Roles02_Def].dbo.tblRuleCondition) + 1) WHERE tName='tblRuleCondition' AND ((SELECT MAX(nID) FROM [Roles02_Def].dbo.tblRuleCondition) >=10000)
UPDATE [Roles02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Roles02_Def].dbo.tblPossibleValue) + 1) WHERE tName='tblPossibleValue' AND ((SELECT MAX(nID) FROM [Roles02_Def].dbo.tblPossibleValue) >=10000)
UPDATE [Roles02_Def].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Roles02_Def].dbo.tblUIElement_Rule) + 1) WHERE tName='tblUIElement_Rule' AND ((SELECT MAX(nID) FROM [Roles02_Def].dbo.tblUIElement_Rule) >=10000)
GO

CREATE TABLE [Users_mdb].[dbo].[tblNextID](
	[tName] [nvarchar](255) NULL,
	[nID] [int] NULL
)
GO

INSERT [Users_mdb].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblDtsFields', 10000)
INSERT [Users_mdb].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblTabs', 10000)
INSERT [Users_mdb].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblRule', 10000)
INSERT [Users_mdb].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblRuleCondition', 10000)
INSERT [Users_mdb].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblPossibleValue', 10000)
INSERT [Users_mdb].[dbo].[tblNextID] ([tName], [nID]) VALUES (N'tblUIElement_Rule', 10000)
GO

UPDATE [Users_mdb].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Users_mdb].dbo.tblDtsFields) + 1) WHERE tName='tblDtsFields' AND ((SELECT MAX(nID) FROM [Users_mdb].dbo.tblDtsFields) >=10000)
UPDATE [Users_mdb].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Users_mdb].dbo.tblTabs) + 1) WHERE tName='tblTabs' AND ((SELECT MAX(nID) FROM [Users_mdb].dbo.tblTabs) >=10000)
UPDATE [Users_mdb].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Users_mdb].dbo.tblRule) + 1) WHERE tName='tblRule' AND ((SELECT MAX(nID) FROM [Users_mdb].dbo.tblRule) >=10000)
UPDATE [Users_mdb].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Users_mdb].dbo.tblRuleCondition) + 1) WHERE tName='tblRuleCondition' AND ((SELECT MAX(nID) FROM [Users_mdb].dbo.tblRuleCondition) >=10000)
UPDATE [Users_mdb].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Users_mdb].dbo.tblPossibleValue) + 1) WHERE tName='tblPossibleValue' AND ((SELECT MAX(nID) FROM [Users_mdb].dbo.tblPossibleValue) >=10000)
UPDATE [Users_mdb].[dbo].[tblNextID] SET nID=((SELECT MAX(nID) FROM [Users_mdb].dbo.tblUIElement_Rule) + 1) WHERE tName='tblUIElement_Rule' AND ((SELECT MAX(nID) FROM [Users_mdb].dbo.tblUIElement_Rule) >=10000)
GO
