// Initialize global Web Session objects



function SetDocumentCursor(strCursor)
{					
	try{	
		if (!document.layers){
			if (objFrames.IsFrameLoaded(TOOLBAR_FRAME_ID)){	
				ToolBar.document.CmdToolBar.style.cursor = strCursor;
			}
			if (objFrames.IsFrameLoaded(SQE_FRAME_ID)){
				SQE.document.SQE.style.cursor = strCursor;
			}								
			if (objFrames.IsFrameLoaded(SUM_LIST_HEADER_FRAME_ID)){
				SumListHeader.document.SummaryListHeader.style.cursor = strCursor;
			}					
			if (objFrames.IsFrameLoaded(SUMMARY_LIST_FRAME_ID)){
				if (SummaryList.document.SummaryList){
					SummaryList.document.SummaryList.style.cursor = strCursor;
				}
			}
			if (objFrames.IsFrameLoaded(TABS_FRAME_ID)){
				Tabs.document.body.style.cursor = strCursor;
			}									
			if (objFrames.IsFrameLoaded(RECORD_FRAME_ID)){		
				Record.document.Record.style.cursor = strCursor;					
			}
			if (objFrames.IsFrameLoaded(COMMANDBAR_FRAME_ID)){
				CommandBar.document.CodeForm.style.cursor = strCursor;					
			}
		}
	}catch(e){
		WriteConsole(e.description);
	}
}		

	
function SetReadOnlyValue (aDocument, strField, strValue)
{	
	aDocument.getElementById(strField).innerHTML=strValue;		
}
	

function AbortPreviousRequest()
{
	var varMsg = MSG_TRANSACTION_IN_PROGRESS;
	
	return window.confirm (varMsg);				
}

function ShowClickBlocker(strFrameID)
{
	ToggleClickBlockerVisibility(strFrameID, true);
}

function HideClickBlocker(strFrameID)
{
	ToggleClickBlockerVisibility(strFrameID, false);
}

function ToggleClickBlockerVisibility(strFrameID, blnVisible)
{
	if(strFrameID.length > 0){
		var objFrame = document.getElementById(strFrameID);
		if(objFrame){
			var objContentWindow = objFrame.contentWindow;
			
			if(objContentWindow){
				if(objContentWindow.m_objLoadingMessage){
					if(blnVisible){
						objContentWindow.m_objLoadingMessage.Show();
					}else{
						objContentWindow.m_objLoadingMessage.Hide();
					}
				}
			}
		}
	}
}

function SetLoadingStatus(){
	// set the statusbar, and the LoadData frame reset it
	objStatus.setStatus(STATUS_LOADING);		

	ShowClickBlocker("Record");
}

function SetIdleStatus(){
	objStatus.setStatus(STATUS_IDLE);
	
	HideClickBlocker("Record");
}

function LoadRecord(intRecordID, intGenerateSumList, intForceLoadRecord, intSelTabID)
{
	var objCommandBarForm;
	
	if (IsCompletelyIdle() || intForceLoadRecord){
		
		objRecord.OnBeforeLoad();
				
		objCommandBarForm = CommandBar.document.CodeForm;
		
		SetLoadingStatus();
		
		if (intGenerateSumList == null){
			intGenerateSumList = 1;
		}	
		
		//Make sure the command bar form is ready to interact with us.
		if (objCommandBarForm != null) {				
			
			//If the user is loading a different record...
			if(objRecord.GetRecordId() != intRecordID){
				OnBeforeNavigate(CLOSE_SCENARIO_USER_LEAVES_ISSUE_CONTEXT);
			}
			
			objRecord.SetRecordId(intRecordID);						
			SetState(COMMANDBAR_FRAME_ID, BUSY_STATE);
			if(objFeatures.getFeature(FEATURE_RECORD)){
				objControls.View(null, intSelTabID);
			}else{
				ExpandSLItem(intRecordID);
			}
			SetState(COMMANDBAR_FRAME_ID, IDLE_STATE);
		} else {
			// just kill some time to let the command bar load
			// and then call the same function again
			var DELAY = 250;
			var timerId;
			var strFunctionCall;
								
			strFunctionCall="LoadRecord(" + eval('intRecordID') + ", ";
			strFunctionCall+=eval('intGenerateSumList') + ", ";
			strFunctionCall+=eval('intForceLoadRecord') + ")";
														
			timerId = setTimeout(strFunctionCall, DELAY);
		}
	}else{
		
		if (objStatus.IsInEditMode()){
			alert(MSG__RECORD_EDIT_MODE);
		}else{			
			alert(MSG_RECORD_LOAD_WHEN_SUMMARY_REFRESH);			
		}
		
	}		

}

function IsCompletelyIdle()
{
	var blnIdle=true;
	if (GetState() == IDLE_STATE ){		
		blnIdle=objStatus.IsIdle();	
	}
	else
	{
		blnIdle=false;
	}
	return blnIdle;
}	

	
function GetFieldType(ctrl)
{
	var ctrltype = ctrl.type;
	var inttype = -1;
	if (ctrltype !== ""){
		switch (ctrltype) {
			case "select-multiple" : // multiselection
				inttype = 0;  // multiselection
				break;
			case "select-one" : // comboBox
				inttype = 1; // comboBox
				break;
			case "text" : // Text Field
				inttype = 2;  // Text Field
				break;
			case "checkbox" : // CheckBox
				inttype = 3;  // CheckBox
				break;
			case "textarea" : // Text AreaField
				inttype = 4;  // Text Field
				break;
		}
	}
	return inttype;
}

function GetFieldValue(fieldName, strToSearchIn)
{
	var varParsString = "";
	var newFieldValue =  fieldName + "=";
	var pos = strToSearchIn.indexOf(newFieldValue);
	if (pos != -1) {
		var Pos2 = strToSearchIn.indexOf("&", pos + fieldName.length + 1);
		if (Pos2 !== 0) {
			varParsString = strToSearchIn.substr(pos+fieldName.length+1, (Pos2 - (pos+fieldName.length+1)));			
		}
	}
	return varParsString;
}

function ChangeValuesForSameFields(strSourceFieldID, strTargetFieldIDList, objSourceElement, blnTriggerOnChange){		 
	if (AlreadyEditing != 1){
		if (strTargetFieldIDList !== "" ){
			AlreadyEditing = 1;
			var FIELD_DELIMITER=",";		
			if (m_objViewFields){
				var objField=m_objViewFields.Field(strSourceFieldID);
				if (objField){
					var objFormElement=new CMqFormElement();					
					var strValue =objFormElement.GetValue(false,objSourceElement,objField.GetControlType());					
					var varFields=strTargetFieldIDList.split(FIELD_DELIMITER);
					m_objLoadDataMgr.SetSingleValueToFields(strValue,varFields,false, null, blnTriggerOnChange);
				}
			}
			AlreadyEditing = 0;
		}
	}
}


function scrollMsg() 
{
	// set the number of times scrolling message is to run
	if (maxCount == 0) {
		maxCount = 3 * msg.length;
	}
	window.status = msg;
	// keep track of how many characters have scrolled
	currCount++;
	// shift first character of msg to end of msg
	msg = msg.substring (1, msg.length) + msg.substring (0, 1);
	// test whether we've reached maximum character count
	if (currCount >= maxCount) {
		timerID = 0;		// zero out the timer
		window.status = "";	// clear the status bar
		return;			// break out of function
	} else {
		// recursive call to this function
		timerId = setTimeout("scrollMsg()", delay);
	}
}
		
function SetListTooltip(objList)
{		
    var IMG_ID_PREF="img_s_";	
    if (objList){
		if (objList.options){
			var objImg = Record.document.getElementById(IMG_ID_PREF + objList.id);
            if (objImg){		
				var lst = "";
                var opts =objList.options;
                 
        	    for (var i = 0; i < opts.length; i++) 
        	    {
        		    if (opts[i].selected){
          			    if (lst === ""){
          				    lst += opts[i].text; 
        			    }else{
            				lst += "\n" + opts[i].text; 
          			    }
            		}
        	    }
                objImg.alt=lst;
                objImg.title=lst;
                objList.title=lst;
            }
        }
    }
}
	
function ConcatenatePath(strPath1, strPath2)
{
	return strPath1 + "/" + strPath2;
}


function SetListTextBox(objList)
{
	var LIST_TEXT_ID_PREF="txt_s_";

	if (objList){
		if (objList.options){
			var objText = Record.document.getElementById(LIST_TEXT_ID_PREF + objList.id);
			if (objText){	
				var lst = "";
                var opts =objList.options;
                 
        	    for (var i = 0; i < opts.length; i++) 
        	    {
        		    if (opts[i].selected){
          			    if (lst === ""){
          				    lst += opts[i].text; 
        			    }else{
            				lst += "," + opts[i].text; 
          			    }
            		}
        	    }
                objText.value=lst;
                objText.title=lst;
                objList.title=lst;	
			}
		}
	}
}

function OnRecordChanged(strFieldID){
	if (!objControlsUi.getReadOnly()){
		if (objFrames.exists(COMMANDBAR_FRAME_ID)){
			
			if (objRecord.GetRecordId() > 0){
										
				if (objFeatures.getFeature(FEATURE_CHANGE) || g_VWS.RecordMgr().CurrentRecord().IsNewRecord()){
					m_objLoadDataMgr.SetFieldChanged(strFieldID);
					if (IsCompletelyIdle()){
						objStatus.setStatus(STATUS_EDITING);
						var frmCode = CommandBar.document.CodeForm;
						objRecord.SynchronizeWithIntern();
						objRecord.DisableRecord(True);
						frmCode = CommandBar.document;								
						var isDisabled = objControlsUi.disableControlButtons();
					}
				
				}else{
					if(objFeatures.getFeature(FEATURE_WIZARD_VIEW)){
						m_objLoadDataMgr.SetFieldChanged(strFieldID);
					}
				}
			}
		}
	}		
}

function GetToken (strFrom, intWhich, strSeparator)
{
	var intPos = 0;
	var intPos1;

	for (var intCount = 0; intCount < intWhich; intCount++) {
		intPos1 = strFrom.indexOf(strSeparator, intPos + 1);
		if (intPos1== -1){  //not found
			intPos1 = strFrom.length + 1;
		}
		if (intCount != intWhich - 1){
			intPos = intPos1;
		}
	}

	if (intPos1 > intPos)  {
		var intLength;
		intLength = intPos1 - intPos;
		
		if (strFrom.charAt(intPos) == strSeparator){
			return (strFrom.substr(intPos + 1, intLength-1));
		}else{
			return (strFrom.substr(intPos, intLength));
		}
	}else{
		return ("");
	}
}

function trim(aStr)
{
	while (aStr.charAt(0) == " "){
		aStr = aStr.substr(1, aStr.length);
	}
	
	while (aStr.charAt(aStr.length - 1) == " "){ 
		aStr = aStr.substr(0, aStr.length - 1);
	}

	return (aStr);
}

function ShutDownOccur (strMsg)
{	
	window.alert(strMsg);
	this.document.location.replace("../../"+LOGON_PAGE +"?Exit=1&");
}
	
	
function SetDirty()
{
	OnRecordChanged();	
}
			
//this function will be called from the child window to verify 
//if the value has been changed or not
function VerifyValue(ctrlName,strNewValue,strFieldID)
{	
	var ctrl = Record.document.getElementById(ctrlName);
	if (ctrl){
		ctrlvalue = ctrl.value;
		if (ctrlvalue !=  strNewValue){
			ctrl.value = strNewValue;
			
			if(ctrl.onchange){
			    ctrl.onchange();
			}
			
			OnRecordChanged(strFieldID);
		}		
	}
}

//this function will get the hidden fields in the CommandBar.htm if there are 
//attachments in a Submit-Only view
function GetHiddenAttachFields(ctrlName)
{
	eval("var ctrl = this.CommandBar.document.CodeForm." + ctrlName);
	return ctrl.value;
}

//this function will set the hidden fields in the CommandBar.htm if there are 
//attachments in a Submit-Only view
function SetHiddenAttachFields(ctrlName,strNewValue)
{
	eval("var ctrl = this.CommandBar.document.CodeForm." + ctrlName);
	ctrlvalue = ctrl.value;

	if (ctrlvalue !=  strNewValue){
		ctrl.value = strNewValue;
	}
}	

function HideFrame(intFrameId)
{		
	var intFrameIndex;
		
	intFrameIndex=objFrames.getFramePosition(intFrameId);
	if (intFrameIndex!=-1){
		var objFrameTemp=objFrames.Item(intFrameId);
		
		if(objFrameTemp){
			intHeight = objFrameTemp.GetRuntimeHeight();

			objFrameTemp.DefinedHeight=0;
			objFrames.SetAllFrameHeights();
			
			if(!objFrameTemp.IsHidden){
				if(intFrameId==SUM_LIST_HEADER_FRAME_ID){
					DEFAULT_FIXED_FRAMES_HEIGHT=DEFAULT_FIXED_FRAMES_HEIGHT-DEFAULT_SUMLISTHEADER;
				}else{
					if(intFrameId==SQE_FRAME_ID){
						DEFAULT_FIXED_FRAMES_HEIGHT=DEFAULT_FIXED_FRAMES_HEIGHT-DEFAULT_SQE;
					}
				}
			}
			
			objFrameTemp.IsHidden = true;
		}
	}
}		

function ShowFrame(intFrameId,strHeight)
{
	var intFrameIndex;
	intFrameIndex=objFrames.getFramePosition(intFrameId);
	if(intFrameIndex!=-1){
		var objFrameTemp=objFrames.Item(intFrameId);
		
		if(objFrameTemp){
			if(objFrameTemp.DefinedHeight!=strHeight){
				objFrameTemp.DefinedHeight=strHeight;
				objFrames.SetAllFrameHeights();
				if(intFrameId==SUM_LIST_HEADER_FRAME_ID){
					DEFAULT_FIXED_FRAMES_HEIGHT=DEFAULT_FIXED_FRAMES_HEIGHT+DEFAULT_SUMLISTHEADER;
				}else{
					if(intFrameId==SQE_FRAME_ID){
						DEFAULT_FIXED_FRAMES_HEIGHT=DEFAULT_FIXED_FRAMES_HEIGHT+DEFAULT_SQE;
					}
				}
			}
		
			objFrameTemp.IsHidden = false;
		}
	}
}
function moveTabFrame(intInc)
{

	var frmSubFrame;

	//var strSLNewRow=objFrames.setFrameSize(SUMMARY_LIST_FRAME_ID,"",intInc);
	//var strRecNewRow=objFrames.setFrameSize(RECORD_FRAME_ID,"",-intInc);
		
	if(document.layers){
		if (GetState() == IDLE_STATE){
			var blnAnswer;
			blnAnswer=confirm(MSG_RELOAD_TO_TAKE_EFFECT);
			if (blnAnswer){
				// Set the cookie to the new value for the frames
				objFrames.saveFrameSizeToCookie(COOKIE_FRAMESET);
				location.reload();
			}
		}else{
			alert(MSG_CANT_MOVE_TABS);
		}
	}else{
		objFrames.HideTabComponents(false,false);
		//ShowFrame(SUM_LIST_HEADER_FRAME_ID,DEFAULT_SUMLISTHEADER);
		if (!objFeatures.getFeature(FEATURE_SUBMIT) && !objFeatures.getFeature(FEATURE_FAQ_VIEW)){	
			// Set the cookie to the new value for the frames
			objFrames.saveFrameSizeToCookie(COOKIE_FRAMESET);
		}			
		objFrames.SetAllFrameHeights();			
	} 
}

function ExpandSLItem(intRecordID)
{
	objControlsUi.disableControl(CONTROL_PRINT);

	SetState(LOADDATA_FRAME_ID,BUSY_STATE);	
	// set the statusbar, and the LoadData frame reset it
	objStatus.setStatus(STATUS_LOADING);
	objRecord.SetRecordId(intRecordID);		
	var objSLRow=SummaryList.document.getElementById("SLR_" + intRecordID);
	
	if(objSLRow){
		if(objSLRow.style.display==""){
			objSLRow.style.display="none";
		}else{
			objSLRow.style.display="";
		}
	}
	
	SetIdleStatus();
	
	objControlsUi.enableControl(CONTROL_PRINT);
	SetState(LOADDATA_FRAME_ID,IDLE_STATE);
	SetDocumentCursor("");
}

function MaxMinSL()
{
	if(document.Tabs){
		var objButton=document.Tabs.document.getElementById(m_objMqButton.GetButtonHTMLName("MaxMinSL"));
		if(m_objMqButton.GetButtonState(objButton)==m_objMqButton.STATE_1){
			MaximizeSL();
		}else{
			MinimizeSL();
		}
		m_objMqButton.Toggle(objButton,"MaxMinSL");
	}
}

function MaximizeSL(blnHideExpandCollapse)
{
	if(IsCompletelyIdle()){
		moveTabFrame(0);
		HideFrame(RECORD_FRAME_ID);
		objFrames.HideTabComponents(true,false,blnHideExpandCollapse);
		var objFrameTemp=objFrames.Item(SUMMARY_LIST_FRAME_ID);
		if(objFrameTemp){
			objFrameTemp.DefinedHeight="100%";
		}
		
		objFrames.SetAllFrameHeights();
	}
}

function MinimizeSL()
{
	moveTabFrame(0);
	HideFrame(SUMMARY_LIST_FRAME_ID);
	HideFrame(SUM_LIST_HEADER_FRAME_ID);
	objFrames.HideTabComponents(false,true);
	var objFrameTemp=objFrames.Item(RECORD_FRAME_ID);
	
	if(objFrameTemp){
		objFrameTemp.DefinedHeight="100%";
	}
	objFrames.SetAllFrameHeights();
}

var m_timWindow;
var m_objTempWindow;

function waitForWindow(objWin,strCallBackFunction)
{
	m_objTempWindow=objWin;
	m_timWindow = setInterval("waitForWindowCallback(\""+strCallBackFunction+"\")",500);
}

function waitForWindowCallback(strCallBackFunction)
{
  if (m_objTempWindow){
  	if (m_objTempWindow.closed){
  		clearInterval(m_timWindow);
  		eval(strCallBackFunction);
  	}
	}
}




function ShowDefaultControls(strIDs, objRef){
	var c;
	if(objRef){
		objDataHTMLDoc=objRef;
	}else{
		objDataHTMLDoc = m_objLoadDataMgr.GetDataHTMLDocumentObject();	
	}
	var objFormElement=new CMqFormElement();
	var arrElementsToShow = Array("MqFC_","MqF_","MqColumnDesc_","sep")
	var VISIBILITY_VISIBLE="visible";
	var strDisplay="";			
	var objTD;
	var strVisibility = VISIBILITY_VISIBLE;
	var STR_CLASS_HIDDEN_OBJ = 'HiddenObject';
	var arrAllTabs;
	var TAB_HAS_VISIBLE_ITEMS = "1";
	var TAB_HAS_HIDDEN_ITEMS = "0";
	
	if(objTabsMgr){
		arrAllTabs=objTabsMgr.GetAllTabIDs();
	}
	if(!strIDs){
		for(c=1;c<=m_objViewFields.GetFieldCol().length;c++){
			if(m_objViewFields.Exists(c)){
				objElement = m_objViewFields.GetFieldCol()[c];
			
				ShowElement(objElement.GetID(), objDataHTMLDoc, objElement.GetTabID());
			}
		}
	}else{
		if(strIDs){
			ShowElementByID(strIDs, objRef);
		}
	}
	
	HideTabsWithNoVisibleElements();
	
	ShowSepLines();
	
	ShowTabHeaders();
	
	function ShowElement(lngFieldID, objDataHTMLDoc, lngTabID)		
	{
		var blnFieldIsVisible=false;
		
		if(lngFieldID){
			var objFormElement=new CMqFormElement();
			for(var c=0;c<arrElementsToShow.length;c++){
				objTD=objDataHTMLDoc.getElementById(arrElementsToShow[c] + lngFieldID);
				if(objTD){
				
					blnFieldIsVisible=false;
					
					if(objTD.getAttribute("MqHidden")!="1"){
						if(objTD.className != STR_CLASS_HIDDEN_OBJ){
							objFormElement.HideElement(false, null, true, lngFieldID, objDataHTMLDoc);
							blnFieldIsVisible=true;
							if(arrAllTabs){
								if(arrAllTabs[lngTabID]){
									arrAllTabs[lngTabID]=TAB_HAS_VISIBLE_ITEMS;
								}
							}
						}
					}
					
					if(!blnFieldIsVisible){
						if(arrAllTabs){
							if(arrAllTabs[lngTabID]){
								if(arrAllTabs[lngTabID]!=TAB_HAS_VISIBLE_ITEMS){
									arrAllTabs[lngTabID]=TAB_HAS_HIDDEN_ITEMS;
								}
							}
						}
					}
				}
			}
		}
	}
	
	function ShowElementByID(strID, objRef){
		var objEls = strID.split(',');		
		
		for(z=0;z<objEls.length;z++){
			ShowElement(objEls[z], objRef);		
		}
	}
	
	function HideTabsWithNoVisibleElements()
	{
		var strHiddenTabs="";
		
		if(arrAllTabs){
			for(var x=0; x<arrAllTabs.length; x++){
				if(arrAllTabs[x]){
					if(arrAllTabs[x]==TAB_HAS_HIDDEN_ITEMS){
						strHiddenTabs+=x + ";";
					}
				}
			}
		}

		if(strHiddenTabs!=""){
			var arrHideTabs=strHiddenTabs.split(";");
			objTabsMgr.HideTabs(arrHideTabs, true);
		}
	}
	
	function ShowSepLines(){
		var elLines;
		var CLASS_SEP_LINE = 'lineSep';
		var objRecordFrame = window.frames['Record'];
		
		if(objRecordFrame){		
			strDisplay = "block";
				
			elLines = objRecordFrame.document.getElementsByTagName('hr');
		
			for(var c=0;c<elLines.length;c++){
				if(elLines[c].getAttribute('class')){
					if(elLines[c].getAttribute('class') != ''){										
						if(elLines[c].getAttribute('class').indexOf(CLASS_SEP_LINE) >= 0 && elLines[c].style.display != 'none'){
							elLines[c].style.display=strDisplay;
							elLines[c].style.visibility=strVisibility;
						}
					}
				}
			}
		}
	}
	
	function ShowTabHeaders(){
		var objRecordFrame = window.frames['Record'];
		
		if(objRecordFrame){		
			strDisplay = "block";
				
			var objCells = objRecordFrame.document.getElementsByTagName('td');
		
			for(var c=0;c<objCells.length;c++){
				if(objCells[c].getAttribute('id')){
					if(objCells[c].getAttribute('id') != ''){		
						if(objCells[c].getAttribute('id').indexOf("Header")>0){
							if(objCells[c].getAttribute('class')){
								if(objCells[c].getAttribute('class') != ''){	
									if(objCells[c].getAttribute('class').indexOf("SeriesHeader") >= 0 && objCells[c].style.display != 'none'){
										objCells[c].style.display=strDisplay;
										objCells[c].style.visibility=strVisibility;
									}
								}
							}
						}
					}
				}
			}
		}
	}
}

function ResizeBannerPopup(lngWidth, lngHeight)
{
	//The height sent in will different based on the browser, 
	//so include a set of pixels that will always be added to the height.
	var EXTRA_PIXELS_RESERVED_FOR_HEIGHT = 30;
	var objBanner = document.getElementById("dvBanner");
	
	if(objBanner){
		objBanner.style.width = lngWidth + "px";
		objBanner.style.height = ((lngHeight)+EXTRA_PIXELS_RESERVED_FOR_HEIGHT) + "px";
	}
}

function ShowBannerPopup(blnHidden)
{
	var objBanner=document.getElementById("dvBanner");
		
	if(objBanner){
		if(blnHidden){
			objBanner.style.display="none";
		}else{
			if(strBannerMsg!=""){
				var MSG_WIDTH=700;
				var MSG_HEIGHT=200;
				var MSG_CONTAINER='<div id="divBannerContents" name="divBannerContents" style="width:665px; position:absolute;margin:10px;padding-bottom:30px; overflow:auto">' + g_MqRef.MqStr.MqHtmlDecode(strBannerMsg) + '</div>';
				var DIALOG_BOTTOM='<div width="100%" style="position:absolute;bottom:0px;right:10px;padding:1px;">' + m_objMqButton.GetTextButtonHTML("Close",g_MqRef.RESX['BUTTON_CLOSE'], "ShowBannerPopup(true);", "", null, "", g_MqRef.RESX['BUTTON_CLOSE']); + '</div>';
				
				objBanner.innerHTML=MSG_CONTAINER+DIALOG_BOTTOM;
							
				var intBodyHeight;
				var intBodyWidth;
							
				if (document.all){
					if (document.documentElement && document.documentElement.offsetHeight){
						intBodyHeight=document.documentElement.offsetHeight;
						intBodyWidth=document.documentElement.offsetWidth;
					}else{
						intBodyHeight=document.body.offsetHeight;
						intBodyWidth=document.body.offsetWidth;
					}
				}else{
					intBodyHeight=window.innerHeight;
					intBodyWidth=window.innerWidth;
				}
							
				if(intBodyHeight && intBodyWidth){
					objBanner.style.top="50px"; 
					objBanner.style.left=parseInt(intBodyWidth-MSG_WIDTH)/2+ "px";
				}
				objBanner.style.width=MSG_WIDTH + "px"; 
				objBanner.style.height=MSG_HEIGHT + "px";
							
				objBanner.style.display="";
				
				var objDivBannerContents = document.getElementById("divBannerContents");
				
				if(objDivBannerContents){
					ResizeBannerPopup(MSG_WIDTH, objDivBannerContents.scrollHeight);
				}
			}
		}
	}else{
		window.setTimeout("ShowBannerPopup(" + blnHidden + ")", 500);
	}
}		

function CMqArrayMgr(){
	function IsValueInArray(varValue,varArray){
		var blnResult=false;
		if (varArray){
			if (varArray.length){
				for(var lngIndex=0;lngIndex<varArray.length;lngIndex++){
					if (varArray[lngIndex]){
						if (varValue==varArray[lngIndex]){
							blnResult=true;
							break;				
						}
					}
				}
			}
		}
		return blnResult;
	}

	this.IsValueInArray=IsValueInArray;
} 


function FixTabs(oFieldValuesRs)
{
	var FLD_COND=197;
	var m_objRSHelper = new CMqRSHelper();
	var vVal=m_objRSHelper.GetFieldValue(FLD_COND,oFieldValuesRs);
	if (m_arrPrevRecVals){
  	if (m_arrPrevRecVals[FLD_COND]!=vVal){
			switch (vVal){
			case "2":	//qa item
				//objTabsMgr.HideTabs([7,8]);
				break;
						
			default:
				//objTabsMgr.HideTabs();
			}
			m_arrPrevRecVals[FLD_COND]=vVal;
  	}
	}
}

function GetVDURL(strBaseVD, strAddRedirQS)
{
	var co = objRequest.Get(mstrCurrentLocation + "wcProdInv.asp?WCI=wciGetDiffVDURL&Base=" + strBaseVD + 
										"&AddQS=" + g_MqRef.MqStr.MqEncodeURIComponent(strAddRedirQS));
	if (co!=objRequest.CANCEL_PROCESS){

		var objResponse=objRequest.Response(co);
									
		if (objResponse){
			if (objResponse.HasErrors()){
				objResponse.ProcessErrors("",true,window);
			}else{
				return co;
			}
		}
	}
				
	return true;
}

						
	
	var objFieldDescription = new FieldsDescription();
	
function FieldsDescription(){
	var FLD_DESC_ID = 'divFieldDescription';
	var FLD_DESC_CLASSNAME = 'fieldDescriptionContainer';
	var FIELD_CAPTION_ID = 'MqFC_';
	var GetObj = function(o){return objFrames.GetFrameWindow(RECORD_FRAME_ID).document.getElementById(o)};
	var DESCRIPTION_PROPERTY = 'MqToolTip';
	var DESC_TAG = "MqDesc";
	var DESC_TAG_CLASS = "MqDescClass";
	var DESC_NEW_LINE = "MqDescLine_"
	var DESC_NEW_COLUMN_ID = "MqColumnDesc_"
	
	this.AttachToAllFields = AttachFieldsDescription;
	this.Show = ShowDescription;
	this.Hide = HideFieldDescription;
	this.CreateFldDescContainer = CreateFldDescContainer;
	this.ShowFieldHeader = ShowFieldHeader;
	this.GetDocument = function(){return objFrames.GetFrameWindow(RECORD_FRAME_ID).document};
	
	function ShowFieldHeader(){
		
		var elmColumns = this.GetDocument().getElementsByTagName('td');
		
		for(var c=0;c<elmColumns.length;c++){			
			if(elmColumns[c].getAttribute('id')){
				if(elmColumns[c].getAttribute(DESC_TAG) != null && elmColumns[c].getAttribute(DESC_TAG) != ""){					
					if(!(elmColumns[c].style.display == 'none' || elmColumns[c].style.visibility == 'hidden')){
						InsertHeaderRow(elmColumns[c], c);
						c++;
					}					
				}
			}
		}		
	}
	
	function InsertHeaderRow(elmColumn, elmPos){
		var elmNewRow;
		var strLineId;
		var strColumnId;
		var intColspan;
		var elmDiv;
		
		if(elmColumn.getAttribute("id")){
		    if(typeof document.documentElement.sourceIndex == "undefined")
		    HTMLElement.prototype.__defineGetter__("sourceIndex", (function(indexOf){
		        return function sourceIndex(){
		            return indexOf.call(this.ownerDocument.getElementsByTagName("*"), this);
		        };
		    })(Array.prototype.indexOf));
		
			strLineId = DESC_NEW_LINE + elmColumn.parentNode.uniqueNumber;
			strColumnId = DESC_NEW_COLUMN_ID + elmColumn.getAttribute("id").replace(FIELD_CAPTION_ID,"");
	 	}
		
		if(!GetObj(strLineId)){
			elmNewRow = document.createElement('tr');
			elmNewRow.id = strLineId != '' ? strLineId : DESC_NEW_LINE + '_' + elmPos.toString();
		}else{
			elmNewRow = GetObj(strLineId);
		}
		
		// Configure TD
		elmNewColumn = document.createElement('td');
		elmNewColumn.id = strColumnId != '' ? strColumnId : strColumnId + '_' + elmPos.toString();
		elmNewColumn.setAttribute('valign', "top");
		
		elmDiv = document.createElement('div');
		elmDiv.className = elmColumn.getAttribute(DESC_TAG_CLASS) != null ? elmColumn.getAttribute(DESC_TAG_CLASS) : '';
		elmNewColumn.appendChild(elmDiv);
		
		intColspan = elmColumn.nextSibling || nextSibling(elmColumn) 		
		intColspan = intColspan.getAttribute('colspan');
		elmNewColumn.setAttribute('colspan', intColspan ? parseInt(intColspan) + 1 : 2);
		
		// Configure text
		var elmText = document.createTextNode(elmColumn.getAttribute(DESC_TAG));
		elmDiv.appendChild(elmText);
		
		elmNewRow.appendChild(elmNewColumn);
		elmColumn.parentNode.parentNode.insertBefore(elmNewRow, elmColumn.parentNode);				
	}
	
	function nextSibling(el) {
	    do { el = el.nextSibling } while ( el && el.nodeType !== 1 );
	    return el;
	}
	
	function GetAttributeCust(ele, attr) {
        var result = (ele.getAttribute && ele.getAttribute(attr)) || null;
        if( !result ) {
            var attrs = ele.attributes;
            var length = attrs.length;
            for(var i = 0; i < length; i++)
                if(attrs[i].nodeName === attr)
                    result = attrs[i].nodeValue;
        }
        return result;
    }
    
	function AttachFieldsDescription(){		
		var objElement;
		
		var objField;
		var strID;
		var strExistingEvent;
		var strEvent = '';
		
		for(c=1;c<=m_objViewFields.GetFieldCol().length;c++){
			if(m_objViewFields.Exists(c)){
				objElement = m_objViewFields.GetFieldCol()[c];
				objField = GetObj(objElement.GetBoundControl());
				
				if(objField){
					if(!objField.readOnly){
						if(objField.getAttribute(DESCRIPTION_PROPERTY) != null && objField.getAttribute(DESCRIPTION_PROPERTY) != ''){
		
							strID = objElement.GetID();
									
							var objCaption=GetObj(FIELD_CAPTION_ID + strID);

							if(objCaption){	
								var objCaptionText=objCaption.children[0];
								if(objCaptionText){
									objCaptionText.style.borderBottom="1px dashed";
									objCaptionText.style.cursor="help";
									
									//objCaptionText.setAttribute("onmouseover", 'parent.objFieldDescription.Show('+strID+');');
									
									//objCaptionText.setAttribute("onmouseout", 'parent.objFieldDescription.Hide();');
									
									objCaptionText.setAttribute("data-balloon", objField.getAttribute(DESCRIPTION_PROPERTY));
									objCaptionText.setAttribute("data-balloon-pos", "right");
									objCaptionText.setAttribute("data-balloon-length", "large");
									
								}
							}
						}
					}
				}
			}
		}	
	}
	
	function HideFieldDescription(blnCloseButton){		
		var objContainer = GetObj(FLD_DESC_ID);	
		
		if(objContainer){	
			if(!blnCloseButton){
				if(GetObj(FLD_DESC_ID).scrollHeight > GetObj(FLD_DESC_ID).clientHeight){
					return false;	
				}
			}
		
			objContainer.parentNode.removeChild(objContainer);
		}
	}
	
	function ShowDescription(strFieldID){	
		var strDescription;
		var oField = m_objViewFields.Field(strFieldID).GetBoundControl();
		
		if(oField){		
			strDescription = document.Record.document.getElementById(oField).getAttribute(DESCRIPTION_PROPERTY);
			if(strDescription != null && strDescription != ''){
				this.CreateFldDescContainer(strFieldID, strDescription);
			}
		}
	}
	
	function CreateFldDescContainer(strFieldID, strDescription){
		var oDocument = document.Record.document;
		var oBody = oDocument.getElementsByTagName('body');
		var oBody = oDocument.getElementById(FIELD_CAPTION_ID+strFieldID);
		var lngFieldType;
		var strContPosOffset;
		var objField;
		
		var oContainter = document.createElement('div');
		var strCloseButton = '<div class=\"fieldDescriptionCloseButton\" onClick=\"parent.objFieldDescription.Hide(true);\"><img src=\"../../theme/images/buttons/closeDesc.png\" width=\"15px\" height="15px"></div>';
		
		oContainter.id = FLD_DESC_ID;
		oContainter.innerHTML = strDescription;
		oContainter.className = FLD_DESC_CLASSNAME;
		
		var oOldContainter = oDocument.getElementById(FLD_DESC_ID);
		if(oOldContainter){
			oOldContainter.parentNode.removeChild(oOldContainter);
		}
		
		if(oBody){
			objField = GetObj(m_objViewFields.Field(strFieldID).GetBoundControl());
			lngFieldType = GetFieldType(objField);
			
			if(getOffset(oBody).top <= 70){
				if(lngFieldType != 0){
					strContPosOffset = '9px';
				}else{
					strContPosOffset = (parseInt(objField.getAttribute('size')) * 12.8) + 'px';
				}
				
				oContainter.style.top = strContPosOffset;
			}
			
			oBody.appendChild(oContainter);
			
			var objDesc=GetObj(FLD_DESC_ID);
			if(objDesc){
				if(objDesc.scrollHeight > objDesc.clientHeight){
					oContainter.innerHTML = strCloseButton + strDescription;
				}
			}
		}
	}
	
	function GetExistingEvent(poCtl, strEvent){
		var strEvent;
		var strTmpEvent;
		var oCtl = GetObj(poCtl);	
		var strExistingEvent = '';
		
		if(eval('GetObj(poCtl).'+strEvent)){
			strEvent = eval('GetObj(poCtl).'+strEvent).valueOf().toString();
			strEvent = strEvent.substr(0, strEvent.length-1).replace(/\s$/,'');
			strExistingEvent = (strEvent.substr(0, strEvent.length-1) != ';' ? strEvent.substr(strEvent.indexOf('{')+1,strEvent.length) : '');
			//strExistingEvent = 'parent.'+strExistingEvent.replace(/^\s+/,'').replace('\n','').replace('\r','')
			strExistingEvent = 'try{'+strExistingEvent+'}catch(e){}';
		}
	
		return strExistingEvent
	}
	
	function getOffset(el) {
		if (el.getBoundingClientRect){
			return el.getBoundingClientRect();
		}else{
			var x = 0, y = 0;
			
			do {
				x += el.offsetLeft - el.scrollLeft;
				y += el.offsetTop - el.scrollTop;
			}while (el = el.offsetParent);
			
			return { "left": x, "top": y }
		}
	}
}